/*     */ package org.jboss.ejb.plugins.cmp.bridge;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.FinderException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.proxy.compiler.InvocationHandler;
/*     */ 
/*     */ public class EntityBridgeInvocationHandler
/*     */   implements InvocationHandler
/*     */ {
/*     */   private final Class beanClass;
/*     */   private final Map fieldMap;
/*     */   private final Map selectorMap;
/*     */   private EntityEnterpriseContext ctx;
/*     */ 
/*     */   public EntityBridgeInvocationHandler(Map fieldMap, Map selectorMap, Class beanClass)
/*     */   {
/*  61 */     this.beanClass = beanClass;
/*  62 */     this.fieldMap = fieldMap;
/*  63 */     this.selectorMap = selectorMap;
/*     */   }
/*     */ 
/*     */   public void setContext(EntityEnterpriseContext ctx)
/*     */   {
/*  68 */     if ((ctx != null) && (!this.beanClass.isInstance(ctx.getInstance())))
/*     */     {
/*  70 */       throw new EJBException("Instance must be an instance of beanClass");
/*     */     }
/*  72 */     this.ctx = ctx;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws FinderException
/*     */   {
/*  87 */     String methodName = method.getName();
/*     */ 
/*  89 */     BridgeInvoker invoker = (BridgeInvoker)this.fieldMap.get(methodName);
/*  90 */     if (invoker == null)
/*     */     {
/*  93 */       invoker = (BridgeInvoker)this.selectorMap.get(method);
/*     */ 
/*  95 */       if (invoker == null)
/*     */       {
/*  97 */         throw new EJBException("Method is not a known CMP field accessor, CMR field accessor, or ejbSelect method: methodName=" + methodName);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 105 */       return invoker.invoke(this.ctx, method, args);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 109 */       throw e;
/*     */     }
/*     */     catch (FinderException e)
/*     */     {
/* 113 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 117 */     throw new EJBException("Internal error", e);
/*     */   }
/*     */ 
/*     */   public static class FieldSetInvoker
/*     */     implements EntityBridgeInvocationHandler.BridgeInvoker
/*     */   {
/*     */     private final FieldBridge field;
/*     */ 
/*     */     public FieldSetInvoker(FieldBridge field)
/*     */     {
/* 157 */       this.field = field;
/*     */     }
/*     */ 
/*     */     public Object invoke(EntityEnterpriseContext ctx, Method method, Object[] args)
/*     */     {
/* 164 */       if (ctx == null)
/*     */       {
/* 166 */         throw new EJBException("EJB home methods are not allowed to access CMP or CMR fields: methodName=" + method.getName());
/*     */       }
/*     */ 
/* 170 */       this.field.setValue(ctx, args[0]);
/* 171 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class FieldGetInvoker
/*     */     implements EntityBridgeInvocationHandler.BridgeInvoker
/*     */   {
/*     */     private final FieldBridge field;
/*     */ 
/*     */     public FieldGetInvoker(FieldBridge field)
/*     */     {
/* 134 */       this.field = field;
/*     */     }
/*     */ 
/*     */     public Object invoke(EntityEnterpriseContext ctx, Method method, Object[] args)
/*     */     {
/* 141 */       if (ctx == null)
/*     */       {
/* 143 */         throw new EJBException("EJB home methods are not allowed to access CMP or CMR fields: methodName=" + method.getName());
/*     */       }
/*     */ 
/* 147 */       return this.field.getValue(ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface BridgeInvoker
/*     */   {
/*     */     public abstract Object invoke(EntityEnterpriseContext paramEntityEnterpriseContext, Method paramMethod, Object[] paramArrayOfObject)
/*     */       throws FinderException, Exception;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler
 * JD-Core Version:    0.6.0
 */