/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.SessionSynchronization;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.AllowedOperationsFlags;
/*     */ import org.jboss.ejb.BeanLock;
/*     */ import org.jboss.ejb.BeanLockManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.StatefulSessionContainer;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class StatefulSessionInstanceInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected Logger log;
/*     */   protected StatefulSessionContainer container;
/*     */   private static final Method getEJBHome;
/*     */   private static final Method getHandle;
/*     */   private static final Method getPrimaryKey;
/*     */   private static final Method isIdentical;
/*     */   private static final Method remove;
/*     */   private static final Method getEJBObject;
/*     */   private static final Method ejbTimeout;
/*     */ 
/*     */   public StatefulSessionInstanceInterceptor()
/*     */   {
/*  70 */     this.log = Logger.getLogger(getClass());
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/* 110 */     this.container = ((StatefulSessionContainer)container);
/*     */   }
/*     */ 
/*     */   public Container getContainer()
/*     */   {
/* 115 */     return this.container;
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 124 */     if (getEJBObject.equals(mi.getMethod())) {
/* 125 */       return getNext().invokeHome(mi);
/*     */     }
/*     */ 
/* 128 */     InstancePool pool = this.container.getInstancePool();
/* 129 */     EnterpriseContext ctx = pool.get();
/*     */ 
/* 132 */     mi.setEnterpriseContext(ctx);
/*     */ 
/* 135 */     ctx.lock();
/*     */ 
/* 142 */     AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_HOME);
/*     */     try
/*     */     {
/* 147 */       localObject1 = getNext().invokeHome(mi);
/*     */     }
/*     */     finally
/*     */     {
/* 151 */       synchronized (ctx)
/*     */       {
/*     */         Object localObject1;
/* 153 */         AllowedOperationsAssociation.popInMethodFlag();
/*     */ 
/* 156 */         ctx.unlock();
/*     */ 
/* 159 */         if (ctx.getId() == null)
/*     */         {
/* 161 */           pool.free(ctx);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void register(EnterpriseContext ctx, Transaction tx, BeanLock lock)
/*     */   {
/* 170 */     InstanceSynchronization synch = new InstanceSynchronization(ctx, lock);
/*     */     try
/*     */     {
/* 177 */       if (tx.getStatus() == 1)
/*     */       {
/* 180 */         return;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 186 */         tx.registerSynchronization(synch);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 192 */         getContainer().getLockManager().removeLockRef(lock.getId());
/* 193 */         throw ex;
/*     */       }
/*     */ 
/* 197 */       synch.afterBegin();
/*     */     }
/*     */     catch (RollbackException e)
/*     */     {
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 205 */       throw new EJBException(e); }  } 
/*     */   // ERROR //
/*     */   public Object invoke(Invocation mi) throws Exception { // Byte code:
/*     */     //   0: aload_0
/*     */     //   1: getfield 6	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:container	Lorg/jboss/ejb/StatefulSessionContainer;
/*     */     //   4: invokevirtual 35	org/jboss/ejb/StatefulSessionContainer:getInstanceCache	()Lorg/jboss/ejb/InstanceCache;
/*     */     //   7: astore_2
/*     */     //   8: aload_0
/*     */     //   9: getfield 6	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:container	Lorg/jboss/ejb/StatefulSessionContainer;
/*     */     //   12: invokevirtual 12	org/jboss/ejb/StatefulSessionContainer:getInstancePool	()Lorg/jboss/ejb/InstancePool;
/*     */     //   15: astore_3
/*     */     //   16: aload_1
/*     */     //   17: invokevirtual 36	org/jboss/invocation/Invocation:getId	()Ljava/lang/Object;
/*     */     //   20: astore 4
/*     */     //   22: aconst_null
/*     */     //   23: astore 5
/*     */     //   25: aload_0
/*     */     //   26: getfield 6	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:container	Lorg/jboss/ejb/StatefulSessionContainer;
/*     */     //   29: invokevirtual 37	org/jboss/ejb/StatefulSessionContainer:getLockManager	()Lorg/jboss/ejb/BeanLockManager;
/*     */     //   32: aload 4
/*     */     //   34: invokevirtual 38	org/jboss/ejb/BeanLockManager:getLock	(Ljava/lang/Object;)Lorg/jboss/ejb/BeanLock;
/*     */     //   37: astore 6
/*     */     //   39: invokestatic 39	org/jboss/ejb/plugins/SecurityActions:peekRunAsIdentity	()Lorg/jboss/security/RunAs;
/*     */     //   42: ifnull +7 -> 49
/*     */     //   45: iconst_1
/*     */     //   46: goto +4 -> 50
/*     */     //   49: iconst_0
/*     */     //   50: istore 7
/*     */     //   52: invokestatic 40	org/jboss/ejb/plugins/SecurityActions:getSecurityContext	()Lorg/jboss/security/SecurityContext;
/*     */     //   55: ifnonnull +7 -> 62
/*     */     //   58: iconst_1
/*     */     //   59: goto +4 -> 63
/*     */     //   62: iconst_0
/*     */     //   63: istore 8
/*     */     //   65: iload 7
/*     */     //   67: ifne +49 -> 116
/*     */     //   70: iload 8
/*     */     //   72: ifeq +44 -> 116
/*     */     //   75: aload_0
/*     */     //   76: getfield 6	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:container	Lorg/jboss/ejb/StatefulSessionContainer;
/*     */     //   79: invokevirtual 41	org/jboss/ejb/StatefulSessionContainer:getSecurityManager	()Lorg/jboss/security/AuthenticationManager;
/*     */     //   82: astore 9
/*     */     //   84: ldc 42
/*     */     //   86: astore 10
/*     */     //   88: aload 9
/*     */     //   90: ifnull +12 -> 102
/*     */     //   93: aload 9
/*     */     //   95: invokeinterface 43 1 0
/*     */     //   100: astore 10
/*     */     //   102: aload_1
/*     */     //   103: invokevirtual 44	org/jboss/invocation/Invocation:getPrincipal	()Ljava/security/Principal;
/*     */     //   106: aload_1
/*     */     //   107: invokevirtual 45	org/jboss/invocation/Invocation:getCredential	()Ljava/lang/Object;
/*     */     //   110: aload 10
/*     */     //   112: aconst_null
/*     */     //   113: invokestatic 46	org/jboss/ejb/plugins/SecurityActions:createAndSetSecurityContext	(Ljava/security/Principal;Ljava/lang/Object;Ljava/lang/String;Ljavax/security/auth/Subject;)V
/*     */     //   116: aload 6
/*     */     //   118: invokeinterface 47 1 0
/*     */     //   123: aload_2
/*     */     //   124: aload 4
/*     */     //   126: invokeinterface 48 2 0
/*     */     //   131: astore 5
/*     */     //   133: goto +98 -> 231
/*     */     //   136: astore 9
/*     */     //   138: aload_1
/*     */     //   139: invokevirtual 50	org/jboss/invocation/Invocation:isLocal	()Z
/*     */     //   142: ifeq +16 -> 158
/*     */     //   145: new 51	javax/ejb/NoSuchObjectLocalException
/*     */     //   148: dup
/*     */     //   149: aload 9
/*     */     //   151: invokevirtual 52	java/rmi/NoSuchObjectException:getMessage	()Ljava/lang/String;
/*     */     //   154: invokespecial 53	javax/ejb/NoSuchObjectLocalException:<init>	(Ljava/lang/String;)V
/*     */     //   157: athrow
/*     */     //   158: aload 9
/*     */     //   160: athrow
/*     */     //   161: astore 9
/*     */     //   163: aload 9
/*     */     //   165: athrow
/*     */     //   166: astore 9
/*     */     //   168: aload 9
/*     */     //   170: athrow
/*     */     //   171: astore 9
/*     */     //   173: aload_1
/*     */     //   174: invokevirtual 55	org/jboss/invocation/Invocation:getType	()Lorg/jboss/invocation/InvocationType;
/*     */     //   177: astore 10
/*     */     //   179: aload 10
/*     */     //   181: getstatic 56	org/jboss/invocation/InvocationType:LOCAL	Lorg/jboss/invocation/InvocationType;
/*     */     //   184: if_acmpeq +11 -> 195
/*     */     //   187: aload 10
/*     */     //   189: getstatic 57	org/jboss/invocation/InvocationType:LOCALHOME	Lorg/jboss/invocation/InvocationType;
/*     */     //   192: if_acmpne +7 -> 199
/*     */     //   195: iconst_1
/*     */     //   196: goto +4 -> 200
/*     */     //   199: iconst_0
/*     */     //   200: istore 11
/*     */     //   202: iload 11
/*     */     //   204: ifeq +15 -> 219
/*     */     //   207: new 33	javax/ejb/EJBException
/*     */     //   210: dup
/*     */     //   211: ldc 58
/*     */     //   213: aload 9
/*     */     //   215: invokespecial 59	javax/ejb/EJBException:<init>	(Ljava/lang/String;Ljava/lang/Exception;)V
/*     */     //   218: athrow
/*     */     //   219: new 54	java/rmi/RemoteException
/*     */     //   222: dup
/*     */     //   223: ldc 60
/*     */     //   225: aload 9
/*     */     //   227: invokespecial 61	java/rmi/RemoteException:<init>	(Ljava/lang/String;Ljava/lang/Throwable;)V
/*     */     //   230: athrow
/*     */     //   231: aload_1
/*     */     //   232: aload 5
/*     */     //   234: invokevirtual 14	org/jboss/invocation/Invocation:setEnterpriseContext	(Ljava/lang/Object;)V
/*     */     //   237: aload 5
/*     */     //   239: invokevirtual 62	org/jboss/ejb/EnterpriseContext:getInstance	()Ljava/lang/Object;
/*     */     //   242: invokestatic 63	org/jboss/ejb/plugins/EnterpriseBeanPolicyContextHandler:setEnterpriseBean	(Ljava/lang/Object;)V
/*     */     //   245: aload_0
/*     */     //   246: getfield 6	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:container	Lorg/jboss/ejb/StatefulSessionContainer;
/*     */     //   249: invokevirtual 64	org/jboss/ejb/StatefulSessionContainer:getBeanMetaData	()Lorg/jboss/metadata/BeanMetaData;
/*     */     //   252: checkcast 65	org/jboss/metadata/SessionMetaData
/*     */     //   255: invokevirtual 66	org/jboss/metadata/SessionMetaData:isBeanManagedTx	()Z
/*     */     //   258: istore 9
/*     */     //   260: iload 9
/*     */     //   262: ifne +134 -> 396
/*     */     //   265: aload 5
/*     */     //   267: invokevirtual 67	org/jboss/ejb/EnterpriseContext:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   270: ifnull +99 -> 369
/*     */     //   273: aload 5
/*     */     //   275: invokevirtual 67	org/jboss/ejb/EnterpriseContext:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   278: aload_1
/*     */     //   279: invokevirtual 68	org/jboss/invocation/Invocation:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   282: invokevirtual 69	java/lang/Object:equals	(Ljava/lang/Object;)Z
/*     */     //   285: ifne +84 -> 369
/*     */     //   288: new 70	java/lang/StringBuffer
/*     */     //   291: dup
/*     */     //   292: ldc 71
/*     */     //   294: invokespecial 72	java/lang/StringBuffer:<init>	(Ljava/lang/String;)V
/*     */     //   297: astore 10
/*     */     //   299: aload 10
/*     */     //   301: new 73	java/lang/StringBuilder
/*     */     //   304: dup
/*     */     //   305: invokespecial 74	java/lang/StringBuilder:<init>	()V
/*     */     //   308: ldc 75
/*     */     //   310: invokevirtual 76	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   313: aload 5
/*     */     //   315: invokevirtual 67	org/jboss/ejb/EnterpriseContext:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   318: invokevirtual 77	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   321: invokevirtual 78	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   324: invokevirtual 79	java/lang/StringBuffer:append	(Ljava/lang/String;)Ljava/lang/StringBuffer;
/*     */     //   327: pop
/*     */     //   328: aload 10
/*     */     //   330: new 73	java/lang/StringBuilder
/*     */     //   333: dup
/*     */     //   334: invokespecial 74	java/lang/StringBuilder:<init>	()V
/*     */     //   337: ldc 80
/*     */     //   339: invokevirtual 76	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   342: aload_1
/*     */     //   343: invokevirtual 68	org/jboss/invocation/Invocation:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   346: invokevirtual 77	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   349: invokevirtual 78	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   352: invokevirtual 79	java/lang/StringBuffer:append	(Ljava/lang/String;)Ljava/lang/StringBuffer;
/*     */     //   355: pop
/*     */     //   356: new 33	javax/ejb/EJBException
/*     */     //   359: dup
/*     */     //   360: aload 10
/*     */     //   362: invokevirtual 81	java/lang/StringBuffer:toString	()Ljava/lang/String;
/*     */     //   365: invokespecial 82	javax/ejb/EJBException:<init>	(Ljava/lang/String;)V
/*     */     //   368: athrow
/*     */     //   369: aload 5
/*     */     //   371: invokevirtual 67	org/jboss/ejb/EnterpriseContext:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   374: ifnonnull +22 -> 396
/*     */     //   377: aload_1
/*     */     //   378: invokevirtual 68	org/jboss/invocation/Invocation:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   381: ifnull +15 -> 396
/*     */     //   384: aload_0
/*     */     //   385: aload 5
/*     */     //   387: aload_1
/*     */     //   388: invokevirtual 68	org/jboss/invocation/Invocation:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   391: aload 6
/*     */     //   393: invokevirtual 83	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:register	(Lorg/jboss/ejb/EnterpriseContext;Ljavax/transaction/Transaction;Lorg/jboss/ejb/BeanLock;)V
/*     */     //   396: aload 5
/*     */     //   398: invokevirtual 84	org/jboss/ejb/EnterpriseContext:isLocked	()Z
/*     */     //   401: ifne +11 -> 412
/*     */     //   404: aload 5
/*     */     //   406: invokevirtual 15	org/jboss/ejb/EnterpriseContext:lock	()V
/*     */     //   409: goto +26 -> 435
/*     */     //   412: aload_0
/*     */     //   413: aload_1
/*     */     //   414: invokevirtual 85	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:isCallAllowed	(Lorg/jboss/invocation/Invocation;)Z
/*     */     //   417: ifne +13 -> 430
/*     */     //   420: new 33	javax/ejb/EJBException
/*     */     //   423: dup
/*     */     //   424: ldc 86
/*     */     //   426: invokespecial 82	javax/ejb/EJBException:<init>	(Ljava/lang/String;)V
/*     */     //   429: athrow
/*     */     //   430: aload 5
/*     */     //   432: invokevirtual 15	org/jboss/ejb/EnterpriseContext:lock	()V
/*     */     //   435: jsr +14 -> 449
/*     */     //   438: goto +22 -> 460
/*     */     //   441: astore 12
/*     */     //   443: jsr +6 -> 449
/*     */     //   446: aload 12
/*     */     //   448: athrow
/*     */     //   449: astore 13
/*     */     //   451: aload 6
/*     */     //   453: invokeinterface 87 1 0
/*     */     //   458: ret 13
/*     */     //   460: getstatic 88	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:ejbTimeout	Ljava/lang/reflect/Method;
/*     */     //   463: aload_1
/*     */     //   464: invokevirtual 8	org/jboss/invocation/Invocation:getMethod	()Ljava/lang/reflect/Method;
/*     */     //   467: invokevirtual 9	java/lang/reflect/Method:equals	(Ljava/lang/Object;)Z
/*     */     //   470: ifeq +12 -> 482
/*     */     //   473: getstatic 89	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:IN_EJB_TIMEOUT	I
/*     */     //   476: invokestatic 17	org/jboss/ejb/AllowedOperationsAssociation:pushInMethodFlag	(I)V
/*     */     //   479: goto +9 -> 488
/*     */     //   482: getstatic 90	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:IN_BUSINESS_METHOD	I
/*     */     //   485: invokestatic 17	org/jboss/ejb/AllowedOperationsAssociation:pushInMethodFlag	(I)V
/*     */     //   488: iconst_1
/*     */     //   489: istore 9
/*     */     //   491: aload_0
/*     */     //   492: invokevirtual 10	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:getNext	()Lorg/jboss/ejb/Interceptor;
/*     */     //   495: aload_1
/*     */     //   496: invokeinterface 91 2 0
/*     */     //   501: astore 10
/*     */     //   503: aload 10
/*     */     //   505: astore 11
/*     */     //   507: jsr +89 -> 596
/*     */     //   510: jsr +167 -> 677
/*     */     //   513: aload 11
/*     */     //   515: areturn
/*     */     //   516: astore 10
/*     */     //   518: aload_2
/*     */     //   519: aload 4
/*     */     //   521: invokeinterface 92 2 0
/*     */     //   526: aload_3
/*     */     //   527: aload 5
/*     */     //   529: invokeinterface 93 2 0
/*     */     //   534: iconst_0
/*     */     //   535: istore 9
/*     */     //   537: aload 10
/*     */     //   539: athrow
/*     */     //   540: astore 10
/*     */     //   542: aload_2
/*     */     //   543: aload 4
/*     */     //   545: invokeinterface 92 2 0
/*     */     //   550: aload_3
/*     */     //   551: aload 5
/*     */     //   553: invokeinterface 93 2 0
/*     */     //   558: iconst_0
/*     */     //   559: istore 9
/*     */     //   561: aload 10
/*     */     //   563: athrow
/*     */     //   564: astore 10
/*     */     //   566: aload_2
/*     */     //   567: aload 4
/*     */     //   569: invokeinterface 92 2 0
/*     */     //   574: aload_3
/*     */     //   575: aload 5
/*     */     //   577: invokeinterface 93 2 0
/*     */     //   582: iconst_0
/*     */     //   583: istore 9
/*     */     //   585: aload 10
/*     */     //   587: athrow
/*     */     //   588: astore 14
/*     */     //   590: jsr +6 -> 596
/*     */     //   593: aload 14
/*     */     //   595: athrow
/*     */     //   596: astore 15
/*     */     //   598: invokestatic 18	org/jboss/ejb/AllowedOperationsAssociation:popInMethodFlag	()V
/*     */     //   601: iload 9
/*     */     //   603: ifeq +64 -> 667
/*     */     //   606: aload 6
/*     */     //   608: invokeinterface 47 1 0
/*     */     //   613: aload 5
/*     */     //   615: invokevirtual 19	org/jboss/ejb/EnterpriseContext:unlock	()V
/*     */     //   618: aload 5
/*     */     //   620: invokevirtual 20	org/jboss/ejb/EnterpriseContext:getId	()Ljava/lang/Object;
/*     */     //   623: ifnonnull +19 -> 642
/*     */     //   626: aload_2
/*     */     //   627: aload 4
/*     */     //   629: invokeinterface 92 2 0
/*     */     //   634: aload_3
/*     */     //   635: aload 5
/*     */     //   637: invokeinterface 21 2 0
/*     */     //   642: jsr +14 -> 656
/*     */     //   645: goto +22 -> 667
/*     */     //   648: astore 16
/*     */     //   650: jsr +6 -> 656
/*     */     //   653: aload 16
/*     */     //   655: athrow
/*     */     //   656: astore 17
/*     */     //   658: aload 6
/*     */     //   660: invokeinterface 87 1 0
/*     */     //   665: ret 17
/*     */     //   667: ret 15
/*     */     //   669: astore 18
/*     */     //   671: jsr +6 -> 677
/*     */     //   674: aload 18
/*     */     //   676: athrow
/*     */     //   677: astore 19
/*     */     //   679: aload_0
/*     */     //   680: getfield 6	org/jboss/ejb/plugins/StatefulSessionInstanceInterceptor:container	Lorg/jboss/ejb/StatefulSessionContainer;
/*     */     //   683: invokevirtual 37	org/jboss/ejb/StatefulSessionContainer:getLockManager	()Lorg/jboss/ejb/BeanLockManager;
/*     */     //   686: aload 6
/*     */     //   688: invokeinterface 29 1 0
/*     */     //   693: invokevirtual 30	org/jboss/ejb/BeanLockManager:removeLockRef	(Ljava/lang/Object;)V
/*     */     //   696: iload 7
/*     */     //   698: ifne +11 -> 709
/*     */     //   701: iload 8
/*     */     //   703: ifeq +6 -> 709
/*     */     //   706: invokestatic 96	org/jboss/ejb/plugins/SecurityActions:clearSecurityContext	()V
/*     */     //   709: aconst_null
/*     */     //   710: invokestatic 63	org/jboss/ejb/plugins/EnterpriseBeanPolicyContextHandler:setEnterpriseBean	(Ljava/lang/Object;)V
/*     */     //   713: ret 19
/*     */     //
/*     */     // Exception table:
/*     */     //   from	to	target	type
/*     */     //   123	133	136	java/rmi/NoSuchObjectException
/*     */     //   123	133	161	javax/ejb/EJBException
/*     */     //   123	133	166	java/rmi/RemoteException
/*     */     //   123	133	171	java/lang/Exception
/*     */     //   123	438	441	finally
/*     */     //   441	446	441	finally
/*     */     //   491	510	516	java/rmi/RemoteException
/*     */     //   491	510	540	java/lang/RuntimeException
/*     */     //   491	510	564	java/lang/Error
/*     */     //   491	510	588	finally
/*     */     //   516	593	588	finally
/*     */     //   613	645	648	finally
/*     */     //   648	653	648	finally
/*     */     //   65	513	669	finally
/*     */     //   516	674	669	finally } 
/* 417 */   protected boolean isCallAllowed(Invocation mi) { Method m = mi.getMethod();
/*     */ 
/* 424 */     return (m.equals(getEJBHome)) || (m.equals(getHandle)) || (m.equals(getPrimaryKey)) || (m.equals(isIdentical)) || (m.equals(remove));
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  88 */       Class[] noArg = new Class[0];
/*  89 */       getEJBHome = EJBObject.class.getMethod("getEJBHome", noArg);
/*  90 */       getHandle = EJBObject.class.getMethod("getHandle", noArg);
/*  91 */       getPrimaryKey = EJBObject.class.getMethod("getPrimaryKey", noArg);
/*  92 */       isIdentical = EJBObject.class.getMethod("isIdentical", new Class[] { EJBObject.class });
/*  93 */       remove = EJBObject.class.getMethod("remove", noArg);
/*  94 */       getEJBObject = Handle.class.getMethod("getEJBObject", noArg);
/*  95 */       ejbTimeout = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  99 */       e.printStackTrace();
/* 100 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private class InstanceSynchronization
/*     */     implements Synchronization
/*     */   {
/*     */     private EnterpriseContext ctx;
/* 440 */     private boolean notifySession = false;
/*     */     private Method afterBegin;
/*     */     private Method beforeCompletion;
/*     */     private Method afterCompletion;
/*     */     private BeanLock lock;
/* 447 */     private boolean beforeCompletionInvoked = false;
/*     */ 
/*     */     InstanceSynchronization(EnterpriseContext ctx, BeanLock lock)
/*     */     {
/* 454 */       this.ctx = ctx;
/* 455 */       this.lock = lock;
/* 456 */       this.lock.addRef();
/*     */ 
/* 459 */       this.notifySession = (ctx.getInstance() instanceof SessionSynchronization);
/*     */ 
/* 461 */       if (this.notifySession)
/*     */       {
/*     */         try
/*     */         {
/* 466 */           sync = Class.forName("javax.ejb.SessionSynchronization");
/*     */ 
/* 469 */           this.afterBegin = sync.getMethod("afterBegin", new Class[0]);
/* 470 */           this.beforeCompletion = sync.getMethod("beforeCompletion", new Class[0]);
/* 471 */           this.afterCompletion = sync.getMethod("afterCompletion", new Class[] { Boolean.TYPE });
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */           Class sync;
/* 476 */           StatefulSessionInstanceInterceptor.this.log.error("failed to setup InstanceSynchronization", e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void afterBegin()
/*     */     {
/* 485 */       if (this.notifySession)
/*     */       {
/*     */         try
/*     */         {
/* 489 */           AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_AFTER_BEGIN);
/* 490 */           this.afterBegin.invoke(this.ctx.getInstance(), new Object[0]);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 494 */           StatefulSessionInstanceInterceptor.this.log.error("failed to invoke afterBegin", e);
/*     */         }
/*     */         finally {
/* 497 */           AllowedOperationsAssociation.popInMethodFlag();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/* 504 */       if (StatefulSessionInstanceInterceptor.this.log.isTraceEnabled()) {
/* 505 */         StatefulSessionInstanceInterceptor.this.log.trace("beforeCompletion called");
/*     */       }
/*     */ 
/* 508 */       this.ctx.lock();
/* 509 */       this.beforeCompletionInvoked = true;
/*     */ 
/* 511 */       if (this.notifySession)
/*     */       {
/*     */         try
/*     */         {
/* 515 */           AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_BEFORE_COMPLETION);
/* 516 */           this.beforeCompletion.invoke(this.ctx.getInstance(), new Object[0]);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 520 */           StatefulSessionInstanceInterceptor.this.log.error("failed to invoke beforeCompletion", e);
/*     */         }
/*     */         finally {
/* 523 */           AllowedOperationsAssociation.popInMethodFlag();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 530 */       if (StatefulSessionInstanceInterceptor.this.log.isTraceEnabled()) {
/* 531 */         StatefulSessionInstanceInterceptor.this.log.trace("afterCompletion called");
/*     */       }
/* 533 */       this.lock.sync();
/*     */       try
/*     */       {
/* 537 */         this.ctx.setTransaction(null);
/*     */ 
/* 539 */         if (this.beforeCompletionInvoked) {
/* 540 */           this.ctx.unlock();
/*     */         }
/* 542 */         if (this.notifySession)
/*     */         {
/*     */           try
/*     */           {
/* 547 */             AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_AFTER_COMPLETION);
/* 548 */             if (status == 3)
/*     */             {
/* 550 */               this.afterCompletion.invoke(this.ctx.getInstance(), new Object[] { Boolean.TRUE });
/*     */             }
/*     */             else
/*     */             {
/* 554 */               this.afterCompletion.invoke(this.ctx.getInstance(), new Object[] { Boolean.FALSE });
/*     */             }
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 559 */             StatefulSessionInstanceInterceptor.this.log.error("failed to invoke afterCompletion", e);
/*     */           }
/*     */           finally {
/* 562 */             AllowedOperationsAssociation.popInMethodFlag();
/*     */           }
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 568 */         this.lock.releaseSync();
/* 569 */         StatefulSessionInstanceInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.StatefulSessionInstanceInterceptor
 * JD-Core Version:    0.6.0
 */