/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.ejb.SessionBean;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.StatefulSessionContainer;
/*     */ import org.jboss.ejb.StatefulSessionEnterpriseContext;
/*     */ import org.jboss.ejb.StatefulSessionPersistenceManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.util.id.UID;
/*     */ 
/*     */ public class StatefulSessionFilePersistenceManager extends ServiceMBeanSupport
/*     */   implements StatefulSessionPersistenceManager, StatefulSessionFilePersistenceManagerMBean
/*     */ {
/*     */   public static final String DEFAULT_STORE_DIRECTORY_NAME = "sessions";
/*     */   private StatefulSessionContainer con;
/*     */   private String storeDirName;
/*     */   private File storeDir;
/*     */   private boolean purgeEnabled;
/*     */ 
/*     */   public StatefulSessionFilePersistenceManager()
/*     */   {
/*  85 */     this.storeDirName = "sessions";
/*     */ 
/*  94 */     this.purgeEnabled = true;
/*     */   }
/*     */ 
/*     */   public void setContainer(Container con)
/*     */   {
/* 104 */     this.con = ((StatefulSessionContainer)con);
/*     */   }
/*     */ 
/*     */   public void setStoreDirectoryName(String dirName)
/*     */   {
/* 130 */     this.storeDirName = dirName;
/*     */   }
/*     */ 
/*     */   public String getStoreDirectoryName()
/*     */   {
/* 145 */     return this.storeDirName;
/*     */   }
/*     */ 
/*     */   public void setPurgeEnabled(boolean flag)
/*     */   {
/* 157 */     this.purgeEnabled = flag;
/*     */   }
/*     */ 
/*     */   public boolean getPurgeEnabled()
/*     */   {
/* 169 */     return this.purgeEnabled;
/*     */   }
/*     */ 
/*     */   public File getStoreDirectory()
/*     */   {
/* 181 */     return this.storeDir;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 192 */     String ejbName = this.con.getBeanMetaData().getEjbName();
/*     */ 
/* 195 */     File dir = ServerConfigLocator.locate().getServerTempDir();
/*     */ 
/* 198 */     dir = new File(dir, this.storeDirName);
/*     */ 
/* 200 */     dir = new File(dir, ejbName + "-" + new UID().toString());
/* 201 */     this.storeDir = dir;
/*     */ 
/* 203 */     this.log.debug("Storing sessions for '" + ejbName + "' in: " + this.storeDir);
/*     */ 
/* 206 */     if (!this.storeDir.exists())
/*     */     {
/* 208 */       if (!MkdirsFileAction.mkdirs(this.storeDir))
/*     */       {
/* 210 */         throw new IOException("Failed to create directory: " + this.storeDir);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 215 */     if (!this.storeDir.isDirectory())
/*     */     {
/* 217 */       throw new IOException("File exists where directory expected: " + this.storeDir);
/*     */     }
/*     */ 
/* 221 */     if ((!this.storeDir.canWrite()) || (!this.storeDir.canRead()))
/*     */     {
/* 223 */       throw new IOException("Directory must be readable and writable: " + this.storeDir);
/*     */     }
/*     */ 
/* 227 */     purgeAllSessionData();
/*     */   }
/*     */ 
/*     */   private void purgeAllSessionData()
/*     */   {
/* 235 */     if (!this.purgeEnabled) return;
/*     */ 
/* 237 */     this.log.debug("Purging all session data in: " + this.storeDir);
/*     */ 
/* 239 */     File[] sessions = this.storeDir.listFiles();
/* 240 */     for (int i = 0; i < sessions.length; i++)
/*     */     {
/* 242 */       if (!sessions[i].delete())
/*     */       {
/* 244 */         this.log.warn("Failed to delete session state file: " + sessions[i]);
/*     */       }
/*     */       else
/*     */       {
/* 248 */         this.log.debug("Removed stale session state: " + sessions[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 259 */     purgeAllSessionData();
/*     */ 
/* 262 */     if ((this.purgeEnabled) && (!this.storeDir.delete()))
/*     */     {
/* 264 */       this.log.warn("Failed to delete session state storage directory: " + this.storeDir);
/*     */     }
/*     */   }
/*     */ 
/*     */   private File getFile(Object id)
/*     */   {
/* 278 */     return new File(this.storeDir, String.valueOf(id) + ".ser");
/*     */   }
/*     */ 
/*     */   public Object createId(StatefulSessionEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 287 */     return new UID();
/*     */   }
/*     */ 
/*     */   public void createdSession(StatefulSessionEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void activateSession(StatefulSessionEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/* 306 */     boolean trace = this.log.isTraceEnabled();
/* 307 */     if (trace)
/*     */     {
/* 309 */       this.log.trace("Attempting to activate; ctx=" + ctx);
/*     */     }
/*     */ 
/* 312 */     Object id = ctx.getId();
/*     */ 
/* 315 */     File file = getFile(id);
/* 316 */     if (trace)
/*     */     {
/* 318 */       this.log.trace("Reading session state from: " + file);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 323 */       FileInputStream fis = FISAction.open(file);
/* 324 */       SessionObjectInputStream in = new SessionObjectInputStream(ctx, new BufferedInputStream(fis));
/*     */       try
/*     */       {
/* 329 */         Object obj = in.readObject();
/* 330 */         if (trace)
/*     */         {
/* 332 */           this.log.trace("Session state: " + obj);
/*     */         }
/* 334 */         ctx.setInstance(obj);
/*     */       }
/*     */       finally
/*     */       {
/* 338 */         in.close();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 343 */       throw new EJBException("Could not activate; failed to restore state", e);
/*     */     }
/*     */ 
/* 347 */     removePassivated(id);
/*     */     try
/*     */     {
/* 352 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_ACTIVATE);
/* 353 */       SessionBean bean = (SessionBean)ctx.getInstance();
/* 354 */       bean.ejbActivate();
/*     */     }
/*     */     finally
/*     */     {
/* 358 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 361 */     if (trace)
/*     */     {
/* 363 */       this.log.trace("Activation complete; ctx=" + ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void passivateSession(StatefulSessionEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/* 374 */     boolean trace = this.log.isTraceEnabled();
/* 375 */     if (trace)
/*     */     {
/* 377 */       this.log.trace("Attempting to passivate; ctx=" + ctx);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 383 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_PASSIVATE);
/* 384 */       SessionBean bean = (SessionBean)ctx.getInstance();
/* 385 */       bean.ejbPassivate();
/*     */     }
/*     */     finally
/*     */     {
/* 389 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 394 */     File file = getFile(ctx.getId());
/* 395 */     if (trace)
/*     */     {
/* 397 */       this.log.trace("Saving session state to: " + file);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 402 */       FileOutputStream fos = FOSAction.open(file);
/* 403 */       SessionObjectOutputStream out = new SessionObjectOutputStream(new BufferedOutputStream(fos));
/*     */ 
/* 406 */       Object obj = ctx.getInstance();
/* 407 */       if (trace)
/*     */       {
/* 409 */         this.log.trace("Writing session state: " + obj);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 414 */         out.writeObject(obj);
/*     */       }
/*     */       finally
/*     */       {
/* 418 */         out.close();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 423 */       throw new EJBException("Could not passivate; failed to save state", e);
/*     */     }
/*     */ 
/* 426 */     if (trace)
/*     */     {
/* 428 */       this.log.trace("Passivation complete; ctx=" + ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeSession(StatefulSessionEnterpriseContext ctx)
/*     */     throws RemoteException, RemoveException
/*     */   {
/* 438 */     boolean trace = this.log.isTraceEnabled();
/* 439 */     if (trace)
/*     */     {
/* 441 */       this.log.trace("Attempting to remove; ctx=" + ctx);
/*     */     }
/*     */ 
/* 445 */     SessionBean bean = (SessionBean)ctx.getInstance();
/* 446 */     bean.ejbRemove();
/*     */ 
/* 448 */     if (trace)
/*     */     {
/* 450 */       this.log.trace("Removal complete; ctx=" + ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removePassivated(Object id)
/*     */   {
/* 459 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 461 */     File file = getFile(id);
/*     */ 
/* 464 */     if (file.exists())
/*     */     {
/* 466 */       if (trace)
/*     */       {
/* 468 */         this.log.trace("Removing passivated state file: " + file);
/*     */       }
/*     */ 
/* 471 */       if (!DeleteFileAction.delete(file))
/*     */       {
/* 473 */         this.log.warn("Failed to delete passivated state file: " + file);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static class FOSAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     File file;
/*     */ 
/*     */     FOSAction(File file)
/*     */     {
/* 551 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception {
/* 555 */       FileOutputStream fis = new FileOutputStream(this.file);
/* 556 */       return fis;
/*     */     }
/*     */ 
/*     */     static FileOutputStream open(File file) throws FileNotFoundException {
/* 560 */       FOSAction action = new FOSAction(file);
/* 561 */       FileOutputStream fos = null;
/*     */       try
/*     */       {
/* 564 */         fos = (FileOutputStream)AccessController.doPrivileged(action);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 568 */         throw ((FileNotFoundException)e.getException());
/*     */       }
/*     */ 
/* 571 */       return fos;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class FISAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     File file;
/*     */ 
/*     */     FISAction(File file)
/*     */     {
/* 522 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception {
/* 526 */       FileInputStream fis = new FileInputStream(this.file);
/* 527 */       return fis;
/*     */     }
/*     */ 
/*     */     static FileInputStream open(File file) throws FileNotFoundException {
/* 531 */       FISAction action = new FISAction(file);
/* 532 */       FileInputStream fis = null;
/*     */       try
/*     */       {
/* 535 */         fis = (FileInputStream)AccessController.doPrivileged(action);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 539 */         throw ((FileNotFoundException)e.getException());
/*     */       }
/*     */ 
/* 542 */       return fis;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class MkdirsFileAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     File file;
/*     */ 
/*     */     MkdirsFileAction(File file)
/*     */     {
/* 502 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 506 */       boolean ok = this.file.mkdirs();
/* 507 */       return new Boolean(ok);
/*     */     }
/*     */ 
/*     */     static boolean mkdirs(File file) {
/* 511 */       MkdirsFileAction action = new MkdirsFileAction(file);
/* 512 */       Boolean ok = (Boolean)AccessController.doPrivileged(action);
/* 513 */       return ok.booleanValue();
/*     */     }
/*     */   }
/*     */ 
/*     */   static class DeleteFileAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     File file;
/*     */ 
/*     */     DeleteFileAction(File file)
/*     */     {
/* 483 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 487 */       boolean deleted = this.file.delete();
/* 488 */       return new Boolean(deleted);
/*     */     }
/*     */ 
/*     */     static boolean delete(File file) {
/* 492 */       DeleteFileAction action = new DeleteFileAction(file);
/* 493 */       Boolean deleted = (Boolean)AccessController.doPrivileged(action);
/* 494 */       return deleted.booleanValue();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.StatefulSessionFilePersistenceManager
 * JD-Core Version:    0.6.0
 */