/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.StatelessSessionEnterpriseContext;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class SingletonStatelessSessionInstancePool extends AbstractInstancePool
/*     */ {
/*     */   EnterpriseContext ctx;
/*  46 */   boolean inUse = false;
/*  47 */   boolean isSynchronized = true;
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public synchronized EnterpriseContext get()
/*     */     throws Exception
/*     */   {
/*  83 */     while ((this.inUse) && (this.isSynchronized))
/*     */       try {
/*  85 */         wait();
/*     */       }
/*     */       catch (InterruptedException e) {
/*     */       }
/*  89 */     if (this.ctx == null)
/*     */     {
/*     */       try
/*     */       {
/*  93 */         this.ctx = create(getContainer().createBeanClassInstance());
/*     */       }
/*     */       catch (InstantiationException e) {
/*  96 */         throw new EJBException("Could not instantiate bean", e);
/*     */       }
/*     */       catch (IllegalAccessException e) {
/*  99 */         throw new EJBException("Could not instantiate bean", e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 107 */     this.inUse = true;
/* 108 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   public synchronized void free(EnterpriseContext ctx)
/*     */   {
/* 123 */     this.inUse = false;
/* 124 */     notifyAll();
/*     */   }
/*     */ 
/*     */   public synchronized void discard(EnterpriseContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 132 */       ctx.discard();
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/*     */     }
/*     */ 
/* 139 */     this.inUse = false;
/* 140 */     notifyAll();
/*     */   }
/*     */ 
/*     */   public void add()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public int getCurrentSize()
/*     */   {
/* 154 */     return 1;
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 159 */     return 1;
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws DeploymentException
/*     */   {
/* 167 */     Element synch = MetaData.getUniqueChild(element, "Synchronized");
/* 168 */     this.isSynchronized = Boolean.valueOf(MetaData.getElementContent(synch)).booleanValue();
/*     */   }
/*     */ 
/*     */   protected EnterpriseContext create(Object instance)
/*     */     throws Exception
/*     */   {
/* 178 */     return new StatelessSessionEnterpriseContext(instance, getContainer());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.SingletonStatelessSessionInstancePool
 * JD-Core Version:    0.6.0
 */