/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.AssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.security.AnybodyPrincipal;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ 
/*     */ public class SecurityRolesInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected RealmMapping realmMapping;
/*     */   protected Map securityRoles;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  60 */     super.setContainer(container);
/*  61 */     if (container != null)
/*     */     {
/*  63 */       BeanMetaData beanMetaData = container.getBeanMetaData();
/*  64 */       ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
/*  65 */       AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
/*  66 */       this.securityRoles = assemblyDescriptor.getSecurityRoles();
/*     */ 
/*  68 */       this.realmMapping = container.getRealmMapping();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*  75 */     super.start();
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  81 */     checkSecurityAssociation(mi);
/*  82 */     Object returnValue = getNext().invokeHome(mi);
/*  83 */     return returnValue;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  89 */     checkSecurityAssociation(mi);
/*  90 */     Object returnValue = getNext().invoke(mi);
/*  91 */     return returnValue;
/*     */   }
/*     */ 
/*     */   private void checkSecurityAssociation(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 101 */     Principal principal = mi.getPrincipal();
/* 102 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 104 */     if (this.realmMapping == null)
/*     */     {
/* 106 */       throw new EJBException("checkSecurityAssociation", new SecurityException("Role mapping manager has not been set"));
/*     */     }
/*     */ 
/* 111 */     InvocationType iface = mi.getType();
/* 112 */     Set methodRoles = this.container.getMethodPermissions(mi.getMethod(), iface);
/* 113 */     if (methodRoles == null)
/*     */     {
/* 115 */       String method = mi.getMethod().getName();
/* 116 */       String msg = "No method permissions assigned to method=" + method + ", interface=" + iface;
/*     */ 
/* 118 */       this.log.error(msg);
/* 119 */       SecurityException e = new SecurityException(msg);
/* 120 */       throw new EJBException("checkSecurityAssociation", e);
/*     */     }
/* 122 */     if (trace)
/*     */     {
/* 124 */       this.log.trace("method=" + mi.getMethod() + ", interface=" + iface + ", requiredRoles=" + methodRoles);
/*     */     }
/*     */ 
/* 129 */     RunAsIdentity callerRunAsIdentity = SecurityAssociation.peekRunAsIdentity();
/* 130 */     if (!methodRoles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL))
/*     */     {
/* 133 */       if (callerRunAsIdentity == null)
/*     */       {
/* 136 */         if (!this.realmMapping.doesUserHaveRole(principal, methodRoles))
/*     */         {
/* 138 */           Set userRoles = this.realmMapping.getUserRoles(principal);
/* 139 */           String method = mi.getMethod().getName();
/* 140 */           String msg = "Insufficient method permissions, principal=" + principal + ", method=" + method + ", interface=" + iface + ", requiredRoles=" + methodRoles + ", principalRoles=" + userRoles;
/*     */ 
/* 143 */           this.log.error(msg);
/* 144 */           SecurityException e = new SecurityException(msg);
/* 145 */           throw new EJBException("checkSecurityAssociation", e);
/*     */         }
/*     */ 
/*     */       }
/* 153 */       else if (!callerRunAsIdentity.doesUserHaveRole(methodRoles))
/*     */       {
/* 155 */         String method = mi.getMethod().getName();
/* 156 */         String msg = "Insufficient method permissions, runAsPrincipal=" + callerRunAsIdentity.getName() + ", method=" + method + ", interface=" + iface + ", requiredRoles=" + methodRoles + ", runAsRoles=" + callerRunAsIdentity.getRunAsRoles();
/*     */ 
/* 159 */         this.log.error(msg);
/* 160 */         SecurityException e = new SecurityException(msg);
/* 161 */         throw new EJBException("checkSecurityAssociation", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.SecurityRolesInterceptor
 * JD-Core Version:    0.6.0
 */