/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Principal;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.AssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.SecurityIdentityMetaData;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.ISecurityManagement;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SecurityRolesAssociation;
/*     */ import org.jboss.security.SecurityUtil;
/*     */ import org.jboss.security.integration.ejb.EJBAuthenticationHelper;
/*     */ import org.jboss.security.integration.ejb.EJBAuthorizationHelper;
/*     */ import org.jboss.system.Registry;
/*     */ 
/*     */ public class SecurityInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected AuthenticationManager securityManager;
/*     */   protected RealmMapping realmMapping;
/*     */   protected RunAs runAsIdentity;
/*     */   protected Map securityRoles;
/*     */   protected Map deploymentRoles;
/*     */   protected AuthenticationObserver authenticationObserver;
/*     */   protected Method ejbTimeout;
/*  99 */   protected String ejbName = null;
/* 100 */   protected CodeSource ejbCS = null;
/*     */ 
/* 104 */   protected String appSecurityDomain = null;
/*     */ 
/* 106 */   protected String defaultAuthorizationSecurityDomain = "jboss-ejb-policy";
/*     */ 
/* 112 */   protected boolean isUseCallerIdentity = false;
/*     */ 
/* 118 */   protected ISecurityManagement securityManagement = null;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/* 125 */     super.setContainer(container);
/* 126 */     if (container != null)
/*     */     {
/* 128 */       BeanMetaData beanMetaData = container.getBeanMetaData();
/* 129 */       ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
/* 130 */       AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
/* 131 */       this.securityRoles = assemblyDescriptor.getSecurityRoles();
/* 132 */       this.deploymentRoles = assemblyDescriptor.getPrincipalVersusRolesMap();
/*     */ 
/* 134 */       SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
/* 135 */       if ((secMetaData != null) && (!secMetaData.getUseCallerIdentity()))
/*     */       {
/* 137 */         String roleName = secMetaData.getRunAsRoleName();
/* 138 */         String principalName = secMetaData.getRunAsPrincipalName();
/*     */ 
/* 141 */         if (principalName == null) {
/* 142 */           principalName = applicationMetaData.getUnauthenticatedPrincipal();
/*     */         }
/*     */ 
/* 145 */         Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
/* 146 */         this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
/*     */       }
/*     */ 
/* 149 */       if ((secMetaData != null) && (secMetaData.getUseCallerIdentity())) {
/* 150 */         this.isUseCallerIdentity = true;
/*     */       }
/* 152 */       this.securityManager = container.getSecurityManager();
/* 153 */       this.realmMapping = container.getRealmMapping();
/*     */       try
/*     */       {
/* 159 */         this.ejbTimeout = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*     */       }
/*     */       catch (NoSuchMethodException ignore)
/*     */       {
/*     */       }
/*     */ 
/* 165 */       if (this.securityManager != null)
/*     */       {
/* 167 */         this.appSecurityDomain = this.securityManager.getSecurityDomain();
/* 168 */         this.appSecurityDomain = SecurityUtil.unprefixSecurityDomain(this.appSecurityDomain);
/*     */       }
/* 170 */       this.ejbName = beanMetaData.getEjbName();
/* 171 */       this.ejbCS = container.getBeanClass().getProtectionDomain().getCodeSource();
/* 172 */       this.securityManagement = container.getSecurityManagement();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 179 */     super.start();
/* 180 */     this.authenticationObserver = ((AuthenticationObserver)Registry.lookup("SecurityInterceptor.AuthenticationObserver"));
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 186 */     if (shouldBypassSecurity(mi)) {
/* 187 */       return getNext().invokeHome(mi);
/*     */     }
/* 189 */     SecurityContext sc = SecurityActions.getSecurityContext();
/* 190 */     if (sc == null) {
/* 191 */       throw new IllegalStateException("Security Context is null");
/*     */     }
/* 193 */     RunAs callerRunAsIdentity = sc.getIncomingRunAs();
/*     */ 
/* 196 */     checkSecurityContext(mi, callerRunAsIdentity);
/*     */ 
/* 202 */     if ((callerRunAsIdentity != null) && (this.isUseCallerIdentity)) {
/* 203 */       this.runAsIdentity = callerRunAsIdentity;
/*     */     }
/*     */ 
/* 210 */     SecurityActions.pushRunAsIdentity(this.runAsIdentity);
/*     */     try
/*     */     {
/* 214 */       Object returnValue = getNext().invokeHome(mi);
/* 215 */       localObject1 = returnValue;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 219 */       SecurityActions.popRunAsIdentity();
/* 220 */       SecurityActions.popSubjectContext();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 227 */     if (shouldBypassSecurity(mi)) {
/* 228 */       return getNext().invoke(mi);
/*     */     }
/* 230 */     SecurityContext sc = SecurityActions.getSecurityContext();
/* 231 */     if (sc == null) {
/* 232 */       throw new IllegalStateException("Security Context is null");
/*     */     }
/* 234 */     RunAs callerRunAsIdentity = sc.getIncomingRunAs();
/*     */ 
/* 237 */     checkSecurityContext(mi, callerRunAsIdentity);
/*     */ 
/* 243 */     if ((callerRunAsIdentity != null) && (this.isUseCallerIdentity)) {
/* 244 */       this.runAsIdentity = callerRunAsIdentity;
/*     */     }
/*     */ 
/* 250 */     SecurityActions.pushRunAsIdentity(this.runAsIdentity);
/*     */     try
/*     */     {
/* 254 */       Object returnValue = getNext().invoke(mi);
/* 255 */       localObject1 = returnValue;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 259 */       SecurityActions.popRunAsIdentity();
/* 260 */       SecurityActions.popSubjectContext();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void checkSecurityContext(Invocation mi, RunAs callerRunAsIdentity)
/*     */     throws Exception
/*     */   {
/* 272 */     Principal principal = mi.getPrincipal();
/* 273 */     Object credential = mi.getCredential();
/* 274 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 277 */     Method m = mi.getMethod();
/* 278 */     boolean containerMethod = (m == null) || (m.equals(this.ejbTimeout));
/* 279 */     if ((containerMethod == true) || (this.securityManager == null) || (this.container == null))
/*     */     {
/* 282 */       SecurityActions.pushSubjectContext(principal, credential, null);
/* 283 */       return;
/*     */     }
/*     */ 
/* 286 */     if (this.realmMapping == null)
/*     */     {
/* 288 */       throw new SecurityException("Role mapping manager has not been set");
/*     */     }
/*     */ 
/* 291 */     SecurityContext sc = SecurityActions.getSecurityContext();
/* 292 */     EJBAuthenticationHelper helper = new EJBAuthenticationHelper(sc);
/* 293 */     boolean isTrusted = helper.isTrusted();
/*     */ 
/* 295 */     if (!isTrusted)
/*     */     {
/* 298 */       Subject subject = new Subject();
/* 299 */       if (!helper.isValid(subject, m.getName()))
/*     */       {
/* 302 */         if (this.authenticationObserver != null) {
/* 303 */           this.authenticationObserver.authenticationFailed();
/*     */         }
/* 305 */         String msg = "Authentication exception, principal=" + principal;
/* 306 */         throw new SecurityException(msg);
/*     */       }
/*     */ 
/* 310 */       SecurityActions.pushSubjectContext(principal, credential, subject);
/* 311 */       if (trace)
/*     */       {
/* 313 */         this.log.trace("Authenticated  principal=" + principal);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 321 */       SecurityActions.pushRunAsIdentity(callerRunAsIdentity);
/*     */     }
/*     */ 
/* 324 */     Method ejbMethod = mi.getMethod();
/*     */ 
/* 326 */     if (ejbMethod == null) {
/* 327 */       return;
/*     */     }
/* 329 */     Subject caller = SecurityActions.getContextSubject();
/* 330 */     if (caller == null) {
/* 331 */       throw new IllegalStateException("Authenticated User. But caller subject is null");
/*     */     }
/*     */ 
/* 334 */     SecurityRolesAssociation.setSecurityRoles(this.deploymentRoles);
/*     */ 
/* 336 */     boolean isAuthorized = false;
/* 337 */     Set methodRoles = this.container.getMethodPermissions(ejbMethod, mi.getType());
/*     */ 
/* 339 */     SecurityContext currentSC = SecurityActions.getSecurityContext();
/* 340 */     if (currentSC.getSecurityManagement() == null)
/* 341 */       currentSC.setSecurityManagement(this.securityManagement);
/* 342 */     EJBAuthorizationHelper eah = new EJBAuthorizationHelper(currentSC);
/* 343 */     isAuthorized = eah.authorize(this.ejbName, ejbMethod, mi.getPrincipal(), mi.getType().toInterfaceString(), this.ejbCS, caller, callerRunAsIdentity, methodRoles);
/*     */ 
/* 352 */     String msg = "Denied: caller with subject=" + caller + " and security context post-mapping roles=" + currentSC.getUtil().getRoles();
/*     */ 
/* 355 */     if (!isAuthorized)
/* 356 */       throw new SecurityException(msg);
/*     */   }
/*     */ 
/*     */   private boolean shouldBypassSecurity(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 362 */     Method m = mi.getMethod();
/* 363 */     boolean containerMethod = (m == null) || (m.equals(this.ejbTimeout));
/* 364 */     if ((containerMethod == true) || (this.securityManager == null) || (this.container == null))
/*     */     {
/* 367 */       SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), "BYPASSED-SECURITY");
/*     */ 
/* 369 */       if (this.runAsIdentity != null)
/* 370 */         SecurityActions.pushRunAsIdentity(this.runAsIdentity);
/* 371 */       return true;
/*     */     }
/* 373 */     return false;
/*     */   }
/*     */ 
/*     */   public static abstract interface AuthenticationObserver
/*     */   {
/*     */     public static final String KEY = "SecurityInterceptor.AuthenticationObserver";
/*     */ 
/*     */     public abstract void authenticationFailed();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.SecurityInterceptor
 * JD-Core Version:    0.6.0
 */