/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 200 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader();
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(ClassLoader loader)
/*     */   {
/* 205 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(loader);
/*     */   }
/*     */ 
/*     */   static RunAs peekRunAsIdentity()
/*     */   {
/* 212 */     if (System.getSecurityManager() == null)
/*     */     {
/* 214 */       return RunAsIdentityActions.NON_PRIVILEGED.peek();
/*     */     }
/*     */ 
/* 218 */     return RunAsIdentityActions.PRIVILEGED.peek();
/*     */   }
/*     */ 
/*     */   static void pushRunAsIdentity(RunAs principal)
/*     */   {
/* 224 */     if (System.getSecurityManager() == null)
/*     */     {
/* 226 */       RunAsIdentityActions.NON_PRIVILEGED.push(principal);
/*     */     }
/*     */     else
/*     */     {
/* 230 */       RunAsIdentityActions.PRIVILEGED.push(principal);
/*     */     }
/*     */   }
/*     */ 
/*     */   static RunAs popRunAsIdentity()
/*     */   {
/* 236 */     if (System.getSecurityManager() == null)
/*     */     {
/* 238 */       return RunAsIdentityActions.NON_PRIVILEGED.pop();
/*     */     }
/*     */ 
/* 242 */     return RunAsIdentityActions.PRIVILEGED.pop();
/*     */   }
/*     */ 
/*     */   static Subject getContextSubject()
/*     */     throws PolicyContextException
/*     */   {
/* 250 */     if (System.getSecurityManager() == null)
/*     */     {
/* 252 */       return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
/*     */     }
/*     */ 
/* 256 */     return PolicyContextActions.PRIVILEGED.getContextSubject();
/*     */   }
/*     */ 
/*     */   static void createAndSetSecurityContext(Principal p, Object cred, String domain)
/*     */     throws PrivilegedActionException
/*     */   {
/* 382 */     AccessController.doPrivileged(new PrivilegedExceptionAction(p, cred, domain)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 386 */         SecurityContext sc = SecurityContextFactory.createSecurityContext(this.val$p, this.val$cred, null, this.val$domain);
/* 387 */         SecurityContextAssociation.setSecurityContext(sc);
/* 388 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void createAndSetSecurityContext(Principal p, Object cred, String domain, Subject subject) throws PrivilegedActionException {
/* 395 */     AccessController.doPrivileged(new PrivilegedExceptionAction(domain, p, cred, subject)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 399 */         SecurityContext sc = SecurityContextFactory.createSecurityContext(this.val$domain);
/* 400 */         sc.getUtil().createSubjectInfo(this.val$p, this.val$cred, this.val$subject);
/* 401 */         SecurityContextAssociation.setSecurityContext(sc);
/* 402 */         return null;
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static void clearSecurityContext() {
/* 408 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 412 */         SecurityContextAssociation.setSecurityContext(null);
/* 413 */         return null;
/*     */       } } );
/*     */   }
/*     */ 
/*     */   static SecurityContext getSecurityContext() {
/* 419 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run() {
/* 422 */         return SecurityContextAssociation.getSecurityContext();
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static Exception getContextException() {
/* 429 */     return (Exception)AccessController.doPrivileged(new PrivilegedAction() {
/*     */       static final String EX_KEY = "org.jboss.security.exception";
/*     */ 
/*     */       public Object run() {
/* 434 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 435 */         return sc.getData().get("org.jboss.security.exception");
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void pushSubjectContext(Principal p, Object cred, Subject s) {
/* 442 */     AccessController.doPrivileged(new PrivilegedAction(p, cred, s)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 446 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 447 */         if (sc == null)
/* 448 */           throw new IllegalStateException("Security Context is null");
/* 449 */         sc.getUtil().createSubjectInfo(this.val$p, this.val$cred, this.val$s);
/* 450 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void popSubjectContext() {
/* 457 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 461 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 462 */         if (sc == null)
/* 463 */           throw new IllegalStateException("Security Context is null");
/* 464 */         Principal p = sc.getUtil().getUserPrincipal();
/* 465 */         Object cred = sc.getUtil().getCredential();
/* 466 */         sc.getUtil().createSubjectInfo(p, cred, null);
/* 467 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void pushCallerRunAsIdentity(RunAs ra) {
/* 474 */     AccessController.doPrivileged(new PrivilegedAction(ra)
/*     */     {
/*     */       public Object run() {
/* 477 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 478 */         if (sc == null)
/* 479 */           throw new IllegalStateException("Security Context is null");
/* 480 */         sc.setIncomingRunAs(this.val$ra);
/* 481 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void popCallerRunAsIdentity() {
/* 488 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run() {
/* 491 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 492 */         if (sc == null)
/* 493 */           throw new IllegalStateException("Security Context is null");
/* 494 */         sc.setIncomingRunAs(null);
/* 495 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 290 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 294 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 299 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 304 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 309 */         thread.setContextClassLoader(cl);
/*     */       }
/* 290 */     };
/*     */ 
/* 313 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 315 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 319 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 315 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 325 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 330 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 334 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 341 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 346 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 347 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 355 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 360 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 361 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 313 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static SecurityActions.TCLAction getTCLAction()
/*     */       {
/* 266 */         return System.getSecurityManager() == null ? SecurityActions.TCLAction.NON_PRIVILEGED : SecurityActions.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 271 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 276 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 281 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 286 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface PolicyContextActions
/*     */   {
/*     */     public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
/* 158 */     public static final PolicyContextActions PRIVILEGED = new PolicyContextActions()
/*     */     {
/* 160 */       private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/* 164 */           return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */         }
/* 160 */       };
/*     */ 
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/*     */         Exception ex;
/*     */         try
/*     */         {
/* 172 */           return (Subject)AccessController.doPrivileged(this.exAction);
/*     */         }
/*     */         catch (PrivilegedActionException e)
/*     */         {
/* 176 */           ex = e.getException();
/* 177 */           if ((ex instanceof PolicyContextException))
/* 178 */             throw ((PolicyContextException)ex);
/*     */         }
/* 180 */         throw new UndeclaredThrowableException(ex);
/*     */       }
/* 158 */     };
/*     */ 
/* 185 */     public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions()
/*     */     {
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/* 190 */         return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */       }
/* 185 */     };
/*     */ 
/*     */     public abstract Subject getContextSubject()
/*     */       throws PolicyContextException;
/*     */   }
/*     */ 
/*     */   static abstract interface RunAsIdentityActions
/*     */   {
/*  52 */     public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/*  54 */       private final PrivilegedAction peekAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  59 */           SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  60 */           if (sc != null) {
/*  61 */             return sc.getOutgoingRunAs();
/*     */           }
/*  63 */           return null;
/*     */         }
/*  54 */       };
/*     */ 
/*  67 */       private final PrivilegedAction popAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  72 */           SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  73 */           if (sc == null)
/*  74 */             throw new IllegalStateException("Security Context is null");
/*  75 */           RunAs ra = sc.getOutgoingRunAs();
/*  76 */           sc.setOutgoingRunAs(null);
/*  77 */           return ra;
/*     */         }
/*  67 */       };
/*     */ 
/*     */       public RunAs peek()
/*     */       {
/*  83 */         return (RunAs)AccessController.doPrivileged(this.peekAction);
/*     */       }
/*     */ 
/*     */       public void push(RunAs id)
/*     */       {
/*  88 */         AccessController.doPrivileged(new PrivilegedAction(id)
/*     */         {
/*     */           public Object run()
/*     */           {
/*  94 */             SecurityContext sa = SecurityContextAssociation.getSecurityContext();
/*  95 */             if (sa == null)
/*  96 */               throw new IllegalStateException("Security Context is null to push runas");
/*  97 */             sa.setOutgoingRunAs(this.val$id);
/*  98 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public RunAs pop()
/*     */       {
/* 106 */         return (RunAs)AccessController.doPrivileged(this.popAction);
/*     */       }
/*  52 */     };
/*     */ 
/* 110 */     public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions()
/*     */     {
/*     */       public RunAs peek()
/*     */       {
/* 115 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 116 */         if (sc != null) {
/* 117 */           return sc.getOutgoingRunAs();
/*     */         }
/* 119 */         return null;
/*     */       }
/*     */ 
/*     */       public void push(RunAs id)
/*     */       {
/* 125 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 126 */         if (sc == null)
/* 127 */           throw new IllegalStateException("Security Context is null to push runas");
/* 128 */         sc.setOutgoingRunAs(id);
/*     */       }
/*     */ 
/*     */       public RunAs pop()
/*     */       {
/* 135 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 136 */         if (sc == null)
/* 137 */           throw new IllegalStateException("Security Context is null");
/* 138 */         RunAs ra = null;
/* 139 */         ra = sc.getOutgoingRunAs();
/* 140 */         sc.setOutgoingRunAs(null);
/* 141 */         return ra;
/*     */       }
/* 110 */     };
/*     */ 
/*     */     public abstract RunAs peek();
/*     */ 
/*     */     public abstract void push(RunAs paramRunAs);
/*     */ 
/*     */     public abstract RunAs pop();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.SecurityActions
 * JD-Core Version:    0.6.0
 */