/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.util.Set;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.AssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.SecurityIdentityMetaData;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ 
/*     */ public class RunAsSecurityInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected RunAs runAsIdentity;
/*     */   protected AuthenticationManager securityManager;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  65 */     super.setContainer(container);
/*  66 */     if (container != null)
/*     */     {
/*  68 */       BeanMetaData beanMetaData = container.getBeanMetaData();
/*  69 */       ApplicationMetaData application = beanMetaData.getApplicationMetaData();
/*  70 */       AssemblyDescriptorMetaData assemblyDescriptor = application.getAssemblyDescriptor();
/*     */ 
/*  72 */       SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
/*  73 */       if ((secMetaData != null) && (!secMetaData.getUseCallerIdentity()))
/*     */       {
/*  75 */         String roleName = secMetaData.getRunAsRoleName();
/*  76 */         String principalName = secMetaData.getRunAsPrincipalName();
/*  77 */         if (principalName == null) {
/*  78 */           principalName = application.getUnauthenticatedPrincipal();
/*     */         }
/*  80 */         Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
/*  81 */         this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
/*     */       }
/*     */ 
/*  84 */       this.securityManager = container.getSecurityManager();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*  91 */     super.start();
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi) throws Exception
/*     */   {
/*  96 */     String securityDomain = "other";
/*  97 */     if (this.securityManager != null)
/*     */     {
/*  99 */       securityDomain = this.securityManager.getSecurityDomain();
/*     */     }
/*     */ 
/* 103 */     if (SecurityActions.getSecurityContext() == null)
/*     */     {
/* 105 */       SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), securityDomain);
/*     */     }
/*     */ 
/* 113 */     SecurityActions.pushRunAsIdentity(this.runAsIdentity);
/* 114 */     SecurityActions.pushCallerRunAsIdentity(this.runAsIdentity);
/*     */     try
/*     */     {
/* 118 */       Object returnValue = getNext().invokeHome(mi);
/* 119 */       localObject1 = returnValue;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 123 */       SecurityActions.popRunAsIdentity();
/* 124 */       SecurityActions.popCallerRunAsIdentity();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi) throws Exception
/*     */   {
/* 130 */     String securityDomain = "other";
/* 131 */     if (this.securityManager != null)
/*     */     {
/* 133 */       securityDomain = this.securityManager.getSecurityDomain();
/*     */     }
/*     */ 
/* 136 */     if (SecurityActions.getSecurityContext() == null)
/*     */     {
/* 138 */       SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), securityDomain);
/*     */     }
/*     */ 
/* 147 */     SecurityActions.pushRunAsIdentity(this.runAsIdentity);
/* 148 */     SecurityActions.pushCallerRunAsIdentity(this.runAsIdentity);
/*     */     try
/*     */     {
/* 151 */       Object returnValue = getNext().invoke(mi);
/* 152 */       localObject1 = returnValue;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 156 */       SecurityActions.popRunAsIdentity();
/* 157 */       SecurityActions.popCallerRunAsIdentity();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.RunAsSecurityInterceptor
 * JD-Core Version:    0.6.0
 */