/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.ejb.BeanLock;
/*     */ import org.jboss.ejb.BeanLockManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.EntityCache;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceManager;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ 
/*     */ public class PerTxEntityInstanceCache
/*     */   implements EntityCache, PerTxEntityInstanceCacheMBean
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(PerTxEntityInstanceCache.class);
/*     */ 
/*  52 */   private final TransactionLocal txLocalCache = new TransactionLocal()
/*     */   {
/*     */     protected Object initialValue()
/*     */     {
/*  56 */       return new HashMap();
/*     */     }
/*  52 */   };
/*     */   private EntityContainer container;
/*     */ 
/*     */   public Object createCacheKey(Object id)
/*     */   {
/*  66 */     return id;
/*     */   }
/*     */ 
/*     */   public EnterpriseContext get(Object id) throws RemoteException, NoSuchObjectException
/*     */   {
/*  71 */     if (id == null) throw new IllegalArgumentException("Can't get an object with a null key");
/*     */ 
/*  73 */     Map cache = getLocalCache();
/*  74 */     EntityEnterpriseContext instance = (EntityEnterpriseContext)cache.get(id);
/*  75 */     if (instance == null)
/*     */     {
/*     */       try
/*     */       {
/*  80 */         instance = (EntityEnterpriseContext)this.container.getInstancePool().get();
/*     */ 
/*  82 */         instance.setId(id);
/*  83 */         instance.setCacheKey(id);
/*     */ 
/*  85 */         this.container.getPersistenceManager().activateEntity(instance);
/*     */ 
/*  87 */         cache.put(id, instance);
/*     */       }
/*     */       catch (Throwable x)
/*     */       {
/*  91 */         throw new NoSuchObjectException(x.getMessage());
/*     */       }
/*     */     }
/*  94 */     return instance;
/*     */   }
/*     */ 
/*     */   public void insert(EnterpriseContext instance)
/*     */   {
/*  99 */     if (instance == null) throw new IllegalArgumentException("Can't insert a null object in the cache");
/*     */ 
/* 101 */     EntityEnterpriseContext entity = (EntityEnterpriseContext)instance;
/* 102 */     getLocalCache().put(entity.getCacheKey(), instance);
/*     */   }
/*     */ 
/*     */   public void release(EnterpriseContext instance)
/*     */   {
/* 107 */     if (instance == null) throw new IllegalArgumentException("Can't release a null object");
/*     */ 
/* 109 */     tryToPassivate(instance);
/*     */   }
/*     */ 
/*     */   public void remove(Object id)
/*     */   {
/* 114 */     getLocalCache().remove(id);
/*     */   }
/*     */ 
/*     */   public boolean isActive(Object id)
/*     */   {
/* 119 */     return getLocalCache().containsKey(id);
/*     */   }
/*     */ 
/*     */   public long getCacheSize()
/*     */   {
/* 124 */     return 0L;
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setContainer(Container con)
/*     */   {
/* 135 */     this.container = ((EntityContainer)con);
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void tryToPassivate(EnterpriseContext instance)
/*     */   {
/* 160 */     Object id = instance.getId();
/* 161 */     if (id != null)
/*     */     {
/* 163 */       BeanLock lock = this.container.getLockManager().getLock(id);
/*     */       try
/*     */       {
/* 166 */         lock.sync();
/* 167 */         if (canPassivate(instance))
/*     */         {
/*     */           try
/*     */           {
/* 171 */             remove(id);
/* 172 */             EntityEnterpriseContext entity = (EntityEnterpriseContext)instance;
/* 173 */             this.container.getPersistenceManager().passivateEntity(entity);
/* 174 */             this.container.getInstancePool().free(instance);
/*     */           }
/*     */           catch (Exception ignored)
/*     */           {
/* 178 */             log.warn("failed to passivate, id=" + id, ignored);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 183 */           log.warn("Unable to passivate due to ctx lock, id=" + id);
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 188 */         lock.releaseSync();
/* 189 */         this.container.getLockManager().removeLockRef(id);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean canPassivate(EnterpriseContext ctx)
/*     */   {
/* 196 */     if (ctx.isLocked())
/*     */     {
/* 199 */       return false;
/*     */     }
/*     */ 
/* 202 */     if (ctx.getTransaction() != null)
/*     */     {
/* 204 */       return false;
/*     */     }
/*     */ 
/* 207 */     Object key = ((EntityEnterpriseContext)ctx).getCacheKey();
/* 208 */     return this.container.getLockManager().canPassivate(key);
/*     */   }
/*     */ 
/*     */   private Map getLocalCache()
/*     */   {
/* 215 */     return (Map)this.txLocalCache.get();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.PerTxEntityInstanceCache
 * JD-Core Version:    0.6.0
 */