/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.MessageDrivenContainer;
/*     */ import org.jboss.invocation.Invocation;
/*     */ 
/*     */ public class MessageDrivenInstanceInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected static final Method ejbTimeout;
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  72 */     throw new Error("Not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  81 */     MessageDrivenContainer mdc = (MessageDrivenContainer)this.container;
/*  82 */     InstancePool pool = mdc.getInstancePool();
/*  83 */     EnterpriseContext ctx = null;
/*     */     try
/*     */     {
/*  86 */       ctx = pool.get();
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/*  90 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  94 */       throw new EJBException("Unable to get an instance from the pool", e);
/*     */     }
/*     */ 
/*  98 */     ctx.setPrincipal(mi.getPrincipal());
/*     */ 
/* 101 */     mi.setEnterpriseContext(ctx);
/*     */ 
/* 103 */     EnterpriseBeanPolicyContextHandler.setEnterpriseBean(ctx.getInstance());
/*     */ 
/* 105 */     if (ejbTimeout.equals(mi.getMethod()))
/* 106 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_TIMEOUT);
/*     */     else {
/* 108 */       AllowedOperationsAssociation.pushInMethodFlag(IN_BUSINESS_METHOD);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 115 */       Object obj = getNext().invoke(mi);
/* 116 */       localObject1 = obj;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*     */       Object localObject1;
/* 120 */       mi.setEnterpriseContext(null);
/* 121 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 125 */       mi.setEnterpriseContext(null);
/* 126 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 130 */       mi.setEnterpriseContext(null);
/* 131 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 135 */       AllowedOperationsAssociation.popInMethodFlag();
/* 136 */       EnterpriseBeanPolicyContextHandler.setEnterpriseBean(null);
/*     */ 
/* 139 */       if (mi.getEnterpriseContext() != null)
/*     */       {
/* 141 */         pool.free((EnterpriseContext)mi.getEnterpriseContext());
/*     */       }
/*     */       else
/*     */       {
/* 145 */         pool.discard(ctx);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  56 */       ejbTimeout = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  60 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.MessageDrivenInstanceInterceptor
 * JD-Core Version:    0.6.0
 */