/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.AccessException;
/*     */ import java.rmi.MarshalException;
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.ServerError;
/*     */ import java.rmi.ServerException;
/*     */ import java.security.GeneralSecurityException;
/*     */ import javax.ejb.AccessLocalException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchEntityException;
/*     */ import javax.ejb.NoSuchObjectLocalException;
/*     */ import javax.ejb.TransactionRolledbackLocalException;
/*     */ import javax.transaction.TransactionRolledbackException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.invocation.JBossLazyUnmarshallingException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ import org.jboss.tm.JBossTransactionRolledbackException;
/*     */ import org.jboss.tm.JBossTransactionRolledbackLocalException;
/*     */ 
/*     */ public class LogInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected String ejbName;
/*     */   protected boolean callLogging;
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  71 */     super.start();
/*     */ 
/*  73 */     BeanMetaData md = getContainer().getBeanMetaData();
/*  74 */     this.ejbName = md.getEjbName();
/*     */ 
/*  77 */     this.callLogging = md.getContainerConfiguration().getCallLogging();
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation invocation)
/*     */     throws Exception
/*     */   {
/*     */     String methodName;
/*     */     String methodName;
/*  93 */     if (invocation.getMethod() != null)
/*     */     {
/*  95 */       methodName = invocation.getMethod().getName();
/*     */     }
/*     */     else
/*     */     {
/*  99 */       methodName = "<no method>";
/*     */     }
/*     */ 
/* 102 */     boolean trace = this.log.isTraceEnabled();
/* 103 */     if (trace)
/*     */     {
/* 105 */       this.log.trace("Start method=" + methodName);
/*     */     }
/*     */     StringBuffer str;
/* 109 */     if (this.callLogging)
/*     */     {
/* 111 */       str = new StringBuffer("InvokeHome: ");
/* 112 */       str.append(methodName);
/* 113 */       str.append("(");
/* 114 */       Object[] args = invocation.getArguments();
/* 115 */       if (args != null)
/*     */       {
/* 117 */         for (int i = 0; i < args.length; i++)
/*     */         {
/* 119 */           if (i > 0)
/*     */           {
/* 121 */             str.append(",");
/*     */           }
/* 123 */           str.append(args[i]);
/*     */         }
/*     */       }
/* 126 */       str.append(")");
/* 127 */       this.log.debug(str.toString());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 132 */       str = getNext().invokeHome(invocation);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 136 */       throw handleException(e, invocation);
/*     */     }
/*     */     finally
/*     */     {
/* 140 */       if (trace)
/*     */       {
/* 142 */         this.log.trace("End method=" + methodName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/*     */     String methodName;
/*     */     String methodName;
/* 160 */     if (invocation.getMethod() != null)
/*     */     {
/* 162 */       methodName = invocation.getMethod().getName();
/*     */     }
/*     */     else
/*     */     {
/* 166 */       methodName = "<no method>";
/*     */     }
/*     */ 
/* 169 */     boolean trace = this.log.isTraceEnabled();
/* 170 */     if (trace)
/*     */     {
/* 172 */       this.log.trace("Start method=" + methodName);
/*     */     }
/*     */     StringBuffer str;
/* 176 */     if (this.callLogging)
/*     */     {
/* 178 */       str = new StringBuffer("Invoke: ");
/* 179 */       if (invocation.getId() != null)
/*     */       {
/* 181 */         str.append("[");
/* 182 */         str.append(invocation.getId().toString());
/* 183 */         str.append("] ");
/*     */       }
/* 185 */       str.append(methodName);
/* 186 */       str.append("(");
/* 187 */       Object[] args = invocation.getArguments();
/* 188 */       if (args != null)
/*     */       {
/* 190 */         for (int i = 0; i < args.length; i++)
/*     */         {
/* 192 */           if (i > 0)
/*     */           {
/* 194 */             str.append(",");
/*     */           }
/* 196 */           str.append(args[i]);
/*     */         }
/*     */       }
/* 199 */       str.append(")");
/* 200 */       this.log.debug(str.toString());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 205 */       str = getNext().invoke(invocation);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 209 */       throw handleException(e, invocation);
/*     */     }
/*     */     finally
/*     */     {
/* 213 */       if (trace)
/*     */       {
/* 215 */         this.log.trace("End method=" + methodName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private Exception handleException(Throwable e, Invocation invocation)
/*     */   {
/* 234 */     InvocationType type = invocation.getType();
/* 235 */     boolean isLocal = (type == InvocationType.LOCAL) || (type == InvocationType.LOCALHOME);
/*     */ 
/* 239 */     if (((e instanceof TransactionRolledbackLocalException)) || ((e instanceof TransactionRolledbackException)))
/*     */     {
/* 244 */       if ((isLocal) && ((e instanceof TransactionRolledbackException)))
/*     */       {
/* 246 */         TransactionRolledbackException remoteTxRollback = (TransactionRolledbackException)e;
/*     */         Exception cause;
/*     */         Exception cause;
/* 250 */         if ((remoteTxRollback.detail instanceof Exception))
/*     */         {
/* 252 */           cause = (Exception)remoteTxRollback.detail;
/*     */         }
/*     */         else
/*     */         {
/*     */           Exception cause;
/* 254 */           if ((remoteTxRollback.detail instanceof Error))
/*     */           {
/* 256 */             String msg = formatException("Unexpected Error", remoteTxRollback.detail);
/*     */ 
/* 259 */             cause = new EJBException(msg);
/*     */           }
/*     */           else
/*     */           {
/* 263 */             String msg = formatException("Unexpected Throwable", remoteTxRollback.detail);
/*     */ 
/* 266 */             cause = new EJBException(msg);
/*     */           }
/*     */         }
/* 269 */         e = new JBossTransactionRolledbackLocalException(remoteTxRollback.getMessage(), cause);
/*     */       }
/*     */ 
/* 276 */       if ((!isLocal) && ((e instanceof TransactionRolledbackLocalException)))
/*     */       {
/* 278 */         TransactionRolledbackLocalException localTxRollback = (TransactionRolledbackLocalException)e;
/*     */ 
/* 280 */         e = new JBossTransactionRolledbackException(localTxRollback.getMessage(), localTxRollback.getCausedByException());
/*     */       }
/*     */ 
/* 285 */       Throwable cause = null;
/* 286 */       String exceptionType = null;
/* 287 */       if ((e instanceof TransactionRolledbackException))
/*     */       {
/* 289 */         cause = ((TransactionRolledbackException)e).detail;
/* 290 */         exceptionType = "TransactionRolledbackException";
/*     */       }
/*     */       else
/*     */       {
/* 294 */         cause = ((TransactionRolledbackLocalException)e).getCausedByException();
/*     */ 
/* 296 */         exceptionType = "TransactionRolledbackLocalException";
/*     */       }
/*     */ 
/* 300 */       if (cause != null)
/*     */       {
/* 303 */         if (((cause instanceof EJBException)) && (((EJBException)cause).getCausedByException() != null))
/*     */         {
/* 306 */           cause = ((EJBException)cause).getCausedByException();
/*     */         }
/* 308 */         this.log.error(exceptionType + " in method: " + invocation.getMethod() + ", causedBy:", cause);
/*     */       }
/*     */       else
/*     */       {
/* 313 */         this.log.error(exceptionType + " in method: " + invocation.getMethod(), e);
/*     */       }
/* 315 */       return (Exception)e;
/*     */     }
/* 317 */     if ((e instanceof NoSuchEntityException))
/*     */     {
/* 319 */       NoSuchEntityException noSuchEntityException = (NoSuchEntityException)e;
/*     */ 
/* 321 */       if (noSuchEntityException.getCausedByException() != null)
/*     */       {
/* 323 */         this.log.error("NoSuchEntityException in method: " + invocation.getMethod() + ", causedBy:", noSuchEntityException.getCausedByException());
/*     */       }
/*     */       else
/*     */       {
/* 328 */         this.log.error("NoSuchEntityException in method: " + invocation.getMethod() + ":", noSuchEntityException);
/*     */       }
/*     */ 
/* 331 */       if (isLocal)
/*     */       {
/* 333 */         return new NoSuchObjectLocalException(noSuchEntityException.getMessage(), noSuchEntityException.getCausedByException());
/*     */       }
/*     */ 
/* 339 */       NoSuchObjectException noSuchObjectException = new NoSuchObjectException(noSuchEntityException.getMessage());
/*     */ 
/* 341 */       noSuchObjectException.detail = noSuchEntityException;
/* 342 */       return noSuchObjectException;
/*     */     }
/*     */ 
/* 345 */     if ((e instanceof EJBException))
/*     */     {
/* 347 */       EJBException ejbException = (EJBException)e;
/* 348 */       if (ejbException.getCausedByException() != null)
/*     */       {
/* 350 */         this.log.error("EJBException in method: " + invocation.getMethod() + ", causedBy:", ejbException.getCausedByException());
/*     */       }
/*     */       else
/*     */       {
/* 355 */         this.log.error("EJBException in method: " + invocation.getMethod() + ":", ejbException);
/*     */       }
/*     */ 
/* 358 */       if (isLocal)
/*     */       {
/* 360 */         return ejbException;
/*     */       }
/*     */ 
/* 365 */       return new ServerException("EJBException:", ejbException);
/*     */     }
/*     */ 
/* 373 */     if (((e instanceof SecurityException)) || ((e instanceof GeneralSecurityException)))
/*     */     {
/* 375 */       Exception runtimeException = (Exception)e;
/* 376 */       if (this.log.isTraceEnabled())
/* 377 */         this.log.trace("SecurityException in method: " + invocation.getMethod() + ":", runtimeException);
/* 378 */       if (isAppException(invocation, e))
/*     */       {
/* 380 */         return runtimeException;
/*     */       }
/* 382 */       if (isLocal)
/*     */       {
/* 384 */         return new AccessLocalException("SecurityException", runtimeException);
/*     */       }
/*     */ 
/* 388 */       return new AccessException("SecurityException", runtimeException);
/*     */     }
/*     */ 
/* 394 */     if ((e instanceof JBossLazyUnmarshallingException))
/*     */     {
/* 396 */       RuntimeException runtimeException = (RuntimeException)e;
/* 397 */       this.log.error("UnmarshalException:", e);
/*     */ 
/* 399 */       if (isLocal)
/*     */       {
/* 401 */         return new EJBException("UnmarshalException", runtimeException);
/*     */       }
/*     */ 
/* 405 */       return new MarshalException("MarshalException", runtimeException);
/*     */     }
/*     */ 
/* 410 */     if ((e instanceof RuntimeException))
/*     */     {
/* 412 */       RuntimeException runtimeException = (RuntimeException)e;
/* 413 */       this.log.error("RuntimeException in method: " + invocation.getMethod() + ":", runtimeException);
/*     */ 
/* 415 */       if (isLocal)
/*     */       {
/* 417 */         return new EJBException("RuntimeException", runtimeException);
/*     */       }
/*     */ 
/* 421 */       return new ServerException("RuntimeException", runtimeException);
/*     */     }
/*     */ 
/* 424 */     if ((e instanceof Error))
/*     */     {
/* 426 */       this.log.error("Unexpected Error in method: " + invocation.getMethod(), e);
/* 427 */       if (isLocal)
/*     */       {
/* 429 */         String msg = formatException("Unexpected Error", e);
/* 430 */         return new EJBException(msg);
/*     */       }
/*     */ 
/* 434 */       return new ServerError("Unexpected Error", (Error)e);
/*     */     }
/*     */ 
/* 440 */     if ((isLocal) && ((e instanceof RemoteException)))
/*     */     {
/* 442 */       if (this.callLogging)
/*     */       {
/* 444 */         this.log.info("Remote Exception in method: " + invocation.getMethod(), e);
/*     */       }
/* 446 */       return new EJBException((RemoteException)e);
/*     */     }
/*     */ 
/* 449 */     if ((e instanceof Exception))
/*     */     {
/* 451 */       if (this.callLogging)
/*     */       {
/* 453 */         this.log.info("Application Exception in method: " + invocation.getMethod(), e);
/*     */       }
/* 455 */       return (Exception)e;
/*     */     }
/*     */ 
/* 460 */     String msg = formatException("Unexpected Throwable", e);
/* 461 */     this.log.warn("Unexpected Throwable in method: " + invocation.getMethod(), e);
/* 462 */     if (isLocal)
/*     */     {
/* 464 */       return new EJBException(msg);
/*     */     }
/*     */ 
/* 468 */     return new ServerException(msg);
/*     */   }
/*     */ 
/*     */   private String formatException(String msg, Throwable t)
/*     */   {
/* 475 */     StringWriter sw = new StringWriter();
/* 476 */     PrintWriter pw = new PrintWriter(sw);
/* 477 */     if (msg != null)
/* 478 */       pw.println(msg);
/* 479 */     if (t != null)
/*     */     {
/* 481 */       t.printStackTrace(pw);
/*     */     }
/* 483 */     return sw.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.LogInterceptor
 * JD-Core Version:    0.6.0
 */