/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.util.LRUCachePolicy.LRUCacheEntry;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class LRUStatefulContextCachePolicy extends LRUEnterpriseContextCachePolicy
/*     */ {
/*     */   private long m_maxBeanLife;
/*     */   private TimerTask m_remover;
/*     */   private long m_removerPeriod;
/*     */   private StatefulSessionInstanceCache ssiCache;
/*     */ 
/*     */   public LRUStatefulContextCachePolicy(AbstractInstanceCache eic)
/*     */   {
/*  61 */     super(eic);
/*  62 */     this.ssiCache = ((StatefulSessionInstanceCache)eic);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  72 */     super.start();
/*  73 */     if (this.m_maxBeanLife > 0L)
/*     */     {
/*  75 */       this.m_remover = new RemoverTask(this.m_removerPeriod);
/*  76 */       long delay = ()(Math.random() * this.m_removerPeriod);
/*  77 */       tasksTimer.schedule(this.m_remover, delay, this.m_removerPeriod);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*  83 */     if (this.m_remover != null)
/*     */     {
/*  85 */       this.m_remover.cancel();
/*     */     }
/*  87 */     super.stop();
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws DeploymentException
/*     */   {
/*  96 */     super.importXml(element);
/*     */ 
/*  98 */     String rp = MetaData.getElementContent(MetaData.getOptionalChild(element, "remover-period"));
/*  99 */     String ml = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-bean-life"));
/*     */     try
/*     */     {
/* 102 */       if (rp != null)
/*     */       {
/* 104 */         int p = Integer.parseInt(rp);
/* 105 */         if (p <= 0)
/*     */         {
/* 107 */           throw new DeploymentException("Remover period can't be <= 0");
/*     */         }
/* 109 */         this.m_removerPeriod = (p * 1000);
/*     */       }
/* 111 */       if (ml != null)
/*     */       {
/* 113 */         int a = Integer.parseInt(ml);
/* 114 */         if (a <= 0)
/*     */         {
/* 116 */           throw new DeploymentException("Max bean life can't be <= 0");
/*     */         }
/* 118 */         this.m_maxBeanLife = (a * 1000);
/*     */       }
/*     */     }
/*     */     catch (NumberFormatException x)
/*     */     {
/* 123 */       throw new DeploymentException("Can't parse policy configuration", x);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class RemoverTask extends LRUEnterpriseContextCachePolicy.OveragerTask
/*     */   {
/*     */     protected RemoverTask(long period)
/*     */     {
/* 143 */       super(period);
/*     */     }
/*     */ 
/*     */     protected String getTaskLogMessage()
/*     */     {
/* 148 */       return "Removing from cache bean";
/*     */     }
/*     */ 
/*     */     protected void kickOut(LRUCachePolicy.LRUCacheEntry entry)
/*     */     {
/* 153 */       LRUStatefulContextCachePolicy.this.remove(entry.m_key);
/*     */     }
/*     */ 
/*     */     protected long getMaxAge()
/*     */     {
/* 158 */       return LRUStatefulContextCachePolicy.this.m_maxBeanLife;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 163 */       if (LRUStatefulContextCachePolicy.this.ssiCache == null)
/*     */       {
/* 165 */         cancel();
/* 166 */         return;
/*     */       }
/*     */ 
/* 169 */       synchronized (LRUStatefulContextCachePolicy.this.ssiCache.getCacheLock())
/*     */       {
/* 171 */         LRUEnterpriseContextCachePolicy.log.debug("Running RemoverTask");
/*     */ 
/* 173 */         super.run();
/* 174 */         LRUEnterpriseContextCachePolicy.log.debug("RemoverTask, PassivatedCount=" + LRUStatefulContextCachePolicy.this.ssiCache.getPassivatedCount());
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 179 */         LRUStatefulContextCachePolicy.this.ssiCache.removePassivated(getMaxAge() - super.getMaxAge());
/* 180 */         LRUEnterpriseContextCachePolicy.log.debug("RemoverTask, done");
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 184 */         LRUEnterpriseContextCachePolicy.log.debug("Ignored error trying to remove passivated beans from cache", t);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.LRUStatefulContextCachePolicy
 * JD-Core Version:    0.6.0
 */