/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.XmlLoadable;
/*     */ import org.jboss.monitor.Monitorable;
/*     */ import org.jboss.monitor.client.BeanCacheSnapshot;
/*     */ import org.jboss.util.LRUCachePolicy;
/*     */ import org.jboss.util.LRUCachePolicy.LRUCacheEntry;
/*     */ import org.jboss.util.LRUCachePolicy.LRUList;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class LRUEnterpriseContextCachePolicy extends LRUCachePolicy
/*     */   implements XmlLoadable, Monitorable
/*     */ {
/*  52 */   protected static Logger log = Logger.getLogger(LRUEnterpriseContextCachePolicy.class);
/*  53 */   protected static Timer tasksTimer = new Timer(true);
/*     */   private AbstractInstanceCache m_cache;
/*     */   private long m_resizerPeriod;
/*     */   private long m_overagerPeriod;
/*     */   private long m_maxBeanAge;
/*     */   private long m_minPeriod;
/*     */   private long m_maxPeriod;
/*     */   private double m_factor;
/*     */   private TimerTask m_overager;
/*     */   private TimerTask m_resizer;
/*  96 */   private StringBuffer m_buffer = new StringBuffer();
/*     */ 
/*     */   public LRUEnterpriseContextCachePolicy(AbstractInstanceCache eic)
/*     */   {
/* 109 */     if (eic == null) {
/* 110 */       throw new IllegalArgumentException("Instance cache argument cannot be null");
/*     */     }
/*     */ 
/* 113 */     this.m_cache = eic;
/*     */   }
/*     */ 
/*     */   public void sample(Object s)
/*     */   {
/* 122 */     if (this.m_cache == null) {
/* 123 */       return;
/*     */     }
/* 125 */     BeanCacheSnapshot snapshot = (BeanCacheSnapshot)s;
/* 126 */     LRUCachePolicy.LRUList list = getList();
/* 127 */     synchronized (this.m_cache.getCacheLock())
/*     */     {
/* 129 */       snapshot.m_cacheMinCapacity = list.m_minCapacity;
/* 130 */       snapshot.m_cacheMaxCapacity = list.m_maxCapacity;
/* 131 */       snapshot.m_cacheCapacity = list.m_capacity;
/* 132 */       snapshot.m_cacheSize = list.m_count;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 140 */     if (this.m_resizerPeriod > 0L)
/*     */     {
/* 142 */       this.m_resizer = new ResizerTask(this.m_resizerPeriod);
/* 143 */       long delay = ()(Math.random() * this.m_resizerPeriod);
/* 144 */       tasksTimer.schedule(this.m_resizer, delay, this.m_resizerPeriod);
/*     */     }
/*     */ 
/* 147 */     if (this.m_overagerPeriod > 0L)
/*     */     {
/* 149 */       this.m_overager = new OveragerTask(this.m_overagerPeriod);
/* 150 */       long delay = ()(Math.random() * this.m_overagerPeriod);
/* 151 */       tasksTimer.schedule(this.m_overager, delay, this.m_overagerPeriod);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 157 */     if (this.m_resizer != null) this.m_resizer.cancel();
/* 158 */     if (this.m_overager != null) this.m_overager.cancel();
/* 159 */     super.stop();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 164 */     this.m_overager = null;
/* 165 */     this.m_resizer = null;
/* 166 */     this.m_cache = null;
/* 167 */     super.destroy();
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws DeploymentException
/*     */   {
/* 182 */     String min = MetaData.getElementContent(MetaData.getOptionalChild(element, "min-capacity"));
/* 183 */     String max = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-capacity"));
/* 184 */     String op = MetaData.getElementContent(MetaData.getOptionalChild(element, "overager-period"));
/* 185 */     String rp = MetaData.getElementContent(MetaData.getOptionalChild(element, "resizer-period"));
/* 186 */     String ma = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-bean-age"));
/* 187 */     String map = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-cache-miss-period"));
/* 188 */     String mip = MetaData.getElementContent(MetaData.getOptionalChild(element, "min-cache-miss-period"));
/* 189 */     String fa = MetaData.getElementContent(MetaData.getOptionalChild(element, "cache-load-factor"));
/*     */     try
/*     */     {
/* 192 */       if (min != null)
/*     */       {
/* 194 */         int s = Integer.parseInt(min);
/* 195 */         if (s <= 0)
/*     */         {
/* 197 */           throw new DeploymentException("Min cache capacity can't be <= 0");
/*     */         }
/* 199 */         this.m_minCapacity = s;
/*     */       }
/* 201 */       if (max != null)
/*     */       {
/* 203 */         int s = Integer.parseInt(max);
/* 204 */         if (s <= 0)
/*     */         {
/* 206 */           throw new DeploymentException("Max cache capacity can't be <= 0");
/*     */         }
/* 208 */         this.m_maxCapacity = s;
/*     */       }
/* 210 */       if (op != null)
/*     */       {
/* 212 */         int p = Integer.parseInt(op);
/* 213 */         if (p <= 0) throw new DeploymentException("Overager period can't be <= 0");
/* 214 */         this.m_overagerPeriod = (p * 1000);
/*     */       }
/* 216 */       if (rp != null)
/*     */       {
/* 218 */         int p = Integer.parseInt(rp);
/* 219 */         if (p <= 0) throw new DeploymentException("Resizer period can't be <= 0");
/* 220 */         this.m_resizerPeriod = (p * 1000);
/*     */       }
/* 222 */       if (ma != null)
/*     */       {
/* 224 */         int a = Integer.parseInt(ma);
/* 225 */         if (a <= 0) throw new DeploymentException("Max bean age can't be <= 0");
/* 226 */         this.m_maxBeanAge = (a * 1000);
/*     */       }
/* 228 */       if (map != null)
/*     */       {
/* 230 */         int p = Integer.parseInt(map);
/* 231 */         if (p <= 0) throw new DeploymentException("Max cache miss period can't be <= 0");
/* 232 */         this.m_maxPeriod = (p * 1000);
/*     */       }
/* 234 */       if (mip != null)
/*     */       {
/* 236 */         int p = Integer.parseInt(mip);
/* 237 */         if (p <= 0) throw new DeploymentException("Min cache miss period can't be <= 0");
/* 238 */         this.m_minPeriod = (p * 1000);
/*     */       }
/* 240 */       if (fa != null)
/*     */       {
/* 242 */         double f = Double.parseDouble(fa);
/* 243 */         if (f <= 0.0D) throw new DeploymentException("Cache load factor can't be <= 0");
/* 244 */         this.m_factor = f;
/*     */       }
/*     */     }
/*     */     catch (NumberFormatException x)
/*     */     {
/* 249 */       throw new DeploymentException("Can't parse policy configuration", x);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 264 */     int i = size();
/* 265 */     LRUCachePolicy.LRUCacheEntry entry = null;
/* 266 */     while ((i-- > 0) && ((entry = this.m_list.m_tail) != null))
/*     */     {
/* 268 */       ageOut(entry);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected LRUCachePolicy.LRUList createList()
/*     */   {
/* 278 */     return new ContextLRUList();
/*     */   }
/*     */ 
/*     */   protected void ageOut(LRUCachePolicy.LRUCacheEntry entry)
/*     */   {
/* 284 */     if (this.m_cache == null) {
/* 285 */       return;
/*     */     }
/* 287 */     if (entry == null)
/*     */     {
/* 289 */       throw new IllegalArgumentException("Cannot remove a null cache entry");
/*     */     }
/*     */ 
/* 293 */     if (log.isTraceEnabled())
/*     */     {
/* 295 */       this.m_buffer.setLength(0);
/* 296 */       this.m_buffer.append("Aging out from cache bean ");
/* 297 */       this.m_buffer.append(this.m_cache.getContainer().getBeanMetaData().getEjbName());
/* 298 */       this.m_buffer.append("with id = ");
/* 299 */       this.m_buffer.append(entry.m_key);
/* 300 */       this.m_buffer.append("; cache size = ");
/* 301 */       this.m_buffer.append(getList().m_count);
/* 302 */       log.trace(this.m_buffer.toString());
/*     */     }
/*     */ 
/* 306 */     this.m_cache.release((EnterpriseContext)entry.m_object);
/*     */   }
/*     */ 
/*     */   protected void cacheMiss() {
/* 310 */     LRUCachePolicy.LRUList list = getList();
/* 311 */     list.m_cacheMiss += 1;
/*     */   }
/*     */ 
/*     */   private LRUCachePolicy.LRUList getList()
/*     */   {
/* 318 */     return this.m_list;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  56 */     log.debug("Cache policy timer started, tasksTimer=" + tasksTimer);
/*     */   }
/*     */ 
/*     */   protected class ContextLRUList extends LRUCachePolicy.LRUList
/*     */   {
/* 494 */     boolean trace = LRUEnterpriseContextCachePolicy.log.isTraceEnabled();
/*     */ 
/*     */     protected ContextLRUList()
/*     */     {
/* 492 */       super();
/*     */     }
/*     */ 
/*     */     protected void entryPromotion(LRUCachePolicy.LRUCacheEntry entry)
/*     */     {
/* 497 */       if (this.trace) {
/* 498 */         LRUEnterpriseContextCachePolicy.log.trace("entryPromotion, entry=" + entry);
/*     */       }
/*     */ 
/* 501 */       if ((this.m_count == this.m_capacity) && (this.m_capacity >= this.m_maxCapacity))
/*     */       {
/* 503 */         this.m_capacity += 1;
/* 504 */         LRUEnterpriseContextCachePolicy.log.warn("Cache has reached maximum capacity for container " + LRUEnterpriseContextCachePolicy.this.m_cache.getContainer().getJmxName() + " - probably because all instances are in use. " + "Temporarily increasing the size to " + this.m_capacity);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void entryAdded(LRUCachePolicy.LRUCacheEntry entry)
/*     */     {
/* 512 */       if (this.trace)
/* 513 */         LRUEnterpriseContextCachePolicy.log.trace("entryAdded, entry=" + entry);
/*     */     }
/*     */ 
/*     */     protected void entryRemoved(LRUCachePolicy.LRUCacheEntry entry) {
/* 517 */       if (this.trace)
/* 518 */         LRUEnterpriseContextCachePolicy.log.trace("entryRemoved, entry=" + entry);
/*     */     }
/*     */ 
/*     */     protected void capacityChanged(int oldCapacity) {
/* 522 */       if (this.trace)
/* 523 */         LRUEnterpriseContextCachePolicy.log.trace("capacityChanged, oldCapacity=" + oldCapacity);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class OveragerTask extends TimerTask
/*     */   {
/*     */     private String m_message;
/*     */     private StringBuffer m_buffer;
/*     */ 
/*     */     protected OveragerTask(long period)
/*     */     {
/* 407 */       this.m_message = (getTaskLogMessage() + " " + LRUEnterpriseContextCachePolicy.this.m_cache.getContainer().getBeanMetaData().getEjbName() + " with id = ");
/*     */ 
/* 410 */       this.m_buffer = new StringBuffer();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 415 */       if (LRUEnterpriseContextCachePolicy.this.m_cache == null)
/*     */       {
/* 417 */         cancel();
/* 418 */         return;
/*     */       }
/*     */ 
/* 421 */       LRUCachePolicy.LRUList list = LRUEnterpriseContextCachePolicy.this.getList();
/* 422 */       long now = System.currentTimeMillis();
/* 423 */       ArrayList passivateEntries = null;
/* 424 */       synchronized (LRUEnterpriseContextCachePolicy.this.m_cache.getCacheLock())
/*     */       {
/* 426 */         for (LRUCachePolicy.LRUCacheEntry entry = list.m_tail; entry != null; entry = entry.m_prev)
/*     */         {
/* 428 */           if (now - entry.m_time < getMaxAge()) {
/*     */             break;
/*     */           }
/* 431 */           if (passivateEntries == null) passivateEntries = new ArrayList();
/* 432 */           passivateEntries.add(entry);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 443 */       if (passivateEntries != null)
/*     */       {
/* 445 */         for (int i = 0; i < passivateEntries.size(); i++)
/*     */         {
/* 447 */           LRUCachePolicy.LRUCacheEntry entry = (LRUCachePolicy.LRUCacheEntry)passivateEntries.get(i);
/*     */           try
/*     */           {
/* 450 */             LRUEnterpriseContextCachePolicy.this.m_cache.tryToPassivate((EnterpriseContext)entry.m_object);
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 454 */             LRUEnterpriseContextCachePolicy.log.debug("Ignored error while trying to passivate ctx", t);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     private void log(Object key, int count)
/*     */     {
/* 462 */       if (LRUEnterpriseContextCachePolicy.log.isTraceEnabled())
/*     */       {
/* 464 */         this.m_buffer.setLength(0);
/* 465 */         this.m_buffer.append(this.m_message);
/* 466 */         this.m_buffer.append(key);
/* 467 */         this.m_buffer.append(" - Cache size = ");
/* 468 */         this.m_buffer.append(count);
/* 469 */         LRUEnterpriseContextCachePolicy.log.trace(this.m_buffer.toString());
/*     */       }
/*     */     }
/*     */ 
/*     */     protected String getTaskLogMessage()
/*     */     {
/* 475 */       return "Scheduling for passivation overaged bean";
/*     */     }
/*     */ 
/*     */     protected String getJMSTaskType()
/*     */     {
/* 480 */       return "OVERAGER";
/*     */     }
/*     */ 
/*     */     protected long getMaxAge()
/*     */     {
/* 485 */       return LRUEnterpriseContextCachePolicy.this.m_maxBeanAge;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class ResizerTask extends TimerTask
/*     */   {
/*     */     private String m_message;
/*     */     private StringBuffer m_buffer;
/*     */     private long resizerPeriod;
/*     */ 
/*     */     protected ResizerTask(long resizerPeriod)
/*     */     {
/* 338 */       this.resizerPeriod = resizerPeriod;
/* 339 */       this.m_message = ("Resized cache for bean " + LRUEnterpriseContextCachePolicy.this.m_cache.getContainer().getBeanMetaData().getEjbName() + ": old capacity = ");
/*     */ 
/* 342 */       this.m_buffer = new StringBuffer();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 348 */       if (LRUEnterpriseContextCachePolicy.this.m_cache == null)
/*     */       {
/* 350 */         cancel();
/* 351 */         return;
/*     */       }
/*     */ 
/* 354 */       LRUCachePolicy.LRUList list = LRUEnterpriseContextCachePolicy.this.getList();
/*     */ 
/* 357 */       synchronized (LRUEnterpriseContextCachePolicy.this.m_cache.getCacheLock())
/*     */       {
/* 359 */         int period = list.m_cacheMiss == 0 ? 2147483647 : (int)(this.resizerPeriod / list.m_cacheMiss);
/* 360 */         int cap = list.m_capacity;
/* 361 */         if ((period <= LRUEnterpriseContextCachePolicy.this.m_minPeriod) && (cap < list.m_maxCapacity))
/*     */         {
/* 365 */           double factor = 1.0D + LRUEnterpriseContextCachePolicy.this.m_minPeriod / period * (1.0D - LRUEnterpriseContextCachePolicy.this.m_factor);
/* 366 */           int newCap = (int)(cap * factor);
/* 367 */           list.m_capacity = (newCap < list.m_maxCapacity ? newCap : list.m_maxCapacity);
/* 368 */           log(cap, list.m_capacity);
/*     */         }
/* 370 */         else if ((period >= LRUEnterpriseContextCachePolicy.this.m_maxPeriod) && (cap > list.m_minCapacity) && (list.m_count < cap * LRUEnterpriseContextCachePolicy.this.m_factor))
/*     */         {
/* 375 */           int newCap = (int)(list.m_count / LRUEnterpriseContextCachePolicy.this.m_factor);
/* 376 */           list.m_capacity = (newCap > list.m_minCapacity ? newCap : list.m_minCapacity);
/* 377 */           log(cap, list.m_capacity);
/*     */         }
/* 379 */         list.m_cacheMiss = 0;
/*     */       }
/*     */     }
/*     */ 
/*     */     private void log(int oldCapacity, int newCapacity)
/*     */     {
/* 385 */       if (LRUEnterpriseContextCachePolicy.log.isTraceEnabled())
/*     */       {
/* 387 */         this.m_buffer.setLength(0);
/* 388 */         this.m_buffer.append(this.m_message);
/* 389 */         this.m_buffer.append(oldCapacity);
/* 390 */         this.m_buffer.append(", new capacity = ");
/* 391 */         this.m_buffer.append(newCapacity);
/* 392 */         LRUEnterpriseContextCachePolicy.log.trace(this.m_buffer.toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.LRUEnterpriseContextCachePolicy
 * JD-Core Version:    0.6.0
 */