/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.cache.invalidation.Invalidatable;
/*     */ import org.jboss.cache.invalidation.InvalidationGroup;
/*     */ import org.jboss.cache.invalidation.InvalidationManagerMBean;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.CacheInvalidationConfigMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.util.CachePolicy;
/*     */ 
/*     */ public class InvalidableEntityInstanceCache extends EntityInstanceCache
/*     */   implements Invalidatable
/*     */ {
/*  51 */   protected InvalidationManagerMBean invalMgr = null;
/*  52 */   protected InvalidationGroup ig = null;
/*     */ 
/*  54 */   protected boolean isTraceEnabled = false;
/*     */ 
/*     */   public void areInvalid(Serializable[] keys)
/*     */   {
/*  71 */     if (this.isTraceEnabled) {
/*  72 */       log.trace("Invalidating entry in cache. Quantity: " + keys.length);
/*     */     }
/*  74 */     for (int i = 0; i < keys.length; i++)
/*     */     {
/*     */       try
/*     */       {
/*  78 */         doInvalidate(keys[i]);
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*  82 */         log.debug(ignored);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void isInvalid(Serializable key)
/*     */   {
/*     */     try
/*     */     {
/*  91 */       doInvalidate(key);
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*  95 */       log.debug(ignored);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invalidateAll()
/*     */   {
/* 101 */     flush();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 108 */     super.start();
/*     */ 
/* 110 */     log.debug("Starting InvalidableEntityInstanceCache...");
/*     */ 
/* 112 */     EntityMetaData emd = (EntityMetaData)getContainer().getBeanMetaData();
/*     */ 
/* 114 */     boolean participateInDistInvalidations = emd.doDistributedCacheInvalidations();
/* 115 */     byte co = emd.getContainerConfiguration().getCommitOption();
/*     */ 
/* 117 */     if ((participateInDistInvalidations) && ((co == 0) || (co == 3)))
/*     */     {
/* 123 */       String groupName = emd.getDistributedCacheInvalidationConfig().getInvalidationGroupName();
/* 124 */       String imName = emd.getDistributedCacheInvalidationConfig().getInvalidationManagerName();
/*     */ 
/* 126 */       this.invalMgr = ((InvalidationManagerMBean)Registry.lookup(imName));
/* 127 */       this.ig = this.invalMgr.getInvalidationGroup(groupName);
/* 128 */       this.ig.register(this);
/* 129 */       this.isTraceEnabled = log.isTraceEnabled();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 138 */       this.ig.unregister(this);
/* 139 */       this.ig = null;
/* 140 */       this.invalMgr = null;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 144 */       log.debug(e);
/*     */     }
/*     */ 
/* 147 */     super.stop();
/*     */   }
/*     */ 
/*     */   protected void doInvalidate(Serializable key)
/*     */   {
/* 156 */     if (key != null)
/*     */     {
/* 158 */       synchronized (getCacheLock())
/*     */       {
/* 160 */         EnterpriseContext ctx = (EnterpriseContext)getCache().peek(key);
/* 161 */         if (ctx != null)
/*     */         {
/* 163 */           release(ctx);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.InvalidableEntityInstanceCache
 * JD-Core Version:    0.6.0
 */