/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.BeanLock;
/*     */ import org.jboss.ejb.BeanLockManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityCache;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceManager;
/*     */ import org.jboss.ejb.GlobalTxEntityMap;
/*     */ import org.jboss.ejb.GlobalTxEntityMap.TxAssociation;
/*     */ import org.jboss.ejb.InstanceCache;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class EntitySynchronizationInterceptor extends AbstractInterceptor
/*     */ {
/*     */   private ValidContextsRefresher vcr;
/*     */   protected int commitOption;
/*     */   protected long optionDRefreshRate;
/*     */   protected EntityContainer container;
/*     */ 
/*     */   public Container getContainer()
/*     */   {
/*  83 */     return this.container;
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  88 */     this.container = ((EntityContainer)container);
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/*  97 */       ConfigurationMetaData configuration = this.container.getBeanMetaData().getContainerConfiguration();
/*  98 */       this.commitOption = configuration.getCommitOption();
/*  99 */       this.optionDRefreshRate = configuration.getOptionDRefreshRate();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 103 */       this.log.warn(e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */     try
/*     */     {
/* 112 */       if (this.commitOption == 3)
/*     */       {
/* 114 */         this.vcr = new ValidContextsRefresher();
/* 115 */         LRUEnterpriseContextCachePolicy.tasksTimer.schedule(this.vcr, this.optionDRefreshRate, this.optionDRefreshRate);
/* 116 */         this.log.debug("Scheduled a cache flush every " + this.optionDRefreshRate / 1000L + " seconds");
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 121 */       this.vcr = null;
/* 122 */       this.log.warn("problem scheduling valid contexts refresher", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 128 */     if (this.vcr != null)
/*     */     {
/* 130 */       TimerTask temp = this.vcr;
/* 131 */       this.vcr = null;
/* 132 */       temp.cancel();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Synchronization createSynchronization(Transaction tx, EntityEnterpriseContext ctx)
/*     */   {
/* 138 */     return new InstanceSynchronization(tx, ctx);
/*     */   }
/*     */ 
/*     */   protected void register(EntityEnterpriseContext ctx, Transaction tx)
/*     */   {
/* 146 */     boolean trace = this.log.isTraceEnabled();
/* 147 */     if (trace) {
/* 148 */       this.log.trace("register, ctx=" + ctx + ", tx=" + tx);
/*     */     }
/* 150 */     EntityContainer ctxContainer = null;
/*     */     try
/*     */     {
/* 153 */       ctxContainer = (EntityContainer)ctx.getContainer();
/* 154 */       if (!ctx.hasTxSynchronization())
/*     */       {
/* 157 */         Synchronization synch = createSynchronization(tx, ctx);
/*     */ 
/* 160 */         tx.registerSynchronization(synch);
/*     */ 
/* 162 */         ctx.hasTxSynchronization(true);
/*     */       }
/*     */ 
/* 165 */       if (!ctxContainer.isReadOnly())
/*     */       {
/* 167 */         ctx.getTxAssociation().scheduleSync(tx, ctx);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (RollbackException e)
/*     */     {
/* 173 */       synchronized (ctx)
/*     */       {
/* 175 */         ctx.setValid(false);
/* 176 */         ctx.hasTxSynchronization(false);
/* 177 */         ctx.setTransaction(null);
/* 178 */         ctx.setTxAssociation(GlobalTxEntityMap.NONE);
/*     */       }
/* 180 */       throw new EJBException(e);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 185 */       ctx.hasTxSynchronization(false);
/* 186 */       ctx.setTxAssociation(GlobalTxEntityMap.NONE);
/* 187 */       if ((t instanceof RuntimeException))
/* 188 */         throw ((RuntimeException)t);
/* 189 */       if ((t instanceof Error))
/* 190 */         throw ((Error)t);
/* 191 */       if ((t instanceof Exception)) {
/* 192 */         throw new EJBException((Exception)t);
/*     */       }
/* 194 */       throw new NestedRuntimeException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi) throws Exception
/*     */   {
/* 200 */     EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
/* 201 */     Transaction tx = mi.getTransaction();
/*     */ 
/* 203 */     Object rtn = getNext().invokeHome(mi);
/*     */ 
/* 206 */     if (ctx.getId() != null)
/*     */     {
/* 210 */       ctx.setValid(true);
/*     */ 
/* 212 */       if (tx != null)
/*     */       {
/* 214 */         BeanLock lock = this.container.getLockManager().getLock(ctx.getCacheKey());
/*     */         try
/*     */         {
/* 217 */           lock.schedule(mi);
/* 218 */           register(ctx, tx);
/* 219 */           lock.endInvocation(mi);
/*     */         }
/*     */         finally
/*     */         {
/* 223 */           this.container.getLockManager().removeLockRef(lock.getId());
/*     */         }
/*     */       }
/*     */     }
/* 227 */     return rtn; } 
/*     */   // ERROR //
/*     */   public Object invoke(Invocation mi) throws Exception { // Byte code:
/*     */     //   0: aload_1
/*     */     //   1: invokevirtual 59	org/jboss/invocation/Invocation:getEnterpriseContext	()Ljava/lang/Object;
/*     */     //   4: checkcast 60	org/jboss/ejb/EntityEnterpriseContext
/*     */     //   7: astore_2
/*     */     //   8: aload_1
/*     */     //   9: invokevirtual 61	org/jboss/invocation/Invocation:getTransaction	()Ljavax/transaction/Transaction;
/*     */     //   12: astore_3
/*     */     //   13: aload_0
/*     */     //   14: getfield 11	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:log	Lorg/jboss/logging/Logger;
/*     */     //   17: invokevirtual 34	org/jboss/logging/Logger:isTraceEnabled	()Z
/*     */     //   20: ifeq +38 -> 58
/*     */     //   23: aload_0
/*     */     //   24: getfield 11	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:log	Lorg/jboss/logging/Logger;
/*     */     //   27: new 19	java/lang/StringBuilder
/*     */     //   30: dup
/*     */     //   31: invokespecial 20	java/lang/StringBuilder:<init>	()V
/*     */     //   34: ldc 73
/*     */     //   36: invokevirtual 22	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   39: aload_2
/*     */     //   40: invokevirtual 36	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   43: ldc 37
/*     */     //   45: invokevirtual 22	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   48: aload_3
/*     */     //   49: invokevirtual 36	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   52: invokevirtual 27	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   55: invokevirtual 38	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   58: aload_2
/*     */     //   59: invokevirtual 74	org/jboss/ejb/EntityEnterpriseContext:isValid	()Z
/*     */     //   62: ifne +21 -> 83
/*     */     //   65: aload_0
/*     */     //   66: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   69: invokevirtual 75	org/jboss/ejb/EntityContainer:getPersistenceManager	()Lorg/jboss/ejb/EntityPersistenceManager;
/*     */     //   72: aload_2
/*     */     //   73: invokeinterface 76 2 0
/*     */     //   78: aload_2
/*     */     //   79: iconst_1
/*     */     //   80: invokevirtual 48	org/jboss/ejb/EntityEnterpriseContext:setValid	(Z)V
/*     */     //   83: iconst_0
/*     */     //   84: istore 4
/*     */     //   86: aload_2
/*     */     //   87: invokevirtual 77	org/jboss/ejb/EntityEnterpriseContext:isReadOnly	()Z
/*     */     //   90: ifne +38 -> 128
/*     */     //   93: aload_0
/*     */     //   94: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   97: invokevirtual 44	org/jboss/ejb/EntityContainer:isReadOnly	()Z
/*     */     //   100: ifne +20 -> 120
/*     */     //   103: aload_0
/*     */     //   104: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   107: invokevirtual 4	org/jboss/ejb/EntityContainer:getBeanMetaData	()Lorg/jboss/metadata/BeanMetaData;
/*     */     //   110: aload_1
/*     */     //   111: invokevirtual 78	org/jboss/invocation/Invocation:getMethod	()Ljava/lang/reflect/Method;
/*     */     //   114: invokevirtual 79	org/jboss/metadata/BeanMetaData:isMethodReadOnly	(Ljava/lang/reflect/Method;)Z
/*     */     //   117: ifeq +11 -> 128
/*     */     //   120: aload_2
/*     */     //   121: iconst_1
/*     */     //   122: invokevirtual 80	org/jboss/ejb/EntityEnterpriseContext:setReadOnly	(Z)V
/*     */     //   125: iconst_1
/*     */     //   126: istore 4
/*     */     //   128: aload_3
/*     */     //   129: ifnull +204 -> 333
/*     */     //   132: aload_3
/*     */     //   133: invokeinterface 81 1 0
/*     */     //   138: bipush 6
/*     */     //   140: if_icmpeq +193 -> 333
/*     */     //   143: aload_0
/*     */     //   144: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   147: invokevirtual 44	org/jboss/ejb/EntityContainer:isReadOnly	()Z
/*     */     //   150: istore 5
/*     */     //   152: iload 5
/*     */     //   154: ifne +31 -> 185
/*     */     //   157: aload_1
/*     */     //   158: invokevirtual 78	org/jboss/invocation/Invocation:getMethod	()Ljava/lang/reflect/Method;
/*     */     //   161: astore 6
/*     */     //   163: aload 6
/*     */     //   165: ifnull +20 -> 185
/*     */     //   168: aload_0
/*     */     //   169: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   172: invokevirtual 4	org/jboss/ejb/EntityContainer:getBeanMetaData	()Lorg/jboss/metadata/BeanMetaData;
/*     */     //   175: aload 6
/*     */     //   177: invokevirtual 82	java/lang/reflect/Method:getName	()Ljava/lang/String;
/*     */     //   180: invokevirtual 83	org/jboss/metadata/BeanMetaData:isMethodReadOnly	(Ljava/lang/String;)Z
/*     */     //   183: istore 5
/*     */     //   185: iload 5
/*     */     //   187: ifne +9 -> 196
/*     */     //   190: aload_0
/*     */     //   191: aload_2
/*     */     //   192: aload_3
/*     */     //   193: invokevirtual 69	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:register	(Lorg/jboss/ejb/EntityEnterpriseContext;Ljavax/transaction/Transaction;)V
/*     */     //   196: aload_0
/*     */     //   197: invokevirtual 62	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:getNext	()Lorg/jboss/ejb/Interceptor;
/*     */     //   200: aload_1
/*     */     //   201: invokeinterface 84 2 0
/*     */     //   206: astore 6
/*     */     //   208: iload 5
/*     */     //   210: ifne +9 -> 219
/*     */     //   213: aload_0
/*     */     //   214: aload_2
/*     */     //   215: aload_3
/*     */     //   216: invokevirtual 69	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:register	(Lorg/jboss/ejb/EntityEnterpriseContext;Ljavax/transaction/Transaction;)V
/*     */     //   219: aload 6
/*     */     //   221: astore 7
/*     */     //   223: jsr +17 -> 240
/*     */     //   226: jsr +271 -> 497
/*     */     //   229: aload 7
/*     */     //   231: areturn
/*     */     //   232: astore 8
/*     */     //   234: jsr +6 -> 240
/*     */     //   237: aload 8
/*     */     //   239: athrow
/*     */     //   240: astore 9
/*     */     //   242: iload 5
/*     */     //   244: ifeq +87 -> 331
/*     */     //   247: aload_2
/*     */     //   248: invokevirtual 40	org/jboss/ejb/EntityEnterpriseContext:hasTxSynchronization	()Z
/*     */     //   251: ifne +80 -> 331
/*     */     //   254: aload_0
/*     */     //   255: getfield 7	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:commitOption	I
/*     */     //   258: lookupswitch	default:+73->331, 1:+26->284, 2:+34->292
/*     */     //   285: iconst_0
/*     */     //   286: invokevirtual 48	org/jboss/ejb/EntityEnterpriseContext:setValid	(Z)V
/*     */     //   289: goto +42 -> 331
/*     */     //   292: aload_2
/*     */     //   293: invokevirtual 64	org/jboss/ejb/EntityEnterpriseContext:getId	()Ljava/lang/Object;
/*     */     //   296: ifnull +19 -> 315
/*     */     //   299: aload_0
/*     */     //   300: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   303: invokevirtual 85	org/jboss/ejb/EntityContainer:getInstanceCache	()Lorg/jboss/ejb/InstanceCache;
/*     */     //   306: aload_2
/*     */     //   307: invokevirtual 64	org/jboss/ejb/EntityEnterpriseContext:getId	()Ljava/lang/Object;
/*     */     //   310: invokeinterface 86 2 0
/*     */     //   315: goto +16 -> 331
/*     */     //   318: astore 10
/*     */     //   320: aload_0
/*     */     //   321: getfield 11	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:log	Lorg/jboss/logging/Logger;
/*     */     //   324: ldc 87
/*     */     //   326: aload 10
/*     */     //   328: invokevirtual 88	org/jboss/logging/Logger:debug	(Ljava/lang/Object;Ljava/lang/Throwable;)V
/*     */     //   331: ret 9
/*     */     //   333: aload_0
/*     */     //   334: invokevirtual 62	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:getNext	()Lorg/jboss/ejb/Interceptor;
/*     */     //   337: aload_1
/*     */     //   338: invokeinterface 84 2 0
/*     */     //   343: astore 5
/*     */     //   345: aload_2
/*     */     //   346: invokevirtual 64	org/jboss/ejb/EntityEnterpriseContext:getId	()Ljava/lang/Object;
/*     */     //   349: ifnull +29 -> 378
/*     */     //   352: aload_0
/*     */     //   353: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   356: invokevirtual 44	org/jboss/ejb/EntityContainer:isReadOnly	()Z
/*     */     //   359: ifne +19 -> 378
/*     */     //   362: aload_0
/*     */     //   363: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   366: aload_2
/*     */     //   367: invokevirtual 89	org/jboss/ejb/EntityContainer:invokeEjbStore	(Lorg/jboss/ejb/EntityEnterpriseContext;)V
/*     */     //   370: aload_0
/*     */     //   371: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   374: aload_2
/*     */     //   375: invokevirtual 90	org/jboss/ejb/EntityContainer:storeEntity	(Lorg/jboss/ejb/EntityEnterpriseContext;)V
/*     */     //   378: aload 5
/*     */     //   380: astore 6
/*     */     //   382: jsr +27 -> 409
/*     */     //   385: jsr +112 -> 497
/*     */     //   388: aload 6
/*     */     //   390: areturn
/*     */     //   391: astore 5
/*     */     //   393: aload_2
/*     */     //   394: iconst_0
/*     */     //   395: invokevirtual 48	org/jboss/ejb/EntityEnterpriseContext:setValid	(Z)V
/*     */     //   398: aload 5
/*     */     //   400: athrow
/*     */     //   401: astore 11
/*     */     //   403: jsr +6 -> 409
/*     */     //   406: aload 11
/*     */     //   408: athrow
/*     */     //   409: astore 12
/*     */     //   411: aload_0
/*     */     //   412: getfield 7	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:commitOption	I
/*     */     //   415: lookupswitch	default:+72->487, 1:+25->440, 2:+33->448
/*     */     //   441: iconst_0
/*     */     //   442: invokevirtual 48	org/jboss/ejb/EntityEnterpriseContext:setValid	(Z)V
/*     */     //   445: goto +42 -> 487
/*     */     //   448: aload_2
/*     */     //   449: invokevirtual 64	org/jboss/ejb/EntityEnterpriseContext:getId	()Ljava/lang/Object;
/*     */     //   452: ifnull +19 -> 471
/*     */     //   455: aload_0
/*     */     //   456: getfield 2	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:container	Lorg/jboss/ejb/EntityContainer;
/*     */     //   459: invokevirtual 85	org/jboss/ejb/EntityContainer:getInstanceCache	()Lorg/jboss/ejb/InstanceCache;
/*     */     //   462: aload_2
/*     */     //   463: invokevirtual 64	org/jboss/ejb/EntityEnterpriseContext:getId	()Ljava/lang/Object;
/*     */     //   466: invokeinterface 86 2 0
/*     */     //   471: goto +16 -> 487
/*     */     //   474: astore 13
/*     */     //   476: aload_0
/*     */     //   477: getfield 11	org/jboss/ejb/plugins/EntitySynchronizationInterceptor:log	Lorg/jboss/logging/Logger;
/*     */     //   480: ldc 87
/*     */     //   482: aload 13
/*     */     //   484: invokevirtual 88	org/jboss/logging/Logger:debug	(Ljava/lang/Object;Ljava/lang/Throwable;)V
/*     */     //   487: ret 12
/*     */     //   489: astore 14
/*     */     //   491: jsr +6 -> 497
/*     */     //   494: aload 14
/*     */     //   496: athrow
/*     */     //   497: astore 15
/*     */     //   499: iload 4
/*     */     //   501: ifeq +8 -> 509
/*     */     //   504: aload_2
/*     */     //   505: iconst_0
/*     */     //   506: invokevirtual 80	org/jboss/ejb/EntityEnterpriseContext:setReadOnly	(Z)V
/*     */     //   509: ret 15
/*     */     //
/*     */     // Exception table:
/*     */     //   from	to	target	type
/*     */     //   185	226	232	finally
/*     */     //   232	237	232	finally
/*     */     //   292	315	318	java/lang/Exception
/*     */     //   333	385	391	java/lang/Exception
/*     */     //   333	385	401	finally
/*     */     //   391	406	401	finally
/*     */     //   448	471	474	java/lang/Exception
/*     */     //   128	229	489	finally
/*     */     //   232	388	489	finally
/*     */     //   391	494	489	finally } 
/*     */   class ValidContextsRefresher extends TimerTask { public ValidContextsRefresher() {  } 
/* 539 */     public void run() { if (EntitySynchronizationInterceptor.this.container == null)
/*     */       {
/* 541 */         cancel();
/* 542 */         return;
/*     */       }
/*     */ 
/* 545 */       if (EntitySynchronizationInterceptor.this.log.isTraceEnabled()) {
/* 546 */         EntitySynchronizationInterceptor.this.log.trace("Flushing the valid contexts " + EntitySynchronizationInterceptor.this.container.getBeanMetaData().getEjbName());
/*     */       }
/* 548 */       EntityCache cache = (EntityCache)EntitySynchronizationInterceptor.this.container.getInstanceCache();
/*     */       try
/*     */       {
/* 551 */         if (cache != null)
/* 552 */           cache.flush();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 556 */         EntitySynchronizationInterceptor.this.log.debug("Ignored error while trying to flush() entity cache", t);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class InstanceSynchronization
/*     */     implements Synchronization
/*     */   {
/*     */     protected Transaction tx;
/*     */     protected EntityEnterpriseContext ctx;
/*     */     protected BeanLock lock;
/*     */ 
/*     */     InstanceSynchronization(Transaction tx, EntityEnterpriseContext ctx)
/*     */     {
/* 422 */       this.tx = tx;
/* 423 */       this.ctx = ctx;
/* 424 */       this.lock = EntitySynchronizationInterceptor.this.container.getLockManager().getLock(ctx.getCacheKey());
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 434 */       boolean trace = EntitySynchronizationInterceptor.this.log.isTraceEnabled();
/*     */ 
/* 438 */       ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 439 */       boolean setCl = !oldCl.equals(EntitySynchronizationInterceptor.this.container.getClassLoader());
/* 440 */       if (setCl)
/*     */       {
/* 442 */         SecurityActions.setContextClassLoader(EntitySynchronizationInterceptor.this.container.getClassLoader());
/*     */       }
/* 444 */       EntitySynchronizationInterceptor.this.container.pushENC();
/*     */ 
/* 446 */       int commitOption = this.ctx.isPassivateAfterCommit() ? 2 : EntitySynchronizationInterceptor.this.commitOption;
/*     */ 
/* 449 */       this.lock.sync();
/*     */ 
/* 451 */       this.ctx.hasTxSynchronization(false);
/* 452 */       this.ctx.setTxAssociation(GlobalTxEntityMap.NONE);
/* 453 */       this.ctx.setTransaction(null);
/*     */       try
/*     */       {
/*     */         try
/*     */         {
/* 459 */           if (status == 4)
/*     */           {
/* 462 */             EntitySynchronizationInterceptor.this.container.getInstanceCache().remove(this.ctx.getCacheKey());
/*     */           }
/*     */           else
/*     */           {
/* 466 */             switch (commitOption)
/*     */             {
/*     */             case 0:
/*     */             case 3:
/* 472 */               this.ctx.setValid(true);
/* 473 */               break;
/*     */             case 1:
/* 478 */               this.ctx.setValid(false);
/* 479 */               break;
/*     */             case 2:
/*     */               try
/*     */               {
/* 487 */                 if (this.ctx.getId() != null)
/*     */                 {
/* 489 */                   EntitySynchronizationInterceptor.this.container.getInstanceCache().remove(this.ctx.getId());
/* 490 */                   EntitySynchronizationInterceptor.this.container.getPersistenceManager().passivateEntity(this.ctx);
/*     */                 }
/*     */ 
/* 493 */                 EntitySynchronizationInterceptor.this.container.getInstancePool().free(this.ctx);
/*     */               }
/*     */               catch (Exception e)
/*     */               {
/* 497 */                 EntitySynchronizationInterceptor.this.log.debug("Exception releasing context", e);
/*     */               }
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */         finally
/*     */         {
/* 505 */           if (trace)
/* 506 */             EntitySynchronizationInterceptor.this.log.trace("afterCompletion, clear tx for ctx=" + this.ctx + ", tx=" + this.tx);
/* 507 */           this.lock.endTransaction(this.tx);
/*     */ 
/* 509 */           if (trace)
/* 510 */             EntitySynchronizationInterceptor.this.log.trace("afterCompletion, sent notify on TxLock for ctx=" + this.ctx);
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 515 */         this.lock.releaseSync();
/* 516 */         EntitySynchronizationInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
/* 517 */         EntitySynchronizationInterceptor.this.container.popENC();
/* 518 */         if (setCl)
/*     */         {
/* 520 */           SecurityActions.setContextClassLoader(oldCl);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.EntitySynchronizationInterceptor
 * JD-Core Version:    0.6.0
 */