/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchObjectLocalException;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.BeanLock;
/*     */ import org.jboss.ejb.BeanLockManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.GlobalTxEntityMap;
/*     */ import org.jboss.ejb.InstanceCache;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class EntityInstanceInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected EntityContainer container;
/*     */   protected static final Method ejbTimeout;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  99 */     this.container = ((EntityContainer)container);
/*     */   }
/*     */ 
/*     */   public Container getContainer()
/*     */   {
/* 104 */     return this.container;
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 113 */     EntityContainer container = (EntityContainer)getContainer();
/* 114 */     EntityEnterpriseContext ctx = (EntityEnterpriseContext)container.getInstancePool().get();
/* 115 */     ctx.setTxAssociation(GlobalTxEntityMap.NOT_READY);
/* 116 */     InstancePool pool = container.getInstancePool();
/*     */ 
/* 119 */     mi.setEnterpriseContext(ctx);
/*     */ 
/* 122 */     ctx.setTransaction(mi.getTransaction());
/*     */ 
/* 124 */     ctx.setSecurityContext(mi.getSecurityContext());
/*     */ 
/* 126 */     ctx.setPrincipal(mi.getPrincipal());
/*     */ 
/* 128 */     AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_HOME);
/*     */ 
/* 132 */     Object obj = null;
/* 133 */     Exception exception = null;
/*     */     try
/*     */     {
/* 137 */       obj = getNext().invokeHome(mi);
/*     */ 
/* 140 */       if (ctx.getId() != null)
/*     */       {
/* 142 */         BeanLock lock = container.getLockManager().getLock(ctx.getCacheKey());
/* 143 */         lock.sync();
/*     */         try
/*     */         {
/* 149 */           cache = container.getInstanceCache();
/* 150 */           cache.remove(ctx.getCacheKey());
/*     */ 
/* 154 */           cache.insert(ctx);
/*     */         }
/*     */         finally
/*     */         {
/* 158 */           lock.releaseSync();
/* 159 */           container.getLockManager().removeLockRef(ctx.getCacheKey());
/*     */         }
/*     */ 
/* 163 */         InstanceCache cache = obj;
/*     */         return cache;
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 168 */       exception = e;
/*     */     }
/*     */     finally
/*     */     {
/* 172 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 175 */     ctx.setTransaction(null);
/*     */ 
/* 177 */     mi.setEnterpriseContext(null);
/*     */ 
/* 181 */     if (exception == null)
/*     */     {
/* 183 */       container.getInstancePool().free(ctx);
/* 184 */       return obj;
/*     */     }
/*     */ 
/* 187 */     if ((exception instanceof RuntimeException))
/*     */     {
/* 191 */       pool.discard(ctx);
/*     */     }
/*     */     else
/*     */     {
/* 198 */       pool.free(ctx);
/*     */     }
/*     */ 
/* 201 */     throw exception;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 208 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 211 */     Object key = mi.getId();
/*     */     EntityEnterpriseContext ctx;
/*     */     try
/*     */     {
/* 217 */       ctx = (EntityEnterpriseContext)this.container.getInstanceCache().get(key);
/*     */     }
/*     */     catch (NoSuchObjectException e)
/*     */     {
/* 221 */       if (mi.isLocal()) {
/* 222 */         throw new NoSuchObjectLocalException(e.getMessage());
/*     */       }
/* 224 */       throw e;
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 228 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 232 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 236 */       InvocationType type = mi.getType();
/* 237 */       boolean isLocal = (type == InvocationType.LOCAL) || (type == InvocationType.LOCALHOME);
/* 238 */       if (isLocal) {
/* 239 */         throw new EJBException("Unable to get an instance from the pool/cache", e);
/*     */       }
/* 241 */       throw new RemoteException("Unable to get an intance from the pool/cache", e);
/*     */     }
/*     */ 
/* 244 */     if (trace) this.log.trace("Begin invoke, key=" + key);
/*     */ 
/* 251 */     Transaction tx = mi.getTransaction();
/* 252 */     if (!this.container.isReadOnly())
/*     */     {
/* 254 */       Method method = mi.getMethod();
/* 255 */       if ((method == null) || (!this.container.getBeanMetaData().isMethodReadOnly(method.getName())))
/*     */       {
/* 258 */         ctx.setTransaction(tx);
/*     */       }
/*     */     }
/*     */ 
/* 262 */     ctx.setSecurityContext(mi.getSecurityContext());
/*     */ 
/* 264 */     ctx.setPrincipal(mi.getPrincipal());
/*     */ 
/* 266 */     EnterpriseBeanPolicyContextHandler.setEnterpriseBean(ctx.getInstance());
/*     */ 
/* 269 */     mi.setEnterpriseContext(ctx);
/*     */ 
/* 271 */     if (ejbTimeout.equals(mi.getMethod()))
/* 272 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_TIMEOUT);
/*     */     else {
/* 274 */       AllowedOperationsAssociation.pushInMethodFlag(IN_BUSINESS_METHOD);
/*     */     }
/* 276 */     Throwable exceptionThrown = null;
/* 277 */     boolean discardContext = false;
/*     */     try
/*     */     {
/* 280 */       Object obj = getNext().invoke(mi);
/* 281 */       localObject1 = obj;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/*     */       Object localObject1;
/* 285 */       exceptionThrown = e;
/* 286 */       discardContext = true;
/* 287 */       throw e;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 291 */       exceptionThrown = e;
/* 292 */       discardContext = true;
/* 293 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 297 */       exceptionThrown = e;
/* 298 */       discardContext = true;
/* 299 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 303 */       exceptionThrown = e;
/* 304 */       throw e;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 308 */       exceptionThrown = e;
/* 309 */       discardContext = true;
/* 310 */       throw new NestedRuntimeException(e);
/*     */     }
/*     */     finally
/*     */     {
/* 314 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */ 
/* 319 */       if ((exceptionThrown != null) && (tx != null))
/*     */       {
/* 321 */         Transaction ctxTx = ctx.getTransaction();
/* 322 */         if ((tx.equals(ctxTx)) && (!ctx.hasTxSynchronization())) {
/* 323 */           ctx.setTransaction(null);
/*     */         }
/*     */       }
/*     */ 
/* 327 */       if ((exceptionThrown != null) && (!ctx.hasTxSynchronization()) && (discardContext))
/*     */       {
/* 336 */         this.container.getInstanceCache().remove(key);
/*     */ 
/* 338 */         if (trace) this.log.trace("Ending invoke, exceptionThrown, ctx=" + ctx, exceptionThrown);
/*     */       }
/* 340 */       else if (ctx.getId() == null)
/*     */       {
/* 343 */         this.container.getInstanceCache().remove(key);
/*     */ 
/* 345 */         if (trace) this.log.trace("Ending invoke, cache removal, ctx=" + ctx);
/*     */ 
/*     */       }
/*     */ 
/* 349 */       EnterpriseBeanPolicyContextHandler.setEnterpriseBean(null);
/*     */ 
/* 351 */       if (trace) this.log.trace("End invoke, key=" + key + ", ctx=" + ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  85 */       ejbTimeout = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  89 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.EntityInstanceInterceptor
 * JD-Core Version:    0.6.0
 */