/*    */ package org.jboss.ejb.plugins;
/*    */ 
/*    */ import javax.ejb.TimerHandle;
/*    */ import org.jboss.ejb.Interceptor;
/*    */ import org.jboss.invocation.Invocation;
/*    */ import org.jboss.invocation.InvocationType;
/*    */ 
/*    */ public class CallValidationInterceptor extends AbstractInterceptor
/*    */ {
/*    */   public Object invokeHome(Invocation mi)
/*    */     throws Exception
/*    */   {
/* 55 */     validateArguments(mi);
/* 56 */     Object obj = getNext().invokeHome(mi);
/* 57 */     return validateReturnValue(mi, obj);
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation mi) throws Exception
/*    */   {
/* 62 */     validateArguments(mi);
/* 63 */     Object obj = getNext().invoke(mi);
/* 64 */     return validateReturnValue(mi, obj);
/*    */   }
/*    */ 
/*    */   protected void validateArguments(Invocation mi)
/*    */   {
/* 70 */     if (mi.getType() == InvocationType.REMOTE)
/*    */     {
/* 72 */       Object[] params = mi.getArguments();
/* 73 */       for (int i = 0; i < params.length; i++)
/*    */       {
/* 75 */         Object obj = params[i];
/* 76 */         if ((obj instanceof TimerHandle))
/* 77 */           throw new IllegalArgumentException("Cannot pass TimerHandle through remote interface");
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   protected Object validateReturnValue(Invocation mi, Object retValue)
/*    */   {
/* 85 */     if (mi.getType() == InvocationType.REMOTE)
/*    */     {
/* 87 */       if ((retValue instanceof TimerHandle))
/* 88 */         throw new IllegalArgumentException("Cannot return TimerHandle from remote interface");
/*    */     }
/* 90 */     return retValue;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.CallValidationInterceptor
 * JD-Core Version:    0.6.0
 */