/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EntityBean;
/*     */ import javax.ejb.RemoveException;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityCache;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceManager;
/*     */ import org.jboss.ejb.EntityPersistenceStore;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ 
/*     */ public class CMPPersistenceManager
/*     */   implements EntityPersistenceManager
/*     */ {
/*     */   EntityContainer con;
/*     */   EntityPersistenceStore store;
/*  70 */   HashMap createMethods = new HashMap();
/*  71 */   HashMap postCreateMethods = new HashMap();
/*     */   private boolean insertAfterEjbPostCreate;
/*     */   private boolean ejbStoreForClean;
/*     */ 
/*     */   public void setContainer(Container c)
/*     */   {
/*  82 */     this.con = ((EntityContainer)c);
/*     */ 
/*  84 */     if (this.store != null)
/*     */     {
/*  86 */       this.store.setContainer(c);
/*     */     }
/*     */ 
/*  89 */     if (this.con != null)
/*     */     {
/*  91 */       ConfigurationMetaData configuration = this.con.getBeanMetaData().getContainerConfiguration();
/*  92 */       this.ejbStoreForClean = configuration.isEjbStoreForClean();
/*     */     }
/*     */   }
/*     */ 
/*     */   public EntityPersistenceStore getPersistenceStore()
/*     */   {
/* 101 */     return this.store;
/*     */   }
/*     */ 
/*     */   public void setPersistenceStore(EntityPersistenceStore store)
/*     */   {
/* 106 */     this.store = store;
/*     */ 
/* 109 */     if (this.con != null) store.setContainer(this.con);
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/* 115 */     if (this.con.getHomeClass() != null)
/*     */     {
/* 117 */       Method[] methods = this.con.getHomeClass().getMethods();
/* 118 */       createMethodCache(methods);
/*     */     }
/*     */ 
/* 121 */     if (this.con.getLocalHomeClass() != null)
/*     */     {
/* 123 */       Method[] methods = this.con.getLocalHomeClass().getMethods();
/* 124 */       createMethodCache(methods);
/*     */     }
/*     */ 
/* 127 */     this.insertAfterEjbPostCreate = this.con.getBeanMetaData().getContainerConfiguration().isInsertAfterEjbPostCreate();
/*     */ 
/* 129 */     this.store.create();
/*     */   }
/*     */ 
/*     */   public Object createBeanClassInstance()
/*     */     throws Exception
/*     */   {
/* 139 */     return this.store.createBeanClassInstance();
/*     */   }
/*     */ 
/*     */   private void createMethodCache(Method[] methods)
/*     */     throws NoSuchMethodException
/*     */   {
/* 146 */     Class beanClass = this.con.getBeanClass();
/* 147 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 149 */       String name = methods[i].getName();
/* 150 */       if (!name.startsWith("create"))
/*     */         continue;
/* 152 */       Class[] types = methods[i].getParameterTypes();
/*     */       try
/*     */       {
/* 155 */         String nameSuffix = name.substring(0, 1).toUpperCase() + name.substring(1);
/* 156 */         Method beanMethod = beanClass.getMethod("ejb" + nameSuffix, types);
/* 157 */         this.createMethods.put(methods[i], beanMethod);
/* 158 */         beanMethod = beanClass.getMethod("ejbPost" + nameSuffix, types);
/* 159 */         this.postCreateMethods.put(methods[i], beanMethod);
/*     */       }
/*     */       catch (NoSuchMethodException nsme)
/*     */       {
/* 163 */         throw new NoSuchMethodException("Can't find ejb[Post]Create in " + beanClass.getName());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 172 */     this.store.start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 177 */     this.store.stop();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 182 */     this.store.destroy();
/*     */   }
/*     */ 
/*     */   public void createEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 189 */     this.store.initEntity(ctx);
/*     */     try
/*     */     {
/* 194 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
/* 195 */       Method createMethod = (Method)this.createMethods.get(m);
/* 196 */       createMethod.invoke(ctx.getInstance(), args);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 201 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite)
/*     */     {
/* 205 */       Throwable e = ite.getTargetException();
/* 206 */       if ((e instanceof EJBException))
/*     */       {
/* 209 */         throw ((EJBException)e);
/*     */       }
/* 211 */       if ((e instanceof RuntimeException))
/*     */       {
/* 214 */         throw new EJBException((Exception)e);
/*     */       }
/* 216 */       if ((e instanceof Exception))
/*     */       {
/* 219 */         throw ((Exception)e);
/*     */       }
/*     */ 
/* 223 */       throw ((Error)e);
/*     */     }
/*     */     finally
/*     */     {
/* 228 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/*     */     Object id;
/*     */     try
/*     */     {
/* 236 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
/* 237 */       id = this.store.createEntity(m, args, ctx);
/*     */     }
/*     */     finally
/*     */     {
/* 241 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 245 */     ctx.setId(id);
/*     */ 
/* 248 */     Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(id);
/*     */ 
/* 251 */     ctx.setCacheKey(cacheKey);
/*     */   }
/*     */ 
/*     */   public void postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 259 */     this.store.postCreateEntity(m, args, ctx);
/*     */     try
/*     */     {
/* 263 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_POST_CREATE);
/*     */ 
/* 265 */       Method postCreateMethod = (Method)this.postCreateMethods.get(m);
/* 266 */       postCreateMethod.invoke(ctx.getInstance(), args);
/* 267 */       if (this.insertAfterEjbPostCreate)
/*     */       {
/* 269 */         this.store.createEntity(m, args, ctx);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 275 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite)
/*     */     {
/* 279 */       Throwable e = ite.getTargetException();
/* 280 */       if ((e instanceof EJBException))
/*     */       {
/* 283 */         throw ((EJBException)e);
/*     */       }
/* 285 */       if ((e instanceof RuntimeException))
/*     */       {
/* 288 */         throw new EJBException((Exception)e);
/*     */       }
/* 290 */       if ((e instanceof Exception))
/*     */       {
/* 293 */         throw ((Exception)e);
/*     */       }
/*     */ 
/* 297 */       throw ((Error)e);
/*     */     }
/*     */     finally
/*     */     {
/* 302 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 314 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_FIND);
/* 315 */       Object localObject1 = this.store.findEntity(finderMethod, args, ctx, factory);
/*     */       return localObject1; } finally { AllowedOperationsAssociation.popInMethodFlag(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 336 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_FIND);
/* 337 */       Collection localCollection = this.store.findEntities(finderMethod, args, ctx, factory);
/*     */       return localCollection; } finally { AllowedOperationsAssociation.popInMethodFlag(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public void activateEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/* 360 */     Object id = ctx.getId();
/* 361 */     Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(id);
/*     */ 
/* 364 */     ctx.setCacheKey(cacheKey);
/*     */     try
/*     */     {
/* 368 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_ACTIVATE);
/* 369 */       EntityBean eb = (EntityBean)ctx.getInstance();
/* 370 */       eb.ejbActivate();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 374 */       if ((e instanceof RemoteException))
/*     */       {
/* 377 */         throw ((RemoteException)e);
/*     */       }
/* 379 */       if ((e instanceof EJBException))
/*     */       {
/* 382 */         throw ((EJBException)e);
/*     */       }
/*     */ 
/* 387 */       throw new EJBException(e);
/*     */     }
/*     */     finally
/*     */     {
/* 392 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 398 */     this.store.activateEntity(ctx);
/*     */   }
/*     */ 
/*     */   public void loadEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/* 406 */     this.store.loadEntity(ctx);
/*     */ 
/* 409 */     invokeLoad(ctx);
/*     */   }
/*     */ 
/*     */   public boolean isStoreRequired(EntityEnterpriseContext ctx) throws Exception
/*     */   {
/* 414 */     return this.store.isStoreRequired(ctx);
/*     */   }
/*     */ 
/*     */   public boolean isModified(EntityEnterpriseContext ctx) throws Exception
/*     */   {
/* 419 */     return this.store.isModified(ctx);
/*     */   }
/*     */ 
/*     */   public void storeEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/* 425 */     AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_STORE);
/*     */     try
/*     */     {
/* 428 */       this.store.storeEntity(ctx);
/*     */     }
/*     */     finally
/*     */     {
/* 432 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invokeEjbStore(EntityEnterpriseContext ctx) throws RemoteException
/*     */   {
/* 438 */     AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_STORE);
/*     */     try
/*     */     {
/* 443 */       if (this.ejbStoreForClean)
/*     */       {
/* 445 */         ejbStore(ctx);
/*     */       }
/*     */       else
/*     */       {
/* 450 */         boolean modified = false;
/*     */         try
/*     */         {
/* 453 */           modified = isStoreRequired(ctx);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 457 */           throwRemoteException(e);
/*     */         }
/*     */ 
/* 460 */         if (modified)
/*     */         {
/* 462 */           ejbStore(ctx);
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 468 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void passivateEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 477 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_PASSIVATE);
/* 478 */       EntityBean eb = (EntityBean)ctx.getInstance();
/* 479 */       eb.ejbPassivate();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 483 */       throwRemoteException(e);
/*     */     }
/*     */     finally
/*     */     {
/* 487 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 490 */     this.store.passivateEntity(ctx);
/* 491 */     ctx.setEJBObject(null);
/* 492 */     ctx.setEJBLocalObject(null);
/*     */   }
/*     */ 
/*     */   public void removeEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException, RemoveException
/*     */   {
/*     */     try
/*     */     {
/* 500 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_REMOVE);
/* 501 */       EntityBean eb = (EntityBean)ctx.getInstance();
/* 502 */       eb.ejbRemove();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 506 */       if ((e instanceof RemoveException))
/*     */       {
/* 509 */         throw ((RemoveException)e);
/*     */       }
/*     */ 
/* 513 */       throwRemoteException(e);
/*     */     }
/*     */     finally
/*     */     {
/* 518 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 521 */     this.store.removeEntity(ctx);
/*     */   }
/*     */ 
/*     */   protected void invokeLoad(EntityEnterpriseContext ctx) throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 528 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_LOAD);
/*     */ 
/* 530 */       EntityBean eb = (EntityBean)ctx.getInstance();
/* 531 */       eb.ejbLoad();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 535 */       throwRemoteException(e);
/*     */     }
/*     */     finally
/*     */     {
/* 539 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void ejbStore(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 550 */       EntityBean eb = (EntityBean)ctx.getInstance();
/* 551 */       eb.ejbStore();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 555 */       throwRemoteException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void throwRemoteException(Exception e)
/*     */     throws RemoteException
/*     */   {
/* 562 */     if ((e instanceof RemoteException))
/*     */     {
/* 565 */       throw ((RemoteException)e);
/*     */     }
/* 567 */     if ((e instanceof EJBException))
/*     */     {
/* 570 */       throw ((EJBException)e);
/*     */     }
/*     */ 
/* 575 */     throw new EJBException(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.CMPPersistenceManager
 * JD-Core Version:    0.6.0
 */