/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.DuplicateKeyException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.FinderException;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.RemoveException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceStore;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory.UTIL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class CMPInMemoryPersistenceManager extends ServiceMBeanSupport
/*     */   implements EntityPersistenceStore
/*     */ {
/*     */   protected EntityContainer con;
/*     */   protected HashMap beans;
/*     */   protected Field idField;
/*     */   protected Method isModified;
/*     */ 
/*     */   public void setContainer(Container con)
/*     */   {
/*  99 */     this.con = ((EntityContainer)con);
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 107 */     this.beans = new HashMap(1000);
/*     */ 
/* 109 */     String ejbName = this.con.getBeanMetaData().getEjbName();
/*     */ 
/* 111 */     this.idField = this.con.getBeanClass().getField("id");
/* 112 */     this.log.debug("Using id field: " + this.idField);
/*     */     try
/*     */     {
/* 117 */       this.isModified = this.con.getBeanClass().getMethod("isModified", new Class[0]);
/* 118 */       if (!this.isModified.getReturnType().equals(Boolean.TYPE)) {
/* 119 */         this.isModified = null;
/* 120 */         this.log.warn("Found isModified method, but return type is not boolean; ignoring");
/*     */       }
/*     */       else {
/* 123 */         this.log.debug("Using isModified method: " + this.isModified);
/*     */       }
/*     */     }
/*     */     catch (NoSuchMethodException ignored) {
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception {
/* 131 */     this.beans.clear();
/*     */   }
/*     */ 
/*     */   public Object createBeanClassInstance()
/*     */     throws Exception
/*     */   {
/* 145 */     return this.con.getBeanClass().newInstance();
/*     */   }
/*     */ 
/*     */   public void initEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 159 */     Object instance = ctx.getInstance();
/* 160 */     Class ejbClass = instance.getClass();
/*     */ 
/* 164 */     EntityMetaData metaData = (EntityMetaData)this.con.getBeanMetaData();
/* 165 */     Iterator i = metaData.getCMPFields();
/*     */ 
/* 167 */     while (i.hasNext())
/*     */     {
/*     */       try
/*     */       {
/* 172 */         Field cmpField = ejbClass.getField((String)i.next());
/* 173 */         Class cmpFieldType = cmpField.getType();
/*     */ 
/* 177 */         if (cmpFieldType.equals(Boolean.TYPE))
/*     */         {
/* 179 */           cmpField.setBoolean(instance, false);
/*     */         }
/* 181 */         else if (cmpFieldType.equals(Byte.TYPE))
/*     */         {
/* 183 */           cmpField.setByte(instance, 0);
/*     */         }
/* 185 */         else if (cmpFieldType.equals(Integer.TYPE))
/*     */         {
/* 187 */           cmpField.setInt(instance, 0);
/*     */         }
/* 189 */         else if (cmpFieldType.equals(Long.TYPE))
/*     */         {
/* 191 */           cmpField.setLong(instance, 0L);
/*     */         }
/* 193 */         else if (cmpFieldType.equals(Short.TYPE))
/*     */         {
/* 195 */           cmpField.setShort(instance, 0);
/*     */         }
/* 197 */         else if (cmpFieldType.equals(Character.TYPE))
/*     */         {
/* 199 */           cmpField.setChar(instance, '\000');
/*     */         }
/* 201 */         else if (cmpFieldType.equals(Double.TYPE))
/*     */         {
/* 203 */           cmpField.setDouble(instance, 0.0D);
/*     */         }
/* 205 */         else if (cmpFieldType.equals(Float.TYPE))
/*     */         {
/* 207 */           cmpField.setFloat(instance, 0.0F);
/*     */         }
/*     */         else
/*     */         {
/* 211 */           cmpField.set(instance, null);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NoSuchFieldException e)
/*     */       {
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 221 */         throw new EJBException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object createEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 243 */       Object id = this.idField.get(ctx.getInstance());
/*     */ 
/* 246 */       if (this.beans.containsKey(id)) {
/* 247 */         throw new DuplicateKeyException("Already exists: " + id);
/*     */       }
/*     */ 
/* 250 */       storeEntity(id, ctx.getInstance());
/*     */ 
/* 252 */       return id;
/*     */     }
/*     */     catch (IllegalAccessException e) {
/*     */     }
/* 256 */     throw new CreateException("Could not create entity: " + e);
/*     */   }
/*     */ 
/*     */   public Object postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 278 */     return null;
/*     */   }
/*     */ 
/*     */   public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory)
/*     */     throws Exception
/*     */   {
/* 298 */     if (finderMethod.getName().equals("findByPrimaryKey"))
/*     */     {
/* 300 */       if (!this.beans.containsKey(args[0])) {
/* 301 */         throw new FinderException(args[0] + " does not exist");
/*     */       }
/* 303 */       return factory.getEntityEJBObject(args[0]);
/*     */     }
/*     */ 
/* 306 */     return null;
/*     */   }
/*     */ 
/*     */   public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory)
/*     */     throws Exception
/*     */   {
/* 330 */     if (finderMethod.getName().equals("findAll"))
/*     */     {
/* 332 */       return GenericEntityObjectFactory.UTIL.getEntityCollection(factory, this.beans.keySet());
/*     */     }
/*     */ 
/* 337 */     return Collections.EMPTY_LIST;
/*     */   }
/*     */ 
/*     */   public void activateEntity(EntityEnterpriseContext instance)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void loadEntity(EntityEnterpriseContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 362 */       ObjectInputStream in = new CMPObjectInputStream(new ByteArrayInputStream((byte[])(byte[])this.beans.get(ctx.getId())));
/*     */ 
/* 365 */       Object obj = ctx.getInstance();
/*     */ 
/* 367 */       Field[] f = obj.getClass().getFields();
/* 368 */       for (int i = 0; i < f.length; i++)
/*     */       {
/* 370 */         f[i].set(obj, in.readObject());
/*     */       }
/*     */ 
/* 373 */       in.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 377 */       throw new EJBException("Load failed", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isStoreRequired(EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 390 */     if (this.isModified == null)
/*     */     {
/* 392 */       return true;
/*     */     }
/*     */ 
/* 395 */     Boolean modified = (Boolean)this.isModified.invoke(ctx.getInstance(), new Object[0]);
/* 396 */     return modified.booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean isModified(EntityEnterpriseContext ctx) throws Exception
/*     */   {
/* 401 */     return isStoreRequired(ctx);
/*     */   }
/*     */ 
/*     */   public void storeEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 413 */     storeEntity(ctx.getId(), ctx.getInstance());
/*     */   }
/*     */ 
/*     */   public void passivateEntity(EntityEnterpriseContext instance)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void removeEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoveException
/*     */   {
/* 435 */     if (this.beans.remove(ctx.getId()) == null)
/* 436 */       throw new RemoveException("Could not remove bean:" + ctx.getId());
/*     */   }
/*     */ 
/*     */   protected void storeEntity(Object id, Object obj)
/*     */   {
/*     */     try
/*     */     {
/* 446 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 447 */       ObjectOutputStream out = new CMPObjectOutputStream(baos);
/*     */       try
/*     */       {
/* 450 */         Field[] f = obj.getClass().getFields();
/* 451 */         for (int i = 0; i < f.length; i++)
/*     */         {
/* 453 */           out.writeObject(f[i].get(obj));
/*     */         }
/*     */       }
/*     */       finally {
/* 457 */         out.close();
/*     */       }
/*     */ 
/* 460 */       this.beans.put(id, baos.toByteArray());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 464 */       throw new EJBException("Store failed", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   static class CMPObjectInputStream extends ObjectInputStream
/*     */   {
/*     */     public CMPObjectInputStream(InputStream in)
/*     */       throws IOException
/*     */     {
/* 492 */       super();
/* 493 */       enableResolveObject(true);
/*     */     }
/*     */ 
/*     */     protected Object resolveObject(Object obj)
/*     */       throws IOException
/*     */     {
/* 499 */       if ((obj instanceof Handle)) {
/* 500 */         return ((Handle)obj).getEJBObject();
/*     */       }
/* 502 */       return obj;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class CMPObjectOutputStream extends ObjectOutputStream
/*     */   {
/*     */     public CMPObjectOutputStream(OutputStream out)
/*     */       throws IOException
/*     */     {
/* 474 */       super();
/* 475 */       enableReplaceObject(true);
/*     */     }
/*     */ 
/*     */     protected Object replaceObject(Object obj)
/*     */       throws IOException
/*     */     {
/* 481 */       if ((obj instanceof EJBObject)) {
/* 482 */         return ((EJBObject)obj).getHandle();
/*     */       }
/* 484 */       return obj;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.CMPInMemoryPersistenceManager
 * JD-Core Version:    0.6.0
 */