/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.LinkedList;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.XmlLoadable;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public abstract class AbstractInstancePool extends ServiceMBeanSupport
/*     */   implements AbstractInstancePoolMBean, InstancePool, XmlLoadable
/*     */ {
/*     */   private FIFOSemaphore strictMaxSize;
/*  70 */   private long strictTimeout = 9223372036854775807L;
/*     */   protected Container container;
/*  74 */   protected LinkedList pool = new LinkedList();
/*     */ 
/*  76 */   protected int maxSize = 30;
/*     */ 
/*  78 */   protected boolean reclaim = false;
/*     */ 
/*     */   public void setContainer(Container c)
/*     */   {
/*  95 */     this.container = c;
/*     */   }
/*     */ 
/*     */   public Container getContainer()
/*     */   {
/* 103 */     return this.container;
/*     */   }
/*     */ 
/*     */   public int getCurrentSize()
/*     */   {
/* 112 */     synchronized (this.pool)
/*     */     {
/* 114 */       return this.pool.size();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 124 */     return this.maxSize;
/*     */   }
/*     */ 
/*     */   public long getAvailableCount()
/*     */   {
/* 135 */     long size = 9223372036854775807L;
/* 136 */     if (this.strictMaxSize != null)
/* 137 */       size = this.strictMaxSize.permits();
/* 138 */     return size;
/*     */   }
/*     */ 
/*     */   public EnterpriseContext get()
/*     */     throws Exception
/*     */   {
/* 151 */     boolean trace = this.log.isTraceEnabled();
/* 152 */     if (trace) {
/* 153 */       this.log.trace("Get instance " + this + "#" + this.pool.size() + "#" + getContainer().getBeanClass());
/*     */     }
/* 155 */     if (this.strictMaxSize != null)
/*     */     {
/* 158 */       boolean acquired = this.strictMaxSize.attempt(this.strictTimeout);
/* 159 */       if (trace)
/* 160 */         this.log.trace("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.permits());
/* 161 */       if (!acquired) {
/* 162 */         throw new EJBException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
/*     */       }
/*     */     }
/* 165 */     synchronized (this.pool)
/*     */     {
/* 167 */       if (!this.pool.isEmpty())
/*     */       {
/* 169 */         return (EnterpriseContext)this.pool.removeFirst();
/*     */       }
/*     */     }
/*     */     Object ex;
/*     */     try
/*     */     {
/* 176 */       Object instance = this.container.createBeanClassInstance();
/* 177 */       return create(instance);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 182 */       if (this.strictMaxSize != null)
/*     */       {
/* 184 */         this.strictMaxSize.release();
/*     */       }
/*     */ 
/* 187 */       if ((e instanceof CreateException)) {
/* 188 */         throw ((CreateException)e);
/*     */       }
/*     */ 
/* 191 */       ex = null;
/* 192 */       if ((e instanceof Exception))
/*     */       {
/* 194 */         ex = (Exception)e;
/*     */       }
/*     */       else
/* 197 */         ex = new UndeclaredThrowableException(e);
/*     */     }
/* 199 */     throw new EJBException("Could not instantiate bean", (Exception)ex);
/*     */   }
/*     */ 
/*     */   public void free(EnterpriseContext ctx)
/*     */   {
/* 214 */     if (this.log.isTraceEnabled())
/*     */     {
/* 216 */       String msg = this.pool.size() + "/" + this.maxSize + " Free instance:" + this + "#" + ctx.getId() + "#" + ctx.getTransaction() + "#" + this.reclaim + "#" + getContainer().getBeanClass();
/*     */ 
/* 221 */       this.log.trace(msg);
/*     */     }
/*     */ 
/* 224 */     ctx.clear();
/*     */     try
/*     */     {
/* 230 */       boolean addedToPool = false;
/*     */ 
/* 232 */       synchronized (this.pool)
/*     */       {
/* 234 */         if (this.pool.size() < this.maxSize)
/*     */         {
/* 236 */           this.pool.addFirst(ctx);
/* 237 */           addedToPool = true;
/*     */         }
/*     */       }
/*     */ 
/* 241 */       if (addedToPool)
/*     */       {
/* 244 */         if (this.strictMaxSize != null)
/*     */         {
/* 246 */           this.strictMaxSize.release();
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 253 */         discard(ctx);
/*     */       }
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void discard(EnterpriseContext ctx)
/*     */   {
/* 263 */     if (this.log.isTraceEnabled())
/*     */     {
/* 265 */       String msg = "Discard instance:" + this + "#" + ctx + "#" + ctx.getTransaction() + "#" + this.reclaim + "#" + getContainer().getBeanClass();
/*     */ 
/* 269 */       this.log.trace(msg);
/*     */     }
/*     */ 
/* 273 */     if (this.strictMaxSize != null) {
/* 274 */       this.strictMaxSize.release();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 279 */       ctx.discard();
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 283 */       if (this.log.isTraceEnabled())
/* 284 */         this.log.trace("Ctx.discard error", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 290 */     synchronized (this.pool)
/*     */     {
/* 292 */       freeAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws DeploymentException
/*     */   {
/* 301 */     String maximumSize = MetaData.getElementContent(MetaData.getUniqueChild(element, "MaximumSize"));
/*     */     try
/*     */     {
/* 304 */       this.maxSize = Integer.parseInt(maximumSize);
/*     */     }
/*     */     catch (NumberFormatException e)
/*     */     {
/* 308 */       throw new DeploymentException("Invalid MaximumSize value for instance pool configuration");
/*     */     }
/*     */ 
/* 312 */     String strictValue = MetaData.getElementContent(MetaData.getOptionalChild(element, "strictMaximumSize"));
/* 313 */     Boolean strictFlag = Boolean.valueOf(strictValue);
/* 314 */     if (strictFlag == Boolean.TRUE)
/* 315 */       this.strictMaxSize = new FIFOSemaphore(this.maxSize);
/* 316 */     String delay = MetaData.getElementContent(MetaData.getOptionalChild(element, "strictTimeout"));
/*     */     try
/*     */     {
/* 319 */       if (delay != null)
/* 320 */         this.strictTimeout = Long.parseLong(delay);
/*     */     }
/*     */     catch (NumberFormatException e)
/*     */     {
/* 324 */       throw new DeploymentException("Invalid strictTimeout value for instance pool configuration");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract EnterpriseContext create(Object paramObject)
/*     */     throws Exception;
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 336 */     freeAll();
/* 337 */     this.container = null;
/*     */   }
/*     */ 
/*     */   private void freeAll()
/*     */   {
/* 347 */     LinkedList clone = (LinkedList)this.pool.clone();
/* 348 */     for (int i = 0; i < clone.size(); i++)
/*     */     {
/* 350 */       EnterpriseContext ec = (EnterpriseContext)clone.get(i);
/*     */ 
/* 352 */       ec.clear();
/* 353 */       discard(ec);
/*     */     }
/* 355 */     this.pool.clear();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.AbstractInstancePool
 * JD-Core Version:    0.6.0
 */