/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.BeanLock;
/*     */ import org.jboss.ejb.BeanLockExt;
/*     */ import org.jboss.ejb.BeanLockManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.InstanceCache;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.XmlLoadable;
/*     */ import org.jboss.monitor.MetricsConstants;
/*     */ import org.jboss.monitor.Monitorable;
/*     */ import org.jboss.monitor.client.BeanCacheSnapshot;
/*     */ import org.jboss.util.CachePolicy;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public abstract class AbstractInstanceCache
/*     */   implements InstanceCache, XmlLoadable, Monitorable, MetricsConstants, AbstractInstanceCacheMBean
/*     */ {
/*  68 */   protected static Logger log = Logger.getLogger(AbstractInstanceCache.class);
/*     */   private CachePolicy m_cache;
/*  73 */   private final Object m_cacheLock = new Object();
/*     */ 
/*     */   public void sample(Object s)
/*     */   {
/*  82 */     if (this.m_cache == null) {
/*  83 */       return;
/*     */     }
/*  85 */     synchronized (getCacheLock())
/*     */     {
/*  87 */       BeanCacheSnapshot snapshot = (BeanCacheSnapshot)s;
/*  88 */       snapshot.m_passivatingBeans = 0;
/*  89 */       CachePolicy policy = getCache();
/*  90 */       if ((policy instanceof Monitorable))
/*     */       {
/*  92 */         ((Monitorable)policy).sample(s);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Map retrieveStatistic() {
/*  98 */     return null;
/*     */   }
/*     */ 
/*     */   public void resetStatistic()
/*     */   {
/*     */   }
/*     */ 
/*     */   public EnterpriseContext get(Object id)
/*     */     throws RemoteException, NoSuchObjectException
/*     */   {
/* 109 */     if (id == null) throw new IllegalArgumentException("Can't get an object with a null key");
/*     */     EnterpriseContext ctx;
/* 113 */     synchronized (getCacheLock())
/*     */     {
/* 115 */       CachePolicy cache = getCache();
/* 116 */       ctx = (EnterpriseContext)cache.get(id);
/* 117 */       if (ctx == null)
/*     */       {
/*     */         try
/*     */         {
/* 121 */           ctx = acquireContext();
/* 122 */           setKey(id, ctx);
/* 123 */           if (!doActivate(ctx))
/*     */           {
/* 125 */             return ctx;
/* 126 */           }logActivation(id);
/*     */ 
/* 129 */           cache.insert(id, ctx);
/*     */         }
/*     */         catch (Throwable x)
/*     */         {
/* 133 */           log.debug("Activation failure", x);
/* 134 */           throw new NoSuchObjectException(x.getMessage());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 139 */     return ctx;
/*     */   }
/*     */ 
/*     */   public void insert(EnterpriseContext ctx)
/*     */   {
/* 145 */     if (ctx == null) throw new IllegalArgumentException("Can't insert a null object in the cache");
/*     */ 
/* 147 */     Object key = getKey(ctx);
/* 148 */     synchronized (getCacheLock())
/*     */     {
/* 152 */       getCache().insert(key, ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void tryToPassivate(EnterpriseContext ctx)
/*     */   {
/* 162 */     tryToPassivate(ctx, false);
/*     */   }
/*     */ 
/*     */   protected void tryToPassivate(EnterpriseContext ctx, boolean passivateAfterCommit)
/*     */   {
/* 173 */     Object id = ctx.getId();
/* 174 */     if (id == null) return;
/* 175 */     BeanLock lock = getContainer().getLockManager().getLock(id);
/* 176 */     boolean lockedBean = false;
/*     */     try
/*     */     {
/* 187 */       if ((lock instanceof BeanLockExt))
/*     */       {
/* 189 */         BeanLockExt lock2 = (BeanLockExt)lock;
/* 190 */         lockedBean = lock2.attemptSync();
/* 191 */         if (!lockedBean)
/*     */         {
/* 193 */           unableToPassivateDueToCtxLock(ctx, passivateAfterCommit);
/*     */           return;
/*     */         }
/*     */       }
/*     */       else {
/* 200 */         lock.sync();
/* 201 */         lockedBean = true;
/*     */       }
/*     */ 
/* 204 */       if (canPassivate(ctx))
/*     */       {
/*     */         try
/*     */         {
/* 208 */           remove(id);
/* 209 */           passivate(ctx);
/* 210 */           freeContext(ctx);
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/* 214 */           log.warn("failed to passivate, id=" + id, ignored);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 220 */         synchronized (getCacheLock())
/*     */         {
/* 222 */           getCache().get(id);
/*     */         }
/*     */ 
/* 225 */         unableToPassivateDueToCtxLock(ctx, passivateAfterCommit);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 230 */       if (lockedBean)
/* 231 */         lock.releaseSync();
/* 232 */       getContainer().getLockManager().removeLockRef(id);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void release(EnterpriseContext ctx)
/*     */   {
/* 243 */     if (ctx == null) throw new IllegalArgumentException("Can't release a null object");
/*     */ 
/* 257 */     tryToPassivate(ctx, true);
/*     */   }
/*     */ 
/*     */   public void remove(Object id)
/*     */   {
/* 266 */     if (id == null) throw new IllegalArgumentException("Can't remove an object using a null key");
/*     */ 
/* 268 */     synchronized (getCacheLock())
/*     */     {
/* 270 */       if (getCache().peek(id) != null)
/*     */       {
/* 272 */         getCache().remove(id);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isActive(Object id)
/*     */   {
/* 280 */     synchronized (getCacheLock())
/*     */     {
/* 282 */       return getCache().peek(id) != null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long getCacheSize()
/*     */   {
/* 292 */     int cacheSize = this.m_cache != null ? this.m_cache.size() : 0;
/* 293 */     return cacheSize;
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 300 */     if (this.m_cache != null)
/* 301 */       this.m_cache.flush();
/*     */   }
/*     */ 
/*     */   public long getPassivatedCount()
/*     */   {
/* 309 */     return 0L;
/*     */   }
/*     */ 
/*     */   public String getCachePolicyString()
/*     */   {
/* 320 */     return this.m_cache.toString();
/*     */   }
/*     */ 
/*     */   public void importXml(Element element)
/*     */     throws DeploymentException
/*     */   {
/* 327 */     String p = MetaData.getElementContent(MetaData.getUniqueChild(element, "cache-policy"));
/*     */     try
/*     */     {
/* 330 */       Class cls = SecurityActions.getContextClassLoader().loadClass(p);
/* 331 */       Constructor ctor = cls.getConstructor(new Class[] { AbstractInstanceCache.class });
/* 332 */       this.m_cache = ((CachePolicy)ctor.newInstance(new Object[] { this }));
/*     */     }
/*     */     catch (Exception x)
/*     */     {
/* 336 */       throw new DeploymentException("Can't create cache policy", x);
/*     */     }
/*     */ 
/* 339 */     Element policyConf = MetaData.getOptionalChild(element, "cache-policy-conf");
/* 340 */     if (policyConf != null)
/*     */     {
/* 342 */       if ((this.m_cache instanceof XmlLoadable))
/*     */       {
/*     */         try
/*     */         {
/* 346 */           ((XmlLoadable)this.m_cache).importXml(policyConf);
/*     */         }
/*     */         catch (Exception x)
/*     */         {
/* 350 */           throw new DeploymentException("Can't import policy configuration", x);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/* 359 */     getCache().create();
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 364 */     getCache().start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 370 */     synchronized (getCacheLock())
/*     */     {
/* 372 */       getCache().stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 378 */     synchronized (getCacheLock())
/*     */     {
/* 380 */       getCache().destroy();
/*     */     }
/* 382 */     this.m_cache = null;
/*     */   }
/*     */ 
/*     */   protected void logActivation(Object id)
/*     */   {
/* 392 */     if (log.isTraceEnabled())
/*     */     {
/* 394 */       StringBuffer m_buffer = new StringBuffer(100);
/* 395 */       m_buffer.append("Activated bean ");
/* 396 */       m_buffer.append(getContainer().getBeanMetaData().getEjbName());
/* 397 */       m_buffer.append(" with id = ");
/* 398 */       m_buffer.append(id);
/* 399 */       log.trace(m_buffer.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void logPassivation(Object id)
/*     */   {
/* 405 */     if (log.isTraceEnabled())
/*     */     {
/* 407 */       StringBuffer m_buffer = new StringBuffer(100);
/* 408 */       m_buffer.append("Passivated bean ");
/* 409 */       m_buffer.append(getContainer().getBeanMetaData().getEjbName());
/* 410 */       m_buffer.append(" with id = ");
/* 411 */       m_buffer.append(id);
/* 412 */       log.trace(m_buffer.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void unableToPassivateDueToCtxLock(EnterpriseContext ctx, boolean passivateAfterCommit)
/*     */   {
/* 418 */     log.warn("Unable to passivate due to ctx lock, id=" + ctx.getId());
/*     */   }
/*     */ 
/*     */   protected abstract Container getContainer();
/*     */ 
/*     */   protected CachePolicy getCache()
/*     */   {
/* 428 */     return this.m_cache;
/*     */   }
/*     */ 
/*     */   public Object getCacheLock()
/*     */   {
/* 434 */     return this.m_cacheLock;
/*     */   }
/*     */ 
/*     */   protected abstract void passivate(EnterpriseContext paramEnterpriseContext)
/*     */     throws RemoteException;
/*     */ 
/*     */   protected abstract void activate(EnterpriseContext paramEnterpriseContext)
/*     */     throws RemoteException;
/*     */ 
/*     */   protected boolean doActivate(EnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/* 453 */     activate(ctx);
/* 454 */     return true;
/*     */   }
/*     */ 
/*     */   protected abstract EnterpriseContext acquireContext()
/*     */     throws Exception;
/*     */ 
/*     */   protected abstract void freeContext(EnterpriseContext paramEnterpriseContext);
/*     */ 
/*     */   protected abstract Object getKey(EnterpriseContext paramEnterpriseContext);
/*     */ 
/*     */   protected abstract void setKey(Object paramObject, EnterpriseContext paramEnterpriseContext);
/*     */ 
/*     */   protected abstract boolean canPassivate(EnterpriseContext paramEnterpriseContext);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.AbstractInstanceCache
 * JD-Core Version:    0.6.0
 */