/*    */ package org.jboss.ejb.deployers;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*    */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*    */ import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*    */ import org.jboss.metadata.ejb.jboss.JBossMetaDataWrapper;
/*    */ 
/*    */ public class StandardJBossMetaDataDeployer extends AbstractDeployer
/*    */ {
/* 40 */   public static final String RAW_ATTACHMENT_NAME = "raw." + JBossMetaData.class.getName();
/*    */ 
/*    */   public StandardJBossMetaDataDeployer()
/*    */   {
/* 46 */     setStage(DeploymentStages.POST_CLASSLOADER);
/*    */ 
/* 48 */     addInput(JBossMetaData.class);
/*    */ 
/* 50 */     addInput("standardjboss.xml");
/*    */ 
/* 52 */     addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
/*    */ 
/* 54 */     setOutput(JBossMetaData.class);
/* 55 */     addOutput(RAW_ATTACHMENT_NAME);
/*    */   }
/*    */ 
/*    */   public void deploy(DeploymentUnit unit)
/*    */     throws DeploymentException
/*    */   {
/* 66 */     JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
/*    */ 
/* 68 */     JBossMetaData stdMetaData = (JBossMetaData)unit.getAttachment("standardjboss.xml", JBossMetaData.class);
/* 69 */     if ((metaData == null) || (stdMetaData == null)) {
/* 70 */       return;
/*    */     }
/* 72 */     JBossMetaDataWrapper wrapper = new JBossMetaDataWrapper(metaData, stdMetaData);
/*    */ 
/* 74 */     unit.getTransientManagedObjects().addAttachment(JBossMetaData.class, wrapper);
/*    */ 
/* 76 */     unit.addAttachment(RAW_ATTACHMENT_NAME, metaData, JBossMetaData.class);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.deployers.StandardJBossMetaDataDeployer
 * JD-Core Version:    0.6.0
 */