/*     */ package org.jboss.ejb.deployers;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.microcontainer.aspects.jmx.JMX;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.ejb.EjbModule;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.InvokerProxyBindingMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.security.ISecurityManagement;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceConstructorMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyValueMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ @JMX(name="jboss.ejb:service=EJBDeployer", exposedInterface=EjbDeployerMBean.class)
/*     */ public class EjbDeployer extends AbstractSimpleVFSRealDeployer<JBossMetaData>
/*     */   implements EjbDeployerMBean
/*     */ {
/*     */   private String transactionManagerServiceName;
/*     */   private String webServiceName;
/*     */   private String ccmServiceName;
/*     */   private String timerServiceName;
/*     */   private boolean callByValue;
/*  73 */   private String unauthenticatedIdentity = null;
/*     */   private ISecurityManagement securityManagement;
/*     */   private String securityContextClassName;
/*     */   private String defaultSecurityDomain;
/*     */ 
/*     */   public EjbDeployer()
/*     */   {
/*  83 */     super(JBossMetaData.class);
/*  84 */     setOutput(ServiceMetaData.class);
/*     */   }
/*     */ 
/*     */   public String getTransactionManagerServiceName()
/*     */   {
/*  89 */     return this.transactionManagerServiceName;
/*     */   }
/*     */ 
/*     */   public void setTransactionManagerServiceName(String transactionManagerServiceName)
/*     */   {
/*  95 */     this.transactionManagerServiceName = transactionManagerServiceName;
/*     */   }
/*     */ 
/*     */   public String getWebServiceName()
/*     */   {
/* 100 */     return this.webServiceName;
/*     */   }
/*     */ 
/*     */   public void setWebServiceName(String webServiceName)
/*     */   {
/* 105 */     this.webServiceName = webServiceName;
/*     */   }
/*     */ 
/*     */   public String getCachedConnectionManagerName()
/*     */   {
/* 110 */     return this.ccmServiceName;
/*     */   }
/*     */ 
/*     */   public void setCachedConnectionManagerName(String ccmServiceName)
/*     */   {
/* 115 */     this.ccmServiceName = ccmServiceName;
/*     */   }
/*     */ 
/*     */   public String getTimerService()
/*     */   {
/* 120 */     return this.timerServiceName;
/*     */   }
/*     */ 
/*     */   public void setTimerServiceName(String timerServiceName)
/*     */   {
/* 125 */     this.timerServiceName = timerServiceName;
/*     */   }
/*     */ 
/*     */   public boolean isCallByValue()
/*     */   {
/* 131 */     return this.callByValue;
/*     */   }
/*     */ 
/*     */   public void setCallByValue(boolean callByValue)
/*     */   {
/* 136 */     this.callByValue = callByValue;
/*     */   }
/*     */ 
/*     */   public String getUnauthenticatedIdentity()
/*     */   {
/* 146 */     return this.unauthenticatedIdentity;
/*     */   }
/*     */ 
/*     */   public void setUnauthenticatedIdentity(String unauthenticatedIdentity)
/*     */   {
/* 155 */     this.unauthenticatedIdentity = unauthenticatedIdentity;
/*     */   }
/*     */ 
/*     */   public void setDefaultSecurityDomain(String defaultSecurityDomain)
/*     */   {
/* 160 */     this.defaultSecurityDomain = defaultSecurityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityManagement(ISecurityManagement sm)
/*     */   {
/* 165 */     this.securityManagement = sm;
/*     */   }
/*     */ 
/*     */   public void setSecurityContextClassName(String securityContextClassName)
/*     */   {
/* 170 */     this.securityContextClassName = securityContextClassName;
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit, JBossMetaData deployment)
/*     */     throws DeploymentException
/*     */   {
/* 180 */     if ((!deployment.isEJB2x()) && (!deployment.isEJB1x())) {
/* 181 */       return;
/*     */     }
/* 183 */     ServiceMetaData ejbModule = new ServiceMetaData();
/* 184 */     ejbModule.setCode(EjbModule.class.getName());
/*     */ 
/* 188 */     ObjectName moduleObjectName = null;
/*     */     try
/*     */     {
/* 191 */       moduleObjectName = getObjectName(unit, deployment);
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 195 */       throw new DeploymentException("Failed to create EJB module " + unit.getName() + ": malformed EjbModule name", e);
/*     */     }
/*     */ 
/* 199 */     ejbModule.setObjectName(moduleObjectName);
/*     */ 
/* 201 */     ServiceConstructorMetaData ctor = new ServiceConstructorMetaData();
/* 202 */     ctor.setSignature(new String[] { VFSDeploymentUnit.class.getName(), ApplicationMetaData.class.getName() });
/*     */ 
/* 205 */     ApplicationMetaData legacyMD = new ApplicationMetaData(deployment);
/* 206 */     ctor.setParameters(new Object[] { unit, legacyMD });
/* 207 */     ejbModule.setConstructor(ctor);
/*     */ 
/* 210 */     List attrs = new ArrayList();
/* 211 */     ServiceAttributeMetaData attr = new ServiceAttributeMetaData();
/* 212 */     attr.setName("TransactionManagerFactory");
/* 213 */     ServiceDependencyValueMetaData dependencyValue = new ServiceDependencyValueMetaData();
/* 214 */     dependencyValue.setDependency(getTransactionManagerServiceName());
/* 215 */     dependencyValue.setProxyType("attribute");
/* 216 */     attr.setValue(dependencyValue);
/* 217 */     attrs.add(attr);
/*     */ 
/* 219 */     String wsName = getWebServiceName();
/* 220 */     if (wsName != null)
/*     */     {
/* 222 */       ServiceAttributeMetaData ws = new ServiceAttributeMetaData();
/* 223 */       ws.setName("WebServiceName");
/* 224 */       ServiceDependencyValueMetaData wsDepends = new ServiceDependencyValueMetaData();
/* 225 */       wsDepends.setDependency(wsName);
/* 226 */       ws.setValue(wsDepends);
/* 227 */       attrs.add(ws);
/*     */     }
/*     */ 
/* 230 */     ServiceAttributeMetaData tms = new ServiceAttributeMetaData();
/* 231 */     ServiceDependencyValueMetaData tmsDepends = new ServiceDependencyValueMetaData();
/* 232 */     tms.setName("TimerService");
/* 233 */     tmsDepends.setDependency(this.timerServiceName);
/* 234 */     tmsDepends.setProxyType("attribute");
/* 235 */     tms.setValue(tmsDepends);
/* 236 */     attrs.add(tms);
/*     */ 
/* 238 */     ejbModule.setAttributes(attrs);
/*     */ 
/* 240 */     List dependencies = new ArrayList();
/*     */ 
/* 243 */     if ((this.ccmServiceName != null) && (this.ccmServiceName.length() > 0))
/*     */     {
/* 245 */       ServiceDependencyMetaData ccm = new ServiceDependencyMetaData();
/* 246 */       ccm.setIDependOn(this.ccmServiceName);
/* 247 */       dependencies.add(ccm);
/*     */     }
/*     */ 
/* 250 */     JBossEnterpriseBeansMetaData beans = deployment.getEnterpriseBeans();
/* 251 */     Iterator beansIter = beans.iterator();
/* 252 */     HashSet invokerNames = new HashSet();
/* 253 */     HashSet beanDepends = new HashSet();
/* 254 */     while (beansIter.hasNext())
/*     */     {
/* 256 */       JBossEnterpriseBeanMetaData bmd = (JBossEnterpriseBeanMetaData)beansIter.next();
/* 257 */       Set depends = bmd.getDepends();
/* 258 */       if (depends != null)
/* 259 */         beanDepends.addAll(depends);
/* 260 */       String configName = bmd.getConfigurationName();
/* 261 */       ContainerConfigurationMetaData cmd = bmd.determineContainerConfiguration();
/* 262 */       Set invokers = cmd.getInvokerProxyBindingNames();
/* 263 */       if (invokers != null) {
/* 264 */         for (String iname : invokers)
/*     */         {
/* 266 */           InvokerProxyBindingMetaData imd = deployment.getInvokerProxyBinding(iname);
/* 267 */           if (imd == null)
/* 268 */             throw new DeploymentException("Failed to locate invoker: " + iname);
/* 269 */           String invokerName = imd.getInvokerMBean();
/* 270 */           if (invokerName.equalsIgnoreCase("default"))
/*     */           {
/*     */             continue;
/*     */           }
/*     */ 
/* 275 */           if (!invokerNames.contains(invokerName))
/*     */           {
/* 277 */             invokerNames.add(invokerName);
/* 278 */             ServiceDependencyMetaData invoker = new ServiceDependencyMetaData();
/* 279 */             invoker.setIDependOn(invokerName);
/* 280 */             dependencies.add(invoker);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 292 */       for (String depend : beanDepends)
/*     */       {
/* 294 */         ObjectName n = new ObjectName(depend);
/* 295 */         ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
/* 296 */         sdmd.setIDependOn(n.toString());
/* 297 */         dependencies.add(sdmd);
/*     */       }
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 302 */       throw new DeploymentException(e);
/*     */     }
/* 304 */     ejbModule.setDependencies(dependencies);
/*     */ 
/* 306 */     unit.addAttachment(ServiceMetaData.class, ejbModule);
/*     */ 
/* 308 */     if (this.callByValue) {
/* 309 */       unit.addAttachment("EJB.callByValue", Boolean.TRUE, Boolean.class);
/*     */     }
/* 311 */     if (this.unauthenticatedIdentity != null) {
/* 312 */       unit.addAttachment("EJB.unauthenticatedIdentity", this.unauthenticatedIdentity, String.class);
/*     */     }
/* 314 */     if (this.securityManagement != null) {
/* 315 */       unit.addAttachment("EJB.securityManagement", this.securityManagement, ISecurityManagement.class);
/*     */     }
/* 317 */     if (this.securityContextClassName != null) {
/* 318 */       unit.addAttachment("EJB.securityContextClassName", this.securityContextClassName, String.class);
/*     */     }
/* 320 */     if (this.defaultSecurityDomain != null)
/* 321 */       unit.addAttachment("EJB.defaultSecurityDomain", this.defaultSecurityDomain, String.class);
/*     */   }
/*     */ 
/*     */   public void undeploy(VFSDeploymentUnit unit, JBossMetaData deployment)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected ObjectName getObjectName(VFSDeploymentUnit unit, JBossMetaData metaData)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 342 */     String name = metaData.getJmxName();
/* 343 */     if (name == null)
/*     */     {
/* 345 */       String unitShortName = unit.getName();
/* 346 */       if (unitShortName.endsWith("/"))
/*     */       {
/* 348 */         unitShortName = unitShortName.substring(0, unitShortName.length() - 1);
/*     */       }
/*     */ 
/* 351 */       if (unitShortName.endsWith("!"))
/*     */       {
/* 353 */         unitShortName = unitShortName.substring(0, unitShortName.length() - 1);
/*     */       }
/*     */ 
/* 356 */       unitShortName = unitShortName.substring(unitShortName.lastIndexOf("/") + 1);
/*     */ 
/* 358 */       unitShortName = ObjectName.quote(unitShortName);
/* 359 */       name = "jboss.j2ee:service=EjbModule,module=" + unitShortName;
/*     */     }
/*     */ 
/* 362 */     return new ObjectName(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.deployers.EjbDeployer
 * JD-Core Version:    0.6.0
 */