/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.RemoveException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public class StatelessSessionContainer extends SessionContainer
/*     */   implements EJBProxyFactoryContainer, InstancePoolContainer
/*     */ {
/*     */   public void remove(Invocation mi)
/*     */     throws RemoteException, RemoveException
/*     */   {
/*  59 */     this.log.debug("Useless invocation of remove() for stateless session bean");
/*     */   }
/*     */ 
/*     */   public EJBLocalObject createLocalHome()
/*     */     throws CreateException
/*     */   {
/*  67 */     if (this.localProxyFactory == null)
/*     */     {
/*  69 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/*  70 */       throw new IllegalStateException(msg);
/*     */     }
/*  72 */     this.createCount += 1L;
/*  73 */     return this.localProxyFactory.getStatelessSessionEJBLocalObject();
/*     */   }
/*     */ 
/*     */   public void removeLocalHome(Object primaryKey)
/*     */   {
/*  81 */     this.log.debug("Useless invocation of remove(Object) for stateless session bean");
/*     */   }
/*     */ 
/*     */   public EJBObject createHome()
/*     */     throws RemoteException, CreateException
/*     */   {
/*  89 */     EJBProxyFactory ci = getProxyFactory();
/*  90 */     if (ci == null)
/*     */     {
/*  92 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/*  93 */       throw new IllegalStateException(msg);
/*     */     }
/*  95 */     this.createCount += 1L;
/*  96 */     Object obj = ci.getStatelessSessionEJBObject();
/*  97 */     return (EJBObject)obj;
/*     */   }
/*     */ 
/*     */   public void removeHome(Handle handle)
/*     */     throws RemoteException, RemoveException
/*     */   {
/* 106 */     throw new UnreachableStatementException();
/*     */   }
/*     */ 
/*     */   public void removeHome(Object primaryKey)
/*     */     throws RemoteException, RemoveException
/*     */   {
/* 115 */     throw new UnreachableStatementException();
/*     */   }
/*     */ 
/*     */   protected void setupHomeMapping()
/*     */     throws NoSuchMethodException
/*     */   {
/* 123 */     Map map = new HashMap();
/*     */ 
/* 125 */     if (this.homeInterface != null)
/*     */     {
/* 127 */       Method[] m = this.homeInterface.getMethods();
/* 128 */       for (int i = 0; i < m.length; i++)
/*     */       {
/* 131 */         this.log.debug("Mapping " + m[i].getName());
/* 132 */         map.put(m[i], getClass().getMethod(m[i].getName() + "Home", m[i].getParameterTypes()));
/*     */       }
/*     */     }
/* 135 */     if (this.localHomeInterface != null)
/*     */     {
/* 137 */       Method[] m = this.localHomeInterface.getMethods();
/* 138 */       for (int i = 0; i < m.length; i++)
/*     */       {
/* 141 */         this.log.debug("Mapping " + m[i].getName());
/* 142 */         map.put(m[i], getClass().getMethod(m[i].getName() + "LocalHome", m[i].getParameterTypes()));
/*     */       }
/*     */     }
/*     */ 
/* 146 */     this.homeMapping = map;
/*     */   }
/*     */ 
/*     */   Interceptor createContainerInterceptor()
/*     */   {
/* 151 */     return new ContainerInterceptor();
/*     */   }
/*     */ 
/*     */   class ContainerInterceptor extends Container.AbstractContainerInterceptor
/*     */   {
/*     */     ContainerInterceptor() {
/* 157 */       super();
/*     */     }
/*     */ 
/*     */     public Object invokeHome(Invocation mi) throws Exception
/*     */     {
/* 162 */       Method miMethod = mi.getMethod();
/* 163 */       Method m = (Method)StatelessSessionContainer.this.getHomeMapping().get(miMethod);
/* 164 */       if (m == null)
/*     */       {
/* 166 */         String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
/* 167 */         throw new EJBException(msg);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 172 */         return mi.performCall(StatelessSessionContainer.this, m, mi.getArguments());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 176 */         rethrow(e);
/*     */       }
/*     */ 
/* 180 */       throw new UnreachableStatementException();
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation mi)
/*     */       throws Exception
/*     */     {
/* 186 */       EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
/* 187 */       if (ctx.getTransaction() == null) {
/* 188 */         ctx.setTransaction(mi.getTransaction());
/*     */       }
/*     */ 
/* 191 */       Method miMethod = mi.getMethod();
/*     */ 
/* 193 */       Map map = StatelessSessionContainer.this.getBeanMapping();
/* 194 */       Method m = (Method)map.get(miMethod);
/*     */ 
/* 198 */       if ((m == null) && (map.values().contains(miMethod)))
/*     */       {
/* 200 */         m = miMethod;
/*     */       }
/*     */ 
/* 203 */       if (m == null)
/*     */       {
/* 205 */         String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
/* 206 */         throw new EJBException(msg);
/*     */       }
/*     */ 
/* 210 */       if ((m.getDeclaringClass().equals(StatelessSessionContainer.class)) || (m.getDeclaringClass().equals(SessionContainer.class)))
/*     */       {
/*     */         try
/*     */         {
/* 215 */           return mi.performCall(StatelessSessionContainer.this, m, new Object[] { mi });
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 219 */           rethrow(e);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 227 */           Object bean = ctx.getInstance();
/* 228 */           return mi.performCall(bean, m, mi.getArguments());
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 232 */           rethrow(e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 237 */       throw new UnreachableStatementException();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.StatelessSessionContainer
 * JD-Core Version:    0.6.0
 */