/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.Principal;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.SessionBean;
/*     */ import javax.ejb.SessionContext;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.transaction.UserTransaction;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ 
/*     */ public class StatefulSessionEnterpriseContext extends EnterpriseContext
/*     */   implements Serializable
/*     */ {
/*     */   private EJBObject ejbObject;
/*     */   private EJBLocalObject ejbLocalObject;
/*     */   private SessionContext ctx;
/*     */ 
/*     */   public StatefulSessionEnterpriseContext(Object instance, Container con)
/*     */     throws RemoteException
/*     */   {
/*  64 */     super(instance, con);
/*  65 */     this.ctx = new StatefulSessionContextImpl();
/*     */     try
/*     */     {
/*  68 */       AllowedOperationsAssociation.pushInMethodFlag(IN_SET_SESSION_CONTEXT);
/*  69 */       ((SessionBean)instance).setSessionContext(this.ctx);
/*     */     }
/*     */     finally
/*     */     {
/*  73 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void discard()
/*     */     throws RemoteException
/*     */   {
/*     */   }
/*     */ 
/*     */   public EJBContext getEJBContext()
/*     */   {
/*  86 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   public void setInstance(Object instance)
/*     */   {
/*  95 */     this.instance = instance;
/*     */     try
/*     */     {
/*  98 */       ((SessionBean)instance).setSessionContext(this.ctx);
/*     */     }
/*     */     catch (Exception x)
/*     */     {
/* 102 */       log.error("Failed to setSessionContext", x);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setEJBObject(EJBObject eo) {
/* 107 */     this.ejbObject = eo;
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject() {
/* 111 */     return this.ejbObject;
/*     */   }
/*     */ 
/*     */   public void setEJBLocalObject(EJBLocalObject eo) {
/* 115 */     this.ejbLocalObject = eo;
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getEJBLocalObject() {
/* 119 */     return this.ejbLocalObject;
/*     */   }
/*     */ 
/*     */   public SessionContext getSessionContext()
/*     */   {
/* 124 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected class StatefulSessionContextImpl extends EnterpriseContext.EJBContextImpl
/*     */     implements SessionContext
/*     */   {
/*     */     protected StatefulSessionContextImpl()
/*     */     {
/* 147 */       super();
/*     */     }
/*     */ 
/*     */     public EJBHome getEJBHome()
/*     */     {
/* 154 */       AllowedOperationsAssociation.assertAllowedIn("getEJBHome", AllowedOperationsFlags.IN_SET_SESSION_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
/*     */ 
/* 159 */       return super.getEJBHome();
/*     */     }
/*     */ 
/*     */     public EJBLocalHome getEJBLocalHome()
/*     */     {
/* 164 */       AllowedOperationsAssociation.assertAllowedIn("getEJBLocalHome", AllowedOperationsFlags.IN_SET_SESSION_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
/*     */ 
/* 169 */       return super.getEJBLocalHome();
/*     */     }
/*     */ 
/*     */     public Principal getCallerPrincipal()
/*     */     {
/* 177 */       AllowedOperationsAssociation.assertAllowedIn("getCallerPrincipal", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
/*     */ 
/* 181 */       return super.getCallerPrincipal();
/*     */     }
/*     */ 
/*     */     public boolean isCallerInRole(String id)
/*     */     {
/* 186 */       AllowedOperationsAssociation.assertAllowedIn("isCallerInRole", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
/*     */ 
/* 190 */       return super.isCallerInRole(id);
/*     */     }
/*     */ 
/*     */     public EJBObject getEJBObject()
/*     */     {
/* 195 */       AllowedOperationsAssociation.assertAllowedIn("getEJBObject", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
/*     */ 
/* 199 */       if (((StatefulSessionContainer)StatefulSessionEnterpriseContext.this.con).getRemoteClass() == null) {
/* 200 */         throw new IllegalStateException("No remote interface defined.");
/*     */       }
/* 202 */       if (StatefulSessionEnterpriseContext.this.ejbObject == null)
/*     */       {
/* 204 */         EJBProxyFactory proxyFactory = StatefulSessionEnterpriseContext.this.con.getProxyFactory();
/* 205 */         if (proxyFactory == null)
/*     */         {
/* 207 */           String defaultInvokerName = StatefulSessionEnterpriseContext.this.con.getBeanMetaData().getContainerConfiguration().getDefaultInvokerName();
/*     */ 
/* 209 */           proxyFactory = StatefulSessionEnterpriseContext.this.con.lookupProxyFactory(defaultInvokerName);
/*     */         }
/* 211 */         StatefulSessionEnterpriseContext.access$002(StatefulSessionEnterpriseContext.this, (EJBObject)proxyFactory.getStatefulSessionEJBObject(StatefulSessionEnterpriseContext.this.id));
/*     */       }
/*     */ 
/* 214 */       return StatefulSessionEnterpriseContext.this.ejbObject;
/*     */     }
/*     */ 
/*     */     public Object getBusinessObject(Class businessInterface) throws IllegalStateException
/*     */     {
/* 219 */       throw new RuntimeException("NOT IMPLEMENTED");
/*     */     }
/*     */ 
/*     */     public Class getInvokedBusinessInterface() throws IllegalStateException
/*     */     {
/* 224 */       throw new RuntimeException("NOT IMPLEMENTED");
/*     */     }
/*     */ 
/*     */     public EJBLocalObject getEJBLocalObject()
/*     */     {
/* 229 */       AllowedOperationsAssociation.assertAllowedIn("getEJBLocalObject", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
/*     */ 
/* 233 */       if (StatefulSessionEnterpriseContext.this.con.getLocalHomeClass() == null)
/* 234 */         throw new IllegalStateException("No local interface for bean.");
/* 235 */       if (StatefulSessionEnterpriseContext.this.ejbLocalObject == null)
/*     */       {
/* 237 */         StatefulSessionEnterpriseContext.access$102(StatefulSessionEnterpriseContext.this, ((StatefulSessionContainer)StatefulSessionEnterpriseContext.this.con).getLocalProxyFactory().getStatefulSessionEJBLocalObject(StatefulSessionEnterpriseContext.this.id));
/*     */       }
/* 239 */       return StatefulSessionEnterpriseContext.this.ejbLocalObject;
/*     */     }
/*     */ 
/*     */     public boolean getRollbackOnly()
/*     */     {
/* 244 */       AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION);
/*     */ 
/* 247 */       return super.getRollbackOnly();
/*     */     }
/*     */ 
/*     */     public void setRollbackOnly()
/*     */     {
/* 252 */       AllowedOperationsAssociation.assertAllowedIn("setRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION);
/*     */ 
/* 255 */       super.setRollbackOnly();
/*     */     }
/*     */ 
/*     */     public UserTransaction getUserTransaction()
/*     */     {
/* 260 */       AllowedOperationsAssociation.assertAllowedIn("getUserTransaction", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD);
/*     */ 
/* 263 */       return super.getUserTransaction();
/*     */     }
/*     */ 
/*     */     public TimerService getTimerService() throws IllegalStateException
/*     */     {
/* 268 */       throw new IllegalStateException("getTimerService should not be access from a stateful session bean");
/*     */     }
/*     */ 
/*     */     public MessageContext getMessageContext() throws IllegalStateException
/*     */     {
/* 273 */       AllowedOperationsAssociation.assertAllowedIn("getMessageContext", 0);
/*     */ 
/* 275 */       return null;
/*     */     }
/*     */ 
/*     */     public Object getPrimaryKey()
/*     */     {
/* 280 */       return StatefulSessionEnterpriseContext.this.id;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.StatefulSessionEnterpriseContext
 * JD-Core Version:    0.6.0
 */