/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.util.UnexpectedThrowable;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public class StatefulSessionContainer extends SessionContainer
/*     */   implements EJBProxyFactoryContainer, InstancePoolContainer
/*     */ {
/*     */   protected StatefulSessionPersistenceManager persistenceManager;
/*     */   protected InstanceCache instanceCache;
/*     */   protected Method getEJBObject;
/*     */   protected Method ejbObjectRemove;
/*     */   protected Method ejbLocalObjectRemove;
/*     */ 
/*     */   public void setInstanceCache(InstanceCache ic)
/*     */   {
/*  74 */     this.instanceCache = ic;
/*  75 */     ic.setContainer(this);
/*     */   }
/*     */ 
/*     */   public InstanceCache getInstanceCache()
/*     */   {
/*  80 */     return this.instanceCache;
/*     */   }
/*     */ 
/*     */   public StatefulSessionPersistenceManager getPersistenceManager()
/*     */   {
/*  85 */     return this.persistenceManager;
/*     */   }
/*     */ 
/*     */   public void setPersistenceManager(StatefulSessionPersistenceManager pm)
/*     */   {
/*  90 */     this.persistenceManager = pm;
/*  91 */     pm.setContainer(this);
/*     */   }
/*     */ 
/*     */   public Set getMethodPermissions(Method m, InvocationType iface)
/*     */   {
/* 105 */     if (!m.equals(this.getEJBObject)) {
/* 106 */       return super.getMethodPermissions(m, iface);
/*     */     }
/* 108 */     Class[] sig = new Class[0];
/* 109 */     Set permissions = getBeanMetaData().getMethodPermissions("create", sig, iface);
/*     */ 
/* 111 */     return permissions;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 117 */     super.createService();
/*     */     try
/*     */     {
/* 121 */       this.getEJBObject = Handle.class.getMethod("getEJBObject", new Class[0]);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 125 */       this.log.warn("Failed to grant access to the Handle.getEJBObject method");
/*     */     }
/*     */ 
/* 128 */     this.ejbObjectRemove = EJBObject.class.getMethod("remove", null);
/* 129 */     this.ejbLocalObjectRemove = EJBLocalObject.class.getMethod("remove", null);
/*     */   }
/*     */ 
/*     */   protected void createInstanceCache()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 140 */       ObjectName containerName = super.getJmxName();
/* 141 */       Hashtable props = containerName.getKeyPropertyList();
/* 142 */       props.put("plugin", "cache");
/* 143 */       ObjectName cacheName = new ObjectName(containerName.getDomain(), props);
/* 144 */       this.server.registerMBean(this.instanceCache, cacheName);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 148 */       this.log.debug("Failed to register cache as mbean", t);
/*     */     }
/*     */ 
/* 151 */     this.instanceCache.create();
/*     */   }
/*     */ 
/*     */   protected void createPersistenceManager()
/*     */     throws Exception
/*     */   {
/* 159 */     this.persistenceManager.create();
/*     */   }
/*     */ 
/*     */   protected void startPersistenceManager()
/*     */     throws Exception
/*     */   {
/* 167 */     this.persistenceManager.start();
/*     */   }
/*     */ 
/*     */   protected void startInstanceCache()
/*     */     throws Exception
/*     */   {
/* 175 */     this.instanceCache.start();
/*     */   }
/*     */ 
/*     */   protected void stopPersistenceManager()
/*     */   {
/* 183 */     this.persistenceManager.stop();
/*     */   }
/*     */ 
/*     */   protected void stopInstanceCache()
/*     */   {
/* 191 */     this.instanceCache.stop();
/*     */   }
/*     */ 
/*     */   protected void destroyPersistenceManager()
/*     */   {
/* 197 */     this.persistenceManager.destroy();
/* 198 */     this.persistenceManager.setContainer(null);
/*     */   }
/*     */ 
/*     */   protected void destroyInstanceCache()
/*     */   {
/* 204 */     this.instanceCache.destroy();
/* 205 */     this.instanceCache.setContainer(null);
/*     */     try
/*     */     {
/* 208 */       ObjectName containerName = super.getJmxName();
/* 209 */       Hashtable props = containerName.getKeyPropertyList();
/* 210 */       props.put("plugin", "cache");
/* 211 */       ObjectName cacheName = new ObjectName(containerName.getDomain(), props);
/* 212 */       this.server.unregisterMBean(cacheName);
/*     */     }
/*     */     catch (Throwable ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(Invocation mi)
/*     */     throws RemoteException, RemoveException
/*     */   {
/* 225 */     StatefulSessionEnterpriseContext ctx = (StatefulSessionEnterpriseContext)mi.getEnterpriseContext();
/* 226 */     if (ctx.getId() == null)
/*     */     {
/* 228 */       throw new RemoveException("SFSB has been removed already");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 234 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_REMOVE);
/* 235 */       getPersistenceManager().removeSession(ctx);
/*     */     }
/*     */     finally
/*     */     {
/* 239 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 243 */     ctx.setId(null);
/* 244 */     this.removeCount += 1L;
/*     */   }
/*     */ 
/*     */   private void createSession(Method m, Object[] args, StatefulSessionEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 255 */     Object id = getPersistenceManager().createId(ctx);
/* 256 */     this.log.debug("Created new session ID: " + id);
/* 257 */     ctx.setId(id);
/*     */     try
/*     */     {
/* 262 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
/*     */ 
/* 265 */       String createName = m.getName();
/* 266 */       Object instance = ctx.getInstance();
/* 267 */       String ejbCreateName = "ejbC" + createName.substring(1);
/* 268 */       Method createMethod = instance.getClass().getMethod(ejbCreateName, m.getParameterTypes());
/* 269 */       this.log.debug("Using create method for session: " + createMethod);
/* 270 */       createMethod.invoke(instance, args);
/* 271 */       this.createCount += 1L;
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 275 */       ctx.setId(null);
/*     */ 
/* 277 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 281 */       ctx.setId(null);
/*     */ 
/* 283 */       Throwable t = e.getTargetException();
/* 284 */       if ((t instanceof RuntimeException))
/*     */       {
/* 286 */         if ((t instanceof EJBException)) {
/* 287 */           throw ((EJBException)t);
/*     */         }
/* 289 */         throw new EJBException((Exception)t);
/*     */       }
/* 291 */       if ((t instanceof Exception))
/*     */       {
/* 294 */         throw ((Exception)t);
/*     */       }
/* 296 */       if ((t instanceof Error))
/*     */       {
/* 298 */         throw ((Error)t);
/*     */       }
/*     */ 
/* 302 */       throw new UnexpectedThrowable(t);
/*     */     }
/*     */     finally
/*     */     {
/* 307 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 311 */     getPersistenceManager().createdSession(ctx);
/*     */ 
/* 314 */     getInstanceCache().insert(ctx);
/*     */ 
/* 317 */     if (getProxyFactory() != null) {
/* 318 */       ctx.setEJBObject((EJBObject)getProxyFactory().getStatefulSessionEJBObject(id));
/*     */     }
/*     */ 
/* 321 */     if (getLocalHomeClass() != null)
/* 322 */       ctx.setEJBLocalObject(getLocalProxyFactory().getStatefulSessionEJBLocalObject(id));
/*     */   }
/*     */ 
/*     */   public EJBObject createHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 328 */     StatefulSessionEnterpriseContext ctx = (StatefulSessionEnterpriseContext)mi.getEnterpriseContext();
/* 329 */     createSession(mi.getMethod(), mi.getArguments(), ctx);
/* 330 */     return ctx.getEJBObject();
/*     */   }
/*     */ 
/*     */   public void removeLocalHome(Invocation mi)
/*     */     throws RemoteException, RemoveException
/*     */   {
/* 342 */     throw new UnreachableStatementException();
/*     */   }
/*     */ 
/*     */   public EJBLocalObject createLocalHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 348 */     StatefulSessionEnterpriseContext ctx = (StatefulSessionEnterpriseContext)mi.getEnterpriseContext();
/* 349 */     createSession(mi.getMethod(), mi.getArguments(), ctx);
/* 350 */     return ctx.getEJBLocalObject();
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject(Invocation mi)
/*     */     throws RemoteException
/*     */   {
/* 359 */     EJBProxyFactory ci = getProxyFactory();
/* 360 */     if (ci == null)
/*     */     {
/* 362 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/* 363 */       throw new IllegalStateException(msg);
/*     */     }
/*     */ 
/* 366 */     Object id = mi.getArguments()[0];
/* 367 */     if (id == null) {
/* 368 */       throw new IllegalStateException("Cannot get a session interface with a null id");
/*     */     }
/*     */ 
/* 371 */     InstanceCache cache = getInstanceCache();
/* 372 */     BeanLock lock = getLockManager().getLock(id);
/* 373 */     lock.sync();
/*     */     try
/*     */     {
/* 376 */       if (cache.get(id) == null)
/* 377 */         throw new RemoteException("Session no longer exists: " + id);
/*     */     }
/*     */     finally
/*     */     {
/* 381 */       lock.releaseSync();
/* 382 */       getLockManager().removeLockRef(id);
/*     */     }
/*     */ 
/* 386 */     return (EJBObject)ci.getStatefulSessionEJBObject(id);
/*     */   }
/*     */ 
/*     */   public void removeHome(Invocation mi)
/*     */     throws RemoteException, RemoveException
/*     */   {
/* 402 */     throw new Error("Not Yet Implemented");
/*     */   }
/*     */ 
/*     */   protected void setupHomeMapping()
/*     */     throws Exception
/*     */   {
/* 410 */     boolean isEJB1x = this.metaData.getApplicationMetaData().isEJB1x();
/*     */ 
/* 412 */     Map map = new HashMap();
/*     */ 
/* 414 */     if (this.homeInterface != null)
/*     */     {
/* 417 */       Method[] m = this.homeInterface.getMethods();
/* 418 */       for (int i = 0; i < m.length; i++)
/*     */       {
/*     */         try
/*     */         {
/* 423 */           if ((!isEJB1x) && (m[i].getName().startsWith("create")))
/*     */           {
/* 425 */             map.put(m[i], getClass().getMethod("createHome", new Class[] { Invocation.class }));
/*     */           }
/*     */           else
/*     */           {
/* 430 */             map.put(m[i], getClass().getMethod(m[i].getName() + "Home", new Class[] { Invocation.class }));
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 436 */           this.log.info(m[i].getName() + " in bean has not been mapped");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 441 */     if (this.localHomeInterface != null)
/*     */     {
/* 443 */       Method[] m = this.localHomeInterface.getMethods();
/* 444 */       for (int i = 0; i < m.length; i++)
/*     */       {
/*     */         try
/*     */         {
/* 449 */           if ((!isEJB1x) && (m[i].getName().startsWith("create")))
/*     */           {
/* 451 */             map.put(m[i], getClass().getMethod("createLocalHome", new Class[] { Invocation.class }));
/*     */           }
/*     */           else
/*     */           {
/* 456 */             map.put(m[i], getClass().getMethod(m[i].getName() + "LocalHome", new Class[] { Invocation.class }));
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 462 */           this.log.info(m[i].getName() + " in bean has not been mapped");
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 470 */       Class handleClass = Class.forName("javax.ejb.Handle");
/*     */ 
/* 473 */       Method getEJBObjectMethod = handleClass.getMethod("getEJBObject", new Class[0]);
/*     */ 
/* 476 */       map.put(getEJBObjectMethod, getClass().getMethod("getEJBObject", new Class[] { Invocation.class }));
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 481 */       this.log.debug("Couldn't find getEJBObject method on container");
/*     */     }
/*     */ 
/* 484 */     this.homeMapping = map;
/*     */   }
/*     */ 
/*     */   protected Interceptor createContainerInterceptor()
/*     */   {
/* 489 */     return new ContainerInterceptor();
/*     */   }
/*     */ 
/*     */   class ContainerInterceptor extends Container.AbstractContainerInterceptor
/*     */   {
/*     */     ContainerInterceptor() {
/* 495 */       super();
/*     */     }
/*     */ 
/*     */     public Object invokeHome(Invocation mi) throws Exception
/*     */     {
/* 500 */       boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 502 */       if (trace)
/*     */       {
/* 504 */         this.log.trace("HOMEMETHOD coming in ");
/* 505 */         this.log.trace("" + mi.getMethod());
/* 506 */         this.log.trace("HOMEMETHOD coming in hashcode" + mi.getMethod().hashCode());
/* 507 */         this.log.trace("HOMEMETHOD coming in classloader" + mi.getMethod().getDeclaringClass().getClassLoader().hashCode());
/* 508 */         this.log.trace("CONTAINS " + StatefulSessionContainer.this.getHomeMapping().containsKey(mi.getMethod()));
/*     */       }
/*     */ 
/* 511 */       Method miMethod = mi.getMethod();
/* 512 */       Method m = (Method)StatefulSessionContainer.this.getHomeMapping().get(miMethod);
/* 513 */       if (m == null)
/*     */       {
/* 515 */         String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
/*     */ 
/* 517 */         throw new EJBException(msg);
/*     */       }
/*     */ 
/* 521 */       if (trace)
/*     */       {
/* 523 */         this.log.trace("HOMEMETHOD m " + m);
/* 524 */         Iterator iterator = StatefulSessionContainer.this.getHomeMapping().keySet().iterator();
/* 525 */         while (iterator.hasNext())
/*     */         {
/* 527 */           Method me = (Method)iterator.next();
/*     */ 
/* 529 */           if (me.getName().endsWith("create"))
/*     */           {
/* 531 */             this.log.trace(me.toString());
/* 532 */             this.log.trace("" + me.hashCode());
/* 533 */             this.log.trace("" + me.getDeclaringClass().getClassLoader().hashCode());
/* 534 */             this.log.trace("equals " + me.equals(mi.getMethod()) + " " + mi.getMethod().equals(me));
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 541 */         return mi.performCall(StatefulSessionContainer.this, m, new Object[] { mi });
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 545 */         rethrow(e);
/*     */       }
/*     */ 
/* 549 */       throw new UnreachableStatementException();
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation mi)
/*     */       throws Exception
/*     */     {
/* 555 */       Method miMethod = mi.getMethod();
/* 556 */       Method m = (Method)StatefulSessionContainer.this.getBeanMapping().get(miMethod);
/* 557 */       if (m == null)
/*     */       {
/* 559 */         String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
/*     */ 
/* 561 */         throw new EJBException(msg);
/*     */       }
/*     */ 
/* 566 */       EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
/* 567 */       if (ctx.getTransaction() == null)
/* 568 */         ctx.setTransaction(mi.getTransaction());
/* 569 */       else if ((StatefulSessionContainer.this.ejbObjectRemove.equals(miMethod)) || (StatefulSessionContainer.this.ejbLocalObjectRemove.equals(miMethod)))
/*     */       {
/* 571 */         throw new RemoveException("An attempt to remove a session object while the object is in a transaction (EJB2.1, 7.6.4 Restrictions for Transactions): ejb-name=" + StatefulSessionContainer.this.metaData.getEjbName() + ", method=" + mi.getMethod() + ", tx=" + ctx.getTransaction());
/*     */       }
/*     */ 
/* 578 */       if ((m.getDeclaringClass().equals(StatefulSessionContainer.class)) || (m.getDeclaringClass().equals(SessionContainer.class)))
/*     */       {
/*     */         try
/*     */         {
/* 584 */           return mi.performCall(StatefulSessionContainer.this, m, new Object[] { mi });
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 588 */           rethrow(e);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 596 */           Object bean = ctx.getInstance();
/* 597 */           return mi.performCall(bean, m, mi.getArguments());
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 601 */           rethrow(e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 606 */       throw new UnreachableStatementException();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.StatefulSessionContainer
 * JD-Core Version:    0.6.0
 */