/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.mx.util.MBeanProxy;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static Object getMBeanProxy(Class iface, ObjectName name, MBeanServer server)
/*     */     throws Exception
/*     */   {
/*     */     Object proxy;
/*     */     Object proxy;
/* 129 */     if (System.getSecurityManager() == null)
/*     */     {
/* 131 */       proxy = MBeanProxy.get(iface, name, server);
/*     */     }
/*     */     else
/*     */     {
/* 135 */       MBeanProxyAction action = new MBeanProxyAction(iface, name, server);
/* 136 */       proxy = AccessController.doPrivileged(action);
/*     */     }
/* 138 */     return proxy;
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader() {
/* 142 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader();
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader(Thread thread)
/*     */   {
/* 147 */     return SecurityActions.TCLAction.UTIL.getContextClassLoader(thread);
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(ClassLoader loader)
/*     */   {
/* 152 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(loader);
/*     */   }
/*     */ 
/*     */   static void setContextClassLoader(Thread thread, ClassLoader loader)
/*     */   {
/* 157 */     SecurityActions.TCLAction.UTIL.setContextClassLoader(thread, loader);
/*     */   }
/*     */ 
/*     */   static String setContextID(String contextID)
/*     */   {
/* 162 */     PrivilegedAction action = new SetContextID(contextID);
/* 163 */     String previousID = (String)AccessController.doPrivileged(action);
/* 164 */     return previousID;
/*     */   }
/*     */ 
/*     */   static Principal getCallerPrincipal(SecurityContext sc)
/*     */   {
/* 169 */     return SecurityActions.IdentityAction.UTIL.getIdentityAction().getCallerPrincipal(sc);
/*     */   }
/*     */ 
/*     */   static Subject getContextSubject()
/*     */     throws PolicyContextException
/*     */   {
/* 386 */     if (System.getSecurityManager() == null)
/*     */     {
/* 388 */       return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
/*     */     }
/*     */ 
/* 392 */     return PolicyContextActions.PRIVILEGED.getContextSubject();
/*     */   }
/*     */ 
/*     */   static abstract interface PolicyContextActions
/*     */   {
/*     */     public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
/* 343 */     public static final PolicyContextActions PRIVILEGED = new PolicyContextActions()
/*     */     {
/* 345 */       private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/* 349 */           return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */         }
/* 345 */       };
/*     */ 
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/*     */         Exception ex;
/*     */         try
/*     */         {
/* 357 */           return (Subject)AccessController.doPrivileged(this.exAction);
/*     */         }
/*     */         catch (PrivilegedActionException e)
/*     */         {
/* 361 */           ex = e.getException();
/* 362 */           if ((ex instanceof PolicyContextException))
/* 363 */             throw ((PolicyContextException)ex);
/*     */         }
/* 365 */         throw new UndeclaredThrowableException(ex);
/*     */       }
/* 343 */     };
/*     */ 
/* 370 */     public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions()
/*     */     {
/*     */       public Subject getContextSubject()
/*     */         throws PolicyContextException
/*     */       {
/* 375 */         return (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/*     */       }
/* 370 */     };
/*     */ 
/*     */     public abstract Subject getContextSubject()
/*     */       throws PolicyContextException;
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 252 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 256 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 261 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 266 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 271 */         thread.setContextClassLoader(cl);
/*     */       }
/* 252 */     };
/*     */ 
/* 275 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 277 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 281 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 277 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 287 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 292 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 296 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 303 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 308 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 309 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 317 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 322 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 323 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 275 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static SecurityActions.TCLAction getTCLAction()
/*     */       {
/* 228 */         return System.getSecurityManager() == null ? SecurityActions.TCLAction.NON_PRIVILEGED : SecurityActions.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 233 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 238 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 243 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 248 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface IdentityAction
/*     */   {
/* 181 */     public static final IdentityAction NON_PRIVILEGED = new IdentityAction()
/*     */     {
/*     */       public Principal getCallerPrincipal(SecurityContext securityContext)
/*     */       {
/* 185 */         Principal caller = null;
/*     */ 
/* 187 */         if (securityContext != null)
/*     */         {
/* 189 */           caller = securityContext.getIncomingRunAs();
/*     */ 
/* 191 */           if (caller == null)
/* 192 */             caller = securityContext.getUtil().getUserPrincipal();
/*     */         }
/* 194 */         return caller;
/*     */       }
/* 181 */     };
/*     */ 
/* 198 */     public static final IdentityAction PRIVILEGED = new IdentityAction()
/*     */     {
/*     */       public Principal getCallerPrincipal(SecurityContext securityContext)
/*     */       {
/* 202 */         return (Principal)AccessController.doPrivileged(new PrivilegedAction(securityContext)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 206 */             Principal caller = null;
/*     */ 
/* 208 */             if (this.val$securityContext != null)
/*     */             {
/* 210 */               caller = this.val$securityContext.getIncomingRunAs();
/*     */ 
/* 212 */               if (caller == null)
/* 213 */                 caller = this.val$securityContext.getUtil().getUserPrincipal();
/*     */             }
/* 215 */             return caller;
/*     */           }
/*     */         });
/*     */       }
/* 198 */     };
/*     */ 
/*     */     public abstract Principal getCallerPrincipal(SecurityContext paramSecurityContext);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static SecurityActions.IdentityAction getIdentityAction()
/*     */       {
/* 178 */         return System.getSecurityManager() == null ? SecurityActions.IdentityAction.NON_PRIVILEGED : SecurityActions.IdentityAction.PRIVILEGED;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class InvocationHandlerAction
/*     */     implements InvocationHandler, PrivilegedExceptionAction
/*     */   {
/*     */     private Method method;
/*     */     private Object[] args;
/*     */     private Object mbean;
/*     */ 
/*     */     private InvocationHandlerAction(Object mbean)
/*     */     {
/* 100 */       this.mbean = mbean;
/*     */     }
/*     */     public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
/* 105 */       this.method = method;
/* 106 */       this.args = args;
/*     */       Object value;
/*     */       try {
/* 110 */         value = AccessController.doPrivileged(this);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 114 */         throw e.getException();
/*     */       }
/* 116 */       return value;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception {
/* 120 */       Object value = this.method.invoke(this.mbean, this.args);
/* 121 */       return value;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class MBeanProxyAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     Class iface;
/*     */     ObjectName name;
/*     */     MBeanServer server;
/*     */ 
/*     */     MBeanProxyAction(Class iface, ObjectName name, MBeanServer server)
/*     */     {
/*  78 */       this.iface = iface;
/*  79 */       this.name = name;
/*  80 */       this.server = server;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception {
/*  84 */       Object proxy = MBeanProxy.get(this.iface, this.name, this.server);
/*  85 */       Class[] ifaces = { this.iface };
/*  86 */       InvocationHandler secureHandler = new SecurityActions.InvocationHandlerAction(proxy, null);
/*  87 */       Object secureProxy = Proxy.newProxyInstance(this.iface.getClassLoader(), ifaces, secureHandler);
/*  88 */       return secureProxy;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class SetContextID
/*     */     implements PrivilegedAction
/*     */   {
/*     */     String contextID;
/*     */ 
/*     */     SetContextID(String contextID)
/*     */     {
/*  56 */       this.contextID = contextID;
/*     */     }
/*     */ 
/*     */     public Object run() {
/*  60 */       String previousID = PolicyContext.getContextID();
/*  61 */       PolicyContext.setContextID(this.contextID);
/*  62 */       return previousID;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.SecurityActions
 * JD-Core Version:    0.6.0
 */