/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import javax.ejb.ActivationConfigProperty;
/*     */ import javax.ejb.MessageDriven;
/*     */ 
/*     */ public class MessageDrivenImpl
/*     */   implements MessageDriven
/*     */ {
/*  39 */   private String name = "";
/*  40 */   private String mn = "";
/*  41 */   private String desc = "";
/*  42 */   private Class listenerInterface = Object.class;
/*     */ 
/*  44 */   private HashMap<String, ActivationConfigProperty> activationConfigProperties = new HashMap();
/*     */ 
/*     */   public MessageDrivenImpl(String name, ActivationConfigProperty[] activationConfigProperties)
/*     */   {
/*  48 */     this.name = name;
/*  49 */     for (ActivationConfigProperty property : activationConfigProperties)
/*     */     {
/*  51 */       this.activationConfigProperties.put(property.propertyName(), property);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/*  57 */     return this.name;
/*     */   }
/*     */ 
/*     */   public ActivationConfigProperty[] activationConfig()
/*     */   {
/*  62 */     ActivationConfigProperty[] properties = new ActivationConfigProperty[this.activationConfigProperties.size()];
/*  63 */     this.activationConfigProperties.values().toArray(properties);
/*  64 */     return properties;
/*     */   }
/*     */ 
/*     */   public Class<? extends Annotation> annotationType()
/*     */   {
/*  69 */     return MessageDriven.class;
/*     */   }
/*     */   public String mappedName() {
/*  72 */     return this.mn; } 
/*  73 */   public void setMappedName(String mn) { this.mn = mn; } 
/*  74 */   public String description() { return this.desc; } 
/*  75 */   public void setDescription(String desc) { this.desc = desc; } 
/*  76 */   public Class messageListenerInterface() { return this.listenerInterface; } 
/*  77 */   public void setMessageListenerInterface(Class clazz) { this.listenerInterface = clazz; }
/*     */ 
/*     */   public void merge(MessageDriven annotation)
/*     */   {
/*  81 */     if (this.name.length() == 0) {
/*  82 */       this.name = annotation.name();
/*     */     }
/*  84 */     if (this.mn.length() == 0) {
/*  85 */       this.mn = annotation.mappedName();
/*     */     }
/*  87 */     if (this.desc.length() == 0) {
/*  88 */       this.desc = annotation.description();
/*     */     }
/*  90 */     if (this.listenerInterface == Object.class) {
/*  91 */       this.listenerInterface = annotation.messageListenerInterface();
/*     */     }
/*  93 */     for (ActivationConfigProperty property : annotation.activationConfig())
/*     */     {
/*  95 */       if (this.activationConfigProperties.containsKey(property.propertyName()))
/*     */         continue;
/*  97 */       this.activationConfigProperties.put(property.propertyName(), property);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 105 */     return super.toString() + "{name=" + this.name + ",description=" + this.desc + ",mappedName=" + this.mn + ",messageListenerInterface=" + this.listenerInterface + "}";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.MessageDrivenImpl
 * JD-Core Version:    0.6.0
 */