/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.HomeHandle;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.MessageDrivenMetaData;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public class MessageDrivenContainer extends Container
/*     */   implements EJBProxyFactoryContainer, InstancePoolContainer, MessageDrivenContainerMBean
/*     */ {
/*     */   protected Map beanMapping;
/*     */   protected InstancePool instancePool;
/*     */   protected Interceptor interceptor;
/*     */   protected long messageCount;
/*     */ 
/*     */   public LocalProxyFactory getLocalProxyFactory()
/*     */   {
/*  81 */     return this.localProxyFactory;
/*     */   }
/*     */ 
/*     */   public void setInstancePool(InstancePool instancePool)
/*     */   {
/*  86 */     if (instancePool == null) {
/*  87 */       throw new NullArgumentException("instancePool");
/*     */     }
/*  89 */     this.instancePool = instancePool;
/*  90 */     this.instancePool.setContainer(this);
/*     */   }
/*     */ 
/*     */   public InstancePool getInstancePool()
/*     */   {
/*  95 */     return this.instancePool;
/*     */   }
/*     */ 
/*     */   public void addInterceptor(Interceptor in)
/*     */   {
/* 100 */     if (this.interceptor == null)
/*     */     {
/* 102 */       this.interceptor = in;
/*     */     }
/*     */     else
/*     */     {
/* 106 */       Interceptor current = this.interceptor;
/*     */ 
/* 108 */       while (current.getNext() != null)
/*     */       {
/* 110 */         current = current.getNext();
/*     */       }
/*     */ 
/* 113 */       current.setNext(in);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Interceptor getInterceptor()
/*     */   {
/* 119 */     return this.interceptor;
/*     */   }
/*     */ 
/*     */   public long getMessageCount()
/*     */   {
/* 128 */     return this.messageCount;
/*     */   }
/*     */ 
/*     */   public Class getHomeClass()
/*     */   {
/* 138 */     return null;
/*     */   }
/*     */ 
/*     */   public Class getRemoteClass()
/*     */   {
/* 144 */     return null;
/*     */   }
/*     */ 
/*     */   public Class getLocalClass()
/*     */   {
/* 149 */     return null;
/*     */   }
/*     */ 
/*     */   public Class getLocalHomeClass()
/*     */   {
/* 155 */     return null;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 163 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 164 */     SecurityActions.setContextClassLoader(getClassLoader());
/* 165 */     pushENC();
/*     */     try
/*     */     {
/* 169 */       super.createService();
/*     */ 
/* 172 */       Map map = new HashMap();
/* 173 */       MessageDrivenMetaData mdMetaData = (MessageDrivenMetaData)this.metaData;
/* 174 */       String type = mdMetaData.getMessagingType();
/* 175 */       if ((type == null) || (type.length() == 0))
/* 176 */         type = "javax.jms.MessageListener";
/* 177 */       Class clazz = getClassLoader().loadClass(type);
/* 178 */       Method[] methods = clazz.getDeclaredMethods();
/* 179 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 181 */         Method m = methods[i];
/* 182 */         map.put(m, this.beanClass.getMethod(m.getName(), m.getParameterTypes()));
/* 183 */         this.log.debug("Mapped " + m.getName() + " " + m.hashCode() + " to " + map.get(m));
/*     */       }
/* 185 */       if (TimedObject.class.isAssignableFrom(this.beanClass))
/*     */       {
/* 187 */         map.put(TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class }), this.beanClass.getMethod("ejbTimeout", new Class[] { Timer.class }));
/*     */       }
/*     */ 
/* 192 */       this.beanMapping = map;
/*     */       try
/*     */       {
/* 197 */         ObjectName containerName = super.getJmxName();
/* 198 */         Hashtable props = containerName.getKeyPropertyList();
/* 199 */         props.put("plugin", "pool");
/* 200 */         ObjectName poolName = new ObjectName(containerName.getDomain(), props);
/* 201 */         this.server.registerMBean(this.instancePool, poolName);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 205 */         this.log.debug("Failed to register pool as mbean", t);
/*     */       }
/*     */ 
/* 208 */       this.instancePool.create();
/*     */ 
/* 210 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*     */       {
/* 212 */         String invokerBinding = (String)it.next();
/* 213 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/*     */         try
/*     */         {
/* 217 */           ObjectName containerName = super.getJmxName();
/* 218 */           Hashtable props = containerName.getKeyPropertyList();
/* 219 */           props.put("plugin", "invoker");
/* 220 */           props.put("binding", invokerBinding);
/* 221 */           ObjectName invokerName = new ObjectName(containerName.getDomain(), props);
/* 222 */           this.server.registerMBean(ci, invokerName);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 226 */           this.log.debug("Failed to register invoker binding as mbean", t);
/*     */         }
/* 228 */         ci.create();
/*     */       }
/*     */ 
/* 232 */       Interceptor in = this.interceptor;
/* 233 */       while (in != null)
/*     */       {
/* 235 */         in.setContainer(this);
/* 236 */         in.create();
/* 237 */         in = in.getNext();
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 243 */       popENC();
/*     */ 
/* 245 */       SecurityActions.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 252 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 253 */     SecurityActions.setContextClassLoader(getClassLoader());
/* 254 */     pushENC();
/*     */     try
/*     */     {
/* 258 */       super.startService();
/*     */ 
/* 261 */       this.instancePool.start();
/*     */ 
/* 264 */       Interceptor in = this.interceptor;
/* 265 */       while (in != null)
/*     */       {
/* 267 */         in.start();
/* 268 */         in = in.getNext();
/*     */       }
/*     */ 
/* 272 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*     */       {
/* 274 */         String invokerBinding = (String)it.next();
/* 275 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 276 */         ci.start();
/*     */       }
/*     */ 
/* 280 */       restoreTimers();
/*     */     }
/*     */     finally
/*     */     {
/* 284 */       popENC();
/*     */ 
/* 286 */       SecurityActions.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 293 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 294 */     SecurityActions.setContextClassLoader(getClassLoader());
/* 295 */     pushENC();
/*     */     try
/*     */     {
/* 299 */       super.stopService();
/*     */ 
/* 302 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*     */       {
/* 304 */         String invokerBinding = (String)it.next();
/* 305 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 306 */         ci.stop();
/*     */       }
/*     */ 
/* 310 */       this.instancePool.stop();
/*     */ 
/* 313 */       Interceptor in = this.interceptor;
/* 314 */       while (in != null)
/*     */       {
/* 316 */         in.stop();
/* 317 */         in = in.getNext();
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 322 */       popENC();
/*     */ 
/* 324 */       SecurityActions.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 331 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 332 */     SecurityActions.setContextClassLoader(getClassLoader());
/* 333 */     pushENC();
/*     */     try
/*     */     {
/* 337 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*     */       {
/* 339 */         String invokerBinding = (String)it.next();
/* 340 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 341 */         ci.destroy();
/* 342 */         ci.setContainer(null);
/*     */         try
/*     */         {
/* 345 */           ObjectName containerName = super.getJmxName();
/* 346 */           Hashtable props = containerName.getKeyPropertyList();
/* 347 */           props.put("plugin", "invoker");
/* 348 */           props.put("binding", invokerBinding);
/* 349 */           ObjectName invokerName = new ObjectName(containerName.getDomain(), props);
/* 350 */           this.server.unregisterMBean(invokerName);
/*     */         }
/*     */         catch (Throwable ignore)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 358 */       this.instancePool.destroy();
/* 359 */       this.instancePool.setContainer(null);
/*     */       try
/*     */       {
/* 362 */         ObjectName containerName = super.getJmxName();
/* 363 */         Hashtable props = containerName.getKeyPropertyList();
/* 364 */         props.put("plugin", "pool");
/* 365 */         ObjectName poolName = new ObjectName(containerName.getDomain(), props);
/* 366 */         this.server.unregisterMBean(poolName);
/*     */       }
/*     */       catch (Throwable ignore)
/*     */       {
/*     */       }
/*     */ 
/* 373 */       Interceptor in = this.interceptor;
/* 374 */       while (in != null)
/*     */       {
/* 376 */         in.destroy();
/* 377 */         in.setContainer(null);
/* 378 */         in = in.getNext();
/*     */       }
/*     */ 
/* 382 */       super.destroyService();
/*     */     }
/*     */     finally
/*     */     {
/* 386 */       popENC();
/*     */ 
/* 388 */       SecurityActions.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object internalInvokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 398 */     throw new Error("invokeHome not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public Object internalInvoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 409 */     return getInterceptor().invoke(mi);
/*     */   }
/*     */ 
/*     */   public EJBObject createHome()
/*     */     throws RemoteException, CreateException
/*     */   {
/* 418 */     throw new Error("createHome not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public void removeHome(Handle handle)
/*     */     throws RemoteException, RemoveException
/*     */   {
/* 425 */     throw new Error("removeHome not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public void removeHome(Object primaryKey)
/*     */     throws RemoteException, RemoveException
/*     */   {
/* 432 */     throw new Error("removeHome not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public EJBMetaData getEJBMetaDataHome()
/*     */     throws RemoteException
/*     */   {
/* 441 */     throw new Error("getEJBMetaDataHome not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   public HomeHandle getHomeHandleHome()
/*     */     throws RemoteException
/*     */   {
/* 449 */     throw new Error("getHomeHandleHome not valid for MessageDriven beans");
/*     */   }
/*     */ 
/*     */   Interceptor createContainerInterceptor()
/*     */   {
/* 454 */     return new ContainerInterceptor();
/*     */   }
/*     */ 
/*     */   class ContainerInterceptor extends Container.AbstractContainerInterceptor
/*     */   {
/*     */     ContainerInterceptor() {
/* 460 */       super();
/*     */     }
/*     */ 
/*     */     public Object invokeHome(Invocation mi)
/*     */       throws Exception
/*     */     {
/* 468 */       throw new Error("invokeHome not valid for MessageDriven beans");
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation mi)
/*     */       throws Exception
/*     */     {
/* 479 */       EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
/*     */ 
/* 483 */       if (ctx.getTransaction() == null)
/*     */       {
/* 485 */         ctx.setTransaction(mi.getTransaction());
/*     */       }
/*     */ 
/* 489 */       Method m = (Method)MessageDrivenContainer.this.beanMapping.get(mi.getMethod());
/* 490 */       if (m == null)
/*     */       {
/* 493 */         String msg = MessageDrivenContainer.this.getBeanMetaData().getEjbName() + " Invalid invocation, check your deployment packaging, interfaces, method=" + mi.getMethod();
/*     */ 
/* 495 */         throw new EJBException(msg);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 501 */         MessageDrivenContainer.this.messageCount += 1L;
/* 502 */         return mi.performCall(ctx.getInstance(), m, mi.getArguments());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 506 */         rethrow(e);
/*     */       }
/*     */ 
/* 510 */       throw new UnreachableStatementException();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.MessageDrivenContainer
 * JD-Core Version:    0.6.0
 */