/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.Identity;
/*     */ import java.security.Principal;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import java.util.Stack;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.SecurityRoleRefMetaData;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityRoleRef;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.security.integration.ejb.EJBAuthorizationHelper;
/*     */ import org.jboss.tm.TransactionTimeoutConfiguration;
/*     */ import org.jboss.tm.usertx.client.ServerVMClientUserTransaction.UserTransactionStartedListener;
/*     */ 
/*     */ public abstract class EnterpriseContext
/*     */   implements AllowedOperationsFlags
/*     */ {
/*  92 */   protected static Logger log = Logger.getLogger(EnterpriseContext.class);
/*     */   Object instance;
/*     */   Container con;
/*     */   Synchronization synch;
/*     */   Transaction transaction;
/*     */   private Principal principal;
/*     */   private Principal beanPrincipal;
/*     */   private SecurityContext securityContext;
/*     */   Object id;
/* 122 */   int locked = 0;
/*     */ 
/* 125 */   Object txLock = new Object();
/*     */ 
/* 132 */   private Stack inMethodStack = new Stack();
/*     */   private static ServerVMClientUserTransaction.UserTransactionStartedListener tsl;
/*     */ 
/*     */   public static void setUserTransactionStartedListener(ServerVMClientUserTransaction.UserTransactionStartedListener newTsl)
/*     */   {
/* 149 */     tsl = newTsl;
/*     */   }
/*     */ 
/*     */   public EnterpriseContext(Object instance, Container con)
/*     */   {
/* 156 */     this.instance = instance;
/* 157 */     this.con = con;
/*     */   }
/*     */ 
/*     */   public Object getInstance()
/*     */   {
/* 164 */     return this.instance;
/*     */   }
/*     */ 
/*     */   public Container getContainer()
/*     */   {
/* 172 */     return this.con;
/*     */   }
/*     */ 
/*     */   public abstract void discard()
/*     */     throws RemoteException;
/*     */ 
/*     */   public abstract EJBContext getEJBContext();
/*     */ 
/*     */   public void setId(Object id)
/*     */   {
/* 185 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public Object getId()
/*     */   {
/* 190 */     return this.id;
/*     */   }
/*     */ 
/*     */   public Object getTxLock()
/*     */   {
/* 195 */     return this.txLock;
/*     */   }
/*     */ 
/*     */   public void setTransaction(Transaction transaction)
/*     */   {
/* 201 */     this.transaction = transaction;
/*     */   }
/*     */ 
/*     */   public Transaction getTransaction()
/*     */   {
/* 206 */     return this.transaction;
/*     */   }
/*     */ 
/*     */   public void setPrincipal(Principal principal)
/*     */   {
/* 211 */     this.principal = principal;
/*     */ 
/* 215 */     this.beanPrincipal = null;
/* 216 */     if (this.con.getSecurityManager() != null)
/* 217 */       this.beanPrincipal = getCallerPrincipal();
/*     */   }
/*     */ 
/*     */   public void setSecurityContext(SecurityContext securityContext)
/*     */   {
/* 222 */     this.securityContext = securityContext;
/*     */   }
/*     */ 
/*     */   public void lock()
/*     */   {
/* 227 */     this.locked += 1;
/*     */   }
/*     */ 
/*     */   public void unlock()
/*     */   {
/* 236 */     this.locked -= 1;
/*     */ 
/* 239 */     if (this.locked < 0)
/*     */     {
/* 242 */       log.error("locked < 0", new Throwable());
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isLocked()
/*     */   {
/* 252 */     return this.locked != 0;
/*     */   }
/*     */ 
/*     */   public Principal getCallerPrincipal()
/*     */   {
/* 257 */     EJBContextImpl ctxImpl = (EJBContextImpl)getEJBContext();
/* 258 */     return ctxImpl.getCallerPrincipalInternal();
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 267 */     this.id = null;
/* 268 */     this.locked = 0;
/* 269 */     this.principal = null;
/* 270 */     this.beanPrincipal = null;
/* 271 */     this.synch = null;
/* 272 */     this.transaction = null;
/* 273 */     this.inMethodStack.clear();
/*     */   }
/*     */ 
/*     */   protected boolean isContainerManagedTx()
/*     */   {
/* 282 */     BeanMetaData md = this.con.getBeanMetaData();
/* 283 */     return md.isContainerManagedTx();
/*     */   }
/*     */ 
/*     */   protected boolean isUserManagedTx()
/*     */   {
/* 288 */     BeanMetaData md = this.con.getBeanMetaData();
/* 289 */     return !md.isContainerManagedTx();
/*     */   }
/*     */ 
/*     */   protected class UserTransactionImpl
/*     */     implements UserTransaction
/*     */   {
/* 557 */     private int timeout = 0;
/*     */     boolean trace;
/*     */ 
/*     */     public UserTransactionImpl()
/*     */     {
/* 564 */       this.trace = EnterpriseContext.log.isTraceEnabled();
/* 565 */       if (this.trace)
/* 566 */         EnterpriseContext.log.trace("new UserTx: " + this);
/*     */     }
/*     */ 
/*     */     public void begin()
/*     */       throws NotSupportedException, SystemException
/*     */     {
/* 572 */       TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
/*     */ 
/* 574 */       int oldTimeout = -1;
/* 575 */       if ((tm instanceof TransactionTimeoutConfiguration)) {
/* 576 */         oldTimeout = ((TransactionTimeoutConfiguration)tm).getTransactionTimeout();
/*     */       }
/*     */ 
/* 579 */       tm.setTransactionTimeout(this.timeout);
/*     */       try
/*     */       {
/* 584 */         tm.begin();
/*     */ 
/* 587 */         if (EnterpriseContext.tsl != null) {
/* 588 */           EnterpriseContext.tsl.userTransactionStarted();
/*     */         }
/* 590 */         Transaction tx = tm.getTransaction();
/* 591 */         if (this.trace) {
/* 592 */           EnterpriseContext.log.trace("UserTx begin: " + tx);
/*     */         }
/*     */ 
/* 595 */         EnterpriseContext.this.setTransaction(tx);
/*     */ 
/* 600 */         if (oldTimeout != -1)
/* 601 */           tm.setTransactionTimeout(oldTimeout);
/*     */       }
/*     */       finally
/*     */       {
/* 600 */         if (oldTimeout != -1)
/* 601 */           tm.setTransactionTimeout(oldTimeout);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void commit()
/*     */       throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */     {
/* 609 */       TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
/*     */       try
/*     */       {
/* 612 */         Transaction tx = tm.getTransaction();
/* 613 */         if (this.trace) {
/* 614 */           EnterpriseContext.log.trace("UserTx commit: " + tx);
/*     */         }
/* 616 */         int status = tm.getStatus();
/* 617 */         tm.commit();
/*     */       }
/*     */       finally
/*     */       {
/* 626 */         EnterpriseContext.this.setTransaction(null);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void rollback()
/*     */       throws IllegalStateException, SecurityException, SystemException
/*     */     {
/* 633 */       TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
/*     */       try
/*     */       {
/* 636 */         Transaction tx = tm.getTransaction();
/* 637 */         if (this.trace)
/* 638 */           EnterpriseContext.log.trace("UserTx rollback: " + tx);
/* 639 */         tm.rollback();
/*     */       }
/*     */       finally
/*     */       {
/* 648 */         EnterpriseContext.this.setTransaction(null);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void setRollbackOnly()
/*     */       throws IllegalStateException, SystemException
/*     */     {
/* 655 */       TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
/* 656 */       Transaction tx = tm.getTransaction();
/* 657 */       if (this.trace) {
/* 658 */         EnterpriseContext.log.trace("UserTx setRollbackOnly: " + tx);
/*     */       }
/* 660 */       tm.setRollbackOnly();
/*     */     }
/*     */ 
/*     */     public int getStatus()
/*     */       throws SystemException
/*     */     {
/* 666 */       TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
/* 667 */       return tm.getStatus();
/*     */     }
/*     */ 
/*     */     public void setTransactionTimeout(int seconds)
/*     */       throws SystemException
/*     */     {
/* 677 */       this.timeout = seconds;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class EJBContextImpl
/*     */     implements EJBContext
/*     */   {
/* 302 */     private EnterpriseContext.UserTransactionImpl userTransaction = null;
/*     */     private InitialContext ctx;
/*     */ 
/*     */     private InitialContext getContext()
/*     */     {
/* 309 */       if (this.ctx == null)
/*     */       {
/*     */         try
/*     */         {
/* 313 */           this.ctx = new InitialContext();
/*     */         }
/*     */         catch (NamingException e)
/*     */         {
/* 317 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/*     */ 
/* 321 */       return this.ctx;
/*     */     }
/*     */ 
/*     */     protected EJBContextImpl()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object lookup(String name)
/*     */     {
/*     */       try
/*     */       {
/* 332 */         return getContext().lookup(name);
/*     */       }
/*     */       catch (NamingException ignored)
/*     */       {
/*     */       }
/* 337 */       return null;
/*     */     }
/*     */ 
/*     */     /** @deprecated */
/*     */     public Identity getCallerIdentity()
/*     */     {
/* 345 */       throw new EJBException("Deprecated");
/*     */     }
/*     */ 
/*     */     public TimerService getTimerService() throws IllegalStateException
/*     */     {
/* 350 */       return EnterpriseContext.this.getContainer().getTimerService(null);
/*     */     }
/*     */ 
/*     */     public Principal getCallerPrincipal()
/*     */     {
/* 359 */       return getCallerPrincipalInternal();
/*     */     }
/*     */ 
/*     */     Principal getCallerPrincipalInternal()
/*     */     {
/* 368 */       if (EnterpriseContext.this.beanPrincipal == null)
/*     */       {
/* 370 */         RealmMapping rm = EnterpriseContext.this.con.getRealmMapping();
/* 371 */         EJBAuthorizationHelper helper = new EJBAuthorizationHelper(EnterpriseContext.this.securityContext);
/* 372 */         Principal caller = helper.getCallerPrincipal(rm);
/* 373 */         if (caller == null)
/*     */         {
/* 379 */           if (EnterpriseContext.this.principal != null)
/*     */           {
/* 381 */             if (rm != null)
/* 382 */               caller = rm.getPrincipal(EnterpriseContext.this.principal);
/*     */             else {
/* 384 */               caller = EnterpriseContext.this.principal;
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 389 */             ApplicationMetaData appMetaData = EnterpriseContext.this.con.getBeanMetaData().getApplicationMetaData();
/* 390 */             String name = appMetaData.getUnauthenticatedPrincipal();
/* 391 */             if (name != null) {
/* 392 */               caller = new SimplePrincipal(name);
/*     */             }
/*     */           }
/*     */         }
/* 396 */         if (caller == null)
/*     */         {
/* 398 */           throw new IllegalStateException("No valid security context for the caller identity");
/*     */         }
/*     */ 
/* 403 */         EnterpriseContext.access$002(EnterpriseContext.this, caller);
/*     */       }
/* 405 */       return EnterpriseContext.this.beanPrincipal;
/*     */     }
/*     */ 
/*     */     public EJBHome getEJBHome()
/*     */     {
/* 410 */       EJBProxyFactory proxyFactory = EnterpriseContext.this.con.getProxyFactory();
/* 411 */       if (proxyFactory == null) {
/* 412 */         throw new IllegalStateException("No remote home defined.");
/*     */       }
/* 414 */       return (EJBHome)proxyFactory.getEJBHome();
/*     */     }
/*     */ 
/*     */     public EJBLocalHome getEJBLocalHome()
/*     */     {
/* 419 */       if (EnterpriseContext.this.con.getLocalHomeClass() == null) {
/* 420 */         throw new IllegalStateException("No local home defined.");
/*     */       }
/* 422 */       if ((EnterpriseContext.this.con instanceof EntityContainer))
/* 423 */         return ((EntityContainer)EnterpriseContext.this.con).getLocalProxyFactory().getEJBLocalHome();
/* 424 */       if ((EnterpriseContext.this.con instanceof StatelessSessionContainer))
/* 425 */         return ((StatelessSessionContainer)EnterpriseContext.this.con).getLocalProxyFactory().getEJBLocalHome();
/* 426 */       if ((EnterpriseContext.this.con instanceof StatefulSessionContainer)) {
/* 427 */         return ((StatefulSessionContainer)EnterpriseContext.this.con).getLocalProxyFactory().getEJBLocalHome();
/*     */       }
/*     */ 
/* 430 */       throw new EJBException("No EJBLocalHome available (BUG!)");
/*     */     }
/*     */ 
/*     */     /** @deprecated */
/*     */     public Properties getEnvironment()
/*     */     {
/* 438 */       throw new EJBException("Deprecated");
/*     */     }
/*     */ 
/*     */     public boolean getRollbackOnly()
/*     */     {
/* 444 */       if (EnterpriseContext.this.con.getBeanMetaData().isBeanManagedTx()) {
/* 445 */         throw new IllegalStateException("getRollbackOnly() not allowed for BMT beans.");
/*     */       }
/*     */       try
/*     */       {
/* 449 */         TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
/*     */ 
/* 453 */         if (tm.getTransaction() == null) {
/* 454 */           throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
/*     */         }
/*     */ 
/* 457 */         int status = tm.getStatus();
/* 458 */         return (status == 1) || (status == 9) || (status == 4);
/*     */       }
/*     */       catch (SystemException e)
/*     */       {
/* 464 */         EnterpriseContext.log.warn("failed to get tx manager status; ignoring", e);
/* 465 */       }return true;
/*     */     }
/*     */ 
/*     */     public void setRollbackOnly()
/*     */     {
/* 472 */       if (EnterpriseContext.this.con.getBeanMetaData().isBeanManagedTx()) {
/* 473 */         throw new IllegalStateException("setRollbackOnly() not allowed for BMT beans.");
/*     */       }
/*     */       try
/*     */       {
/* 477 */         TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
/*     */ 
/* 481 */         if (tm.getTransaction() == null) {
/* 482 */           throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
/*     */         }
/* 484 */         tm.setRollbackOnly();
/*     */       }
/*     */       catch (SystemException e)
/*     */       {
/* 488 */         EnterpriseContext.log.warn("failed to set rollback only; ignoring", e);
/*     */       }
/*     */     }
/*     */ 
/*     */     /** @deprecated */
/*     */     public boolean isCallerInRole(Identity id)
/*     */     {
/* 497 */       throw new EJBException("Deprecated");
/*     */     }
/*     */ 
/*     */     public boolean isCallerInRole(String roleName)
/*     */     {
/* 508 */       Iterator it = EnterpriseContext.this.getContainer().getBeanMetaData().getSecurityRoleReferences();
/* 509 */       Set securityRoleRefs = new HashSet();
/* 510 */       while (it.hasNext())
/*     */       {
/* 512 */         SecurityRoleRefMetaData meta = (SecurityRoleRefMetaData)it.next();
/* 513 */         securityRoleRefs.add(new SecurityRoleRef(meta.getName(), meta.getLink(), meta.getDescription()));
/*     */       }
/*     */ 
/* 516 */       Subject contextSubject = null;
/*     */       try
/*     */       {
/* 519 */         contextSubject = SecurityActions.getContextSubject();
/* 520 */         if (contextSubject == null)
/* 521 */           EnterpriseContext.log.error("Subject is null for isCallerInRole Check with role=" + roleName);
/*     */       }
/*     */       catch (PolicyContextException pe)
/*     */       {
/* 525 */         if (EnterpriseContext.log.isTraceEnabled()) {
/* 526 */           EnterpriseContext.log.trace("PolicyContextException in getting caller subject:", pe);
/*     */         }
/*     */       }
/* 529 */       EJBAuthorizationHelper helper = new EJBAuthorizationHelper(EnterpriseContext.this.securityContext);
/* 530 */       String ejbName = EnterpriseContext.this.getContainer().getBeanMetaData().getEjbName();
/* 531 */       return helper.isCallerInRole(roleName, ejbName, EnterpriseContext.this.principal, securityRoleRefs);
/*     */     }
/*     */ 
/*     */     public UserTransaction getUserTransaction()
/*     */     {
/* 536 */       if (this.userTransaction == null)
/*     */       {
/* 538 */         if (EnterpriseContext.this.isContainerManagedTx())
/*     */         {
/* 540 */           throw new IllegalStateException("CMT beans are not allowed to get a UserTransaction");
/*     */         }
/*     */ 
/* 544 */         this.userTransaction = new EnterpriseContext.UserTransactionImpl(EnterpriseContext.this);
/*     */       }
/*     */ 
/* 547 */       return this.userTransaction;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.EnterpriseContext
 * JD-Core Version:    0.6.0
 */