/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public final class EjbUtil50
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(EjbUtil50.class);
/*     */ 
/*     */   public static String findEjbLink(MainDeployerStructure server, DeploymentUnit unit, String link)
/*     */   {
/*  67 */     return resolveLink(server, unit, link, false);
/*     */   }
/*     */ 
/*     */   public static String findLocalEjbLink(MainDeployerStructure server, DeploymentUnit unit, String link)
/*     */   {
/*  83 */     return resolveLink(server, unit, link, true);
/*     */   }
/*     */ 
/*     */   public static MessageDestinationMetaData findMessageDestination(MainDeployerStructure server, DeploymentUnit di, String link)
/*     */   {
/*  99 */     return resolveMessageDestination(server, di, link);
/*     */   }
/*     */ 
/*     */   private static String resolveLink(MainDeployerStructure server, DeploymentUnit di, String link, boolean isLocal)
/*     */   {
/* 104 */     if (link == null)
/*     */     {
/* 106 */       return null;
/*     */     }
/*     */ 
/* 109 */     if (log.isTraceEnabled())
/*     */     {
/* 111 */       log.trace("resolveLink( {" + di + "}, {" + link + "}, {" + isLocal + "}");
/*     */     }
/*     */ 
/* 114 */     if (di == null)
/*     */     {
/* 117 */       return null;
/*     */     }
/*     */ 
/* 120 */     if (link.indexOf('#') != -1)
/*     */     {
/* 123 */       return resolveRelativeLink(server, di, link, isLocal);
/*     */     }
/*     */ 
/* 128 */     DeploymentUnit top = di.getTopLevel();
/* 129 */     return resolveAbsoluteLink(top, link, isLocal);
/*     */   }
/*     */ 
/*     */   private static String resolveRelativeLink(MainDeployerStructure server, DeploymentUnit unit, String link, boolean isLocal)
/*     */   {
/* 136 */     String path = link.substring(0, link.indexOf('#'));
/* 137 */     String ejbName = link.substring(link.indexOf('#') + 1);
/* 138 */     String us = unit.getName();
/*     */ 
/* 141 */     if (us.charAt(us.length() - 1) == '/') {
/* 142 */       us = us.substring(0, us.length() - 1);
/*     */     }
/* 144 */     String ourPath = us.substring(0, us.lastIndexOf('/'));
/*     */ 
/* 146 */     if (log.isTraceEnabled())
/*     */     {
/* 148 */       log.trace("Resolving relative link: " + link);
/* 149 */       log.trace("Looking for: '" + link + "', we're located at: '" + ourPath + "'");
/*     */     }
/*     */ 
/* 152 */     for (StringTokenizer st = new StringTokenizer(path, "/"); st.hasMoreTokens(); )
/*     */     {
/* 154 */       String s = st.nextToken();
/* 155 */       if (s.equals(".."))
/*     */       {
/* 157 */         ourPath = ourPath.substring(0, ourPath.lastIndexOf('/'));
/*     */       }
/*     */       else
/*     */       {
/* 161 */         ourPath = ourPath + "/" + s;
/*     */       }
/*     */     }
/*     */ 
/* 165 */     URL target = null;
/*     */     try
/*     */     {
/* 169 */       target = Strings.toURL(ourPath);
/*     */     }
/*     */     catch (MalformedURLException mue)
/*     */     {
/* 173 */       log.warn("Can't construct URL for: " + ourPath);
/* 174 */       return null;
/*     */     }
/*     */ 
/* 177 */     DeploymentUnit targetUnit = null;
/*     */     try
/*     */     {
/* 180 */       DeploymentContext ctx = server.getDeploymentContext(target.toString());
/* 181 */       targetUnit = ctx.getDeploymentUnit();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 185 */       log.warn("Got Exception when looking for DeploymentUnit: " + e);
/* 186 */       return null;
/*     */     }
/*     */ 
/* 189 */     if (targetUnit == null)
/*     */     {
/* 191 */       log.warn("Can't locate DeploymentUnit for target: " + target);
/* 192 */       return null;
/*     */     }
/*     */ 
/* 195 */     if (log.isTraceEnabled())
/*     */     {
/* 197 */       log.trace("Found appropriate DeploymentUnit: " + targetUnit);
/*     */     }
/*     */ 
/* 200 */     String linkTarget = null;
/* 201 */     if (targetUnit.getAttachment(JBossMetaData.class) != null)
/*     */     {
/* 203 */       JBossMetaData appMD = (JBossMetaData)targetUnit.getAttachment(JBossMetaData.class);
/* 204 */       JBossEnterpriseBeanMetaData beanMD = appMD.getEnterpriseBean(ejbName);
/*     */ 
/* 206 */       if (beanMD != null)
/*     */       {
/* 208 */         linkTarget = getJndiName(beanMD, isLocal);
/*     */       }
/*     */       else
/*     */       {
/* 212 */         log.warn("No Bean named '" + ejbName + "' found in '" + path + "'!");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 217 */       log.warn("DeploymentUnit " + targetUnit + " is not an EJB .jar " + "file!");
/*     */     }
/*     */ 
/* 220 */     return linkTarget;
/*     */   }
/*     */ 
/*     */   private static String resolveAbsoluteLink(DeploymentUnit unit, String link, boolean isLocal)
/*     */   {
/* 225 */     if (log.isTraceEnabled())
/*     */     {
/* 227 */       log.trace("Resolving absolute link, di: " + unit);
/*     */     }
/*     */ 
/* 230 */     String ejbName = null;
/*     */ 
/* 233 */     if (unit.getAttachment(JBossMetaData.class) != null)
/*     */     {
/* 235 */       JBossMetaData appMD = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
/* 236 */       JBossEnterpriseBeanMetaData beanMD = appMD.getEnterpriseBean(link);
/* 237 */       if (beanMD != null)
/*     */       {
/* 239 */         ejbName = getJndiName(beanMD, isLocal);
/* 240 */         if (log.isTraceEnabled())
/*     */         {
/* 242 */           log.trace("Found Bean: " + beanMD + ", resolves to: " + ejbName);
/*     */         }
/*     */ 
/* 245 */         return ejbName;
/*     */       }
/* 247 */       if (log.isTraceEnabled())
/*     */       {
/* 250 */         log.trace("No match for ejb-link: " + link + ", module names:");
/* 251 */         for (JBossEnterpriseBeanMetaData md : appMD.getEnterpriseBeans())
/*     */         {
/* 253 */           String beanEjbName = getJndiName(md, isLocal);
/* 254 */           log.trace("... ejbName: " + beanEjbName);
/*     */         }
/*     */       }
/*     */     }
/* 258 */     else if (unit.getAttachment("EJB_DEPLOYMENTS") != null)
/*     */     {
/* 260 */       log.debug("Saw EJB3 module, cannot resolve it");
/*     */     }
/*     */ 
/* 264 */     Iterator it = unit.getChildren().iterator();
/* 265 */     while ((it.hasNext()) && (ejbName == null))
/*     */     {
/* 267 */       DeploymentUnit child = (DeploymentUnit)it.next();
/* 268 */       ejbName = resolveAbsoluteLink(child, link, isLocal);
/*     */     }
/*     */ 
/* 271 */     return ejbName;
/*     */   }
/*     */ 
/*     */   private static String getJndiName(JBossEnterpriseBeanMetaData beanMD, boolean isLocal)
/*     */   {
/* 276 */     String jndiName = null;
/* 277 */     if (isLocal)
/*     */     {
/* 280 */       jndiName = beanMD.determineLocalJndiName();
/* 281 */       if (jndiName == null)
/*     */       {
/* 283 */         log.warn("LocalHome jndi name requested for: '" + beanMD.getEjbName() + "' but there is no LocalHome class");
/*     */       }
/*     */ 
/*     */     }
/* 288 */     else if (beanMD.isEntity())
/*     */     {
/* 290 */       JBossEntityBeanMetaData md = (JBossEntityBeanMetaData)beanMD;
/* 291 */       jndiName = md.determineJndiName();
/*     */     }
/* 293 */     else if (beanMD.isSession())
/*     */     {
/* 295 */       JBossSessionBeanMetaData md = (JBossSessionBeanMetaData)beanMD;
/* 296 */       jndiName = md.determineJndiName();
/*     */     }
/*     */ 
/* 299 */     return jndiName;
/*     */   }
/*     */ 
/*     */   private static MessageDestinationMetaData resolveMessageDestination(MainDeployerStructure server, DeploymentUnit di, String link)
/*     */   {
/* 304 */     if (link == null) {
/* 305 */       return null;
/*     */     }
/* 307 */     if (log.isTraceEnabled()) {
/* 308 */       log.trace("resolveLink( {" + di + "}, {" + link + "})");
/*     */     }
/* 310 */     if (di == null)
/*     */     {
/* 312 */       return null;
/*     */     }
/* 314 */     if (link.indexOf('#') != -1)
/*     */     {
/* 316 */       return resolveRelativeMessageDestination(server, di, link);
/*     */     }
/*     */ 
/* 320 */     DeploymentUnit top = di.getTopLevel();
/* 321 */     return resolveAbsoluteMessageDestination(top, link);
/*     */   }
/*     */ 
/*     */   private static MessageDestinationMetaData resolveRelativeMessageDestination(MainDeployerStructure server, DeploymentUnit unit, String link)
/*     */   {
/* 327 */     String path = link.substring(0, link.indexOf('#'));
/* 328 */     String destinationName = link.substring(link.indexOf('#') + 1);
/* 329 */     String us = unit.getName();
/*     */ 
/* 332 */     if (us.charAt(us.length() - 1) == '/') {
/* 333 */       us = us.substring(0, us.length() - 1);
/*     */     }
/* 335 */     String ourPath = us.substring(0, us.lastIndexOf('/'));
/*     */ 
/* 337 */     if (log.isTraceEnabled())
/*     */     {
/* 339 */       log.trace("Resolving relative message-destination-link: " + link);
/* 340 */       log.trace("Looking for: '" + link + "', we're located at: '" + ourPath + "'");
/*     */     }
/*     */ 
/* 343 */     for (StringTokenizer st = new StringTokenizer(path, "/"); st.hasMoreTokens(); )
/*     */     {
/* 345 */       String s = st.nextToken();
/* 346 */       if (s.equals(".."))
/* 347 */         ourPath = ourPath.substring(0, ourPath.lastIndexOf('/'));
/* 348 */       else ourPath = ourPath + "/" + s;
/*     */     }
/*     */ 
/* 351 */     URL target = null;
/*     */     try
/*     */     {
/* 354 */       target = Strings.toURL(ourPath);
/*     */     }
/*     */     catch (MalformedURLException mue)
/*     */     {
/* 358 */       log.warn("Can't construct URL for: " + ourPath);
/* 359 */       return null;
/*     */     }
/*     */ 
/* 362 */     DeploymentUnit targetUnit = null;
/*     */     try
/*     */     {
/* 365 */       DeploymentContext ctx = server.getDeploymentContext(target.toString());
/* 366 */       targetUnit = ctx.getDeploymentUnit();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 370 */       log.warn("Got Exception when looking for DeploymentUnit: " + e);
/* 371 */       return null;
/*     */     }
/*     */ 
/* 374 */     if (targetUnit == null)
/*     */     {
/* 376 */       log.warn("Can't locate DeploymentUnit for target: " + target);
/* 377 */       return null;
/*     */     }
/*     */ 
/* 380 */     if (log.isTraceEnabled()) {
/* 381 */       log.trace("Found appropriate DeploymentUnit: " + targetUnit);
/*     */     }
/* 383 */     if (targetUnit.getAttachment(JBossMetaData.class) != null)
/*     */     {
/* 385 */       JBossMetaData appMD = (JBossMetaData)targetUnit.getAttachment(JBossMetaData.class);
/* 386 */       return appMD.getAssemblyDescriptor().getMessageDestination(destinationName);
/*     */     }
/* 388 */     if (targetUnit.getAttachment(JBossWebMetaData.class) != null)
/*     */     {
/* 390 */       JBossWebMetaData webMD = (JBossWebMetaData)targetUnit.getAttachment(JBossWebMetaData.class);
/* 391 */       return webMD.getMessageDestination(destinationName);
/*     */     }
/*     */ 
/* 395 */     log.warn("DeploymentUnit " + targetUnit + " is not an EJB .jar " + "file!");
/* 396 */     return null;
/*     */   }
/*     */ 
/*     */   private static MessageDestinationMetaData resolveAbsoluteMessageDestination(DeploymentUnit unit, String link)
/*     */   {
/* 402 */     if (log.isTraceEnabled()) {
/* 403 */       log.trace("Resolving absolute link, di: " + unit);
/*     */     }
/*     */ 
/* 406 */     if (unit.getAttachment(JBossMetaData.class) != null)
/*     */     {
/* 408 */       JBossMetaData appMD = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
/* 409 */       MessageDestinationMetaData mdMD = appMD.getAssemblyDescriptor().getMessageDestination(link);
/* 410 */       if (mdMD != null)
/* 411 */         return mdMD;
/*     */     }
/* 413 */     if (unit.getAttachment(JBossWebMetaData.class) != null)
/*     */     {
/* 415 */       JBossWebMetaData webMD = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
/* 416 */       return webMD.getMessageDestination(link);
/*     */     }
/*     */ 
/* 420 */     Iterator it = unit.getChildren().iterator();
/* 421 */     while (it.hasNext())
/*     */     {
/* 423 */       DeploymentUnit child = (DeploymentUnit)it.next();
/* 424 */       MessageDestinationMetaData mdMD = resolveAbsoluteMessageDestination(child, link);
/* 425 */       if (mdMD != null) {
/* 426 */         return mdMD;
/*     */       }
/*     */     }
/*     */ 
/* 430 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.EjbUtil50
 * JD-Core Version:    0.6.0
 */