/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.security.jacc.EJBMethodPermission;
/*     */ import javax.security.jacc.EJBRoleRefPermission;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.SessionMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MethodInterfaceType;
/*     */ import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.MethodsMetaData;
/*     */ import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
/*     */ 
/*     */ public class EJBPermissionMapping
/*     */ {
/*     */   public static void createPermissions(JBossEnterpriseBeanMetaData bean, PolicyConfiguration pc)
/*     */     throws PolicyContextException
/*     */   {
/*  61 */     MethodPermissionsMetaData perms = bean.getMethodPermissions();
/*     */     Iterator i$;
/*  62 */     if (perms != null)
/*  63 */       for (i$ = perms.iterator(); i$.hasNext(); ) { perm = (MethodPermissionMetaData)i$.next();
/*     */ 
/*  65 */         MethodsMetaData methods = perm.getMethods();
/*  66 */         if (methods != null)
/*  67 */           for (org.jboss.metadata.ejb.spec.MethodMetaData mmd : methods)
/*     */           {
/*  69 */             String[] params = new String[0];
/*  70 */             if (mmd.getMethodParams() != null)
/*  71 */               params = (String[])mmd.getMethodParams().toArray(params);
/*     */             else
/*  73 */               params = null;
/*  74 */             String methodName = mmd.getMethodName();
/*  75 */             if ((methodName != null) && (methodName.equals("*")))
/*  76 */               methodName = null;
/*  77 */             MethodInterfaceType miType = mmd.getMethodIntf();
/*  78 */             String iface = miType != null ? miType.name() : null;
/*  79 */             EJBMethodPermission p = new EJBMethodPermission(mmd.getEjbName(), methodName, iface, params);
/*     */ 
/*  81 */             if (perm.getUnchecked() != null)
/*     */             {
/*  83 */               pc.addToUncheckedPolicy(p);
/*     */             }
/*     */             else
/*     */             {
/*  87 */               Set roles = perm.getRoles();
/*  88 */               Iterator riter = roles.iterator();
/*  89 */               while (riter.hasNext())
/*     */               {
/*  91 */                 String role = (String)riter.next();
/*  92 */                 pc.addToRole(role, p);
/*     */               }
/*     */             }
/*     */           }
/*     */       }
/*     */     MethodPermissionMetaData perm;
/*  99 */     ExcludeListMetaData excluded = bean.getExcludeList();
/* 100 */     if (excluded != null)
/*     */     {
/* 102 */       MethodsMetaData methods = excluded.getMethods();
/* 103 */       if (methods != null) {
/* 104 */         for (org.jboss.metadata.ejb.spec.MethodMetaData mmd : methods)
/*     */         {
/* 106 */           String[] params = new String[0];
/* 107 */           if (mmd.getMethodParams() != null)
/* 108 */             params = (String[])mmd.getMethodParams().toArray(params);
/* 109 */           String methodName = mmd.getMethodName();
/* 110 */           if ((methodName != null) && (methodName.equals("*")))
/* 111 */             methodName = null;
/* 112 */           MethodInterfaceType miType = mmd.getMethodIntf();
/* 113 */           String iface = miType != null ? miType.name() : null;
/* 114 */           EJBMethodPermission p = new EJBMethodPermission(mmd.getEjbName(), methodName, iface, params);
/*     */ 
/* 116 */           pc.addToExcludedPolicy(p);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 121 */     SecurityRoleRefsMetaData refs = bean.getSecurityRoleRefs();
/* 122 */     if (refs != null) {
/* 123 */       for (org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData ref : refs)
/*     */       {
/* 125 */         EJBRoleRefPermission p = new EJBRoleRefPermission(bean.getEjbName(), ref.getRoleName());
/* 126 */         pc.addToRole(ref.getRoleLink(), p);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 133 */     if (bean.isSession())
/*     */     {
/* 135 */       JBossSessionBeanMetaData smd = (JBossSessionBeanMetaData)bean;
/* 136 */       if (smd.isStateful())
/*     */       {
/* 138 */         EJBMethodPermission p = new EJBMethodPermission(bean.getEjbName(), "getEJBObject", "Home", null);
/*     */ 
/* 140 */         pc.addToUncheckedPolicy(p);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void createPermissions(BeanMetaData bean, PolicyConfiguration pc)
/*     */     throws PolicyContextException
/*     */   {
/* 149 */     Iterator iter = bean.getPermissionMethods();
/* 150 */     while (iter.hasNext())
/*     */     {
/* 152 */       org.jboss.metadata.MethodMetaData mmd = (org.jboss.metadata.MethodMetaData)iter.next();
/* 153 */       String[] params = null;
/* 154 */       if (mmd.isParamGiven())
/* 155 */         params = mmd.getMethodParams();
/* 156 */       String methodName = mmd.getMethodName();
/* 157 */       if ((methodName != null) && (methodName.equals("*")))
/* 158 */         methodName = null;
/* 159 */       EJBMethodPermission p = new EJBMethodPermission(mmd.getEjbName(), methodName, mmd.getInterfaceType(), params);
/*     */ 
/* 161 */       if (mmd.isUnchecked())
/*     */       {
/* 163 */         pc.addToUncheckedPolicy(p);
/*     */       }
/*     */       else
/*     */       {
/* 167 */         Set roles = mmd.getRoles();
/* 168 */         Iterator riter = roles.iterator();
/* 169 */         while (riter.hasNext())
/*     */         {
/* 171 */           String role = (String)riter.next();
/* 172 */           pc.addToRole(role, p);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 177 */     iter = bean.getExcludedMethods();
/* 178 */     while (iter.hasNext())
/*     */     {
/* 180 */       org.jboss.metadata.MethodMetaData mmd = (org.jboss.metadata.MethodMetaData)iter.next();
/* 181 */       String[] params = null;
/* 182 */       if (mmd.isParamGiven())
/* 183 */         params = mmd.getMethodParams();
/* 184 */       EJBMethodPermission p = new EJBMethodPermission(mmd.getEjbName(), mmd.getMethodName(), mmd.getInterfaceType(), params);
/*     */ 
/* 186 */       pc.addToExcludedPolicy(p);
/*     */     }
/*     */ 
/* 189 */     iter = bean.getSecurityRoleReferences();
/* 190 */     while (iter.hasNext())
/*     */     {
/* 192 */       org.jboss.metadata.SecurityRoleRefMetaData srrmd = (org.jboss.metadata.SecurityRoleRefMetaData)iter.next();
/* 193 */       EJBRoleRefPermission p = new EJBRoleRefPermission(bean.getEjbName(), srrmd.getName());
/* 194 */       pc.addToRole(srrmd.getLink(), p);
/*     */     }
/*     */ 
/* 200 */     if ((bean instanceof SessionMetaData))
/*     */     {
/* 202 */       SessionMetaData smd = (SessionMetaData)bean;
/* 203 */       if (smd.isStateful())
/*     */       {
/* 205 */         EJBMethodPermission p = new EJBMethodPermission(bean.getEjbName(), "getEJBObject", "Home", null);
/*     */ 
/* 207 */         pc.addToUncheckedPolicy(p);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.EJBPermissionMapping
 * JD-Core Version:    0.6.0
 */