/*      */ package org.jboss.ejb;
/*      */ 
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.net.URL;
/*      */ import java.rmi.MarshalException;
/*      */ import java.security.AccessController;
/*      */ import java.security.Policy;
/*      */ import java.security.Principal;
/*      */ import java.security.PrivilegedActionException;
/*      */ import java.security.PrivilegedExceptionAction;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.concurrent.ConcurrentHashMap;
/*      */ import javax.ejb.EJBException;
/*      */ import javax.ejb.EJBObject;
/*      */ import javax.ejb.TimedObject;
/*      */ import javax.ejb.Timer;
/*      */ import javax.ejb.TimerService;
/*      */ import javax.ejb.spi.HandleDelegate;
/*      */ import javax.management.MBeanException;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.MalformedObjectNameException;
/*      */ import javax.management.ObjectName;
/*      */ import javax.naming.Context;
/*      */ import javax.naming.InitialContext;
/*      */ import javax.naming.LinkRef;
/*      */ import javax.naming.NamingException;
/*      */ import javax.naming.Reference;
/*      */ import javax.naming.StringRefAddr;
/*      */ import javax.transaction.TransactionManager;
/*      */ import javax.xml.soap.SOAPMessage;
/*      */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.deployment.DeploymentInfo;
/*      */ import org.jboss.ejb.plugins.local.BaseLocalProxyFactory;
/*      */ import org.jboss.ejb.txtimer.EJBTimerService;
/*      */ import org.jboss.ejb.txtimer.EJBTimerServiceImpl;
/*      */ import org.jboss.invocation.Invocation;
/*      */ import org.jboss.invocation.InvocationKey;
/*      */ import org.jboss.invocation.InvocationStatistics;
/*      */ import org.jboss.invocation.InvocationType;
/*      */ import org.jboss.invocation.JBossLazyUnmarshallingException;
/*      */ import org.jboss.invocation.MarshalledInvocation;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.ApplicationMetaData;
/*      */ import org.jboss.metadata.BeanMetaData;
/*      */ import org.jboss.metadata.ConfigurationMetaData;
/*      */ import org.jboss.metadata.EjbLocalRefMetaData;
/*      */ import org.jboss.metadata.EjbRefMetaData;
/*      */ import org.jboss.metadata.EnvEntryBinder;
/*      */ import org.jboss.metadata.EnvEntryMetaData;
/*      */ import org.jboss.metadata.MessageDestinationRefMetaData;
/*      */ import org.jboss.metadata.ResourceEnvRefMetaData;
/*      */ import org.jboss.metadata.ResourceRefMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*      */ import org.jboss.metadata.serviceref.ServiceReferenceHandler;
/*      */ import org.jboss.metadata.serviceref.VirtualFileAdaptor;
/*      */ import org.jboss.mx.util.ObjectNameConverter;
/*      */ import org.jboss.mx.util.ObjectNameFactory;
/*      */ import org.jboss.naming.ENCFactory;
/*      */ import org.jboss.naming.ENCThreadLocalKey;
/*      */ import org.jboss.naming.NonSerializableFactory;
/*      */ import org.jboss.naming.Util;
/*      */ import org.jboss.security.AnybodyPrincipal;
/*      */ import org.jboss.security.AuthenticationManager;
/*      */ import org.jboss.security.ISecurityManagement;
/*      */ import org.jboss.security.RealmMapping;
/*      */ import org.jboss.security.SimplePrincipal;
/*      */ import org.jboss.system.ServiceMBeanSupport;
/*      */ import org.jboss.util.NestedError;
/*      */ import org.jboss.util.NestedRuntimeException;
/*      */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*      */ import org.omg.CORBA.ORB;
/*      */ 
/*      */ public abstract class Container extends ServiceMBeanSupport
/*      */   implements ContainerMBean, AllowedOperationsFlags
/*      */ {
/*      */   public static final String BASE_EJB_CONTAINER_NAME = "jboss.j2ee:service=EJB";
/*  130 */   public static final ObjectName ORB_NAME = ObjectNameFactory.create("jboss:service=CorbaORB");
/*      */ 
/*  132 */   public static final ObjectName EJB_CONTAINER_QUERY_NAME = ObjectNameFactory.create("jboss.j2ee:service=EJB,*");
/*      */   protected static final Method EJBOBJECT_REMOVE;
/*      */   protected static final Method EJB_TIMEOUT;
/*      */   protected EjbModule ejbModule;
/*      */   protected ClassLoader classLoader;
/*      */   protected ClassLoader webClassLoader;
/*      */   private VFSDeploymentUnit unit;
/*      */   protected BeanMetaData metaData;
/*      */   protected Class beanClass;
/*      */   protected Class homeInterface;
/*      */   protected Class remoteInterface;
/*      */   protected Class localHomeInterface;
/*      */   protected Class localInterface;
/*      */   protected TransactionManager tm;
/*      */   protected String securityContextClassName;
/*      */   protected String defaultSecurityDomain;
/*      */   protected ISecurityManagement securityManagement;
/*      */   protected AuthenticationManager sm;
/*      */   protected RealmMapping rm;
/*      */   protected Object securityProxy;
/*      */   protected BeanLockManager lockManager;
/*      */   protected LocalProxyFactory localProxyFactory;
/*      */   private HashMap<Method, Set<Principal>> methodPermissionsCache;
/*      */   protected Map marshalledInvocationMapping;
/*      */   private ObjectName jmxName;
/*      */   protected HashMap proxyFactories;
/*      */   private MBeanServerAction serverAction;
/*      */   protected ThreadLocal proxyFactoryTL;
/*      */   protected long createCount;
/*      */   protected long removeCount;
/*      */   protected InvocationStatistics invokeStats;
/*      */   protected String jaccContextID;
/*      */   protected boolean isJaccEnabled;
/*      */   protected EJBTimerService timerService;
/*      */ 
/*      */   public Container()
/*      */   {
/*  204 */     this.localProxyFactory = new BaseLocalProxyFactory();
/*      */ 
/*  207 */     this.methodPermissionsCache = new HashMap();
/*      */ 
/*  210 */     this.marshalledInvocationMapping = new HashMap();
/*      */ 
/*  216 */     this.proxyFactories = new HashMap();
/*      */ 
/*  219 */     this.serverAction = new MBeanServerAction();
/*      */ 
/*  225 */     this.proxyFactoryTL = new ThreadLocal();
/*      */ 
/*  234 */     this.invokeStats = new InvocationStatistics();
/*      */ 
/*  242 */     this.isJaccEnabled = false;
/*      */   }
/*      */ 
/*      */   public Class getLocalClass()
/*      */   {
/*  263 */     return this.localInterface;
/*      */   }
/*      */ 
/*      */   public Class getLocalHomeClass()
/*      */   {
/*  268 */     return this.localHomeInterface;
/*      */   }
/*      */ 
/*      */   public Class getRemoteClass()
/*      */   {
/*  273 */     return this.remoteInterface;
/*      */   }
/*      */ 
/*      */   public Class getHomeClass()
/*      */   {
/*  282 */     return this.homeInterface;
/*      */   }
/*      */ 
/*      */   public boolean isCallByValue()
/*      */   {
/*  292 */     if (this.ejbModule.isCallByValue())
/*  293 */       return true;
/*  294 */     return this.metaData.isCallByValue();
/*      */   }
/*      */ 
/*      */   public void setTransactionManager(TransactionManager tm)
/*      */   {
/*  306 */     this.tm = tm;
/*      */   }
/*      */ 
/*      */   public TransactionManager getTransactionManager()
/*      */   {
/*  316 */     return this.tm;
/*      */   }
/*      */ 
/*      */   public void setSecurityManager(AuthenticationManager sm)
/*      */   {
/*  321 */     this.sm = sm;
/*      */   }
/*      */ 
/*      */   public AuthenticationManager getSecurityManager()
/*      */   {
/*  326 */     return this.sm;
/*      */   }
/*      */ 
/*      */   public ISecurityManagement getSecurityManagement()
/*      */   {
/*  331 */     return this.securityManagement;
/*      */   }
/*      */ 
/*      */   public void setSecurityManagement(ISecurityManagement securityManagement)
/*      */   {
/*  336 */     this.securityManagement = securityManagement;
/*      */   }
/*      */ 
/*      */   public String getDefaultSecurityDomain()
/*      */   {
/*  341 */     return this.defaultSecurityDomain;
/*      */   }
/*      */ 
/*      */   public void setDefaultSecurityDomain(String defaultSecurityDomain)
/*      */   {
/*  346 */     this.defaultSecurityDomain = defaultSecurityDomain;
/*      */   }
/*      */ 
/*      */   public String getSecurityContextClassName()
/*      */   {
/*  351 */     return this.securityContextClassName;
/*      */   }
/*      */ 
/*      */   public void setSecurityContextClassName(String securityContextClassName)
/*      */   {
/*  356 */     this.securityContextClassName = securityContextClassName;
/*      */   }
/*      */ 
/*      */   public BeanLockManager getLockManager()
/*      */   {
/*  361 */     return this.lockManager;
/*      */   }
/*      */ 
/*      */   public void setLockManager(BeanLockManager lockManager)
/*      */   {
/*  366 */     this.lockManager = lockManager;
/*  367 */     lockManager.setContainer(this);
/*      */   }
/*      */ 
/*      */   public void addProxyFactory(String invokerBinding, EJBProxyFactory factory)
/*      */   {
/*  372 */     this.proxyFactories.put(invokerBinding, factory);
/*      */   }
/*      */ 
/*      */   public void setRealmMapping(RealmMapping rm)
/*      */   {
/*  377 */     this.rm = rm;
/*      */   }
/*      */ 
/*      */   public RealmMapping getRealmMapping()
/*      */   {
/*  382 */     return this.rm;
/*      */   }
/*      */ 
/*      */   public void setSecurityProxy(Object proxy)
/*      */   {
/*  387 */     this.securityProxy = proxy;
/*      */   }
/*      */ 
/*      */   public Object getSecurityProxy()
/*      */   {
/*  392 */     return this.securityProxy;
/*      */   }
/*      */ 
/*      */   public EJBProxyFactory getProxyFactory()
/*      */   {
/*  397 */     EJBProxyFactory factory = (EJBProxyFactory)this.proxyFactoryTL.get();
/*      */ 
/*  404 */     if ((factory == null) && (this.remoteInterface != null))
/*      */     {
/*  406 */       Iterator i = this.proxyFactories.values().iterator();
/*  407 */       if (i.hasNext())
/*  408 */         factory = (EJBProxyFactory)i.next();
/*      */     }
/*  410 */     return factory;
/*      */   }
/*      */ 
/*      */   public void setProxyFactory(Object factory)
/*      */   {
/*  415 */     this.proxyFactoryTL.set(factory);
/*      */   }
/*      */ 
/*      */   public EJBProxyFactory lookupProxyFactory(String binding)
/*      */   {
/*  420 */     return (EJBProxyFactory)this.proxyFactories.get(binding);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public final DeploymentInfo getDeploymentInfo()
/*      */   {
/*  430 */     return null;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public final void setDeploymentInfo(DeploymentInfo di)
/*      */   {
/*      */   }
/*      */ 
/*      */   public final VFSDeploymentUnit getDeploymentUnit()
/*      */   {
/*  444 */     return this.unit;
/*      */   }
/*      */ 
/*      */   public final void setDeploymentUnit(VFSDeploymentUnit di)
/*      */   {
/*  449 */     this.unit = di;
/*      */   }
/*      */ 
/*      */   public void setEjbModule(EjbModule app)
/*      */   {
/*  460 */     this.ejbModule = app;
/*      */   }
/*      */ 
/*      */   public String getJaccContextID()
/*      */   {
/*  465 */     return this.jaccContextID;
/*      */   }
/*      */ 
/*      */   public void setJaccContextID(String id)
/*      */   {
/*  470 */     this.jaccContextID = id;
/*      */   }
/*      */ 
/*      */   public EJBTimerService getTimerService()
/*      */   {
/*  475 */     return this.timerService;
/*      */   }
/*      */ 
/*      */   public void setTimerService(EJBTimerService timerService)
/*      */   {
/*  480 */     this.timerService = timerService;
/*      */   }
/*      */ 
/*      */   public boolean isJaccEnabled()
/*      */   {
/*  489 */     return this.isJaccEnabled;
/*      */   }
/*      */ 
/*      */   public void setJaccEnabled(boolean isJaccEnabled)
/*      */   {
/*  499 */     this.isJaccEnabled = isJaccEnabled;
/*      */   }
/*      */ 
/*      */   public EjbModule getEjbModule()
/*      */   {
/*  509 */     return this.ejbModule;
/*      */   }
/*      */ 
/*      */   public long getCreateCount()
/*      */   {
/*  518 */     return this.createCount;
/*      */   }
/*      */ 
/*      */   public long getRemoveCount()
/*      */   {
/*  527 */     return this.removeCount;
/*      */   }
/*      */ 
/*      */   public InvocationStatistics getInvokeStats()
/*      */   {
/*  535 */     return this.invokeStats;
/*      */   }
/*      */ 
/*      */   public void setClassLoader(ClassLoader cl)
/*      */   {
/*  546 */     this.classLoader = cl;
/*      */   }
/*      */ 
/*      */   public ClassLoader getClassLoader()
/*      */   {
/*  556 */     return this.classLoader;
/*      */   }
/*      */ 
/*      */   public ClassLoader getWebClassLoader()
/*      */   {
/*  563 */     return this.webClassLoader;
/*      */   }
/*      */ 
/*      */   public void setWebClassLoader(ClassLoader webClassLoader)
/*      */   {
/*  570 */     this.webClassLoader = webClassLoader;
/*      */   }
/*      */ 
/*      */   public void setBeanMetaData(BeanMetaData metaData)
/*      */   {
/*  581 */     this.metaData = metaData;
/*      */   }
/*      */ 
/*      */   public void pushENC()
/*      */   {
/*  590 */     ENCFactory.pushContextId(getJmxName());
/*      */   }
/*      */ 
/*      */   public void popENC()
/*      */   {
/*  595 */     ENCFactory.popContextId();
/*      */   }
/*      */ 
/*      */   public void cleanENC()
/*      */   {
/*  604 */     ENCFactory.getEncById().remove(getJmxName());
/*      */   }
/*      */ 
/*      */   public Context getEnvContext()
/*      */     throws NamingException
/*      */   {
/*  613 */     pushENC();
/*      */     try
/*      */     {
/*  616 */       Context localContext = (Context)new InitialContext().lookup("java:comp/env");
/*      */       return localContext; } finally { popENC(); } throw localObject;
/*      */   }
/*      */ 
/*      */   public BeanMetaData getBeanMetaData()
/*      */   {
/*  632 */     return this.metaData;
/*      */   }
/*      */ 
/*      */   public Set<Principal> getMethodPermissions(Method m, InvocationType iface)
/*      */   {
/*      */     Set permissions;
/*      */     Set permissions;
/*  644 */     if (this.methodPermissionsCache.containsKey(m))
/*      */     {
/*  646 */       permissions = (Set)this.methodPermissionsCache.get(m);
/*      */     }
/*  648 */     else if (m.equals(EJB_TIMEOUT))
/*      */     {
/*  651 */       Set permissions = new HashSet();
/*  652 */       permissions.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*  653 */       this.methodPermissionsCache.put(m, permissions);
/*      */     }
/*      */     else
/*      */     {
/*  657 */       String name = m.getName();
/*  658 */       Class[] sig = m.getParameterTypes();
/*  659 */       Set roles = getBeanMetaData().getMethodPermissions(name, sig, iface);
/*  660 */       permissions = new HashSet();
/*  661 */       if (roles != null)
/*      */       {
/*  663 */         for (String role : roles)
/*  664 */           permissions.add(new SimplePrincipal(role));
/*      */       }
/*  666 */       this.methodPermissionsCache.put(m, permissions);
/*      */     }
/*      */ 
/*  669 */     return permissions;
/*      */   }
/*      */ 
/*      */   public Class getBeanClass()
/*      */   {
/*  679 */     return this.beanClass;
/*      */   }
/*      */ 
/*      */   public Object createBeanClassInstance()
/*      */     throws Exception
/*      */   {
/*  695 */     return getBeanClass().newInstance();
/*      */   }
/*      */ 
/*      */   public ObjectName getJmxName()
/*      */   {
/*  728 */     if (this.jmxName == null)
/*      */     {
/*  730 */       BeanMetaData beanMetaData = getBeanMetaData();
/*  731 */       if (beanMetaData == null)
/*      */       {
/*  733 */         throw new IllegalStateException("Container metaData is null");
/*      */       }
/*      */ 
/*  736 */       String jndiName = beanMetaData.getContainerObjectNameJndiName();
/*  737 */       if (jndiName == null)
/*      */       {
/*  739 */         throw new IllegalStateException("Container jndiName is null");
/*      */       }
/*      */ 
/*  743 */       String name = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
/*      */       try
/*      */       {
/*  746 */         this.jmxName = ObjectNameConverter.convert(name);
/*      */       }
/*      */       catch (MalformedObjectNameException e)
/*      */       {
/*  750 */         throw new RuntimeException("Failed to create ObjectName, msg=" + e.getMessage());
/*      */       }
/*      */     }
/*  753 */     return this.jmxName;
/*      */   }
/*      */ 
/*      */   public TimerService getTimerService(Object pKey)
/*      */     throws IllegalStateException
/*      */   {
/*  770 */     if ((this instanceof StatefulSessionContainer)) {
/*  771 */       throw new IllegalStateException("Statefull Session Beans are not allowed to access the TimerService");
/*      */     }
/*      */ 
/*  774 */     if (!TimedObject.class.isAssignableFrom(this.beanClass))
/*      */     {
/*  777 */       return EJBTimerServiceImpl.FOR_NON_TIMED_OBJECT;
/*      */     }
/*      */ 
/*  780 */     TimerService timerService = null;
/*      */     try
/*      */     {
/*  783 */       timerService = this.timerService.createTimerService(getJmxName(), pKey, this);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  787 */       throw new EJBException("Could not create timer service", e);
/*      */     }
/*  789 */     return timerService;
/*      */   }
/*      */ 
/*      */   public void removeTimerService(Object pKey)
/*      */     throws IllegalStateException
/*      */   {
/*      */     try
/*      */     {
/*  804 */       if (pKey != null)
/*      */       {
/*  807 */         this.timerService.removeTimerService(getJmxName(), pKey);
/*      */       }
/*      */       else
/*      */       {
/*  813 */         this.timerService.removeTimerService(getJmxName(), getBeanMetaData().getTimerPersistence());
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  818 */       this.log.error("Could not remove timer service", e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void restoreTimers()
/*      */   {
/*      */     try
/*      */     {
/*  831 */       this.timerService.restoreTimers(getServiceName(), getClassLoader());
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  835 */       this.log.warn("Could not restore ejb timers", e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void createService()
/*      */     throws Exception
/*      */   {
/*  854 */     this.beanClass = this.classLoader.loadClass(this.metaData.getEjbClass());
/*      */ 
/*  856 */     if (this.metaData.getLocalHome() != null)
/*  857 */       this.localHomeInterface = this.classLoader.loadClass(this.metaData.getLocalHome());
/*  858 */     if (this.metaData.getLocal() != null) {
/*  859 */       this.localInterface = this.classLoader.loadClass(this.metaData.getLocal());
/*      */     }
/*  861 */     this.localProxyFactory.setContainer(this);
/*  862 */     this.localProxyFactory.create();
/*  863 */     if (this.localHomeInterface != null)
/*  864 */       this.ejbModule.addLocalHome(this, this.localProxyFactory.getEJBLocalHome());
/*  865 */     this.ejbModule.createMissingPermissions(this, this.metaData);
/*      */ 
/*  867 */     Policy.getPolicy().refresh();
/*      */   }
/*      */ 
/*      */   protected void startService()
/*      */     throws Exception
/*      */   {
/*  885 */     setupEnvironment();
/*      */ 
/*  887 */     this.localProxyFactory.start();
/*      */   }
/*      */ 
/*      */   protected void stopService()
/*      */     throws Exception
/*      */   {
/*  897 */     this.localProxyFactory.stop();
/*  898 */     removeTimerService(null);
/*  899 */     teardownEnvironment();
/*      */   }
/*      */ 
/*      */   protected void destroyService()
/*      */     throws Exception
/*      */   {
/*  909 */     cleanENC();
/*  910 */     this.localProxyFactory.destroy();
/*  911 */     this.ejbModule.removeLocalHome(this);
/*      */ 
/*  913 */     this.beanClass = null;
/*  914 */     this.homeInterface = null;
/*  915 */     this.remoteInterface = null;
/*  916 */     this.localHomeInterface = null;
/*  917 */     this.localInterface = null;
/*  918 */     this.methodPermissionsCache.clear();
/*      */ 
/*  923 */     this.invokeStats.resetStats();
/*  924 */     this.invokeStats = new InvocationStatistics();
/*  925 */     this.marshalledInvocationMapping.clear();
/*      */   }
/*      */ 
/*      */   public abstract Object internalInvokeHome(Invocation paramInvocation)
/*      */     throws Exception;
/*      */ 
/*      */   public abstract Object internalInvoke(Invocation paramInvocation)
/*      */     throws Exception;
/*      */ 
/*      */   abstract Interceptor createContainerInterceptor();
/*      */ 
/*      */   public abstract void addInterceptor(Interceptor paramInterceptor);
/*      */ 
/*      */   public Object invoke(Invocation mi)
/*      */     throws Exception
/*      */   {
/*  961 */     ClassLoader callerClassLoader = SecurityActions.getContextClassLoader();
/*  962 */     long start = System.currentTimeMillis();
/*  963 */     Method m = null;
/*      */ 
/*  965 */     Object type = null;
/*  966 */     String contextID = getJaccContextID();
/*      */     try
/*      */     {
/*  969 */       pushENC();
/*      */ 
/*  972 */       SecurityActions.setContextClassLoader(this.classLoader);
/*      */ 
/*  975 */       mi.setValue(InvocationKey.JACC_CONTEXT_ID, contextID);
/*  976 */       contextID = SecurityActions.setContextID(contextID);
/*      */ 
/*  978 */       if (mi.getType() != InvocationType.SERVICE_ENDPOINT)
/*      */       {
/*  980 */         EJBArgsPolicyContextHandler.setArgs(mi.getArguments());
/*      */       }
/*      */       else
/*      */       {
/*  984 */         SOAPMessage msg = (SOAPMessage)mi.getValue(InvocationKey.SOAP_MESSAGE);
/*  985 */         SOAPMsgPolicyContextHandler.setMessage(msg);
/*      */       }
/*      */ 
/*  988 */       BeanMetaDataPolicyContextHandler.setMetaData(getBeanMetaData());
/*      */ 
/*  992 */       type = mi.getType();
/*      */ 
/*  995 */       this.invokeStats.callIn();
/*      */       Object localObject1;
/*  997 */       if ((type == InvocationType.REMOTE) || (type == InvocationType.LOCAL) || (type == InvocationType.SERVICE_ENDPOINT))
/*      */       {
/* 1001 */         if ((mi instanceof MarshalledInvocation))
/*      */         {
/* 1003 */           ((MarshalledInvocation)mi).setMethodMap(this.marshalledInvocationMapping);
/*      */ 
/* 1005 */           if (this.log.isTraceEnabled())
/*      */           {
/* 1007 */             this.log.trace("METHOD REMOTE INVOKE " + mi.getObjectName() + "||" + mi.getMethod().getName() + "||");
/*      */           }
/*      */         }
/*      */ 
/* 1011 */         m = mi.getMethod();
/*      */ 
/* 1013 */         Object obj = internalInvoke(mi);
/* 1014 */         localObject1 = obj;
/*      */         long end;
/*      */         long elapsed;
/*      */         return localObject1;
/*      */       }
/* 1016 */       if ((type == InvocationType.HOME) || (type == InvocationType.LOCALHOME))
/*      */       {
/* 1018 */         if ((mi instanceof MarshalledInvocation))
/*      */         {
/* 1021 */           ((MarshalledInvocation)mi).setMethodMap(this.marshalledInvocationMapping);
/*      */ 
/* 1023 */           if (this.log.isTraceEnabled())
/*      */           {
/* 1025 */             this.log.trace("METHOD HOME INVOKE " + mi.getObjectName() + "||" + mi.getMethod().getName() + "||" + mi.getArguments().toString());
/*      */           }
/*      */         }
/* 1028 */         m = mi.getMethod();
/*      */ 
/* 1030 */         Object obj = internalInvokeHome(mi);
/* 1031 */         localObject1 = obj;
/*      */         long end;
/*      */         long elapsed;
/*      */         return localObject1;
/*      */       }
/* 1035 */       throw new MBeanException(new IllegalArgumentException("Unknown invocation type: " + type));
/*      */     }
/*      */     catch (JBossLazyUnmarshallingException e)
/*      */     {
/* 1045 */       InvocationType calltype = mi.getType();
/* 1046 */       boolean isLocal = (calltype == InvocationType.LOCAL) || (calltype == InvocationType.LOCALHOME);
/*      */ 
/* 1050 */       if (isLocal)
/*      */       {
/* 1052 */         throw new EJBException("UnmarshalException", e);
/*      */       }
/*      */ 
/* 1056 */       throw new MarshalException("MarshalException", e);
/*      */     }
/*      */     finally
/*      */     {
/* 1061 */       if (m != null)
/*      */       {
/* 1063 */         long end = System.currentTimeMillis();
/* 1064 */         long elapsed = end - start;
/* 1065 */         this.invokeStats.updateStats(m, elapsed);
/*      */       }
/*      */ 
/* 1069 */       this.invokeStats.callOut();
/*      */ 
/* 1071 */       popENC();
/*      */ 
/* 1074 */       SecurityActions.setContextClassLoader(callerClassLoader);
/*      */ 
/* 1077 */       contextID = SecurityActions.setContextID(contextID);
/*      */ 
/* 1079 */       if (mi.getType() == InvocationType.SERVICE_ENDPOINT)
/*      */       {
/* 1082 */         SOAPMsgPolicyContextHandler.setMessage(null);
/*      */       }
/*      */       else
/*      */       {
/* 1087 */         EJBArgsPolicyContextHandler.setArgs(null);
/*      */       }
/*      */ 
/* 1091 */       BeanMetaDataPolicyContextHandler.setMetaData(null); } throw localObject2;
/*      */   }
/*      */ 
/*      */   private void setupEnvironment()
/*      */     throws Exception
/*      */   {
/* 1104 */     BeanMetaData beanMetaData = getBeanMetaData();
/*      */ 
/* 1107 */     this.log.debug("Begin java:comp/env for EJB: " + beanMetaData.getEjbName());
/* 1108 */     ClassLoader tcl = SecurityActions.getContextClassLoader();
/* 1109 */     this.log.debug("TCL: " + tcl);
/*      */ 
/* 1111 */     ORB orb = null;
/* 1112 */     HandleDelegate hd = null;
/*      */     try
/*      */     {
/* 1115 */       orb = (ORB)this.server.getAttribute(ORB_NAME, "ORB");
/* 1116 */       hd = (HandleDelegate)this.server.getAttribute(ORB_NAME, "HandleDelegate");
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1120 */       this.log.debug("Unable to retrieve orb" + t.toString());
/*      */     }
/*      */ 
/* 1125 */     Context ctx = (Context)new InitialContext().lookup("java:comp");
/* 1126 */     Object id = ENCFactory.getCurrentId();
/* 1127 */     this.log.debug("Using java:comp using id=" + id);
/*      */ 
/* 1130 */     if (orb != null)
/*      */     {
/* 1132 */       NonSerializableFactory.rebind(ctx, "ORB", orb);
/* 1133 */       this.log.debug("Bound java:comp/ORB for EJB: " + getBeanMetaData().getEjbName());
/*      */ 
/* 1135 */       NonSerializableFactory.rebind(ctx, "HandleDelegate", hd);
/* 1136 */       this.log.debug("Bound java:comp/HandleDelegate for EJB: " + getBeanMetaData().getEjbName());
/*      */     }
/*      */ 
/* 1140 */     ctx.bind("TransactionSynchronizationRegistry", new LinkRef("java:TransactionSynchronizationRegistry"));
/* 1141 */     this.log.debug("Linked java:comp/TransactionSynchronizationRegistry to JNDI name: java:TransactionSynchronizationRegistry");
/*      */ 
/* 1143 */     Context envCtx = ctx.createSubcontext("env");
/*      */ 
/* 1147 */     Iterator i = beanMetaData.getEnvironmentEntries();
/* 1148 */     while (i.hasNext())
/*      */     {
/* 1150 */       EnvEntryMetaData entry = (EnvEntryMetaData)i.next();
/* 1151 */       this.log.debug("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue());
/*      */ 
/* 1153 */       EnvEntryBinder.bindEnvEntry(envCtx, entry);
/*      */     }
/*      */ 
/* 1159 */     Iterator i = beanMetaData.getEjbReferences();
/* 1160 */     while (i.hasNext())
/*      */     {
/* 1162 */       EjbRefMetaData ref = (EjbRefMetaData)i.next();
/* 1163 */       this.log.debug("Binding an EJBReference " + ref.getName());
/*      */ 
/* 1165 */       if (ref.getLink() != null)
/*      */       {
/* 1168 */         String linkName = ref.getLink();
/* 1169 */         String jndiName = ref.getJndiName();
/* 1170 */         this.log.debug("Binding " + ref.getName() + " to ejb-link: " + linkName + " -> " + jndiName);
/*      */ 
/* 1172 */         if (jndiName == null)
/*      */         {
/* 1174 */           String msg = "Failed to resolve ejb-link: " + linkName + " from ejb-ref: " + ref.getName() + " in ejb: " + beanMetaData.getEjbName();
/* 1175 */           throw new DeploymentException(msg);
/*      */         }
/*      */ 
/* 1178 */         Util.bind(envCtx, ref.getName(), new LinkRef(jndiName));
/*      */       }
/*      */       else
/*      */       {
/* 1184 */         Iterator it = beanMetaData.getInvokerBindings();
/* 1185 */         Reference reference = null;
/* 1186 */         while (it.hasNext())
/*      */         {
/* 1188 */           String invokerBinding = (String)it.next();
/*      */ 
/* 1190 */           String name = ref.getInvokerBinding(invokerBinding);
/*      */ 
/* 1192 */           if (name == null)
/* 1193 */             name = ref.getJndiName();
/* 1194 */           if (name == null)
/*      */           {
/* 1196 */             throw new DeploymentException("ejb-ref " + ref.getName() + ", expected either ejb-link in ejb-jar.xml or " + "jndi-name in jboss.xml");
/*      */           }
/*      */ 
/* 1199 */           StringRefAddr addr = new StringRefAddr(invokerBinding, name);
/* 1200 */           this.log.debug("adding " + invokerBinding + ":" + name + " to Reference");
/*      */ 
/* 1202 */           if (reference == null)
/*      */           {
/* 1204 */             reference = new Reference("javax.naming.LinkRef", ENCThreadLocalKey.class.getName(), null);
/*      */           }
/* 1206 */           reference.add(addr);
/*      */         }
/*      */ 
/* 1210 */         if (reference != null)
/*      */         {
/* 1212 */           if (ref.getJndiName() != null)
/*      */           {
/* 1215 */             StringRefAddr addr = new StringRefAddr("default", ref.getJndiName());
/* 1216 */             reference.add(addr);
/*      */           }
/* 1218 */           if ((reference.size() == 1) && (reference.get("default") == null))
/*      */           {
/* 1224 */             StringRefAddr addr = (StringRefAddr)reference.get(0);
/* 1225 */             String target = (String)addr.getContent();
/* 1226 */             StringRefAddr addr1 = new StringRefAddr("default", target);
/* 1227 */             reference.add(addr1);
/*      */           }
/* 1229 */           Util.bind(envCtx, ref.getName(), reference);
/*      */         }
/*      */         else
/*      */         {
/* 1234 */           if (ref.getJndiName() == null)
/*      */           {
/* 1236 */             throw new DeploymentException("ejb-ref " + ref.getName() + ", expected either ejb-link in ejb-jar.xml " + "or jndi-name in jboss.xml");
/*      */           }
/* 1238 */           Util.bind(envCtx, ref.getName(), new LinkRef(ref.getJndiName()));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1246 */     Iterator i = beanMetaData.getEjbLocalReferences();
/* 1247 */     while (i.hasNext())
/*      */     {
/* 1249 */       EjbLocalRefMetaData ref = (EjbLocalRefMetaData)i.next();
/* 1250 */       String refName = ref.getName();
/* 1251 */       this.log.debug("Binding an EJBLocalReference " + ref.getName());
/*      */ 
/* 1253 */       if (ref.getLink() != null)
/*      */       {
/* 1256 */         this.log.debug("Binding " + refName + " to bean source: " + ref.getLink());
/*      */ 
/* 1258 */         String jndiName = ref.getJndiName();
/*      */ 
/* 1260 */         Util.bind(envCtx, ref.getName(), new LinkRef(jndiName));
/*      */       }
/*      */       else
/*      */       {
/* 1265 */         if (ref.getJndiName() == null)
/*      */         {
/* 1267 */           throw new DeploymentException("ejb-local-ref " + ref.getName() + ", expected either ejb-link in ejb-jar.xml " + "or local-jndi-name in jboss.xml");
/*      */         }
/* 1269 */         Util.bind(envCtx, ref.getName(), new LinkRef(ref.getJndiName()));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1276 */     ClassLoader loader = this.unit.getClassLoader();
/* 1277 */     UnifiedVirtualFile vfsRoot = new VirtualFileAdaptor(this.unit.getRoot());
/* 1278 */     Iterator serviceReferences = beanMetaData.getServiceReferences();
/* 1279 */     if (serviceReferences != null)
/*      */     {
/* 1281 */       while (serviceReferences.hasNext())
/*      */       {
/* 1283 */         ServiceReferenceMetaData sref = (ServiceReferenceMetaData)serviceReferences.next();
/* 1284 */         String refName = sref.getServiceRefName();
/* 1285 */         new ServiceReferenceHandler().bindServiceRef(envCtx, refName, vfsRoot, loader, sref);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1292 */     Iterator i = beanMetaData.getResourceReferences();
/*      */ 
/* 1295 */     ApplicationMetaData application = beanMetaData.getApplicationMetaData();
/*      */ 
/* 1297 */     while (i.hasNext())
/*      */     {
/* 1299 */       ResourceRefMetaData ref = (ResourceRefMetaData)i.next();
/*      */ 
/* 1301 */       String resourceName = ref.getResourceName();
/* 1302 */       String finalName = application.getResourceByName(resourceName);
/* 1303 */       String resType = ref.getType();
/*      */ 
/* 1306 */       if (finalName == null) {
/* 1307 */         finalName = ref.getJndiName();
/*      */       }
/* 1309 */       if ((finalName == null) && (!resType.equals("java.net.URL")))
/*      */       {
/* 1314 */         if (ref.getType().equals("javax.sql.DataSource"))
/*      */         {
/* 1317 */           Context dsCtx = new InitialContext();
/*      */           try
/*      */           {
/* 1321 */             dsCtx.lookup("java:/DefaultDS");
/* 1322 */             finalName = "java:/DefaultDS";
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/* 1326 */             this.log.debug("failed to lookup DefaultDS; ignoring", e);
/*      */           }
/*      */           finally
/*      */           {
/* 1330 */             dsCtx.close();
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1336 */         if (finalName == null)
/*      */         {
/* 1338 */           this.log.warn("No resource manager found for " + ref.getResourceName());
/* 1339 */           continue;
/*      */         }
/*      */       }
/*      */ 
/* 1343 */       if (resType.equals("java.net.URL"))
/*      */       {
/* 1346 */         if (ref.getResURL() != null)
/*      */         {
/* 1349 */           this.log.debug("Binding URL: " + ref.getRefName() + " to JDNI ENC as: " + ref.getResURL());
/* 1350 */           URL resURL = new URL(ref.getResURL());
/* 1351 */           Util.bind(envCtx, ref.getRefName(), resURL);
/*      */         }
/*      */         else
/*      */         {
/* 1355 */           this.log.debug("Binding URL: " + ref.getRefName() + " to: " + finalName);
/* 1356 */           Object bind = null;
/* 1357 */           if (ref.getJndiName() != null)
/*      */           {
/* 1360 */             bind = new LinkRef(finalName);
/*      */           }
/*      */           else
/*      */           {
/* 1365 */             bind = new URL(finalName);
/*      */           }
/* 1367 */           Util.bind(envCtx, ref.getRefName(), bind);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1373 */         this.log.debug("Binding resource manager: " + ref.getRefName() + " to JDNI ENC as: " + finalName);
/* 1374 */         Util.bind(envCtx, ref.getRefName(), new LinkRef(finalName));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1381 */     Iterator i = beanMetaData.getResourceEnvReferences();
/* 1382 */     while (i.hasNext())
/*      */     {
/* 1384 */       ResourceEnvRefMetaData resRef = (ResourceEnvRefMetaData)i.next();
/* 1385 */       String encName = resRef.getRefName();
/* 1386 */       String jndiName = resRef.getJndiName();
/*      */ 
/* 1388 */       this.log.debug("Binding env resource: " + encName + " to JDNI ENC as: " + jndiName);
/* 1389 */       Util.bind(envCtx, encName, new LinkRef(jndiName));
/*      */     }
/*      */ 
/* 1395 */     Iterator i = beanMetaData.getMessageDestinationReferences();
/*      */ 
/* 1397 */     while (i.hasNext())
/*      */     {
/* 1399 */       MessageDestinationRefMetaData ref = (MessageDestinationRefMetaData)i.next();
/*      */ 
/* 1401 */       String refName = ref.getRefName();
/* 1402 */       String jndiName = ref.getJNDIName();
/* 1403 */       String link = ref.getLink();
/* 1404 */       if (link != null)
/*      */       {
/* 1406 */         if (jndiName == null)
/*      */         {
/* 1408 */           MessageDestinationMetaData messageDestination = getMessageDestination(link);
/* 1409 */           if (messageDestination == null) {
/* 1410 */             throw new DeploymentException("message-destination-ref '" + refName + "' message-destination-link '" + link + "' not found and no jndi-name in jboss.xml");
/*      */           }
/*      */ 
/* 1414 */           String linkJNDIName = messageDestination.getJndiName();
/* 1415 */           if (linkJNDIName == null)
/* 1416 */             this.log.warn("message-destination '" + link + "' has no jndi-name in jboss.xml");
/*      */           else
/* 1418 */             jndiName = linkJNDIName;
/*      */         }
/*      */         else
/*      */         {
/* 1422 */           this.log.warn("message-destination-ref '" + refName + "' ignoring message-destination-link '" + link + "' because it has a jndi-name in jboss.xml");
/*      */         }
/* 1424 */       } else if (jndiName == null)
/* 1425 */         throw new DeploymentException("message-destination-ref '" + refName + "' has no message-destination-link in ejb-jar.xml and no jndi-name in jboss.xml");
/* 1426 */       Util.bind(envCtx, refName, new LinkRef(jndiName));
/*      */     }
/*      */ 
/* 1434 */     String securityDomain = this.metaData.getContainerConfiguration().getSecurityDomain();
/* 1435 */     if (securityDomain == null)
/* 1436 */       securityDomain = this.metaData.getApplicationMetaData().getSecurityDomain();
/* 1437 */     if (securityDomain != null)
/*      */     {
/* 1439 */       this.log.debug("Binding securityDomain: " + securityDomain + " to JDNI ENC as: security/security-domain");
/*      */ 
/* 1441 */       Util.bind(envCtx, "security/security-domain", new LinkRef(securityDomain));
/* 1442 */       Util.bind(envCtx, "security/subject", new LinkRef(securityDomain + "/subject"));
/* 1443 */       Util.bind(envCtx, "security/realmMapping", new LinkRef(securityDomain + "/realmMapping"));
/* 1444 */       Util.bind(envCtx, "security/authorizationMgr", new LinkRef(securityDomain + "/authorizationMgr"));
/*      */     }
/*      */ 
/* 1447 */     this.log.debug("End java:comp/env for EJB: " + beanMetaData.getEjbName());
/*      */   }
/*      */ 
/*      */   public MessageDestinationMetaData getMessageDestination(String link)
/*      */   {
/* 1452 */     return EjbUtil50.findMessageDestination(null, this.unit, link);
/*      */   }
/*      */ 
/*      */   private void teardownEnvironment()
/*      */     throws Exception
/*      */   {
/* 1464 */     Context ctx = (Context)new InitialContext().lookup("java:comp");
/* 1465 */     ctx.unbind("env");
/* 1466 */     this.log.debug("Removed bindings from java:comp/env for EJB: " + getBeanMetaData().getEjbName());
/*      */     try
/*      */     {
/* 1469 */       NonSerializableFactory.unbind("ORB");
/* 1470 */       this.log.debug("Unbound java:comp/ORB for EJB: " + getBeanMetaData().getEjbName());
/*      */ 
/* 1472 */       NonSerializableFactory.unbind("HandleDelegate");
/* 1473 */       this.log.debug("Unbound java:comp/HandleDelegate for EJB: " + getBeanMetaData().getEjbName());
/*      */     }
/*      */     catch (NamingException ignored)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*      */     try
/*      */     {
/*  250 */       EJBOBJECT_REMOVE = EJBObject.class.getMethod("remove", new Class[0]);
/*  251 */       EJB_TIMEOUT = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  255 */       throw new NestedRuntimeException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   class MBeanServerAction
/*      */     implements PrivilegedExceptionAction
/*      */   {
/*      */     private ObjectName target;
/*      */     String method;
/*      */     Object[] args;
/*      */     String[] sig;
/*      */ 
/*      */     MBeanServerAction()
/*      */     {
/*      */     }
/*      */ 
/*      */     MBeanServerAction(ObjectName target, String method, Object[] args, String[] sig)
/*      */     {
/* 1585 */       this.target = target;
/* 1586 */       this.method = method;
/* 1587 */       this.args = args;
/* 1588 */       this.sig = sig;
/*      */     }
/*      */ 
/*      */     public Object run() throws Exception
/*      */     {
/* 1593 */       Object rtnValue = Container.this.server.invoke(this.target, this.method, this.args, this.sig);
/* 1594 */       return rtnValue;
/*      */     }
/*      */ 
/*      */     Object invoke(ObjectName target, String method, Object[] args, String[] sig) throws Exception
/*      */     {
/* 1599 */       SecurityManager sm = System.getSecurityManager();
/* 1600 */       Object rtnValue = null;
/* 1601 */       if (sm == null)
/*      */       {
/* 1604 */         rtnValue = Container.this.server.invoke(target, method, args, sig);
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/* 1611 */           MBeanServerAction action = new MBeanServerAction(Container.this, target, method, args, sig);
/* 1612 */           rtnValue = AccessController.doPrivileged(action);
/*      */         }
/*      */         catch (PrivilegedActionException e)
/*      */         {
/* 1616 */           Exception ex = e.getException();
/* 1617 */           throw ex;
/*      */         }
/*      */       }
/* 1620 */       return rtnValue;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected abstract class AbstractContainerInterceptor
/*      */     implements Interceptor
/*      */   {
/* 1489 */     protected final Logger log = Logger.getLogger(getClass());
/*      */ 
/*      */     protected AbstractContainerInterceptor() {
/*      */     }
/*      */ 
/*      */     public void setContainer(Container con) {
/*      */     }
/*      */ 
/*      */     public void setNext(Interceptor interceptor) {
/*      */     }
/*      */ 
/*      */     public Interceptor getNext() {
/* 1501 */       return null;
/*      */     }
/*      */ 
/*      */     public void create()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void start()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void stop()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void destroy()
/*      */     {
/*      */     }
/*      */ 
/*      */     protected void rethrow(Exception e) throws Exception
/*      */     {
/* 1522 */       if ((e instanceof IllegalAccessException))
/*      */       {
/* 1525 */         throw new EJBException(e);
/*      */       }
/* 1527 */       if ((e instanceof InvocationTargetException))
/*      */       {
/* 1529 */         Throwable t = ((InvocationTargetException)e).getTargetException();
/*      */ 
/* 1531 */         if ((t instanceof EJBException))
/*      */         {
/* 1533 */           throw ((EJBException)t);
/*      */         }
/* 1535 */         if ((t instanceof Exception))
/*      */         {
/* 1537 */           throw ((Exception)t);
/*      */         }
/* 1539 */         if ((t instanceof Error))
/*      */         {
/* 1541 */           throw ((Error)t);
/*      */         }
/*      */ 
/* 1545 */         throw new NestedError("Unexpected Throwable", t);
/*      */       }
/*      */ 
/* 1549 */       throw e;
/*      */     }
/*      */ 
/*      */     public void sample(Object s)
/*      */     {
/*      */     }
/*      */ 
/*      */     public Map retrieveStatistic()
/*      */     {
/* 1561 */       return null;
/*      */     }
/*      */ 
/*      */     public void resetStatistic()
/*      */     {
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.Container
 * JD-Core Version:    0.6.0
 */