/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.monitor.EntityLockMonitor;
/*     */ import org.jboss.monitor.LockMonitor;
/*     */ 
/*     */ public class BeanLockManager
/*     */ {
/*     */   private static final int NUMBER_OF_INSTANCES = 40;
/*  43 */   private static Logger log = Logger.getLogger(BeanLockManager.class);
/*     */ 
/*  47 */   private HashMap[] map = new HashMap[40];
/*     */   private Container container;
/*  54 */   private boolean reentrant = false;
/*  55 */   private int txTimeout = 5000;
/*     */   private boolean trace;
/*     */   public Class lockClass;
/*  59 */   protected LockMonitor monitor = null;
/*     */ 
/*     */   private BeanLockManager()
/*     */   {
/*  63 */     for (int i = 0; i < this.map.length; i++)
/*     */     {
/*  65 */       this.map[i] = new HashMap();
/*     */     }
/*     */   }
/*     */ 
/*     */   public BeanLockManager(Container container) {
/*  70 */     this();
/*  71 */     this.container = container;
/*  72 */     this.trace = log.isTraceEnabled();
/*     */     try
/*     */     {
/*  75 */       InitialContext ctx = new InitialContext();
/*  76 */       EntityLockMonitor elm = (EntityLockMonitor)ctx.lookup("EntityLockMonitor");
/*  77 */       String jndiName = container.getBeanMetaData().getContainerObjectNameJndiName();
/*  78 */       this.monitor = elm.getEntityLockMonitor(jndiName);
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public LockMonitor getLockMonitor()
/*     */   {
/*  88 */     return this.monitor;
/*     */   }
/*     */ 
/*     */   private HashMap getHashMap(Object id)
/*     */   {
/*  93 */     int mapInUse = id.hashCode() % 40;
/*  94 */     if (mapInUse > 0)
/*     */     {
/*  96 */       return this.map[mapInUse];
/*     */     }
/*     */ 
/* 100 */     return this.map[(mapInUse * -1)];
/*     */   }
/*     */ 
/*     */   public BeanLock getLock(Object id)
/*     */   {
/* 114 */     if (id == null) {
/* 115 */       throw new IllegalArgumentException("Attempt to get lock ref with a null object");
/*     */     }
/* 117 */     HashMap mapInUse = getHashMap(id);
/*     */ 
/* 119 */     synchronized (mapInUse)
/*     */     {
/* 121 */       BeanLock lock = (BeanLock)mapInUse.get(id);
/* 122 */       if (lock != null)
/*     */       {
/* 124 */         lock.addRef();
/* 125 */         return lock;
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 131 */       BeanLock lock2 = createLock(id);
/* 132 */       synchronized (mapInUse)
/*     */       {
/* 134 */         BeanLock lock = (BeanLock)mapInUse.get(id);
/*     */ 
/* 136 */         if (lock != null)
/*     */         {
/* 138 */           lock.addRef();
/* 139 */           return lock;
/*     */         }
/* 141 */         mapInUse.put(id, lock2);
/* 142 */         lock2.addRef();
/* 143 */         return lock2;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 150 */       log.warn("Failed to initialize lock:" + id, e);
/* 151 */     }throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private BeanLock createLock(Object id)
/*     */     throws Exception
/*     */   {
/* 157 */     BeanLock lock = (BeanLock)this.lockClass.newInstance();
/* 158 */     lock.setId(id);
/* 159 */     lock.setTimeout(this.txTimeout);
/* 160 */     lock.setContainer(this.container);
/*     */ 
/* 162 */     return lock;
/*     */   }
/*     */ 
/*     */   public void removeLockRef(Object id)
/*     */   {
/* 167 */     if (id == null) {
/* 168 */       throw new IllegalArgumentException("Attempt to remove lock ref with a null object");
/*     */     }
/* 170 */     HashMap mapInUse = getHashMap(id);
/*     */ 
/* 172 */     synchronized (mapInUse)
/*     */     {
/* 174 */       BeanLock lock = (BeanLock)mapInUse.get(id);
/*     */ 
/* 176 */       if (lock != null)
/*     */       {
/*     */         try
/*     */         {
/* 180 */           lock.removeRef();
/* 181 */           if (this.trace)
/* 182 */             log.trace("Remove ref lock:" + lock);
/*     */         }
/*     */         finally
/*     */         {
/*     */           Object mapLock;
/* 190 */           if (lock.getRefs() <= 0)
/*     */           {
/* 192 */             Object mapLock = mapInUse.remove(lock.getId());
/* 193 */             if (this.trace)
/* 194 */               log.trace("Lock no longer referenced, lock: " + lock);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean canPassivate(Object id)
/*     */   {
/* 203 */     if (id == null) {
/* 204 */       throw new IllegalArgumentException("Attempt to passivate with a null object");
/*     */     }
/* 206 */     HashMap mapInUse = getHashMap(id);
/* 207 */     synchronized (mapInUse)
/*     */     {
/* 209 */       BeanLock lock = (BeanLock)mapInUse.get(id);
/* 210 */       if (lock == null) {
/* 211 */         throw new IllegalStateException("Attempt to passivate without a lock");
/*     */       }
/* 213 */       return lock.getRefs() <= 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setLockCLass(Class lockClass)
/*     */   {
/* 219 */     this.lockClass = lockClass;
/*     */   }
/*     */ 
/*     */   public void setReentrant(boolean reentrant)
/*     */   {
/* 224 */     this.reentrant = reentrant;
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/* 229 */     this.container = container;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.BeanLockManager
 * JD-Core Version:    0.6.0
 */