/*     */ package org.jboss.deployment.security;
/*     */ 
/*     */ import java.security.Policy;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyConfigurationFactory;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class PolicyConfigurationFacade
/*     */   implements PolicyConfigurationFacadeMBean
/*     */ {
/*  43 */   private static Logger log = Logger.getLogger(PolicyConfigurationFacade.class);
/*     */   private String jaccContextId;
/*     */   private PolicyConfiguration policyConfiguration;
/*     */   private JaccPolicyMBean jaccPolicyMBean;
/*     */   private Object metaData;
/*     */ 
/*     */   public PolicyConfigurationFacade(String id, Object md)
/*     */   {
/*  53 */     if (id == null)
/*  54 */       throw new IllegalArgumentException("Context ID is null");
/*  55 */     if (md == null)
/*  56 */       throw new IllegalArgumentException("Meta Data is null");
/*  57 */     this.jaccContextId = id;
/*  58 */     this.metaData = md;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/*     */     try
/*     */     {
/*  65 */       PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
/*  66 */       this.policyConfiguration = pcf.getPolicyConfiguration(this.jaccContextId, true);
/*     */ 
/*  68 */       JaccPolicyUtil.createPermissions(this.policyConfiguration, this.metaData);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  72 */       new RuntimeException(e);
/*     */     }
/*     */     catch (PolicyContextException e)
/*     */     {
/*  76 */       new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  83 */     this.policyConfiguration = null;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */     try
/*     */     {
/*  90 */       if (this.jaccPolicyMBean != null)
/*     */       {
/*  92 */         this.jaccPolicyMBean.link(this.policyConfiguration);
/*     */       }
/*  94 */       this.policyConfiguration.commit();
/*     */ 
/*  96 */       Policy.getPolicy().refresh();
/*     */     }
/*     */     catch (PolicyContextException e)
/*     */     {
/* 100 */       new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 108 */       this.policyConfiguration.delete();
/*     */     }
/*     */     catch (PolicyContextException e)
/*     */     {
/* 112 */       new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public JaccPolicyMBean getJaccPolicyMBean()
/*     */   {
/* 118 */     return this.jaccPolicyMBean;
/*     */   }
/*     */ 
/*     */   public void setJaccPolicyMBean(JaccPolicyMBean jaccPolicy)
/*     */   {
/* 123 */     this.jaccPolicyMBean = jaccPolicy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.security.PolicyConfigurationFacade
 * JD-Core Version:    0.6.0
 */