/*     */ package org.jboss.deployment.security;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.List;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.ejb.EJBPermissionMapping;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.web.WebPermissionMapping;
/*     */ 
/*     */ public class JaccPolicyUtil
/*     */ {
/*  52 */   public static String IGNORE_ME_NAME = "org.jboss.deployment.security.ignoreMe";
/*     */ 
/*     */   public static List<String> getJaccDeployments(VFSDeploymentUnit unit, Collection<String> ignoreSuffix)
/*     */   {
/*  64 */     ArrayList list = new ArrayList();
/*  65 */     List children = unit.getVFSChildren();
/*  66 */     for (VFSDeploymentUnit child : children)
/*     */     {
/*  68 */       String childName = child.getSimpleName();
/*  69 */       boolean tobeIgnored = false;
/*     */ 
/*  71 */       if (ignoreSuffix != null)
/*     */       {
/*  73 */         for (String ignoreStr : ignoreSuffix)
/*     */         {
/*  75 */           tobeIgnored = false;
/*  76 */           if (childName.endsWith(ignoreStr))
/*     */           {
/*  78 */             tobeIgnored = true;
/*  79 */             break;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*  84 */       if ((childName.endsWith("jar")) && (!tobeIgnored) && (!isEJBDeployment(child))) {
/*     */         continue;
/*     */       }
/*  87 */       if (!tobeIgnored)
/*  88 */         list.add(childName);
/*     */     }
/*  90 */     return list;
/*     */   }
/*     */ 
/*     */   public static boolean isEJBDeployment(VFSDeploymentUnit du)
/*     */   {
/*  97 */     Boolean ignoreMe = (Boolean)du.getAttachment(IGNORE_ME_NAME, Boolean.class);
/*  98 */     if ((ignoreMe != null) && (ignoreMe.booleanValue()))
/*  99 */       return false;
/* 100 */     boolean ejbxml = du.getMetaDataFile("ejb-jar.xml") != null;
/* 101 */     boolean jbossxml = du.getMetaDataFile("jboss.xml") != null;
/* 102 */     return (ejbxml) || (jbossxml);
/*     */   }
/*     */ 
/*     */   public static void createPermissions(PolicyConfiguration policyConfiguration, Object metadata)
/*     */     throws PolicyContextException
/*     */   {
/* 114 */     if (metadata == null)
/* 115 */       throw new IllegalArgumentException("Meta Data is null");
/* 116 */     if (policyConfiguration == null) {
/* 117 */       throw new IllegalArgumentException("Policy Configuration is null");
/*     */     }
/* 119 */     if ((metadata instanceof JBossWebMetaData))
/*     */     {
/* 121 */       JBossWebMetaData wmd = (JBossWebMetaData)metadata;
/* 122 */       WebPermissionMapping.createPermissions(wmd, policyConfiguration);
/*     */     }
/* 124 */     else if ((metadata instanceof JBossEnterpriseBeanMetaData))
/*     */     {
/* 126 */       JBossEnterpriseBeanMetaData bmd = (JBossEnterpriseBeanMetaData)metadata;
/* 127 */       EJBPermissionMapping.createPermissions(bmd, policyConfiguration);
/*     */     }
/* 129 */     else if ((metadata instanceof JBossMetaData))
/*     */     {
/* 131 */       JBossMetaData jmd = (JBossMetaData)metadata;
/* 132 */       JBossEnterpriseBeansMetaData beans = jmd.getEnterpriseBeans();
/* 133 */       for (JBossEnterpriseBeanMetaData bmd : beans)
/*     */       {
/* 135 */         EJBPermissionMapping.createPermissions(bmd, policyConfiguration);
/*     */       }
/*     */     }
/*     */     else {
/* 139 */       throw new IllegalStateException("Unknown metadata");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.security.JaccPolicyUtil
 * JD-Core Version:    0.6.0
 */