/*     */ package org.jboss.deployment.security;
/*     */ 
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyConfigurationFactory;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JaccPolicy
/*     */   implements JaccPolicyMBean
/*     */ {
/*  40 */   private static Logger log = Logger.getLogger(JaccPolicy.class);
/*  41 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  43 */   private PolicyConfiguration parentPC = null;
/*  44 */   private String contextID = null;
/*     */   private Object metaData;
/*  48 */   private Boolean standaloneDeployment = Boolean.FALSE;
/*     */ 
/*     */   public JaccPolicy(String id)
/*     */   {
/*  58 */     if (id == null)
/*  59 */       throw new IllegalArgumentException("Jacc Context Id passed is null");
/*  60 */     this.contextID = id;
/*     */   }
/*     */ 
/*     */   public JaccPolicy(String id, Object metaData, Boolean standaloneDeployment)
/*     */   {
/*  65 */     this(id);
/*  66 */     this.metaData = metaData;
/*  67 */     this.standaloneDeployment = standaloneDeployment;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/*     */     try
/*     */     {
/*  77 */       createPolicyConfiguration();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  81 */       throw new RuntimeException(e);
/*     */     }
/*  83 */     if (this.standaloneDeployment == Boolean.TRUE)
/*     */     {
/*     */       try
/*     */       {
/*  87 */         if (this.metaData != null)
/*  88 */           JaccPolicyUtil.createPermissions(this.parentPC, this.metaData);
/*     */         else {
/*  90 */           log.warn("Cannot create permissions with 'null' metaData for id=" + this.contextID);
/*     */         }
/*     */       }
/*     */       catch (PolicyContextException e)
/*     */       {
/*  95 */         throw new RuntimeException("Cannot create permissions:", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 105 */     this.parentPC = null;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */     try
/*     */     {
/* 116 */       this.parentPC.commit();
/*     */     }
/*     */     catch (PolicyContextException e)
/*     */     {
/* 120 */       log.error("Cannot commit Parent Policy Configuration:", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 131 */       this.parentPC.delete();
/*     */     }
/*     */     catch (PolicyContextException e)
/*     */     {
/* 135 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void link(PolicyConfiguration pc)
/*     */     throws PolicyContextException
/*     */   {
/* 145 */     if (this.trace)
/* 146 */       log.trace("Linking " + pc + " to parent pc=" + this.parentPC);
/* 147 */     if (pc == null)
/* 148 */       throw new IllegalArgumentException("pc is null");
/*     */     try
/*     */     {
/* 151 */       createPolicyConfiguration();
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 155 */       throw new RuntimeException(e);
/*     */     }
/* 157 */     this.parentPC.linkConfiguration(pc);
/*     */   }
/*     */ 
/*     */   private void createPolicyConfiguration() throws PolicyContextException, ClassNotFoundException
/*     */   {
/* 162 */     if (this.parentPC == null)
/*     */     {
/* 164 */       PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
/* 165 */       this.parentPC = pcf.getPolicyConfiguration(this.contextID, true);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.security.JaccPolicy
 * JD-Core Version:    0.6.0
 */