/*     */ package org.jboss.deployment.scanner;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployment.DefaultDeploymentSorter;
/*     */ import org.jboss.deployment.Deployer;
/*     */ import org.jboss.deployment.IncompleteDeploymentException;
/*     */ import org.jboss.deployment.MainDeployerMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.net.protocol.URLLister;
/*     */ import org.jboss.net.protocol.URLLister.URLFilter;
/*     */ import org.jboss.net.protocol.URLListerFactory;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ 
/*     */ public class URLDeploymentScanner extends AbstractDeploymentScanner
/*     */   implements DeploymentScanner, URLDeploymentScannerMBean
/*     */ {
/*     */   protected Set skipSet;
/*     */   protected List urlList;
/*     */   protected Set deployedSet;
/*     */   protected URLListerFactory listerFactory;
/*     */   protected File serverHome;
/*     */   protected URL serverHomeURL;
/*     */   protected Comparator sorter;
/*     */   protected URLLister.URLFilter filter;
/*     */   protected IncompleteDeploymentException lastIncompleteDeploymentException;
/*     */   protected boolean doRecursiveSearch;
/*     */ 
/*     */   public URLDeploymentScanner()
/*     */   {
/*  67 */     this.skipSet = Collections.synchronizedSet(new HashSet());
/*     */ 
/*  70 */     this.urlList = Collections.synchronizedList(new ArrayList());
/*     */ 
/*  73 */     this.deployedSet = Collections.synchronizedSet(new HashSet());
/*     */ 
/*  76 */     this.listerFactory = new URLListerFactory();
/*     */ 
/*  94 */     this.doRecursiveSearch = true;
/*     */   }
/*     */ 
/*     */   public void setRecursiveSearch(boolean recurse)
/*     */   {
/* 101 */     this.doRecursiveSearch = recurse;
/*     */   }
/*     */ 
/*     */   public boolean getRecursiveSearch()
/*     */   {
/* 109 */     return this.doRecursiveSearch;
/*     */   }
/*     */ 
/*     */   public void setURLList(List list)
/*     */   {
/* 117 */     if (list == null) {
/* 118 */       throw new NullArgumentException("list");
/*     */     }
/*     */ 
/* 121 */     this.urlList.clear();
/*     */ 
/* 123 */     Iterator iter = list.iterator();
/* 124 */     while (iter.hasNext())
/*     */     {
/* 126 */       URL url = (URL)iter.next();
/* 127 */       if (url == null) {
/* 128 */         throw new NullArgumentException("list element");
/*     */       }
/* 130 */       addURL(url);
/*     */     }
/*     */ 
/* 133 */     this.log.debug("URL list: " + this.urlList);
/*     */   }
/*     */ 
/*     */   public void setURLComparator(String classname)
/*     */     throws ClassNotFoundException, IllegalAccessException, InstantiationException
/*     */   {
/* 145 */     this.sorter = ((Comparator)Thread.currentThread().getContextClassLoader().loadClass(classname).newInstance());
/*     */   }
/*     */ 
/*     */   public String getURLComparator()
/*     */   {
/* 153 */     if (this.sorter == null)
/* 154 */       return null;
/* 155 */     return this.sorter.getClass().getName();
/*     */   }
/*     */ 
/*     */   public void setFilter(String classname)
/*     */     throws ClassNotFoundException, IllegalAccessException, InstantiationException
/*     */   {
/* 166 */     Class filterClass = Thread.currentThread().getContextClassLoader().loadClass(classname);
/* 167 */     this.filter = ((URLLister.URLFilter)filterClass.newInstance());
/*     */   }
/*     */ 
/*     */   public String getFilter()
/*     */   {
/* 175 */     if (this.filter == null)
/* 176 */       return null;
/* 177 */     return this.filter.getClass().getName();
/*     */   }
/*     */ 
/*     */   public void setFilterInstance(URLLister.URLFilter filter)
/*     */   {
/* 188 */     this.filter = filter;
/*     */   }
/*     */ 
/*     */   public URLLister.URLFilter getFilterInstance()
/*     */   {
/* 196 */     return this.filter;
/*     */   }
/*     */ 
/*     */   public List getURLList()
/*     */   {
/* 205 */     return new ArrayList(this.urlList);
/*     */   }
/*     */ 
/*     */   public void addURL(URL url)
/*     */   {
/* 213 */     if (url == null) {
/* 214 */       throw new NullArgumentException("url");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 219 */       url.openConnection().connect();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 224 */       this.log.warn("addURL(), caught " + e.getClass().getName() + ": " + e.getMessage());
/*     */     }
/* 226 */     this.urlList.add(url);
/*     */ 
/* 228 */     this.log.debug("Added url: " + url);
/*     */   }
/*     */ 
/*     */   public void removeURL(URL url)
/*     */   {
/* 236 */     if (url == null) {
/* 237 */       throw new NullArgumentException("url");
/*     */     }
/* 239 */     boolean success = this.urlList.remove(url);
/* 240 */     if (success)
/*     */     {
/* 242 */       this.log.debug("Removed url: " + url);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean hasURL(URL url)
/*     */   {
/* 251 */     if (url == null) {
/* 252 */       throw new NullArgumentException("url");
/*     */     }
/* 254 */     return this.urlList.contains(url);
/*     */   }
/*     */ 
/*     */   public void suspendDeployment(URL url)
/*     */   {
/* 270 */     if (url == null) {
/* 271 */       throw new NullArgumentException("url");
/*     */     }
/* 273 */     if (this.skipSet.add(url))
/* 274 */       this.log.debug("Deployment URL added to skipSet: " + url);
/*     */     else
/* 276 */       throw new IllegalStateException("Deployment URL already suspended: " + url);
/*     */   }
/*     */ 
/*     */   public void resumeDeployment(URL url, boolean markUpToDate)
/*     */   {
/* 290 */     if (url == null) {
/* 291 */       throw new NullArgumentException("url");
/*     */     }
/* 293 */     if (this.skipSet.contains(url))
/*     */     {
/*     */       Iterator i;
/* 295 */       if (markUpToDate)
/*     */       {
/* 298 */         for (i = this.deployedSet.iterator(); i.hasNext(); )
/*     */         {
/* 300 */           DeployedURL deployedURL = (DeployedURL)i.next();
/* 301 */           if (deployedURL.url.equals(url))
/*     */           {
/* 304 */             this.log.debug("Marking up-to-date: " + url);
/* 305 */             deployedURL.deployed();
/* 306 */             break;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 311 */       this.skipSet.remove(url);
/* 312 */       this.log.debug("Deployment URL removed from skipSet: " + url);
/*     */     }
/*     */     else
/*     */     {
/* 316 */       throw new IllegalStateException("Deployment URL not suspended: " + url);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String listDeployedURLs()
/*     */   {
/* 327 */     StringBuffer sbuf = new StringBuffer();
/* 328 */     for (Iterator i = this.deployedSet.iterator(); i.hasNext(); )
/*     */     {
/* 330 */       URL url = ((DeployedURL)i.next()).url;
/* 331 */       if (sbuf.length() > 0)
/*     */       {
/* 333 */         sbuf.append("\n").append(url);
/*     */       }
/*     */       else
/*     */       {
/* 337 */         sbuf.append(url);
/*     */       }
/*     */     }
/* 340 */     return sbuf.toString();
/*     */   }
/*     */ 
/*     */   public void setURLs(String listspec)
/*     */     throws MalformedURLException
/*     */   {
/* 352 */     if (listspec == null) {
/* 353 */       throw new NullArgumentException("listspec");
/*     */     }
/* 355 */     List list = new LinkedList();
/*     */ 
/* 357 */     StringTokenizer stok = new StringTokenizer(listspec, ",");
/* 358 */     while (stok.hasMoreTokens())
/*     */     {
/* 360 */       String urlspec = stok.nextToken().trim();
/* 361 */       this.log.debug("Adding URL from spec: " + urlspec);
/*     */ 
/* 363 */       URL url = makeURL(urlspec);
/* 364 */       this.log.debug("URL: " + url);
/*     */ 
/* 366 */       list.add(url);
/*     */     }
/*     */ 
/* 369 */     setURLList(list);
/*     */   }
/*     */ 
/*     */   protected URL makeURL(String urlspec)
/*     */     throws MalformedURLException
/*     */   {
/* 379 */     urlspec = StringPropertyReplacer.replaceProperties(urlspec);
/* 380 */     return new URL(this.serverHomeURL, urlspec);
/*     */   }
/*     */ 
/*     */   public void addURL(String urlspec)
/*     */     throws MalformedURLException
/*     */   {
/* 388 */     addURL(makeURL(urlspec));
/*     */   }
/*     */ 
/*     */   public void removeURL(String urlspec)
/*     */     throws MalformedURLException
/*     */   {
/* 396 */     removeURL(makeURL(urlspec));
/*     */   }
/*     */ 
/*     */   public boolean hasURL(String urlspec)
/*     */     throws MalformedURLException
/*     */   {
/* 404 */     return hasURL(makeURL(urlspec));
/*     */   }
/*     */ 
/*     */   protected void deploy(DeployedURL du)
/*     */   {
/* 413 */     if (this.deployer == null) {
/* 414 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 418 */       if (this.log.isTraceEnabled()) {
/* 419 */         this.log.trace("Deploying: " + du);
/*     */       }
/* 421 */       this.deployer.deploy(du.url);
/*     */     }
/*     */     catch (IncompleteDeploymentException e)
/*     */     {
/* 425 */       this.lastIncompleteDeploymentException = e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 429 */       this.log.debug("Failed to deploy: " + du, e);
/*     */     }
/*     */ 
/* 432 */     du.deployed();
/*     */ 
/* 434 */     if (!this.deployedSet.contains(du))
/*     */     {
/* 436 */       this.deployedSet.add(du);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void undeploy(DeployedURL du)
/*     */   {
/*     */     try
/*     */     {
/* 447 */       if (this.log.isTraceEnabled()) {
/* 448 */         this.log.trace("Undeploying: " + du);
/*     */       }
/* 450 */       this.deployer.undeploy(du.url);
/* 451 */       this.deployedSet.remove(du);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 455 */       this.log.error("Failed to undeploy: " + du, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isDeployed(URL url)
/*     */   {
/* 464 */     DeployedURL du = new DeployedURL(url);
/* 465 */     return this.deployedSet.contains(du);
/*     */   }
/*     */ 
/*     */   public synchronized void scan() throws Exception
/*     */   {
/* 470 */     this.lastIncompleteDeploymentException = null;
/* 471 */     if (this.urlList == null) {
/* 472 */       throw new IllegalStateException("not initialized");
/*     */     }
/* 474 */     updateSorter();
/*     */ 
/* 476 */     boolean trace = this.log.isTraceEnabled();
/* 477 */     List urlsToDeploy = new LinkedList();
/*     */ 
/* 480 */     if (trace)
/*     */     {
/* 482 */       this.log.trace("Scanning for new deployments");
/*     */     }
/*     */     Iterator i;
/* 484 */     synchronized (this.urlList)
/*     */     {
/* 486 */       for (i = this.urlList.iterator(); i.hasNext(); )
/*     */       {
/* 488 */         URL url = (URL)i.next();
/*     */         try
/*     */         {
/* 491 */           if (url.toString().endsWith("/"))
/*     */           {
/* 494 */             URLLister lister = this.listerFactory.createURLLister(url);
/*     */ 
/* 497 */             urlsToDeploy.addAll(lister.listMembers(url, this.filter, this.doRecursiveSearch));
/*     */           }
/*     */           else
/*     */           {
/* 504 */             url.openConnection().connect();
/* 505 */             urlsToDeploy.add(url);
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 514 */           this.log.warn("Scan URL, caught " + e.getClass().getName() + ": " + e.getMessage());
/*     */ 
/* 522 */           return;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 527 */     if (trace)
/*     */     {
/* 529 */       this.log.trace("Updating existing deployments");
/*     */     }
/* 531 */     LinkedList urlsToRemove = new LinkedList();
/* 532 */     LinkedList urlsToCheckForUpdate = new LinkedList();
/*     */     Iterator i;
/* 533 */     synchronized (this.deployedSet)
/*     */     {
/* 536 */       for (i = this.deployedSet.iterator(); i.hasNext(); )
/*     */       {
/* 538 */         DeployedURL deployedURL = (DeployedURL)i.next();
/*     */ 
/* 540 */         if (this.skipSet.contains(deployedURL.url))
/*     */         {
/* 542 */           if (trace) {
/* 543 */             this.log.trace("Skipping update/removal check for: " + deployedURL.url);
/*     */           }
/*     */ 
/*     */         }
/* 547 */         else if (urlsToDeploy.contains(deployedURL.url))
/*     */         {
/* 549 */           urlsToCheckForUpdate.add(deployedURL);
/*     */         }
/*     */         else
/*     */         {
/* 553 */           urlsToRemove.add(deployedURL);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 563 */     for (Iterator i = urlsToRemove.iterator(); i.hasNext(); )
/*     */     {
/* 565 */       DeployedURL deployedURL = (DeployedURL)i.next();
/* 566 */       if (trace)
/*     */       {
/* 568 */         this.log.trace("Removing " + deployedURL.url);
/*     */       }
/* 570 */       undeploy(deployedURL);
/*     */     }
/*     */ 
/* 578 */     ArrayList urlsToUpdate = new ArrayList(urlsToCheckForUpdate.size());
/* 579 */     for (Iterator i = urlsToCheckForUpdate.iterator(); i.hasNext(); )
/*     */     {
/* 581 */       DeployedURL deployedURL = (DeployedURL)i.next();
/* 582 */       if (deployedURL.isModified())
/*     */       {
/* 584 */         if (trace)
/*     */         {
/* 586 */           this.log.trace("Re-deploying " + deployedURL.url);
/*     */         }
/* 588 */         urlsToUpdate.add(deployedURL);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 593 */     Collections.sort(urlsToUpdate, new Comparator()
/*     */     {
/*     */       public int compare(Object o1, Object o2)
/*     */       {
/* 597 */         return URLDeploymentScanner.this.sorter.compare(((URLDeploymentScanner.DeployedURL)o1).url, ((URLDeploymentScanner.DeployedURL)o2).url);
/*     */       }
/*     */     });
/* 602 */     for (int i = urlsToUpdate.size() - 1; i >= 0; i--)
/*     */     {
/* 604 */       undeploy((DeployedURL)urlsToUpdate.get(i));
/*     */     }
/*     */ 
/* 608 */     for (int i = 0; i < urlsToUpdate.size(); i++)
/*     */     {
/* 610 */       deploy((DeployedURL)urlsToUpdate.get(i));
/*     */     }
/*     */ 
/* 617 */     Collections.sort(urlsToDeploy, this.sorter);
/* 618 */     for (Iterator i = urlsToDeploy.iterator(); i.hasNext(); )
/*     */     {
/* 620 */       URL url = (URL)i.next();
/* 621 */       DeployedURL deployedURL = new DeployedURL(url);
/* 622 */       if (!this.deployedSet.contains(deployedURL))
/*     */       {
/* 624 */         if (this.skipSet.contains(url))
/*     */         {
/* 626 */           if (trace)
/* 627 */             this.log.trace("Skipping deployment of: " + url);
/*     */         }
/*     */         else
/*     */         {
/* 631 */           if (trace) {
/* 632 */             this.log.trace("Deploying " + deployedURL.url);
/*     */           }
/* 634 */           deploy(deployedURL);
/*     */         }
/*     */       }
/* 637 */       i.remove();
/*     */ 
/* 640 */       if ((i.hasNext()) && (updateSorter()))
/*     */       {
/* 642 */         Collections.sort(urlsToDeploy, this.sorter);
/* 643 */         i = urlsToDeploy.iterator();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 648 */     if (this.lastIncompleteDeploymentException != null)
/*     */     {
/*     */       try
/*     */       {
/* 652 */         Object[] args = new Object[0];
/* 653 */         String[] sig = new String[0];
/* 654 */         getServer().invoke(getDeployer(), "checkIncompleteDeployments", args, sig);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 659 */         Throwable t = JMXExceptionDecoder.decode(e);
/* 660 */         this.log.error(t);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean updateSorter()
/*     */   {
/* 668 */     if ((this.sorter instanceof DefaultDeploymentSorter))
/*     */     {
/* 670 */       DefaultDeploymentSorter defaultSorter = (DefaultDeploymentSorter)this.sorter;
/* 671 */       if (defaultSorter.getSuffixOrder() != this.mainDeployer.getSuffixOrder())
/*     */       {
/* 673 */         defaultSorter.setSuffixOrder(this.mainDeployer.getSuffixOrder());
/* 674 */         return true;
/*     */       }
/*     */     }
/* 677 */     return false;
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 689 */     ServerConfig serverConfig = ServerConfigLocator.locate();
/* 690 */     this.serverHome = serverConfig.getServerHomeDir();
/* 691 */     this.serverHomeURL = serverConfig.getServerHomeURL();
/*     */ 
/* 693 */     return super.preRegister(server, name);
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 699 */     if (this.filter == null)
/*     */     {
/* 701 */       throw new IllegalStateException("'FilterInstance' attribute not configured");
/*     */     }
/* 703 */     if (this.sorter == null)
/*     */     {
/* 705 */       throw new IllegalStateException("'URLComparator' attribute not configured");
/*     */     }
/*     */ 
/* 708 */     super.createService();
/*     */   }
/*     */ 
/*     */   protected class DeployedURL
/*     */   {
/*     */     public URL url;
/*     */     public URL watchUrl;
/*     */     public long deployedLastModified;
/*     */ 
/*     */     public DeployedURL(URL url)
/*     */     {
/* 729 */       this.url = url;
/*     */     }
/*     */ 
/*     */     public void deployed()
/*     */     {
/* 734 */       this.deployedLastModified = getLastModified();
/*     */     }
/*     */ 
/*     */     public boolean isFile() {
/* 738 */       return this.url.getProtocol().equals("file");
/*     */     }
/*     */ 
/*     */     public File getFile()
/*     */     {
/* 743 */       return new File(this.url.getFile());
/*     */     }
/*     */ 
/*     */     public boolean isRemoved()
/*     */     {
/* 748 */       if (isFile())
/*     */       {
/* 750 */         File file = getFile();
/* 751 */         return !file.exists();
/*     */       }
/* 753 */       return false;
/*     */     }
/*     */ 
/*     */     public long getLastModified()
/*     */     {
/* 758 */       if (this.watchUrl == null)
/*     */       {
/*     */         try
/*     */         {
/* 762 */           Object o = URLDeploymentScanner.this.getServer().invoke(URLDeploymentScanner.this.getDeployer(), "getWatchUrl", new Object[] { this.url }, new String[] { URL.class.getName() });
/*     */ 
/* 768 */           this.watchUrl = (o == null ? this.url : (URL)o);
/* 769 */           URLDeploymentScanner.this.getLog().debug("Watch URL for: " + this.url + " -> " + this.watchUrl);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 773 */           this.watchUrl = this.url;
/* 774 */           URLDeploymentScanner.this.getLog().debug("Unable to obtain watchUrl from deployer. Use url: " + this.url, e);
/*     */         }
/*     */       }
/*     */       try
/*     */       {
/*     */         URLConnection connection;
/*     */         URLConnection connection;
/* 781 */         if (this.watchUrl != null)
/*     */         {
/* 783 */           connection = this.watchUrl.openConnection();
/*     */         }
/*     */         else
/*     */         {
/* 787 */           connection = this.url.openConnection();
/*     */         }
/*     */ 
/* 792 */         long lastModified = connection.getLastModified();
/*     */ 
/* 794 */         return lastModified;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 798 */         URLDeploymentScanner.this.log.warn("Failed to check modification of deployed url: " + this.url, e);
/*     */       }
/* 800 */       return -1L;
/*     */     }
/*     */ 
/*     */     public boolean isModified()
/*     */     {
/* 805 */       long lastModified = getLastModified();
/* 806 */       if (lastModified == -1L)
/*     */       {
/* 809 */         return false;
/*     */       }
/* 811 */       return this.deployedLastModified != lastModified;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 816 */       return this.url.hashCode();
/*     */     }
/*     */ 
/*     */     public boolean equals(Object other)
/*     */     {
/* 821 */       if ((other instanceof DeployedURL))
/*     */       {
/* 823 */         return ((DeployedURL)other).url.equals(this.url);
/*     */       }
/* 825 */       return false;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 830 */       return super.toString() + "{ url=" + this.url + ", deployedLastModified=" + this.deployedLastModified + " }";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.scanner.URLDeploymentScanner
 * JD-Core Version:    0.6.0
 */