/*     */ package org.jboss.deployment.scanner;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Comparator;
/*     */ import org.jboss.deployment.DefaultDeploymentSorter;
/*     */ import org.jboss.deployment.DeploymentSorter;
/*     */ 
/*     */ public class PrefixDeploymentSorter
/*     */   implements Comparator, DefaultDeploymentSorter
/*     */ {
/*  44 */   private DeploymentSorter sorter = new DeploymentSorter();
/*     */ 
/*     */   public String[] getSuffixOrder()
/*     */   {
/*  48 */     return this.sorter.getSuffixOrder();
/*     */   }
/*     */ 
/*     */   public void setSuffixOrder(String[] suffixOrder)
/*     */   {
/*  53 */     this.sorter.setSuffixOrder(suffixOrder);
/*     */   }
/*     */ 
/*     */   public int compare(Object o1, Object o2)
/*     */   {
/*  61 */     int comp = getPrefixValue((URL)o1) - getPrefixValue((URL)o2);
/*     */ 
/*  63 */     return comp == 0 ? this.sorter.compare(o1, o2) : comp;
/*     */   }
/*     */ 
/*     */   private int getPrefixValue(URL url)
/*     */   {
/*  71 */     String path = url.getPath();
/*  72 */     int nameEnd = path.length() - 1;
/*  73 */     if (nameEnd <= 0) {
/*  74 */       return 0;
/*     */     }
/*     */ 
/*  78 */     if (path.charAt(nameEnd) == '/') {
/*  79 */       nameEnd--;
/*     */     }
/*     */ 
/*  83 */     int nameStart = path.lastIndexOf('/', nameEnd) + 1;
/*     */ 
/*  86 */     int prefixEnd = nameStart;
/*  87 */     while ((prefixEnd <= nameEnd) && (Character.isDigit(path.charAt(prefixEnd)))) {
/*  88 */       prefixEnd++;
/*     */     }
/*     */ 
/*  92 */     if (prefixEnd == nameStart) {
/*  93 */       return -1;
/*     */     }
/*     */ 
/*  97 */     while ((nameStart < prefixEnd) && (path.charAt(nameStart) == '0')) {
/*  98 */       nameStart++;
/*     */     }
/*     */ 
/* 101 */     return nameStart == prefixEnd ? 0 : Integer.parseInt(path.substring(nameStart, prefixEnd));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.scanner.PrefixDeploymentSorter
 * JD-Core Version:    0.6.0
 */