/*     */ package org.jboss.deployment.scanner;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileFilter;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import org.jboss.net.protocol.URLLister.URLFilter;
/*     */ 
/*     */ public class DeploymentFilter
/*     */   implements FileFilter, URLLister.URLFilter
/*     */ {
/*  52 */   private static final Comparator reverseComparator = new Comparator()
/*     */   {
/*     */     public int compare(Object o1, Object o2)
/*     */     {
/*  56 */       int idx1 = ((String)o1).length();
/*  57 */       int idx2 = ((String)o2).length();
/*  58 */       int comp = 0;
/*     */ 
/*  60 */       while ((comp == 0) && (idx1 > 0) && (idx2 > 0)) {
/*  61 */         idx1--; idx2--; comp = ((String)o1).charAt(idx1) - ((String)o2).charAt(idx2);
/*     */       }
/*  63 */       return comp == 0 ? idx1 - idx2 : comp;
/*     */     }
/*  52 */   };
/*     */ 
/*  68 */   private static final String[] DEFAULT_PREFIXES = { "#", "%", ",", ".", "_$" };
/*     */ 
/*  72 */   private static final String[] DEFAULT_SUFFIXES = { "#", "$", "%", "~", ",v", ".BAK", ".bak", ".old", ".orig", ".tmp", ".rej", ".sh" };
/*     */ 
/*  77 */   private static final String[] DEFAULT_MATCHES = { ".make.state", ".nse_depinfo", "CVS", "CVS.admin", "RCS", "RCSLOG", "SCCS", "TAGS", "core", "tags" };
/*     */   private ArrayList suffixes;
/*     */   private ArrayList prefixes;
/*     */   private ArrayList matches;
/*     */ 
/*     */   public DeploymentFilter()
/*     */   {
/*  93 */     this(DEFAULT_MATCHES, DEFAULT_PREFIXES, DEFAULT_SUFFIXES);
/*     */   }
/*     */ 
/*     */   public DeploymentFilter(String[] matches, String[] prefixes, String[] suffixes)
/*     */   {
/* 103 */     if (matches == null)
/* 104 */       matches = DEFAULT_MATCHES;
/* 105 */     Arrays.sort(matches);
/* 106 */     this.matches = new ArrayList(Arrays.asList(matches));
/*     */ 
/* 108 */     if (prefixes == null)
/* 109 */       prefixes = DEFAULT_PREFIXES;
/* 110 */     Arrays.sort(prefixes);
/* 111 */     this.prefixes = new ArrayList(Arrays.asList(prefixes));
/*     */ 
/* 113 */     if (suffixes == null)
/* 114 */       suffixes = DEFAULT_SUFFIXES;
/* 115 */     Arrays.sort(suffixes, reverseComparator);
/* 116 */     this.suffixes = new ArrayList(Arrays.asList(suffixes));
/*     */   }
/*     */ 
/*     */   public void addPrefix(String prefix)
/*     */   {
/* 121 */     this.prefixes.add(prefix);
/* 122 */     Collections.sort(this.prefixes);
/*     */   }
/*     */ 
/*     */   public void addPrefixes(String[] prefixes) {
/* 126 */     this.prefixes.add(Arrays.asList(prefixes));
/* 127 */     Collections.sort(this.prefixes);
/*     */   }
/*     */ 
/*     */   public void delPrefix(String prefix)
/*     */   {
/* 132 */     this.prefixes.remove(prefix);
/*     */   }
/*     */ 
/*     */   public void delPrefixes(String[] prefixes) {
/* 136 */     this.prefixes.removeAll(Arrays.asList(prefixes));
/* 137 */     Collections.sort(this.prefixes);
/*     */   }
/*     */ 
/*     */   public void addSuffix(String suffix)
/*     */   {
/* 142 */     this.suffixes.add(suffix);
/* 143 */     Collections.sort(this.suffixes, reverseComparator);
/*     */   }
/*     */ 
/*     */   public void addSuffixes(String[] suffixes) {
/* 147 */     this.suffixes.add(Arrays.asList(suffixes));
/* 148 */     Collections.sort(this.suffixes, reverseComparator);
/*     */   }
/*     */ 
/*     */   public void delSuffix(String suffix)
/*     */   {
/* 153 */     this.suffixes.remove(suffix);
/*     */   }
/*     */ 
/*     */   public void delSuffixes(String[] suffixes) {
/* 157 */     this.suffixes.removeAll(Arrays.asList(suffixes));
/* 158 */     Collections.sort(this.suffixes, reverseComparator);
/*     */   }
/*     */ 
/*     */   public String[] getSuffixes()
/*     */   {
/* 163 */     String[] tmp = new String[this.suffixes.size()];
/* 164 */     this.suffixes.toArray(tmp);
/* 165 */     return tmp;
/*     */   }
/*     */ 
/*     */   public void setSuffixes(String[] suffixes) {
/* 169 */     Arrays.sort(suffixes, reverseComparator);
/* 170 */     this.suffixes.clear();
/* 171 */     this.suffixes.addAll(Arrays.asList(suffixes));
/*     */   }
/*     */ 
/*     */   public String[] getPrefixes()
/*     */   {
/* 176 */     String[] tmp = new String[this.prefixes.size()];
/* 177 */     this.prefixes.toArray(tmp);
/* 178 */     return tmp;
/*     */   }
/*     */ 
/*     */   public void setPrefixes(String[] prefixes) {
/* 182 */     Arrays.sort(prefixes);
/* 183 */     this.prefixes.clear();
/* 184 */     this.prefixes.addAll(Arrays.asList(prefixes));
/*     */   }
/*     */ 
/*     */   public String[] getMatches()
/*     */   {
/* 189 */     String[] tmp = new String[this.matches.size()];
/* 190 */     this.matches.toArray(tmp);
/* 191 */     return tmp;
/*     */   }
/*     */ 
/*     */   public void setMatches(String[] matches) {
/* 195 */     Arrays.sort(matches);
/* 196 */     this.matches.clear();
/* 197 */     this.matches.addAll(Arrays.asList(matches));
/*     */   }
/*     */ 
/*     */   public boolean accept(File file)
/*     */   {
/* 211 */     return accept(file.getName());
/*     */   }
/*     */ 
/*     */   public boolean accept(URL baseURL, String memberName)
/*     */   {
/* 216 */     return accept(memberName);
/*     */   }
/*     */ 
/*     */   private boolean accept(String name)
/*     */   {
/* 222 */     int index = Collections.binarySearch(this.matches, name);
/* 223 */     if (index >= 0) {
/* 224 */       return false;
/*     */     }
/*     */ 
/* 227 */     index = Collections.binarySearch(this.prefixes, name);
/* 228 */     if (index >= 0)
/* 229 */       return false;
/* 230 */     if (index < -1)
/*     */     {
/* 233 */       int firstLessIndex = -2 - index;
/* 234 */       String prefix = (String)this.prefixes.get(firstLessIndex);
/*     */ 
/* 236 */       if (name.startsWith(prefix)) {
/* 237 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 241 */     index = Collections.binarySearch(this.suffixes, name, reverseComparator);
/* 242 */     if (index >= 0)
/* 243 */       return false;
/* 244 */     if (index < -1)
/*     */     {
/* 247 */       int firstLessIndex = -2 - index;
/* 248 */       String suffix = (String)this.suffixes.get(firstLessIndex);
/*     */ 
/* 250 */       if (name.endsWith(suffix)) {
/* 251 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 255 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.scanner.DeploymentFilter
 * JD-Core Version:    0.6.0
 */