/*     */ package org.jboss.deployment.dependency;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import org.jboss.beans.metadata.spi.DependencyMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class JndiDependencyMetaData extends JBossObject
/*     */   implements DependencyMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  45 */   private static final Logger log = Logger.getLogger(JndiDependencyMetaData.class);
/*     */   private String jndiName;
/*     */   private Object demand;
/*     */   private ClassLoader loader;
/*  53 */   private ControllerState whenRequired = ControllerState.INSTALLED;
/*     */ 
/*     */   public JndiDependencyMetaData(String jndiName, ClassLoader loader, ControllerState whenRequired)
/*     */   {
/*  64 */     this.jndiName = jndiName;
/*  65 */     this.loader = loader;
/*     */   }
/*     */ 
/*     */   public Object getDependency()
/*     */   {
/*  70 */     return this.demand;
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequired()
/*     */   {
/*  75 */     return this.whenRequired;
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/*  80 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/*  85 */     return null;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/*  90 */     KernelControllerContext context = visitor.getControllerContext();
/*  91 */     DependencyItem item = new JndiDependencyItem(this.jndiName, this.loader, this.whenRequired);
/*  92 */     visitor.addDependency(item);
/*  93 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public String toShortString()
/*     */   {
/*  98 */     JBossStringBuilder buffer = new JBossStringBuilder();
/*  99 */     toShortString(buffer);
/* 100 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 105 */     buffer.append(this.jndiName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.dependency.JndiDependencyMetaData
 * JD-Core Version:    0.6.0
 */