/*     */ package org.jboss.deployment.dependency;
/*     */ 
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class JndiDependencyItem extends AbstractDependencyItem
/*     */   implements DependencyItem
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(JndiDependencyItem.class);
/*     */   private String jndiName;
/*     */   private Object demand;
/*     */   private ClassLoader loader;
/*     */ 
/*     */   public JndiDependencyItem(String jndiName, ClassLoader loader, ControllerState whenRequired)
/*     */   {
/*  61 */     super(jndiName, null, whenRequired, null);
/*  62 */     this.jndiName = jndiName;
/*  63 */     this.loader = loader;
/*     */   }
/*     */ 
/*     */   public Object getDemand()
/*     */   {
/*  68 */     return this.demand;
/*     */   }
/*     */ 
/*     */   public boolean resolve(Controller controller)
/*     */   {
/*  74 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/*  77 */       Thread.currentThread().setContextClassLoader(this.loader);
/*  78 */       InitialContext ctx = new InitialContext();
/*  79 */       this.demand = ctx.lookup(this.jndiName);
/*  80 */       setResolved(true);
/*  81 */       boolean bool = isResolved();
/*     */       return bool;
/*     */     }
/*     */     catch (NameNotFoundException e)
/*     */     {
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/*  89 */       if (log.isTraceEnabled())
/*  90 */         log.trace("Unexpected error", ignored);
/*     */     }
/*     */     finally
/*     */     {
/*  94 */       Thread.currentThread().setContextClassLoader(tcl);
/*     */     }
/*  96 */     setResolved(false);
/*  97 */     return isResolved();
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 103 */     super.toString(buffer);
/* 104 */     buffer.append(" depend=").append(this.jndiName);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 110 */     buffer.append(getName()).append(" depend ").append(this.jndiName);
/*     */   }
/*     */ 
/*     */   public String toHumanReadableString()
/*     */   {
/* 116 */     StringBuilder builder = new StringBuilder();
/* 117 */     builder.append("JndiDepends: '");
/* 118 */     builder.append(this.jndiName);
/* 119 */     builder.append("'");
/* 120 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.dependency.JndiDependencyItem
 * JD-Core Version:    0.6.0
 */