/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import javax.management.ObjectName;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.Templates;
/*     */ import javax.xml.transform.Transformer;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import javax.xml.transform.TransformerFactory;
/*     */ import javax.xml.transform.dom.DOMResult;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ import org.jboss.util.xml.DOMWriter;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.jboss.util.xml.JBossErrorHandler;
/*     */ import org.w3c.dom.Document;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class XSLSubDeployer extends SubDeployerSupport
/*     */   implements XSLSubDeployerMBean
/*     */ {
/*     */   protected String xslUrl;
/*     */   protected String packageSuffix;
/*     */   protected String ddSuffix;
/*     */   protected DocumentBuilderFactory dbf;
/*     */   private Templates templates;
/*  68 */   protected ObjectName delegateName = SARDeployerMBean.OBJECT_NAME;
/*     */   protected SubDeployer delegate;
/*     */   private boolean validateDTDs;
/*     */ 
/*     */   public void setXslUrl(String xslUrl)
/*     */   {
/*  82 */     this.xslUrl = xslUrl;
/*     */   }
/*     */ 
/*     */   public String getXslUrl()
/*     */   {
/*  87 */     return this.xslUrl;
/*     */   }
/*     */ 
/*     */   public void setPackageSuffix(String packageSuffix)
/*     */   {
/*  92 */     this.packageSuffix = packageSuffix;
/*     */   }
/*     */ 
/*     */   public String getPackageSuffix()
/*     */   {
/*  97 */     return this.packageSuffix;
/*     */   }
/*     */ 
/*     */   public void setDdSuffix(String ddSuffix)
/*     */   {
/* 102 */     this.ddSuffix = ddSuffix;
/*     */   }
/*     */ 
/*     */   public String getDdSuffix()
/*     */   {
/* 107 */     return this.ddSuffix;
/*     */   }
/*     */ 
/*     */   public void setDelegateName(ObjectName delegateName)
/*     */   {
/* 112 */     this.delegateName = delegateName;
/*     */   }
/*     */ 
/*     */   public ObjectName getDelegateName()
/*     */   {
/* 117 */     return this.delegateName;
/*     */   }
/*     */ 
/*     */   public boolean getValidateDTDs() {
/* 121 */     return this.validateDTDs;
/*     */   }
/*     */ 
/*     */   public void setValidateDTDs(boolean validate)
/*     */   {
/* 126 */     this.validateDTDs = validate;
/*     */   }
/*     */ 
/*     */   protected void createService() throws Exception
/*     */   {
/* 131 */     super.createService();
/* 132 */     this.delegate = ((SubDeployer)MBeanProxyExt.create(SubDeployer.class, this.delegateName, this.server));
/*     */ 
/* 134 */     TransformerFactory tf = TransformerFactory.newInstance();
/* 135 */     this.dbf = DocumentBuilderFactory.newInstance();
/* 136 */     this.dbf.setNamespaceAware(true);
/* 137 */     this.dbf.setValidating(this.validateDTDs);
/*     */ 
/* 139 */     InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xslUrl);
/* 140 */     StreamSource ss = new StreamSource(is);
/* 141 */     this.templates = tf.newTemplates(ss);
/* 142 */     this.log.debug("Created templates: " + this.templates);
/*     */   }
/*     */ 
/*     */   protected void destroyService() throws Exception
/*     */   {
/* 147 */     this.templates = null;
/* 148 */     super.destroyService();
/*     */   }
/*     */ 
/*     */   public boolean accepts(DeploymentInfo di)
/*     */   {
/* 153 */     String urlStr = di.url.toString();
/* 154 */     return ((this.packageSuffix != null) && ((urlStr.endsWith(this.packageSuffix)) || (urlStr.endsWith(this.packageSuffix + "/")))) || ((this.ddSuffix != null) && (urlStr.endsWith(this.ddSuffix)));
/*     */   }
/*     */ 
/*     */   public void init(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 160 */     if (di.document == null) {
/* 161 */       findDd(di);
/*     */     }
/*     */     try
/*     */     {
/* 165 */       Transformer trans = this.templates.newTransformer();
/* 166 */       String urlStr = di.url.toString();
/* 167 */       String shortURL = ServerConfigUtil.shortUrlFromServerHome(urlStr);
/* 168 */       trans.setErrorListener(new JBossErrorHandler(shortURL, null));
/* 169 */       Source s = new DOMSource(di.document);
/* 170 */       DOMResult r = new DOMResult();
/* 171 */       setParameters(trans);
/*     */ 
/* 173 */       trans.transform(s, r);
/*     */ 
/* 175 */       di.document = ((Document)r.getNode());
/* 176 */       this.log.debug("transformed into doc: " + di.document);
/* 177 */       if (this.log.isDebugEnabled())
/*     */       {
/* 179 */         String docStr = DOMWriter.printNode(di.document, true);
/* 180 */         this.log.debug("transformed into doc: " + docStr);
/*     */       }
/*     */     }
/*     */     catch (TransformerException ce)
/*     */     {
/* 185 */       throw new DeploymentException("Problem with xsl transformation", ce);
/*     */     }
/* 187 */     this.delegate.init(di);
/*     */   }
/*     */ 
/*     */   public void create(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 192 */     this.delegate.create(di);
/*     */   }
/*     */ 
/*     */   public void start(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 197 */     this.delegate.start(di);
/*     */   }
/*     */ 
/*     */   public void stop(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 202 */     this.delegate.stop(di);
/*     */   }
/*     */ 
/*     */   public void destroy(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 207 */     this.delegate.destroy(di);
/*     */   }
/*     */ 
/*     */   protected void setParameters(Transformer trans)
/*     */     throws TransformerException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void findDd(DeploymentInfo di) throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 219 */       DocumentBuilder db = this.dbf.newDocumentBuilder();
/* 220 */       String urlStr = di.url.toString();
/* 221 */       String shortURL = ServerConfigUtil.shortUrlFromServerHome(urlStr);
/* 222 */       JBossEntityResolver resolver = new JBossEntityResolver();
/* 223 */       db.setEntityResolver(resolver);
/* 224 */       db.setErrorHandler(new JBossErrorHandler(shortURL, resolver));
/*     */ 
/* 226 */       if ((this.ddSuffix != null) && (urlStr.endsWith(this.ddSuffix)))
/* 227 */         di.document = db.parse(di.url.openStream());
/*     */     }
/*     */     catch (SAXException se)
/*     */     {
/* 231 */       throw new DeploymentException("Could not parse dd", se);
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 235 */       throw new DeploymentException("Could not read dd", ioe);
/*     */     }
/*     */     catch (ParserConfigurationException pce)
/*     */     {
/* 239 */       throw new DeploymentException("Could not create document builder for dd", pce);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.XSLSubDeployer
 * JD-Core Version:    0.6.0
 */