/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class SuffixOrderHelper
/*     */ {
/*  56 */   public static final String[] DEFAULT_ENHANCED_SUFFIXES = new String[0];
/*     */   public static final int DEFAULT_RELATIVE_ORDER = 850;
/*  88 */   public static final Logger log = Logger.getLogger(SuffixOrderHelper.class);
/*     */   private final DeploymentSorter sorter;
/*     */   private String[] enhancedSuffixes;
/*     */   private List suffixes;
/*     */   private Set staticSuffixes;
/*     */ 
/*     */   public SuffixOrderHelper(DeploymentSorter sorter)
/*     */   {
/* 108 */     this.sorter = sorter;
/* 109 */     this.suffixes = new ArrayList();
/* 110 */     this.staticSuffixes = new HashSet();
/*     */   }
/*     */ 
/*     */   public String[] getSuffixOrder()
/*     */   {
/* 125 */     return this.sorter.getSuffixOrder();
/*     */   }
/*     */ 
/*     */   public String[] getEnhancedSuffixes()
/*     */   {
/* 135 */     return this.enhancedSuffixes;
/*     */   }
/*     */ 
/*     */   public void setEnhancedSuffixes(String[] enhancedSuffixes)
/*     */   {
/* 145 */     this.enhancedSuffixes = enhancedSuffixes;
/*     */   }
/*     */ 
/*     */   public void initialize()
/*     */   {
/* 161 */     if (this.enhancedSuffixes == null)
/*     */     {
/* 163 */       this.enhancedSuffixes = DEFAULT_ENHANCED_SUFFIXES;
/*     */     }
/*     */ 
/* 167 */     this.suffixes.clear();
/* 168 */     this.staticSuffixes.clear();
/*     */ 
/* 171 */     for (int i = 0; i < this.enhancedSuffixes.length; i++)
/*     */     {
/* 173 */       EnhancedSuffix es = new EnhancedSuffix(this.enhancedSuffixes[i]);
/* 174 */       addSuffix(es);
/*     */ 
/* 177 */       this.staticSuffixes.add(es.suffix);
/*     */     }
/*     */ 
/* 181 */     this.sorter.setSuffixOrder(produceSuffixOrder());
/*     */   }
/*     */ 
/*     */   public void addEnhancedSuffixes(String[] enhancedSuffixes)
/*     */   {
/* 193 */     if (enhancedSuffixes != null)
/*     */     {
/* 196 */       int size = this.suffixes.size();
/*     */ 
/* 199 */       for (int i = 0; i < enhancedSuffixes.length; i++)
/*     */       {
/* 201 */         EnhancedSuffix es = new EnhancedSuffix(enhancedSuffixes[i]);
/* 202 */         addSuffix(es);
/*     */       }
/* 204 */       if (this.suffixes.size() > size)
/*     */       {
/* 207 */         this.sorter.setSuffixOrder(produceSuffixOrder());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addSuffixes(String[] suffixes, int relativeOrder)
/*     */   {
/* 221 */     if (suffixes != null)
/*     */     {
/* 224 */       int size = this.suffixes.size();
/*     */ 
/* 226 */       for (int i = 0; i < suffixes.length; i++)
/*     */       {
/* 228 */         addSuffix(new EnhancedSuffix(suffixes[i], relativeOrder));
/*     */       }
/*     */ 
/* 231 */       if (this.suffixes.size() > size)
/*     */       {
/* 234 */         this.sorter.setSuffixOrder(produceSuffixOrder());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeEnhancedSuffixes(String[] enhancedSuffixes)
/*     */   {
/* 245 */     if (enhancedSuffixes != null)
/*     */     {
/* 248 */       int size = this.suffixes.size();
/*     */ 
/* 250 */       for (int i = 0; i < enhancedSuffixes.length; i++)
/*     */       {
/* 252 */         EnhancedSuffix es = new EnhancedSuffix(enhancedSuffixes[i]);
/*     */ 
/* 255 */         if (this.staticSuffixes.contains(es.suffix))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 262 */         this.suffixes.remove(es);
/*     */       }
/*     */ 
/* 266 */       if (this.suffixes.size() < size)
/*     */       {
/* 269 */         this.sorter.setSuffixOrder(produceSuffixOrder());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeSuffixes(String[] suffixes, int relativeOrder)
/*     */   {
/* 280 */     if (suffixes != null)
/*     */     {
/* 283 */       int size = this.suffixes.size();
/*     */ 
/* 285 */       for (int i = 0; i < suffixes.length; i++)
/*     */       {
/* 288 */         if (this.staticSuffixes.contains(suffixes[i]))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 295 */         this.suffixes.remove(new EnhancedSuffix(suffixes[i], relativeOrder));
/*     */       }
/*     */ 
/* 299 */       if (this.suffixes.size() < size)
/*     */       {
/* 302 */         this.sorter.setSuffixOrder(produceSuffixOrder());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String[] produceSuffixOrder()
/*     */   {
/* 314 */     String[] suffixOrder = new String[this.suffixes.size()];
/*     */ 
/* 316 */     for (int i = 0; i < this.suffixes.size(); i++)
/*     */     {
/* 318 */       suffixOrder[i] = ((EnhancedSuffix)this.suffixes.get(i)).suffix;
/*     */     }
/* 320 */     return suffixOrder;
/*     */   }
/*     */ 
/*     */   private void addSuffix(EnhancedSuffix enhancedSuffix)
/*     */   {
/* 338 */     if (this.staticSuffixes.contains(enhancedSuffix.suffix))
/*     */     {
/* 340 */       log.debug("Static suffix exists; ignoring request for adding enhanced suffix: " + enhancedSuffix);
/*     */     }
/*     */     else
/*     */     {
/* 344 */       int size = this.suffixes.size();
/*     */ 
/* 347 */       if (size == 0)
/*     */       {
/* 349 */         this.suffixes.add(enhancedSuffix);
/*     */       }
/*     */       else
/*     */       {
/* 354 */         for (int i = size - 1; i > -1; i--)
/*     */         {
/* 356 */           EnhancedSuffix entry = (EnhancedSuffix)this.suffixes.get(i);
/* 357 */           if (enhancedSuffix.order >= entry.order)
/*     */           {
/* 360 */             this.suffixes.add(i + 1, enhancedSuffix);
/* 361 */             break;
/*     */           }
/* 363 */           if (i != 0) {
/*     */             continue;
/*     */           }
/* 366 */           this.suffixes.add(0, enhancedSuffix);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final class EnhancedSuffix
/*     */   {
/*     */     public String suffix;
/*     */     public int order;
/*     */ 
/*     */     public EnhancedSuffix(String suffix, int order)
/*     */     {
/* 390 */       this.suffix = suffix;
/* 391 */       this.order = order;
/*     */     }
/*     */ 
/*     */     public EnhancedSuffix(String enhancedSuffix)
/*     */       throws IllegalArgumentException
/*     */     {
/* 400 */       StringTokenizer tokenizer = new StringTokenizer(enhancedSuffix, ":");
/* 401 */       int tokens = tokenizer.countTokens();
/*     */ 
/* 403 */       switch (tokens)
/*     */       {
/*     */       case 1:
/* 406 */         this.order = 850;
/* 407 */         this.suffix = enhancedSuffix;
/* 408 */         break;
/*     */       case 2:
/* 411 */         this.order = Integer.parseInt(tokenizer.nextToken());
/* 412 */         this.suffix = tokenizer.nextToken();
/* 413 */         break;
/*     */       default:
/* 416 */         throw new IllegalArgumentException("Cannot parse enhancedSuffix: " + enhancedSuffix);
/*     */       }
/*     */     }
/*     */ 
/*     */     public boolean equals(Object other)
/*     */     {
/* 428 */       if (other == this) {
/* 429 */         return true;
/*     */       }
/* 431 */       if (!(other instanceof EnhancedSuffix)) {
/* 432 */         return false;
/*     */       }
/* 434 */       EnhancedSuffix that = (EnhancedSuffix)other;
/*     */ 
/* 437 */       return (this.suffix.equals(that.suffix)) && (this.order == that.order);
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 445 */       int result = 17;
/* 446 */       result = 37 * result + this.suffix.hashCode();
/* 447 */       result = 37 * result + this.order;
/* 448 */       return result;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 456 */       return this.order + ":" + this.suffix;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.SuffixOrderHelper
 * JD-Core Version:    0.6.0
 */