/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Enumeration;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import javax.management.Notification;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ import org.jboss.util.file.JarUtils;
/*     */ import org.jboss.util.property.PropertyContainer;
/*     */ import org.jboss.util.stream.Streams;
/*     */ 
/*     */ public abstract class SubDeployerSupport extends ServiceMBeanSupport
/*     */   implements SubDeployerExt, SubDeployerExtMBean
/*     */ {
/*     */   protected static final String nativeSuffix;
/*     */   protected static final String nativePrefix;
/*     */   protected MainDeployerMBean mainDeployer;
/*     */   protected File tempDeployDir;
/*     */   protected String[] enhancedSuffixes;
/*     */   protected String[] suffixes;
/*     */   protected int relativeOrder;
/*     */   private File tempNativeDir;
/*     */   private boolean loadNative;
/* 596 */   protected static final ClassConfiguration CONFIGURATION = new ClassConfiguration();
/*     */ 
/*     */   public SubDeployerSupport()
/*     */   {
/*  89 */     this.relativeOrder = -1;
/*     */ 
/*  95 */     this.loadNative = false;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 106 */     ServerConfig config = ServerConfigLocator.locate();
/* 107 */     this.tempNativeDir = config.getServerNativeDir();
/* 108 */     this.tempDeployDir = config.getServerTempDeployDir();
/* 109 */     this.loadNative = ServerConfigUtil.isLoadNative();
/*     */ 
/* 112 */     this.mainDeployer = ((MainDeployerMBean)MBeanProxyExt.create(MainDeployerMBean.class, MainDeployerMBean.OBJECT_NAME, this.server));
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 124 */     this.mainDeployer.addDeployer(this);
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 133 */     this.mainDeployer.removeDeployer(this);
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 142 */     this.mainDeployer = null;
/* 143 */     this.tempNativeDir = null;
/*     */   }
/*     */ 
/*     */   protected void setSuffixes(String[] suffixes)
/*     */   {
/* 155 */     this.suffixes = suffixes;
/*     */   }
/*     */ 
/*     */   protected void setRelativeOrder(int relativeOrder)
/*     */   {
/* 166 */     this.relativeOrder = relativeOrder;
/*     */   }
/*     */ 
/*     */   public void setEnhancedSuffixes(String[] enhancedSuffixes)
/*     */   {
/* 184 */     if (enhancedSuffixes != null)
/*     */     {
/* 186 */       int len = enhancedSuffixes.length;
/* 187 */       this.suffixes = new String[len];
/*     */ 
/* 189 */       for (int i = 0; i < len; i++)
/*     */       {
/* 192 */         SuffixOrderHelper.EnhancedSuffix e = new SuffixOrderHelper.EnhancedSuffix(enhancedSuffixes[i]);
/*     */ 
/* 195 */         this.suffixes[i] = e.suffix;
/*     */       }
/*     */     }
/* 198 */     this.enhancedSuffixes = enhancedSuffixes;
/*     */   }
/*     */ 
/*     */   public String[] getEnhancedSuffixes()
/*     */   {
/* 208 */     return this.enhancedSuffixes;
/*     */   }
/*     */ 
/*     */   public String[] getSuffixes()
/*     */   {
/* 218 */     return this.suffixes;
/*     */   }
/*     */ 
/*     */   public int getRelativeOrder()
/*     */   {
/* 228 */     return this.relativeOrder;
/*     */   }
/*     */ 
/*     */   public boolean accepts(DeploymentInfo sdi)
/*     */   {
/* 246 */     String[] acceptedSuffixes = getSuffixes();
/* 247 */     if (acceptedSuffixes == null)
/*     */     {
/* 249 */       return false;
/*     */     }
/*     */ 
/* 253 */     String urlPath = sdi.url.getPath();
/* 254 */     String shortName = sdi.shortName;
/* 255 */     boolean checkDir = (sdi.isDirectory) && (!sdi.isXML) && (!sdi.isScript);
/*     */ 
/* 257 */     for (int i = 0; i < acceptedSuffixes.length; i++)
/*     */     {
/* 261 */       if ((urlPath.endsWith(acceptedSuffixes[i])) || ((checkDir) && (shortName.endsWith(acceptedSuffixes[i]))))
/*     */       {
/* 264 */         return true;
/*     */       }
/*     */     }
/* 267 */     return false;
/*     */   }
/*     */ 
/*     */   public void init(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 284 */     processNestedDeployments(di);
/*     */ 
/* 286 */     emitNotification("org.jboss.deployment.SubDeployer.init", di);
/*     */   }
/*     */ 
/*     */   public void create(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 297 */     emitNotification("org.jboss.deployment.SubDeployer.create", di);
/*     */   }
/*     */ 
/*     */   public void start(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 308 */     emitNotification("org.jboss.deployment.SubDeployer.start", di);
/*     */   }
/*     */ 
/*     */   public void stop(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 319 */     emitNotification("org.jboss.deployment.SubDeployer.stop", di);
/*     */   }
/*     */ 
/*     */   public void destroy(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 330 */     emitNotification("org.jboss.deployment.SubDeployer.destroy", di);
/*     */   }
/*     */ 
/*     */   protected void emitNotification(String type, DeploymentInfo di)
/*     */   {
/* 338 */     Notification notification = new Notification(type, this, getNextNotificationSequenceNumber());
/* 339 */     notification.setUserData(di);
/* 340 */     sendNotification(notification);
/*     */   }
/*     */ 
/*     */   protected void processNestedDeployments(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 352 */     this.log.debug("looking for nested deployments in : " + di.url);
/* 353 */     if (di.isXML)
/*     */     {
/* 356 */       return;
/*     */     }
/*     */ 
/* 359 */     if (di.isDirectory)
/*     */     {
/* 361 */       File f = new File(di.url.getFile());
/* 362 */       if (!f.isDirectory())
/*     */       {
/* 365 */         throw new DeploymentException("Deploy file incorrectly reported as a directory: " + di.url);
/*     */       }
/*     */ 
/* 369 */       addDeployableFiles(di, f);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 376 */         URL nestedURL = JarUtils.extractNestedJar(di.localUrl, this.tempDeployDir);
/* 377 */         JarFile jarFile = new JarFile(nestedURL.getFile());
/* 378 */         addDeployableJar(di, jarFile);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 382 */         this.log.warn("Failed to add deployable jar: " + di.localUrl, e);
/*     */ 
/* 391 */         return;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isDeployable(String name, URL url)
/*     */   {
/* 414 */     if (url.getPath().indexOf("META-INF") != -1)
/*     */     {
/* 416 */       return false;
/*     */     }
/* 418 */     String[] acceptedSuffixes = this.mainDeployer.getSuffixOrder();
/* 419 */     for (int i = 0; i < acceptedSuffixes.length; i++)
/*     */     {
/* 421 */       if (name.endsWith(acceptedSuffixes[i]))
/*     */       {
/* 423 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 427 */     return (name.endsWith(nativeSuffix)) && (name.startsWith(nativePrefix));
/*     */   }
/*     */ 
/*     */   protected void addDeployableFiles(DeploymentInfo di, File dir)
/*     */     throws DeploymentException
/*     */   {
/* 441 */     File[] files = dir.listFiles();
/* 442 */     for (int i = 0; i < files.length; i++)
/*     */     {
/* 444 */       File file = files[i];
/* 445 */       String name = file.getName();
/*     */       try
/*     */       {
/* 448 */         URL url = file.toURL();
/* 449 */         if (isDeployable(name, url))
/*     */         {
/* 451 */           deployUrl(di, url, name);
/*     */ 
/* 453 */           continue;
/*     */         }
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 458 */         this.log.warn("File name invalid; ignoring: " + file, e);
/*     */       }
/* 460 */       if (!file.isDirectory())
/*     */         continue;
/* 462 */       addDeployableFiles(di, file);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void addDeployableJar(DeploymentInfo di, JarFile jarFile)
/*     */     throws DeploymentException
/*     */   {
/* 477 */     String urlPrefix = "jar:" + di.localUrl.toString() + "!/";
/* 478 */     for (Enumeration e = jarFile.entries(); e.hasMoreElements(); )
/*     */     {
/* 480 */       JarEntry entry = (JarEntry)e.nextElement();
/* 481 */       String name = entry.getName();
/*     */       try
/*     */       {
/* 484 */         URL url = new URL(urlPrefix + name);
/* 485 */         if (isDeployable(name, url))
/*     */         {
/* 488 */           URL nestedURL = JarUtils.extractNestedJar(url, this.tempDeployDir);
/* 489 */           deployUrl(di, nestedURL, name);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (MalformedURLException mue)
/*     */       {
/* 497 */         this.log.warn("Jar entry invalid; ignoring: " + name, mue);
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/* 501 */         this.log.warn("Failed to extract nested jar; ignoring: " + name, ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deployUrl(DeploymentInfo di, URL url, String name)
/*     */     throws DeploymentException
/*     */   {
/* 509 */     this.log.debug("nested deployment: " + url);
/*     */     try
/*     */     {
/* 529 */       if ((name.endsWith(nativeSuffix)) && (name.startsWith(nativePrefix)))
/*     */       {
/* 531 */         File destFile = new File(this.tempNativeDir, name);
/* 532 */         this.log.info("Loading native library: " + destFile.toString());
/*     */ 
/* 534 */         File parent = destFile.getParentFile();
/* 535 */         if (!parent.exists()) {
/* 536 */           parent.mkdirs();
/*     */         }
/*     */ 
/* 539 */         InputStream in = url.openStream();
/* 540 */         OutputStream out = new FileOutputStream(destFile);
/* 541 */         Streams.copyb(in, out);
/*     */ 
/* 543 */         out.flush();
/* 544 */         out.close();
/* 545 */         in.close();
/*     */ 
/* 547 */         if (this.loadNative)
/* 548 */           System.load(destFile.toString());
/*     */       }
/*     */       else
/*     */       {
/* 552 */         new DeploymentInfo(url, di, getServer());
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 557 */       throw new DeploymentException("Could not deploy sub deployment " + name + " of deployment " + di.url, ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 610 */     String token = CONFIGURATION.getNativeLibToken();
/*     */ 
/* 613 */     String nativex = System.mapLibraryName(token);
/* 614 */     int xPos = nativex.indexOf(token);
/* 615 */     nativePrefix = nativex.substring(0, xPos);
/* 616 */     nativeSuffix = nativex.substring(xPos + 3);
/*     */   }
/*     */ 
/*     */   protected static class ClassConfiguration extends PropertyContainer
/*     */   {
/* 573 */     private String nativeLibToken = "XxX";
/*     */ 
/*     */     public ClassConfiguration()
/*     */     {
/* 578 */       super();
/*     */ 
/* 581 */       bindMethod("nativeLibToken");
/*     */     }
/*     */ 
/*     */     public void setNativeLibToken(String token)
/*     */     {
/* 586 */       this.nativeLibToken = token;
/*     */     }
/*     */ 
/*     */     public String getNativeLibToken()
/*     */     {
/* 591 */       return this.nativeLibToken;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.SubDeployerSupport
 * JD-Core Version:    0.6.0
 */