/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import org.jboss.mx.interceptor.AbstractInterceptor;
/*     */ import org.jboss.mx.interceptor.Interceptor;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ 
/*     */ public abstract class SubDeployerInterceptor extends AbstractInterceptor
/*     */ {
/*     */   public SubDeployerInterceptor()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SubDeployerInterceptor(String name)
/*     */   {
/*  58 */     super(name);
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  71 */     String type = invocation.getType();
/*     */ 
/*  74 */     if (type.equals("invoke"))
/*     */     {
/*  76 */       Object[] args = invocation.getArgs();
/*  77 */       Object retn = invocation.getReturnTypeClass();
/*     */ 
/*  80 */       if ((args.length == 1) && ((args[0] instanceof DeploymentInfo)) && (retn == null))
/*     */       {
/*  82 */         String method = invocation.getName();
/*  83 */         DeploymentInfo di = (DeploymentInfo)args[0];
/*     */ 
/*  85 */         if (method.equals("init"))
/*     */         {
/*  87 */           return init(invocation, di);
/*     */         }
/*  89 */         if (method.equals("create"))
/*     */         {
/*  91 */           return create(invocation, di);
/*     */         }
/*  93 */         if (method.equals("start"))
/*     */         {
/*  95 */           return start(invocation, di);
/*     */         }
/*  97 */         if (method.equals("stop"))
/*     */         {
/*  99 */           return stop(invocation, di);
/*     */         }
/* 101 */         if (method.equals("destroy"))
/*     */         {
/* 103 */           return destroy(invocation, di);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 109 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object invokeNext(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 121 */     Interceptor next = invocation.nextInterceptor();
/* 122 */     if (next != null)
/*     */     {
/* 124 */       return next.invoke(invocation);
/*     */     }
/*     */ 
/* 128 */     return invocation.dispatch();
/*     */   }
/*     */ 
/*     */   protected Object init(Invocation invocation, DeploymentInfo di)
/*     */     throws Throwable
/*     */   {
/* 139 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object create(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */   {
/* 144 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object start(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */   {
/* 149 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object stop(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */   {
/* 154 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object destroy(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */   {
/* 159 */     return invokeNext(invocation);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.SubDeployerInterceptor
 * JD-Core Version:    0.6.0
 */