/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.io.File;
/*     */ import java.io.FileFilter;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.Map;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.net.protocol.URLLister;
/*     */ import org.jboss.net.protocol.URLListerFactory;
/*     */ import org.jboss.system.ServiceControllerMBean;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.util.Strings;
/*     */ import org.jboss.util.stream.Streams;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class SARDeployer extends SubDeployerSupport
/*     */   implements SARDeployerMBean
/*     */ {
/*  83 */   private static final String[] DEFAULT_ENHANCED_SUFFIXES = { "050:.deployer", "050:-deployer.xml", "150:.sar", "150:-service.xml" };
/*     */   private static final String JBOSS_SERVICE = "META-INF/jboss-service.xml";
/*     */   private ServiceControllerMBean serviceController;
/*     */   private File dataDir;
/*     */   private URL serverHomeURL;
/* 106 */   private HashMap serviceDeploymentMap = new HashMap();
/*     */ 
/* 112 */   private Map suffixToDescriptorMap = new ConcurrentReaderHashMap();
/*     */   private boolean useNamespaceAwareParser;
/*     */ 
/*     */   public SARDeployer()
/*     */   {
/* 122 */     setEnhancedSuffixes(DEFAULT_ENHANCED_SUFFIXES);
/*     */ 
/* 124 */     ArrayList tmp = new ArrayList();
/* 125 */     tmp.add("META-INF/jboss-service.xml");
/* 126 */     tmp.add("META-INF/hibernate-service.xml");
/* 127 */     this.suffixToDescriptorMap.put(".har", tmp);
/*     */   }
/*     */ 
/*     */   public boolean isUseNamespaceAwareParser()
/*     */   {
/* 132 */     return this.useNamespaceAwareParser;
/*     */   }
/*     */ 
/*     */   public void setUseNamespaceAwareParser(boolean useNamespaceAwareParser)
/*     */   {
/* 137 */     this.useNamespaceAwareParser = useNamespaceAwareParser;
/*     */   }
/*     */ 
/*     */   public DeploymentInfo getService(ObjectName serviceName)
/*     */   {
/* 149 */     DeploymentInfo di = null;
/* 150 */     synchronized (this.serviceDeploymentMap)
/*     */     {
/* 152 */       di = (DeploymentInfo)this.serviceDeploymentMap.get(serviceName);
/*     */     }
/* 154 */     return di;
/*     */   }
/*     */ 
/*     */   public void init(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 169 */       if (di.url.getPath().endsWith("/"))
/*     */       {
/* 172 */         di.watch = new URL(di.url, "META-INF/jboss-service.xml");
/*     */       }
/*     */       else
/*     */       {
/* 177 */         di.watch = di.url;
/*     */       }
/*     */ 
/* 181 */       parseDocument(di);
/*     */ 
/* 184 */       NodeList loaders = di.document.getElementsByTagName("loader-repository");
/* 185 */       if (loaders.getLength() > 0)
/*     */       {
/* 187 */         Element loader = (Element)loaders.item(0);
/* 188 */         LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig(loader);
/* 189 */         di.setRepositoryInfo(config);
/*     */       }
/*     */ 
/* 193 */       parseXMLClasspath(di);
/*     */ 
/* 196 */       NodeList lds = di.document.getElementsByTagName("local-directory");
/* 197 */       this.log.debug("about to copy " + lds.getLength() + " local directories");
/*     */ 
/* 199 */       for (int i = 0; i < lds.getLength(); i++)
/*     */       {
/* 201 */         Element ld = (Element)lds.item(i);
/* 202 */         String path = ld.getAttribute("path");
/* 203 */         this.log.debug("about to copy local directory at " + path);
/*     */ 
/* 206 */         this.log.debug("copying from " + di.localUrl + path + " -> " + this.dataDir);
/*     */ 
/* 208 */         inflateJar(di.localUrl, this.dataDir, path);
/*     */       }
/*     */     }
/*     */     catch (DeploymentException de)
/*     */     {
/* 213 */       throw de;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 217 */       throw new DeploymentException(e);
/*     */     }
/*     */ 
/* 221 */     super.init(di);
/*     */   }
/*     */ 
/*     */   public void create(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 237 */       this.log.debug("Deploying SAR, create step: url " + di.url);
/*     */ 
/* 240 */       ObjectName uclName = di.ucl.getObjectName();
/* 241 */       if (!getServer().isRegistered(uclName))
/*     */       {
/* 243 */         this.log.debug("Registering service UCL=" + uclName);
/* 244 */         getServer().registerMBean(di.ucl, uclName);
/*     */       }
/*     */ 
/* 247 */       List mbeans = di.mbeans;
/* 248 */       mbeans.clear();
/* 249 */       List descriptorMbeans = this.serviceController.install(di.document.getDocumentElement(), uclName);
/* 250 */       mbeans.addAll(descriptorMbeans);
/*     */ 
/* 253 */       for (Iterator iter = di.mbeans.iterator(); iter.hasNext(); )
/*     */       {
/* 255 */         ObjectName service = (ObjectName)iter.next();
/*     */ 
/* 258 */         this.serviceController.create(service);
/* 259 */         synchronized (this.serviceDeploymentMap)
/*     */         {
/* 261 */           this.serviceDeploymentMap.put(service, di);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 266 */       super.create(di);
/*     */     }
/*     */     catch (DeploymentException e)
/*     */     {
/* 270 */       this.log.debug("create operation failed for package " + di.url, e);
/* 271 */       destroy(di);
/* 272 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 276 */       this.log.debug("create operation failed for package " + di.url, e);
/* 277 */       destroy(di);
/* 278 */       throw new DeploymentException("create operation failed for package " + di.url, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 292 */     this.log.debug("Deploying SAR, start step: url " + di.url);
/*     */     try
/*     */     {
/* 297 */       for (Iterator iter = di.mbeans.iterator(); iter.hasNext(); )
/*     */       {
/* 299 */         ObjectName service = (ObjectName)iter.next();
/*     */ 
/* 302 */         this.serviceController.start(service);
/*     */       }
/*     */ 
/* 305 */       super.start(di);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 309 */       stop(di);
/* 310 */       destroy(di);
/* 311 */       throw new DeploymentException("start operation failed on package " + di.url, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop(DeploymentInfo di)
/*     */   {
/* 324 */     this.log.debug("undeploying document " + di.url);
/*     */ 
/* 326 */     List services = di.mbeans;
/* 327 */     int lastService = services.size();
/*     */ 
/* 330 */     for (ListIterator i = services.listIterator(lastService); i.hasPrevious(); )
/*     */     {
/* 332 */       ObjectName name = (ObjectName)i.previous();
/* 333 */       this.log.debug("stopping mbean " + name);
/*     */       try
/*     */       {
/* 336 */         this.serviceController.stop(name);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 340 */         this.log.error("Could not stop mbean: " + name, e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 347 */       super.stop(di);
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy(DeploymentInfo di)
/*     */   {
/* 362 */     List services = di.mbeans;
/* 363 */     int lastService = services.size();
/*     */ 
/* 365 */     for (ListIterator i = services.listIterator(lastService); i.hasPrevious(); )
/*     */     {
/* 367 */       ObjectName name = (ObjectName)i.previous();
/* 368 */       this.log.debug("destroying mbean " + name);
/* 369 */       synchronized (this.serviceDeploymentMap)
/*     */       {
/* 371 */         this.serviceDeploymentMap.remove(name);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 376 */         this.serviceController.destroy(name);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 380 */         this.log.error("Could not destroy mbean: " + name, e);
/*     */       }
/*     */     }
/*     */ 
/* 384 */     for (ListIterator i = services.listIterator(lastService); i.hasPrevious(); )
/*     */     {
/* 386 */       ObjectName name = (ObjectName)i.previous();
/* 387 */       this.log.debug("removing mbean " + name);
/*     */       try
/*     */       {
/* 390 */         this.serviceController.remove(name);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 394 */         this.log.error("Could not remove mbean: " + name, e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 401 */       ObjectName uclName = di.ucl.getObjectName();
/* 402 */       if (getServer().isRegistered(uclName) == true)
/*     */       {
/* 404 */         this.log.debug("Unregistering service UCL=" + uclName);
/* 405 */         getServer().unregisterMBean(uclName);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 415 */       super.destroy(di);
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 432 */     super.startService();
/*     */ 
/* 435 */     this.serviceController = ((ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, this.server));
/*     */ 
/* 440 */     ServerConfig config = ServerConfigLocator.locate();
/* 441 */     this.dataDir = config.getServerDataDir();
/* 442 */     this.serverHomeURL = config.getServerHomeURL();
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 451 */     super.stopService();
/*     */ 
/* 454 */     this.serviceController = null;
/* 455 */     this.serverHomeURL = null;
/* 456 */     this.dataDir = null;
/*     */   }
/*     */ 
/*     */   protected ObjectName getObjectName(MBeanServer server, ObjectName name)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 463 */     return name == null ? OBJECT_NAME : name;
/*     */   }
/*     */ 
/*     */   protected File[] listFiles(String urlspec)
/*     */     throws Exception
/*     */   {
/* 470 */     URL url = Strings.toURL(urlspec);
/*     */ 
/* 473 */     File dir = new File(url.getFile());
/*     */ 
/* 475 */     File[] files = dir.listFiles(new FileFilter()
/*     */     {
/*     */       public boolean accept(File pathname)
/*     */       {
/* 479 */         String name = pathname.getName().toLowerCase();
/* 480 */         return (name.endsWith(".jar")) || (name.endsWith(".zip"));
/*     */       }
/*     */     });
/* 484 */     return files;
/*     */   }
/*     */ 
/*     */   protected void parseXMLClasspath(DeploymentInfo di)
/*     */     throws Exception
/*     */   {
/* 494 */     ArrayList classpath = new ArrayList();
/* 495 */     URLListerFactory listerFactory = new URLListerFactory();
/*     */ 
/* 497 */     NodeList children = di.document.getDocumentElement().getChildNodes();
/* 498 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/* 500 */       if (children.item(i).getNodeType() != 1)
/*     */         continue;
/* 502 */       Element classpathElement = (Element)children.item(i);
/* 503 */       if (!classpathElement.getTagName().equals("classpath"))
/*     */         continue;
/* 505 */       this.log.debug("Found classpath element: " + classpathElement);
/* 506 */       if (!classpathElement.hasAttribute("codebase"))
/*     */       {
/* 508 */         throw new DeploymentException("Invalid classpath element missing codebase: " + classpathElement);
/*     */       }
/*     */ 
/* 511 */       String codebase = classpathElement.getAttribute("codebase").trim();
/*     */ 
/* 513 */       codebase = StringPropertyReplacer.replaceProperties(codebase);
/*     */ 
/* 515 */       String archives = null;
/* 516 */       if (classpathElement.hasAttribute("archives"))
/*     */       {
/* 518 */         archives = classpathElement.getAttribute("archives").trim();
/*     */ 
/* 520 */         archives = StringPropertyReplacer.replaceProperties(archives);
/* 521 */         if ("".equals(archives))
/*     */         {
/* 523 */           archives = null;
/*     */         }
/*     */       }
/*     */       URL codebaseUrl;
/*     */       URL codebaseUrl;
/* 531 */       if (".".equals(codebase))
/*     */       {
/* 533 */         codebaseUrl = new URL(di.url, "./");
/*     */       }
/*     */       else
/*     */       {
/* 537 */         if ((archives != null) && (!codebase.endsWith("/")))
/*     */         {
/* 539 */           codebase = codebase + "/";
/*     */         }
/* 541 */         codebaseUrl = new URL(this.serverHomeURL, codebase);
/*     */       }
/* 543 */       this.log.debug("codebase URL is " + codebaseUrl);
/*     */ 
/* 545 */       if (archives == null)
/*     */       {
/* 548 */         classpath.add(codebaseUrl);
/* 549 */         this.log.debug("added codebase to classpath");
/*     */       }
/*     */       else
/*     */       {
/* 555 */         this.log.debug("listing codebase for archives matching " + archives);
/* 556 */         URLLister lister = listerFactory.createURLLister(codebaseUrl);
/* 557 */         this.log.debug("URLLister class is " + lister.getClass().getName());
/* 558 */         classpath.addAll(lister.listMembers(codebaseUrl, archives));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 566 */     Iterator jars = classpath.iterator();
/* 567 */     while (jars.hasNext())
/*     */     {
/* 569 */       URL neededURL = (URL)jars.next();
/* 570 */       di.addLibraryJar(neededURL);
/* 571 */       this.log.debug("deployed classes for " + neededURL);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void parseDocument(DeploymentInfo di)
/*     */     throws Exception
/*     */   {
/* 580 */     InputStream stream = null;
/*     */     try
/*     */     {
/* 583 */       if (di.document == null)
/*     */       {
/* 585 */         DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/* 586 */         factory.setNamespaceAware(this.useNamespaceAwareParser);
/* 587 */         DocumentBuilder parser = factory.newDocumentBuilder();
/* 588 */         URL docURL = di.localUrl;
/* 589 */         URLClassLoader localCL = di.localCl;
/*     */ 
/* 591 */         if (!di.isXML)
/*     */         {
/* 594 */           String[] descriptors = getDescriptorName(di);
/* 595 */           for (int n = 0; n < descriptors.length; n++)
/*     */           {
/* 597 */             String descriptor = descriptors[n];
/* 598 */             docURL = localCL.findResource(descriptor);
/* 599 */             if (docURL == null) {
/*     */               continue;
/*     */             }
/* 602 */             if (!di.url.getPath().endsWith("/"))
/*     */               break;
/* 604 */             di.watch = new URL(di.url, descriptor);
/* 605 */             this.log.debug("Updated watch URL to: " + di.watch); break;
/*     */           }
/*     */ 
/* 611 */           if (docURL == null) {
/* 612 */             docURL = localCL.findResource("META-INF/jboss-service.xml");
/*     */           }
/*     */         }
/* 615 */         if (docURL == null) {
/* 616 */           throw new DeploymentException("Failed to find META-INF/jboss-service.xml for archive " + di.shortName);
/*     */         }
/* 618 */         stream = docURL.openStream();
/* 619 */         InputSource is = new InputSource(stream);
/* 620 */         is.setSystemId(docURL.toString());
/* 621 */         parser.setEntityResolver(new JBossEntityResolver());
/* 622 */         di.document = parser.parse(is);
/*     */       }
/*     */       else
/*     */       {
/* 626 */         this.log.debug("Using existing deployment.document");
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 634 */         stream.close();
/*     */       }
/*     */       catch (Exception ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void inflateJar(URL url, File destDir, String path)
/*     */     throws DeploymentException, IOException
/*     */   {
/* 658 */     String filename = url.getFile();
/* 659 */     JarFile jarFile = new JarFile(filename);
/*     */     try
/*     */     {
/* 662 */       for (e = jarFile.entries(); e.hasMoreElements(); )
/*     */       {
/* 664 */         JarEntry entry = (JarEntry)e.nextElement();
/* 665 */         String name = entry.getName();
/*     */ 
/* 667 */         if ((path == null) || (name.startsWith(path)))
/*     */         {
/* 669 */           File outFile = new File(destDir, name);
/* 670 */           if (!outFile.exists())
/*     */           {
/* 672 */             if (entry.isDirectory())
/*     */             {
/* 674 */               outFile.mkdirs();
/*     */             }
/*     */             else
/*     */             {
/* 678 */               Streams.copyb(jarFile.getInputStream(entry), new FileOutputStream(outFile));
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/*     */       Enumeration e;
/* 687 */       jarFile.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private String[] getDescriptorName(DeploymentInfo sdi)
/*     */   {
/* 704 */     String[] descriptorNames = { "META-INF/jboss-service.xml" };
/* 705 */     String shortName = sdi.shortName;
/* 706 */     int dot = shortName.lastIndexOf('.');
/* 707 */     if (dot >= 0)
/*     */     {
/* 709 */       String suffix = shortName.substring(dot);
/* 710 */       List descriptors = (List)this.suffixToDescriptorMap.get(suffix);
/* 711 */       if (descriptors != null)
/*     */       {
/* 713 */         descriptorNames = new String[descriptors.size()];
/* 714 */         descriptors.toArray(descriptorNames);
/*     */       }
/*     */     }
/* 717 */     return descriptorNames;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.SARDeployer
 * JD-Core Version:    0.6.0
 */