/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.client.jboss.JBossClientMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
/*     */ import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
/*     */ import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.Environment;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ 
/*     */ public class ReferenceMetaDataResolverDeployer extends AbstractRealDeployer
/*     */ {
/*  61 */   private static Logger log = Logger.getLogger(ReferenceMetaDataResolverDeployer.class);
/*     */   private boolean failOnUnresolvedRefs;
/*  68 */   private ConcurrentHashMap<String, String> mappedNameMap = new ConcurrentHashMap();
/*     */ 
/*     */   public ReferenceMetaDataResolverDeployer()
/*     */   {
/*  72 */     setStage(DeploymentStages.POST_CLASSLOADER);
/*  73 */     HashSet inputs = new HashSet();
/*  74 */     inputs.add(JBossClientMetaData.class.getName());
/*  75 */     inputs.add(JBossMetaData.class.getName());
/*  76 */     inputs.add(JBossWebMetaData.class.getName());
/*  77 */     super.setInputs(inputs);
/*     */   }
/*     */ 
/*     */   public boolean isParentFirst()
/*     */   {
/*  86 */     return false;
/*     */   }
/*     */ 
/*     */   public void internalDeploy(DeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*  95 */     JBossMetaData ejbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
/*  96 */     JBossWebMetaData webMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
/*  97 */     JBossClientMetaData clientMetaData = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class);
/*  98 */     if ((ejbMetaData == null) && (webMetaData == null) && (clientMetaData == null)) {
/*  99 */       return;
/*     */     }
/*     */ 
/* 102 */     dump(unit);
/* 103 */     if (ejbMetaData != null)
/*     */     {
/* 105 */       JBossEnterpriseBeansMetaData beans = ejbMetaData.getEnterpriseBeans();
/*     */ 
/* 107 */       mapEjbs(unit.getRelativePath(), beans);
/*     */ 
/* 109 */       List unresolvedPaths = resolve(unit, beans);
/* 110 */       if ((unresolvedPaths != null) && (unresolvedPaths.size() > 0))
/* 111 */         log.warn("Unresolved references exist in JBossMetaData: " + unresolvedPaths);
/*     */     }
/* 113 */     if (webMetaData != null)
/*     */     {
/* 116 */       List unresolvedPaths = resolve(unit, webMetaData.getJndiEnvironmentRefsGroup());
/* 117 */       if ((unresolvedPaths != null) && (unresolvedPaths.size() > 0))
/* 118 */         log.warn("Unresolved references exist in JBossWebMetaData: " + unresolvedPaths);
/*     */     }
/* 120 */     if (clientMetaData != null)
/*     */     {
/* 123 */       List unresolvedPaths = resolve(unit, clientMetaData.getJndiEnvironmentRefsGroup());
/* 124 */       if ((unresolvedPaths != null) && (unresolvedPaths.size() > 0))
/* 125 */         log.warn("Unresolved references exist in JBossClientMetaData: " + unresolvedPaths);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void mapEjbs(String vfsPath, JBossEnterpriseBeansMetaData beans)
/*     */   {
/* 131 */     if ((beans == null) || (beans.size() == 0))
/* 132 */       return;
/* 133 */     for (JBossEnterpriseBeanMetaData bean : beans)
/*     */     {
/* 135 */       String ejbPath = vfsPath + "/" + bean.getEjbName();
/*     */ 
/* 137 */       String mappedName = bean.getMappedName();
/* 138 */       if (mappedName != null)
/* 139 */         this.mappedNameMap.put(ejbPath, mappedName);
/* 140 */       if ((bean instanceof JBossSessionBeanMetaData))
/*     */       {
/* 142 */         JBossSessionBeanMetaData sbean = (JBossSessionBeanMetaData)bean;
/* 143 */         BusinessLocalsMetaData locals = sbean.getBusinessLocals();
/*     */         String local;
/* 144 */         if (locals != null)
/*     */         {
/* 146 */           for (Iterator i$ = locals.iterator(); i$.hasNext(); local = (String)i$.next());
/*     */         }
/*     */ 
/* 151 */         BusinessRemotesMetaData remotes = sbean.getBusinessRemotes();
/* 152 */         if (remotes != null)
/*     */         {
/* 154 */           for (Iterator i$ = remotes.iterator(); i$.hasNext(); remote = (String)i$.next());
/*     */         }
/*     */       }
/*     */     }
/*     */     String remote;
/*     */   }
/*     */ 
/*     */   protected List<String> resolve(DeploymentUnit unit, Environment env)
/*     */   {
/* 165 */     if (env == null) {
/* 166 */       return null;
/*     */     }
/* 168 */     ArrayList unresolvedRefs = new ArrayList();
/* 169 */     AnnotatedEJBReferencesMetaData annotatedRefs = env.getAnnotatedEjbReferences();
/*     */ 
/* 171 */     EJBLocalReferencesMetaData localRefs = env.getEjbLocalReferences();
/* 172 */     resolveEjbLocalRefs(unit, localRefs, unresolvedRefs);
/* 173 */     EJBReferencesMetaData ejbRefs = env.getEjbReferences();
/* 174 */     resolveEjbRefs(unit, ejbRefs, unresolvedRefs);
/*     */ 
/* 176 */     return unresolvedRefs;
/*     */   }
/*     */ 
/*     */   protected List<String> resolve(DeploymentUnit unit, JBossEnterpriseBeansMetaData beans) {
/* 180 */     ArrayList unresolvedRefs = new ArrayList();
/* 181 */     if ((beans == null) || (beans.size() == 0)) {
/* 182 */       return unresolvedRefs;
/*     */     }
/* 184 */     for (JBossEnterpriseBeanMetaData bean : beans)
/*     */     {
/* 186 */       EJBLocalReferencesMetaData localRefs = bean.getEjbLocalReferences();
/* 187 */       resolveEjbLocalRefs(unit, localRefs, unresolvedRefs);
/* 188 */       EJBReferencesMetaData ejbRefs = bean.getEjbReferences();
/* 189 */       resolveEjbRefs(unit, ejbRefs, unresolvedRefs);
/*     */     }
/* 191 */     return unresolvedRefs;
/*     */   }
/*     */ 
/*     */   protected void resolveEjbLocalRefs(DeploymentUnit unit, EJBLocalReferencesMetaData localRefs, ArrayList<String> unresolvedRefs)
/*     */   {
/* 196 */     if (localRefs == null)
/* 197 */       return;
/* 198 */     ArrayList searched = new ArrayList();
/* 199 */     for (EJBLocalReferenceMetaData ref : localRefs)
/*     */     {
/* 201 */       String link = ref.getLink();
/* 202 */       String target = findLocalEjbLink(unit, link, searched);
/* 203 */       if (target == null)
/* 204 */         unresolvedRefs.add(ref.getEjbRefName() + "/ejb-local-ref/" + link + " available: " + searched);
/*     */       else
/* 206 */         ref.setMappedName(target);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void resolveEjbRefs(DeploymentUnit unit, EJBReferencesMetaData ejbRefs, ArrayList<String> unresolvedRefs) {
/* 211 */     if (ejbRefs == null)
/* 212 */       return;
/* 213 */     ArrayList searched = new ArrayList();
/* 214 */     for (EJBReferenceMetaData ref : ejbRefs)
/*     */     {
/* 216 */       String mappedName = ref.getMappedName();
/* 217 */       if ((mappedName == null) || (mappedName.length() == 0))
/*     */       {
/* 219 */         String link = ref.getLink();
/* 220 */         String target = null;
/* 221 */         if (link != null)
/* 222 */           target = findEjbLink(unit, link, searched);
/* 223 */         if (target == null)
/* 224 */           unresolvedRefs.add(ref.getEjbRefName() + "/ejb-ref/" + link + " available: " + searched);
/*     */         else
/* 226 */           ref.setMappedName(target);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String findEjbLink(DeploymentUnit unit, String link, ArrayList<String> searched)
/*     */   {
/* 244 */     return resolveLink(unit, link, searched, false);
/*     */   }
/*     */ 
/*     */   public static String findLocalEjbLink(DeploymentUnit unit, String link, ArrayList<String> searched)
/*     */   {
/* 260 */     return resolveLink(unit, link, searched, true);
/*     */   }
/*     */ 
/*     */   public static MessageDestinationMetaData findMessageDestination(MainDeployerStructure server, DeploymentUnit di, String link)
/*     */   {
/* 276 */     return resolveMessageDestination(server, di, link);
/*     */   }
/*     */ 
/*     */   private static String resolveLink(DeploymentUnit di, String link, ArrayList<String> searched, boolean isLocal)
/*     */   {
/* 281 */     if (link == null)
/*     */     {
/* 283 */       return null;
/*     */     }
/*     */ 
/* 286 */     if (log.isTraceEnabled())
/*     */     {
/* 288 */       log.trace("resolveLink( {" + di + "}, {" + link + "}, {" + isLocal + "}");
/*     */     }
/*     */ 
/* 291 */     if (di == null)
/*     */     {
/* 294 */       return null;
/*     */     }
/*     */ 
/* 297 */     if (link.indexOf('#') != -1)
/*     */     {
/* 300 */       return resolveRelativeLink(di, link, searched, isLocal);
/*     */     }
/*     */ 
/* 305 */     DeploymentUnit top = di.getTopLevel();
/* 306 */     return resolveAbsoluteLink(top, link, searched, isLocal);
/*     */   }
/*     */ 
/*     */   private static String resolveRelativeLink(DeploymentUnit unit, String link, ArrayList<String> searched, boolean isLocal)
/*     */   {
/* 312 */     DeploymentUnit top = unit.getTopLevel();
/* 313 */     String path = link.substring(0, link.indexOf('#'));
/* 314 */     String ejbName = link.substring(link.indexOf('#') + 1);
/*     */ 
/* 317 */     if (log.isTraceEnabled())
/*     */     {
/* 319 */       log.trace("Resolving relative link: " + link);
/*     */     }
/* 321 */     DeploymentUnit targetUnit = findLinkPath(top, path);
/* 322 */     if (targetUnit == null)
/*     */     {
/* 324 */       log.warn("Can't locate DeploymentUnit for target: " + path);
/* 325 */       return null;
/*     */     }
/*     */ 
/* 328 */     String linkTarget = null;
/* 329 */     if (targetUnit.getAttachment(JBossMetaData.class) != null)
/*     */     {
/* 331 */       JBossMetaData appMD = (JBossMetaData)targetUnit.getAttachment(JBossMetaData.class);
/* 332 */       JBossEnterpriseBeanMetaData beanMD = appMD.getEnterpriseBean(ejbName);
/*     */ 
/* 334 */       if (beanMD != null)
/*     */       {
/* 336 */         linkTarget = getJndiName(beanMD, isLocal);
/* 337 */         if (linkTarget == null)
/*     */         {
/* 339 */           if (isLocal)
/* 340 */             log.warn("Unable to determine local jndi name for " + beanMD.getEjbName());
/*     */           else
/* 342 */             log.warn("Unable to determine jndi name for " + beanMD.getEjbName());
/* 343 */           searched.add(beanMD.getEjbName());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 348 */         log.warn("No Bean named '" + ejbName + "' found in '" + path + "'!");
/* 349 */         for (JBossEnterpriseBeanMetaData md : appMD.getEnterpriseBeans())
/* 350 */           searched.add(md.getEjbName());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 355 */       log.warn("DeploymentUnit " + targetUnit + " is not an EJB .jar " + "file!");
/* 356 */       searched.add(targetUnit.getName());
/*     */     }
/*     */ 
/* 359 */     return linkTarget;
/*     */   }
/*     */ 
/*     */   private static String resolveAbsoluteLink(DeploymentUnit unit, String link, ArrayList<String> searched, boolean isLocal)
/*     */   {
/* 364 */     if (log.isTraceEnabled())
/*     */     {
/* 366 */       log.trace("Resolving absolute link, di: " + unit);
/*     */     }
/*     */ 
/* 369 */     String ejbName = null;
/*     */ 
/* 372 */     List ejbMetaData = getAllAttachments(unit, JBossMetaData.class);
/* 373 */     for (JBossMetaData ejbMD : ejbMetaData)
/*     */     {
/* 375 */       JBossEnterpriseBeanMetaData beanMD = ejbMD.getEnterpriseBean(link);
/* 376 */       if (beanMD != null)
/*     */       {
/* 378 */         ejbName = getJndiName(beanMD, isLocal);
/* 379 */         if (ejbName == null)
/*     */         {
/* 381 */           if (isLocal)
/* 382 */             log.warn("Unable to determine local jndi name for " + beanMD.getEjbName());
/*     */           else
/* 384 */             log.warn("Unable to determine jndi name for " + beanMD.getEjbName());
/* 385 */           searched.add(beanMD.getEjbName());
/*     */         }
/* 387 */         if (log.isTraceEnabled())
/*     */         {
/* 389 */           log.trace("Found Bean: " + beanMD + ", resolves to: " + ejbName);
/*     */         }
/*     */ 
/* 392 */         return ejbName;
/*     */       }
/* 394 */       if (log.isTraceEnabled())
/*     */       {
/* 397 */         log.trace("No match for ejb-link: " + link + ", module names:");
/* 398 */         for (JBossEnterpriseBeanMetaData md : ejbMD.getEnterpriseBeans())
/*     */         {
/* 400 */           String beanEjbName = getJndiName(md, isLocal);
/* 401 */           searched.add(md.getEjbName());
/* 402 */           log.trace("... ejbName: " + beanEjbName);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 407 */     return ejbName;
/*     */   }
/*     */ 
/*     */   private static <T> List<T> getAllAttachments(DeploymentUnit unit, Class<T> type)
/*     */   {
/* 412 */     ArrayList attachments = new ArrayList();
/* 413 */     DeploymentUnit top = unit.getTopLevel();
/* 414 */     getAllAttachments(top, type, attachments);
/* 415 */     return attachments;
/*     */   }
/*     */ 
/*     */   private static <T> void getAllAttachments(DeploymentUnit unit, Class<T> type, ArrayList<T> attachments) {
/* 419 */     Object attachment = unit.getAttachment(type);
/* 420 */     if (attachment != null)
/* 421 */       attachments.add(attachment);
/* 422 */     List children = unit.getChildren();
/* 423 */     if (children != null)
/* 424 */       for (DeploymentUnit child : children)
/* 425 */         getAllAttachments(child, type, attachments);
/*     */   }
/*     */ 
/*     */   private static String getJndiName(JBossEnterpriseBeanMetaData beanMD, boolean isLocal)
/*     */   {
/* 430 */     String jndiName = null;
/* 431 */     if (isLocal)
/*     */     {
/* 434 */       jndiName = beanMD.determineLocalJndiName();
/* 435 */       if (jndiName == null)
/*     */       {
/* 437 */         log.warn("LocalHome jndi name requested for: '" + beanMD.getEjbName() + "' but there is no LocalHome class");
/*     */       }
/*     */ 
/*     */     }
/* 444 */     else if (beanMD.isEntity())
/*     */     {
/* 446 */       JBossEntityBeanMetaData md = (JBossEntityBeanMetaData)beanMD;
/* 447 */       jndiName = md.determineJndiName();
/*     */     }
/* 449 */     else if (beanMD.isSession())
/*     */     {
/* 451 */       JBossSessionBeanMetaData md = (JBossSessionBeanMetaData)beanMD;
/* 452 */       jndiName = md.getHomeJndiName();
/* 453 */       if (jndiName == null) {
/* 454 */         jndiName = md.determineJndiName();
/*     */       }
/*     */     }
/* 457 */     return jndiName;
/*     */   }
/*     */ 
/*     */   private static MessageDestinationMetaData resolveMessageDestination(MainDeployerStructure server, DeploymentUnit di, String link)
/*     */   {
/* 462 */     if (link == null) {
/* 463 */       return null;
/*     */     }
/* 465 */     if (log.isTraceEnabled()) {
/* 466 */       log.trace("resolveLink( {" + di + "}, {" + link + "})");
/*     */     }
/* 468 */     if (di == null)
/*     */     {
/* 470 */       return null;
/*     */     }
/* 472 */     if (link.indexOf('#') != -1)
/*     */     {
/* 474 */       return resolveRelativeMessageDestination(di, link);
/*     */     }
/*     */ 
/* 478 */     DeploymentUnit top = di.getTopLevel();
/* 479 */     return resolveAbsoluteMessageDestination(top, link);
/*     */   }
/*     */ 
/*     */   private static MessageDestinationMetaData resolveRelativeMessageDestination(DeploymentUnit unit, String link)
/*     */   {
/* 485 */     String path = link.substring(0, link.indexOf('#'));
/* 486 */     String destinationName = link.substring(link.indexOf('#') + 1);
/*     */ 
/* 488 */     if (log.isTraceEnabled())
/*     */     {
/* 490 */       log.trace("Resolving relative message-destination-link: " + link);
/*     */     }
/* 492 */     DeploymentUnit top = unit.getTopLevel();
/* 493 */     DeploymentUnit targetUnit = findLinkPath(top, path);
/* 494 */     if (targetUnit == null)
/*     */     {
/* 496 */       log.warn("Can't locate DeploymentUnit for target: " + path);
/* 497 */       return null;
/*     */     }
/*     */ 
/* 500 */     if (log.isTraceEnabled()) {
/* 501 */       log.trace("Found appropriate DeploymentUnit: " + targetUnit);
/*     */     }
/* 503 */     if (targetUnit.getAttachment(JBossMetaData.class) != null)
/*     */     {
/* 505 */       JBossMetaData appMD = (JBossMetaData)targetUnit.getAttachment(JBossMetaData.class);
/* 506 */       return appMD.getAssemblyDescriptor().getMessageDestination(destinationName);
/*     */     }
/* 508 */     if (targetUnit.getAttachment(JBossWebMetaData.class) != null)
/*     */     {
/* 510 */       JBossWebMetaData webMD = (JBossWebMetaData)targetUnit.getAttachment(JBossWebMetaData.class);
/* 511 */       return webMD.getMessageDestination(destinationName);
/*     */     }
/*     */ 
/* 515 */     log.warn("DeploymentUnit " + targetUnit + " is not an EJB .jar " + "file!");
/* 516 */     return null;
/*     */   }
/*     */ 
/*     */   private static MessageDestinationMetaData resolveAbsoluteMessageDestination(DeploymentUnit unit, String link)
/*     */   {
/* 522 */     if (log.isTraceEnabled()) {
/* 523 */       log.trace("Resolving absolute link, di: " + unit);
/*     */     }
/*     */ 
/* 526 */     if (unit.getAttachment(JBossMetaData.class) != null)
/*     */     {
/* 528 */       JBossMetaData appMD = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
/* 529 */       MessageDestinationMetaData mdMD = appMD.getAssemblyDescriptor().getMessageDestination(link);
/* 530 */       if (mdMD != null)
/* 531 */         return mdMD;
/*     */     }
/* 533 */     if (unit.getAttachment(JBossWebMetaData.class) != null)
/*     */     {
/* 535 */       JBossWebMetaData webMD = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
/* 536 */       return webMD.getMessageDestination(link);
/*     */     }
/*     */ 
/* 540 */     Iterator it = unit.getChildren().iterator();
/* 541 */     while (it.hasNext())
/*     */     {
/* 543 */       DeploymentUnit child = (DeploymentUnit)it.next();
/* 544 */       MessageDestinationMetaData mdMD = resolveAbsoluteMessageDestination(child, link);
/* 545 */       if (mdMD != null) {
/* 546 */         return mdMD;
/*     */       }
/*     */     }
/*     */ 
/* 550 */     return null;
/*     */   }
/*     */ 
/*     */   private static DeploymentUnit findLinkPath(DeploymentUnit top, String path)
/*     */   {
/* 555 */     List children = top.getChildren();
/* 556 */     DeploymentUnit targetUnit = null;
/* 557 */     if (children != null)
/*     */     {
/* 559 */       for (DeploymentUnit child : children)
/*     */       {
/* 561 */         String childPath = child.getRelativePath();
/* 562 */         if (childPath.endsWith(path))
/*     */         {
/* 564 */           targetUnit = child;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 569 */     if (targetUnit == null)
/*     */     {
/* 571 */       return null;
/*     */     }
/*     */ 
/* 574 */     if (log.isTraceEnabled())
/*     */     {
/* 576 */       log.trace("Found appropriate DeploymentUnit: " + targetUnit);
/*     */     }
/* 578 */     return targetUnit;
/*     */   }
/*     */ 
/*     */   private void dump(DeploymentUnit unit)
/*     */   {
/* 583 */     DeploymentUnit top = unit.getTopLevel();
/* 584 */     StringBuffer tmp = new StringBuffer();
/* 585 */     dump(top, tmp, 0);
/* 586 */     log.debug("Processing unit:\n" + tmp);
/*     */   }
/*     */ 
/*     */   private void dump(DeploymentUnit unit, StringBuffer tmp, int depth) {
/* 590 */     for (int n = 0; n < depth; n++)
/* 591 */       tmp.append('+');
/* 592 */     tmp.append(unit.getRelativePath());
/* 593 */     JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
/* 594 */     if (metaData != null)
/*     */     {
/* 596 */       JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
/* 597 */       if (beans != null)
/*     */       {
/* 599 */         for (JBossEnterpriseBeanMetaData bean : beans)
/*     */         {
/* 601 */           tmp.append(",ejbName=");
/* 602 */           tmp.append(bean.getEjbName());
/* 603 */           if (bean.getEjbClass() != null)
/*     */           {
/* 605 */             tmp.append(",ejbClass=");
/* 606 */             tmp.append(bean.getEjbClass());
/*     */           }
/* 608 */           if ((bean instanceof JBossSessionBeanMetaData))
/*     */           {
/* 610 */             JBossSessionBeanMetaData sbean = (JBossSessionBeanMetaData)bean;
/* 611 */             if (sbean.getHome() != null)
/*     */             {
/* 613 */               tmp.append(",home=");
/* 614 */               tmp.append(sbean.getHome());
/*     */             }
/* 616 */             if (sbean.getRemote() != null)
/*     */             {
/* 618 */               tmp.append(",remote=");
/* 619 */               tmp.append(sbean.getRemote());
/*     */             }
/* 621 */             BusinessLocalsMetaData locals = sbean.getBusinessLocals();
/* 622 */             if (locals != null)
/*     */             {
/* 624 */               tmp.append(",BusinessLocals: ");
/* 625 */               tmp.append(locals);
/*     */             }
/* 627 */             BusinessRemotesMetaData remotes = sbean.getBusinessRemotes();
/* 628 */             if (remotes != null)
/*     */             {
/* 630 */               tmp.append(",BusinessRemotes: ");
/* 631 */               tmp.append(remotes);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 637 */     tmp.append('\n');
/* 638 */     List children = unit.getChildren();
/* 639 */     if (children != null)
/*     */     {
/* 641 */       for (DeploymentUnit child : children)
/* 642 */         dump(child, tmp, depth + 1);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.ReferenceMetaDataResolverDeployer
 * JD-Core Version:    0.6.0
 */