/*      */ package org.jboss.deployment;
/*      */ 
/*      */ import java.io.BufferedInputStream;
/*      */ import java.io.BufferedOutputStream;
/*      */ import java.io.File;
/*      */ import java.io.FileOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.net.URLClassLoader;
/*      */ import java.net.URLConnection;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Comparator;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedList;
/*      */ import java.util.List;
/*      */ import java.util.ListIterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.StringTokenizer;
/*      */ import java.util.jar.Attributes;
/*      */ import java.util.jar.Attributes.Name;
/*      */ import java.util.jar.Manifest;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.MalformedObjectNameException;
/*      */ import javax.management.Notification;
/*      */ import javax.management.ObjectName;
/*      */ import org.jboss.deployers.client.spi.DeployerClient;
/*      */ import org.jboss.deployers.client.spi.Deployment;
/*      */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*      */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*      */ import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
/*      */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*      */ import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
/*      */ import org.jboss.kernel.spi.dependency.KernelController;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.system.ServiceMBeanSupport;
/*      */ import org.jboss.system.server.ServerConfig;
/*      */ import org.jboss.system.server.ServerConfigLocator;
/*      */ import org.jboss.util.file.Files;
/*      */ import org.jboss.util.file.JarUtils;
/*      */ import org.jboss.util.stream.Streams;
/*      */ import org.jboss.virtual.VFS;
/*      */ import org.jboss.virtual.VirtualFile;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class MainDeployer extends ServiceMBeanSupport
/*      */   implements Deployer, MainDeployerMBean
/*      */ {
/*      */   private KernelController controller;
/*      */   private DeployerClient delegate;
/*   89 */   private Map<URL, String> contextMap = Collections.synchronizedMap(new HashMap());
/*      */ 
/*   92 */   private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
/*      */   private ObjectName serviceController;
/*  102 */   private final LinkedList deployers = new LinkedList();
/*      */ 
/*  105 */   private final Map deploymentMap = Collections.synchronizedMap(new HashMap());
/*      */ 
/*  108 */   private final List deploymentList = new ArrayList();
/*      */ 
/*  111 */   private final List waitingDeployments = new ArrayList();
/*      */ 
/*  114 */   private final DeploymentSorter sorter = new DeploymentSorter();
/*      */ 
/*  117 */   private final Comparator infoSorter = new DeploymentInfoComparator(this.sorter);
/*      */ 
/*  120 */   private final SuffixOrderHelper suffixOrderHelper = new SuffixOrderHelper(this.sorter);
/*      */ 
/*  123 */   private boolean copyFiles = true;
/*      */   private File tempDir;
/*      */   private String tempDirString;
/*      */ 
/*      */   public MainDeployer()
/*      */   {
/*  137 */     String localCopy = System.getProperty("jboss.deploy.localcopy");
/*  138 */     if ((localCopy != null) && ((localCopy.equalsIgnoreCase("false")) || (localCopy.equalsIgnoreCase("no")) || (localCopy.equalsIgnoreCase("off"))))
/*      */     {
/*  143 */       this.log.debug("Disabling local copies of file: urls");
/*  144 */       this.copyFiles = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   public DeployerClient getKernelMainDeployer()
/*      */   {
/*  150 */     return this.delegate;
/*      */   }
/*      */ 
/*      */   public void setKernelMainDeployer(DeployerClient delegate) {
/*  154 */     this.delegate = delegate;
/*      */   }
/*      */ 
/*      */   public KernelController getController()
/*      */   {
/*  159 */     return this.controller;
/*      */   }
/*      */ 
/*      */   public void setController(KernelController controller)
/*      */   {
/*  164 */     this.controller = controller;
/*      */   }
/*      */ 
/*      */   public boolean getCopyFiles()
/*      */   {
/*  174 */     return this.copyFiles;
/*      */   }
/*      */ 
/*      */   public void setCopyFiles(boolean copyFiles)
/*      */   {
/*  185 */     this.copyFiles = copyFiles;
/*      */   }
/*      */ 
/*      */   public File getTempDir()
/*      */   {
/*  195 */     return this.tempDir;
/*      */   }
/*      */ 
/*      */   public void setTempDir(File tempDir)
/*      */   {
/*  204 */     this.tempDir = tempDir;
/*      */   }
/*      */ 
/*      */   public String getTempDirString()
/*      */   {
/*  214 */     return this.tempDirString;
/*      */   }
/*      */ 
/*      */   public String[] getSuffixOrder()
/*      */   {
/*  224 */     return this.suffixOrderHelper.getSuffixOrder();
/*      */   }
/*      */ 
/*      */   public String[] getEnhancedSuffixOrder()
/*      */   {
/*  234 */     return this.suffixOrderHelper.getEnhancedSuffixes();
/*      */   }
/*      */ 
/*      */   public void setEnhancedSuffixOrder(String[] enhancedSuffixOrder)
/*      */   {
/*  244 */     this.suffixOrderHelper.setEnhancedSuffixes(enhancedSuffixOrder);
/*      */   }
/*      */ 
/*      */   public void setServiceController(ObjectName serviceController)
/*      */   {
/*  255 */     this.serviceController = serviceController;
/*      */   }
/*      */ 
/*      */   public Collection listDeployed()
/*      */   {
/*  267 */     synchronized (this.deploymentList)
/*      */     {
/*  269 */       this.log.debug("deployment list string: " + this.deploymentList);
/*  270 */       return new ArrayList(this.deploymentList);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Collection listDeployedModules()
/*      */   {
/*  283 */     this.log.debug("listDeployedModules");
/*      */ 
/*  285 */     HashMap map = new HashMap();
/*      */     Iterator it;
/*  286 */     synchronized (this.deploymentList)
/*      */     {
/*  288 */       Collection col = new ArrayList(this.deploymentList);
/*      */ 
/*  291 */       for (it = col.iterator(); it.hasNext(); )
/*      */       {
/*  293 */         DeploymentInfo info = (DeploymentInfo)it.next();
/*  294 */         map.put(info.url, new SerializableDeploymentInfo(info));
/*      */ 
/*  296 */         fillParentAndChildrenSDI(info, map);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  301 */     return new ArrayList(map.values());
/*      */   }
/*      */ 
/*      */   public String listDeployedAsString()
/*      */   {
/*  312 */     return "<pre>" + listDeployed() + "</pre>";
/*      */   }
/*      */ 
/*      */   public Collection listIncompletelyDeployed()
/*      */   {
/*  325 */     List id = new ArrayList();
/*      */     List copy;
/*  327 */     synchronized (this.deploymentList)
/*      */     {
/*  329 */       copy = new ArrayList(this.deploymentList);
/*      */     }
/*  331 */     for (Iterator i = copy.iterator(); i.hasNext(); )
/*      */     {
/*  333 */       DeploymentInfo di = (DeploymentInfo)i.next();
/*  334 */       if ((!"Deployed".equals(di.status)) && (!"Starting".equals(di.status)))
/*      */       {
/*  336 */         id.add(di);
/*      */       }
/*      */     }
/*      */ 
/*  340 */     return id;
/*      */   }
/*      */ 
/*      */   public Collection listWaitingForDeployer()
/*      */   {
/*  352 */     synchronized (this.waitingDeployments)
/*      */     {
/*  354 */       return new ArrayList(this.waitingDeployments);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addDeployer(SubDeployer deployer)
/*      */   {
/*  367 */     this.log.debug("Adding deployer: " + deployer);
/*  368 */     ObjectName deployerName = deployer.getServiceName();
/*      */ 
/*  370 */     synchronized (this.deployers)
/*      */     {
/*  372 */       this.deployers.addFirst(deployer);
/*      */       try
/*      */       {
/*  375 */         String[] suffixes = (String[])(String[])this.server.getAttribute(deployerName, "EnhancedSuffixes");
/*  376 */         this.suffixOrderHelper.addEnhancedSuffixes(suffixes);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  380 */         this.log.debug(deployerName + " does not support EnhancedSuffixes");
/*  381 */         this.suffixOrderHelper.addSuffixes(deployer.getSuffixes(), deployer.getRelativeOrder());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  386 */     Notification msg = new Notification("org.jboss.deployment.MainDeployer.addDeployer", this, getNextNotificationSequenceNumber());
/*  387 */     msg.setUserData(deployerName);
/*  388 */     sendNotification(msg);
/*      */     Iterator i;
/*  390 */     synchronized (this.waitingDeployments)
/*      */     {
/*  392 */       Object copy = new ArrayList(this.waitingDeployments);
/*  393 */       this.waitingDeployments.clear();
/*  394 */       for (i = ((List)copy).iterator(); i.hasNext(); )
/*      */       {
/*  396 */         DeploymentInfo di = (DeploymentInfo)i.next();
/*  397 */         this.log.debug("trying to deploy with new deployer: " + di.shortName);
/*      */         try
/*      */         {
/*  400 */           di.setServer(this.server);
/*  401 */           deploy(di);
/*      */         }
/*      */         catch (DeploymentException e)
/*      */         {
/*  405 */           this.log.error("DeploymentException while trying to deploy a package with a new deployer", e);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeDeployer(SubDeployer deployer)
/*      */   {
/*  420 */     this.log.debug("Removing deployer: " + deployer);
/*  421 */     ObjectName deployerName = deployer.getServiceName();
/*  422 */     boolean removed = false;
/*      */ 
/*  424 */     synchronized (this.deployers)
/*      */     {
/*  426 */       removed = this.deployers.remove(deployer);
/*      */       try
/*      */       {
/*  429 */         String[] suffixes = (String[])(String[])this.server.getAttribute(deployerName, "EnhancedSuffixes");
/*  430 */         this.suffixOrderHelper.removeEnhancedSuffixes(suffixes);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  434 */         this.log.debug(deployerName + " does not support EnhancedSuffixes");
/*  435 */         this.suffixOrderHelper.removeSuffixes(deployer.getSuffixes(), deployer.getRelativeOrder());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  440 */     if (removed)
/*      */     {
/*  442 */       Notification msg = new Notification("org.jboss.deployment.MainDeployer.removeDeployer", this, getNextNotificationSequenceNumber());
/*  443 */       msg.setUserData(deployerName);
/*  444 */       sendNotification(msg);
/*      */     }
/*      */     List copy;
/*  448 */     synchronized (this.deploymentList)
/*      */     {
/*  450 */       copy = new ArrayList(this.deploymentList);
/*      */     }
/*  452 */     for (Iterator i = copy.iterator(); i.hasNext(); )
/*      */     {
/*  454 */       DeploymentInfo di = (DeploymentInfo)i.next();
/*  455 */       if (di.deployer == deployer)
/*      */       {
/*  457 */         undeploy(di);
/*  458 */         di.deployer = null;
/*  459 */         synchronized (this.waitingDeployments)
/*      */         {
/*  461 */           this.waitingDeployments.add(di);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Collection listDeployers()
/*      */   {
/*  476 */     ArrayList deployerNames = new ArrayList();
/*  477 */     synchronized (this.deployers)
/*      */     {
/*  479 */       for (int n = 0; n < this.deployers.size(); n++)
/*      */       {
/*  481 */         SubDeployer deployer = (SubDeployer)this.deployers.get(n);
/*  482 */         ObjectName name = deployer.getServiceName();
/*  483 */         deployerNames.add(name);
/*      */       }
/*      */     }
/*  486 */     return deployerNames;
/*      */   }
/*      */ 
/*      */   protected ObjectName getObjectName(MBeanServer server, ObjectName name)
/*      */     throws MalformedObjectNameException
/*      */   {
/*  494 */     return name == null ? OBJECT_NAME : name;
/*      */   }
/*      */ 
/*      */   protected void createService()
/*      */     throws Exception
/*      */   {
/*  504 */     ServerConfig config = ServerConfigLocator.locate();
/*      */ 
/*  506 */     File basedir = config.getServerTempDir();
/*      */ 
/*  508 */     this.tempDir = new File(basedir, "deploy");
/*      */ 
/*  510 */     Files.delete(this.tempDir);
/*      */ 
/*  512 */     this.tempDir.mkdirs();
/*      */ 
/*  515 */     this.tempDirString = this.tempDir.toURL().toString();
/*      */ 
/*  518 */     this.suffixOrderHelper.initialize();
/*      */   }
/*      */ 
/*      */   public void shutdown()
/*      */   {
/*  531 */     int deployCounter = 0;
/*      */     List copy;
/*  535 */     synchronized (this.deploymentList)
/*      */     {
/*  537 */       copy = new ArrayList(this.deploymentList);
/*      */     }
/*  539 */     for (ListIterator i = copy.listIterator(copy.size()); i.hasPrevious(); )
/*      */     {
/*      */       try
/*      */       {
/*  543 */         undeploy((DeploymentInfo)i.previous(), true);
/*  544 */         deployCounter++;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  548 */         this.log.info("exception trying to undeploy during shutdown", e);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  553 */     this.deployers.clear();
/*  554 */     this.deploymentMap.clear();
/*  555 */     this.deploymentList.clear();
/*  556 */     this.waitingDeployments.clear();
/*  557 */     this.tempDir = null;
/*      */ 
/*  559 */     this.log.debug("Undeployed " + deployCounter + " deployed packages");
/*      */   }
/*      */ 
/*      */   public void redeploy(String urlspec)
/*      */     throws DeploymentException, MalformedURLException
/*      */   {
/*  574 */     redeploy(new URL(urlspec));
/*      */   }
/*      */ 
/*      */   public void redeploy(URL url)
/*      */     throws DeploymentException
/*      */   {
/*  586 */     undeploy(url);
/*  587 */     deploy(url);
/*      */   }
/*      */ 
/*      */   public void redeploy(DeploymentInfo sdi)
/*      */     throws DeploymentException
/*      */   {
/*      */     try
/*      */     {
/*  601 */       undeploy(sdi);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  605 */       this.log.info("Throwable from undeployment attempt: ", t);
/*      */     }
/*  607 */     sdi.setServer(this.server);
/*  608 */     deploy(sdi);
/*      */   }
/*      */ 
/*      */   public void undeploy(String urlspec)
/*      */     throws DeploymentException, MalformedURLException
/*      */   {
/*  621 */     undeploy(new URL(urlspec));
/*      */   }
/*      */ 
/*      */   public void undeploy(URL url)
/*      */     throws DeploymentException
/*      */   {
/*  632 */     String deploymentName = (String)this.contextMap.remove(url);
/*  633 */     if (deploymentName != null)
/*      */     {
/*      */       try
/*      */       {
/*  637 */         this.delegate.removeDeployment(deploymentName);
/*  638 */         this.delegate.process();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  642 */         DeploymentException ex = new DeploymentException("Error during undeploy of: " + url, e);
/*  643 */         throw ex;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  648 */       this.log.warn("undeploy '" + url + "' : package not deployed");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void undeploy(DeploymentInfo di)
/*      */   {
/*  661 */     undeploy(di, false);
/*      */   }
/*      */ 
/*      */   protected void undeploy(DeploymentInfo di, boolean isShutdown) {
/*  665 */     this.log.debug("Undeploying " + di.url);
/*  666 */     stop(di);
/*  667 */     destroy(di);
/*      */   }
/*      */ 
/*      */   private void stop(DeploymentInfo di)
/*      */   {
/*  678 */     ArrayList reverseSortedSubs = new ArrayList(di.subDeployments);
/*  679 */     Collections.sort(reverseSortedSubs, this.infoSorter);
/*  680 */     Collections.reverse(reverseSortedSubs);
/*  681 */     for (Iterator subs = reverseSortedSubs.iterator(); subs.hasNext(); )
/*      */     {
/*  683 */       DeploymentInfo sub = (DeploymentInfo)subs.next();
/*  684 */       this.log.debug("Stopping sub deployment: " + sub.url);
/*  685 */       stop(sub);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  691 */       if (di.deployer != null)
/*      */       {
/*  693 */         di.deployer.stop(di);
/*  694 */         di.status = "Stopped";
/*  695 */         di.state = DeploymentState.STOPPED;
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  700 */       this.log.error("Deployer stop failed for: " + di.url, t);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void destroy(DeploymentInfo di)
/*      */   {
/*  713 */     ArrayList reverseSortedSubs = new ArrayList(di.subDeployments);
/*  714 */     Collections.sort(reverseSortedSubs, this.infoSorter);
/*  715 */     Collections.reverse(reverseSortedSubs);
/*  716 */     for (Iterator subs = reverseSortedSubs.iterator(); subs.hasNext(); )
/*      */     {
/*  718 */       DeploymentInfo sub = (DeploymentInfo)subs.next();
/*  719 */       this.log.debug("Destroying sub deployment: " + sub.url);
/*  720 */       destroy(sub);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  726 */       if (di.deployer != null)
/*      */       {
/*  728 */         di.deployer.destroy(di);
/*  729 */         di.status = "Destroyed";
/*  730 */         di.state = DeploymentState.DESTROYED;
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  735 */       this.log.error("Deployer destroy failed for: " + di.url, t);
/*  736 */       di.state = DeploymentState.FAILED;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  742 */       synchronized (this.deploymentList)
/*      */       {
/*  744 */         this.deploymentMap.remove(di.url);
/*  745 */         if (this.deploymentList.lastIndexOf(di) != -1)
/*      */         {
/*  747 */           this.deploymentList.remove(this.deploymentList.lastIndexOf(di));
/*      */         }
/*      */       }
/*  750 */       synchronized (this.waitingDeployments)
/*      */       {
/*  752 */         this.waitingDeployments.remove(di);
/*      */       }
/*      */ 
/*  755 */       di.cleanup();
/*      */ 
/*  757 */       this.log.debug("Undeployed " + di.url);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  761 */       this.log.error("Undeployment cleanup failed: " + di.url, t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deploy(String urlspec)
/*      */     throws DeploymentException, MalformedURLException
/*      */   {
/*  776 */     if (this.server == null)
/*  777 */       throw new DeploymentException("The MainDeployer has been unregistered");
/*      */     URL url;
/*      */     try
/*      */     {
/*  782 */       url = new URL(urlspec);
/*      */     }
/*      */     catch (MalformedURLException e)
/*      */     {
/*  786 */       File file = new File(urlspec);
/*  787 */       url = file.toURL();
/*      */     }
/*      */ 
/*  790 */     deploy(url);
/*      */   }
/*      */ 
/*      */   public void deploy(URL url)
/*      */     throws DeploymentException
/*      */   {
/*  801 */     this.log.info("deploy, url=" + url);
/*  802 */     String deploymentName = (String)this.contextMap.get(url);
/*      */ 
/*  804 */     if (deploymentName == null)
/*      */     {
/*      */       try
/*      */       {
/*  808 */         VirtualFile file = VFS.getRoot(url);
/*  809 */         VFSDeployment deployment = this.deploymentFactory.createVFSDeployment(file);
/*  810 */         this.delegate.addDeployment(deployment);
/*  811 */         deploymentName = deployment.getName();
/*  812 */         this.delegate.process();
/*      */ 
/*  814 */         this.delegate.checkComplete(new Deployment[] { deployment });
/*  815 */         this.contextMap.put(url, deploymentName);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  819 */         this.log.warn("Failed to deploy: " + url, e);
/*  820 */         DeploymentException ex = new DeploymentException("Failed to deploy: " + url, e);
/*  821 */         throw ex;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void deploy(DeploymentInfo deployment)
/*      */     throws DeploymentException
/*      */   {
/*  837 */     if (isDeployed(deployment.url))
/*      */     {
/*  839 */       this.log.info("Package: " + deployment.url + " is already deployed");
/*  840 */       return;
/*      */     }
/*  842 */     this.log.debug("Starting deployment of package: " + deployment.url);
/*      */ 
/*  844 */     boolean inited = false;
/*      */     try
/*      */     {
/*  847 */       inited = init(deployment);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  851 */       this.log.error("Could not initialise deployment: " + deployment.url, t);
/*  852 */       DeploymentException.rethrowAsDeploymentException("Could not initialise deployment: " + deployment.url, t);
/*      */     }
/*  854 */     if (inited)
/*      */     {
/*  856 */       create(deployment);
/*  857 */       start(deployment);
/*  858 */       this.log.debug("Deployed package: " + deployment.url);
/*      */     }
/*      */     else
/*      */     {
/*  862 */       this.log.debug("Deployment of package: " + deployment.url + " is waiting for an appropriate deployer.");
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean init(DeploymentInfo deployment)
/*      */     throws DeploymentException
/*      */   {
/*  878 */     if (isDeployed(deployment.url))
/*      */     {
/*  880 */       this.log.info("Package: " + deployment.url + " is already deployed");
/*  881 */       return false;
/*      */     }
/*  883 */     this.log.debug("Starting deployment (init step) of package at: " + deployment.url);
/*      */     try
/*      */     {
/*  887 */       if (deployment.localUrl == null)
/*      */       {
/*  889 */         makeLocalCopy(deployment);
/*  890 */         URL[] localCl = { deployment.localUrl };
/*  891 */         deployment.localCl = new URLClassLoader(localCl);
/*      */       }
/*      */ 
/*  895 */       findDeployer(deployment);
/*      */ 
/*  897 */       if (deployment.deployer == null)
/*      */       {
/*  899 */         deployment.state = DeploymentState.INIT_WAITING_DEPLOYER;
/*  900 */         this.log.debug("deployment waiting for deployer: " + deployment.url);
/*  901 */         synchronized (this.waitingDeployments)
/*      */         {
/*  903 */           if (!this.waitingDeployments.contains(deployment))
/*  904 */             this.waitingDeployments.add(deployment);
/*      */         }
/*  906 */         ??? = 0; jsr 224;
/*      */       }
/*  908 */       deployment.state = DeploymentState.INIT_DEPLOYER;
/*      */ 
/*  910 */       deployment.deployer.init(deployment);
/*      */ 
/*  912 */       deployment.createClassLoaders();
/*  913 */       deployment.state = DeploymentState.INITIALIZED;
/*      */ 
/*  916 */       synchronized (this.deploymentList)
/*      */       {
/*  918 */         this.deploymentMap.put(deployment.url, deployment);
/*      */       }
/*      */ 
/*  922 */       parseManifestLibraries(deployment);
/*      */ 
/*  924 */       this.log.debug("found " + deployment.subDeployments.size() + " subpackages of " + deployment.url);
/*      */ 
/*  926 */       ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
/*  927 */       Collections.sort(sortedSubs, this.infoSorter);
/*  928 */       for (lt = sortedSubs.listIterator(); ((Iterator)lt).hasNext(); )
/*      */       {
/*  930 */         init((DeploymentInfo)((Iterator)lt).next());
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*      */       Object lt;
/*  935 */       deployment.state = DeploymentState.FAILED;
/*  936 */       DeploymentException.rethrowAsDeploymentException("exception in init of " + deployment.url, e);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  943 */         URL url = deployment.localUrl == null ? deployment.url : deployment.localUrl;
/*      */ 
/*  945 */         long lastModified = -1L;
/*      */ 
/*  947 */         if (url.getProtocol().equals("file"))
/*  948 */           lastModified = new File(url.getFile()).lastModified();
/*      */         else {
/*  950 */           lastModified = url.openConnection().getLastModified();
/*      */         }
/*  952 */         deployment.lastModified = lastModified;
/*  953 */         deployment.lastDeployed = System.currentTimeMillis();
/*      */       }
/*      */       catch (IOException ignore)
/*      */       {
/*  957 */         deployment.lastModified = System.currentTimeMillis();
/*  958 */         deployment.lastDeployed = System.currentTimeMillis();
/*      */       }
/*      */ 
/*  961 */       synchronized (this.deploymentList)
/*      */       {
/*  964 */         if ((!inLocalCopyDir(deployment.url)) && (!this.deploymentList.contains(deployment)))
/*      */         {
/*  966 */           this.deploymentList.add(deployment);
/*  967 */           this.log.debug("Watching new file: " + deployment.url);
/*      */         }
/*      */       }
/*      */     }
/*  971 */     return true;
/*      */   }
/*      */ 
/*      */   private void create(DeploymentInfo deployment)
/*      */     throws DeploymentException
/*      */   {
/*  985 */     this.log.debug("create step for deployment " + deployment.url);
/*      */     try
/*      */     {
/*  988 */       ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
/*  989 */       Collections.sort(sortedSubs, this.infoSorter);
/*  990 */       for (Iterator lt = sortedSubs.listIterator(); lt.hasNext(); )
/*      */       {
/*  992 */         create((DeploymentInfo)lt.next());
/*      */       }
/*  994 */       deployment.state = DeploymentState.CREATE_SUBDEPLOYMENTS;
/*      */ 
/*  997 */       if (deployment.deployer != null)
/*      */       {
/*      */         try
/*      */         {
/* 1001 */           deployment.state = DeploymentState.CREATE_DEPLOYER;
/* 1002 */           deployment.deployer.create(deployment);
/*      */ 
/* 1004 */           deployment.state = DeploymentState.CREATED;
/* 1005 */           deployment.status = "Created";
/* 1006 */           this.log.debug("Done with create step of deploying " + deployment.shortName);
/*      */         }
/*      */         catch (Throwable t)
/*      */         {
/* 1010 */           this.log.error("Could not create deployment: " + deployment.url, t);
/* 1011 */           throw t;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1016 */         this.log.debug("Still no deployer for package in create step: " + deployment.shortName);
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1021 */       this.log.trace("could not create deployment: " + deployment.url, t);
/* 1022 */       deployment.status = ("Deployment FAILED reason: " + t.getMessage());
/* 1023 */       deployment.state = DeploymentState.FAILED;
/* 1024 */       DeploymentException.rethrowAsDeploymentException("Could not create deployment: " + deployment.url, t);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void start(DeploymentInfo deployment)
/*      */     throws DeploymentException
/*      */   {
/* 1038 */     deployment.status = "Starting";
/* 1039 */     this.log.debug("Begin deployment start " + deployment.url);
/*      */     try
/*      */     {
/* 1042 */       ArrayList sortedSubs = new ArrayList(deployment.subDeployments);
/* 1043 */       Collections.sort(sortedSubs, this.infoSorter);
/* 1044 */       for (Iterator lt = sortedSubs.listIterator(); lt.hasNext(); )
/*      */       {
/* 1046 */         start((DeploymentInfo)lt.next());
/*      */       }
/* 1048 */       deployment.state = DeploymentState.START_SUBDEPLOYMENTS;
/*      */ 
/* 1051 */       if (deployment.deployer != null)
/*      */       {
/*      */         try
/*      */         {
/* 1055 */           deployment.state = DeploymentState.START_DEPLOYER;
/* 1056 */           deployment.deployer.start(deployment);
/*      */ 
/* 1058 */           Object[] args = { deployment, DeploymentState.STARTED };
/* 1059 */           String[] sig = { "org.jboss.deployment.DeploymentInfo", "org.jboss.deployment.DeploymentState" };
/*      */ 
/* 1061 */           this.server.invoke(this.serviceController, "validateDeploymentState", args, sig);
/* 1062 */           deployment.status = "Deployed";
/* 1063 */           this.log.debug("End deployment start on package: " + deployment.shortName);
/*      */         }
/*      */         catch (Throwable t)
/*      */         {
/* 1067 */           this.log.error("Could not start deployment: " + deployment.url, t);
/* 1068 */           throw t;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1073 */         this.log.debug("Still no deployer for package in start step: " + deployment.shortName);
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1078 */       this.log.trace("could not start deployment: " + deployment.url, t);
/* 1079 */       deployment.state = DeploymentState.FAILED;
/* 1080 */       deployment.status = ("Deployment FAILED reason: " + t.getMessage());
/* 1081 */       DeploymentException.rethrowAsDeploymentException("Could not create deployment: " + deployment.url, t);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void findDeployer(DeploymentInfo sdi)
/*      */   {
/* 1094 */     if (sdi.deployer != null)
/*      */     {
/* 1096 */       this.log.debug("using existing deployer " + sdi.deployer);
/* 1097 */       return;
/*      */     }
/*      */     Iterator iterator;
/* 1104 */     synchronized (this.deployers)
/*      */     {
/* 1106 */       for (iterator = this.deployers.iterator(); iterator.hasNext(); )
/*      */       {
/* 1108 */         SubDeployer deployer = (SubDeployer)iterator.next();
/* 1109 */         if (deployer.accepts(sdi))
/*      */         {
/* 1111 */           sdi.deployer = deployer;
/* 1112 */           this.log.debug("using deployer " + deployer);
/* 1113 */           return;
/*      */         }
/*      */       }
/*      */     }
/* 1117 */     this.log.debug("No deployer found for url: " + sdi.url);
/*      */   }
/*      */ 
/*      */   private void parseManifestLibraries(DeploymentInfo sdi)
/*      */   {
/* 1128 */     String classPath = null;
/*      */ 
/* 1130 */     Manifest mf = sdi.getManifest();
/*      */ 
/* 1132 */     if (mf != null)
/*      */     {
/* 1134 */       Attributes mainAttributes = mf.getMainAttributes();
/* 1135 */       classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
/*      */     }
/*      */ 
/* 1138 */     if (classPath != null)
/*      */     {
/* 1140 */       StringTokenizer st = new StringTokenizer(classPath);
/* 1141 */       this.log.debug("resolveLibraries: " + classPath);
/*      */ 
/* 1143 */       while (st.hasMoreTokens())
/*      */       {
/* 1145 */         URL lib = null;
/* 1146 */         String tk = st.nextToken();
/* 1147 */         this.log.debug("new manifest entry for sdi at " + sdi.shortName + " entry is " + tk);
/*      */         try
/*      */         {
/* 1151 */           if (sdi.isDirectory)
/*      */           {
/* 1153 */             File parentDir = new File(sdi.url.getPath()).getParentFile();
/* 1154 */             lib = new File(parentDir, tk).toURL();
/*      */           }
/*      */           else
/*      */           {
/* 1158 */             lib = new URL(sdi.url, tk);
/*      */           }
/*      */ 
/* 1162 */           if (!this.deploymentMap.containsKey(lib))
/*      */           {
/* 1168 */             DeploymentInfo mfRef = new DeploymentInfo(lib, null, getServer());
/* 1169 */             makeLocalCopy(mfRef);
/* 1170 */             URL[] localURL = { mfRef.localUrl };
/* 1171 */             mfRef.localCl = new URLClassLoader(localURL);
/* 1172 */             findDeployer(mfRef);
/* 1173 */             SubDeployer deployer = mfRef.deployer;
/* 1174 */             if ((deployer != null) && (!(deployer instanceof JARDeployer)))
/*      */             {
/* 1177 */               this.log.warn("Found non-jar deployer for " + tk + ": " + deployer);
/*      */             }
/*      */ 
/* 1181 */             sdi.addLibraryJar(lib);
/*      */           }
/*      */         }
/*      */         catch (Exception ignore)
/*      */         {
/* 1186 */           this.log.debug("The manifest entry in " + sdi.url + " references URL " + lib + " which could not be opened, entry ignored", ignore);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void makeLocalCopy(DeploymentInfo sdi)
/*      */   {
/*      */     try
/*      */     {
/* 1201 */       if ((sdi.url.getProtocol().equals("file")) && ((!this.copyFiles) || (sdi.isDirectory)))
/*      */       {
/* 1204 */         sdi.localUrl = sdi.url;
/* 1205 */         return;
/*      */       }
/*      */ 
/* 1208 */       if (inLocalCopyDir(sdi.url))
/*      */       {
/* 1210 */         sdi.localUrl = sdi.url;
/* 1211 */         return;
/*      */       }
/*      */ 
/* 1215 */       String shortName = sdi.shortName;
/* 1216 */       File localFile = File.createTempFile("tmp", shortName, this.tempDir);
/* 1217 */       sdi.localUrl = localFile.toURL();
/* 1218 */       copy(sdi.url, localFile);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1223 */       this.log.error("Could not make local copy for " + sdi.url, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean inLocalCopyDir(URL url)
/*      */   {
/* 1229 */     int i = 0;
/* 1230 */     String urlTest = url.toString();
/* 1231 */     if (urlTest.startsWith("jar:")) {
/* 1232 */       i = 4;
/*      */     }
/* 1234 */     return urlTest.startsWith(this.tempDirString, i);
/*      */   }
/*      */ 
/*      */   protected void copy(URL src, File dest) throws IOException
/*      */   {
/* 1239 */     this.log.debug("Copying " + src + " -> " + dest);
/*      */ 
/* 1242 */     File dir = dest.getParentFile();
/* 1243 */     if (!dir.exists())
/*      */     {
/* 1245 */       boolean created = dir.mkdirs();
/* 1246 */       if (!created) {
/* 1247 */         throw new IOException("mkdirs failed for: " + dir.getAbsolutePath());
/*      */       }
/*      */     }
/*      */ 
/* 1251 */     if (dest.exists() == true)
/*      */     {
/* 1253 */       boolean deleted = Files.delete(dest);
/* 1254 */       if (!deleted) {
/* 1255 */         throw new IOException("delete of previous content failed for: " + dest.getAbsolutePath());
/*      */       }
/*      */     }
/* 1258 */     if (src.getProtocol().equals("file"))
/*      */     {
/* 1260 */       File srcFile = new File(src.getFile());
/* 1261 */       if (srcFile.isDirectory())
/*      */       {
/* 1263 */         this.log.debug("Making zip copy of: " + srcFile);
/*      */ 
/* 1265 */         OutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
/* 1266 */         JarUtils.jar(out, srcFile.listFiles());
/* 1267 */         out.close();
/* 1268 */         return;
/*      */       }
/*      */     }
/*      */ 
/* 1272 */     InputStream in = new BufferedInputStream(src.openStream());
/* 1273 */     OutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
/* 1274 */     Streams.copy(in, out);
/* 1275 */     out.flush();
/* 1276 */     out.close();
/* 1277 */     in.close();
/*      */   }
/*      */ 
/*      */   public void start(String urlspec)
/*      */     throws DeploymentException, MalformedURLException
/*      */   {
/* 1289 */     throw new DeploymentException("Not supported");
/*      */   }
/*      */ 
/*      */   public void stop(String urlspec)
/*      */     throws DeploymentException, MalformedURLException
/*      */   {
/* 1301 */     throw new DeploymentException("Not supported");
/*      */   }
/*      */ 
/*      */   public boolean isDeployed(String url)
/*      */     throws MalformedURLException
/*      */   {
/* 1316 */     return isDeployed(new URL(url));
/*      */   }
/*      */ 
/*      */   public boolean isDeployed(URL url)
/*      */   {
/* 1328 */     String name = (String)this.contextMap.get(url);
/* 1329 */     if (name == null)
/*      */     {
/* 1331 */       if (this.log.isTraceEnabled())
/* 1332 */         this.log.trace("No such context: " + url);
/* 1333 */       if (url == null)
/* 1334 */         throw new IllegalArgumentException("Null url");
/* 1335 */       String urlString = url.toString();
/*      */ 
/* 1337 */       if (!urlString.startsWith("vfs")) {
/* 1338 */         return checkDeployed("vfs" + urlString);
/*      */       }
/* 1340 */       return checkDeployed(urlString);
/*      */     }
/*      */ 
/* 1343 */     return checkDeployed(name);
/*      */   }
/*      */ 
/*      */   protected boolean checkDeployed(String name)
/*      */   {
/* 1354 */     org.jboss.deployers.spi.DeploymentState deploymentState = this.delegate.getDeploymentState(name);
/* 1355 */     this.log.debug("isDeployed, url=" + name + ", state=" + deploymentState);
/* 1356 */     return deploymentState == org.jboss.deployers.spi.DeploymentState.DEPLOYED;
/*      */   }
/*      */ 
/*      */   public Deployment getDeployment(URL url)
/*      */   {
/* 1369 */     String name = (String)this.contextMap.get(url);
/* 1370 */     if (name == null) {
/* 1371 */       return null;
/*      */     }
/* 1373 */     Deployment dc = this.delegate.getDeployment(name);
/* 1374 */     this.log.debug("getDeployment, url=" + url + ", dc=" + dc);
/* 1375 */     return dc;
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public DeploymentContext getDeploymentContext(URL url)
/*      */   {
/* 1389 */     String name = (String)this.contextMap.get(url);
/* 1390 */     if (name == null) {
/* 1391 */       return null;
/*      */     }
/* 1393 */     MainDeployerStructure structure = (MainDeployerStructure)this.delegate;
/* 1394 */     DeploymentContext dc = structure.getDeploymentContext(name);
/* 1395 */     this.log.debug("getDeploymentContext, url=" + url + ", dc=" + dc);
/* 1396 */     return dc;
/*      */   }
/*      */ 
/*      */   public DeploymentUnit getDeploymentUnit(URL url)
/*      */   {
/* 1409 */     String name = (String)this.contextMap.get(url);
/* 1410 */     if (name == null) {
/* 1411 */       return null;
/*      */     }
/* 1413 */     MainDeployerStructure structure = (MainDeployerStructure)this.delegate;
/* 1414 */     DeploymentUnit du = structure.getDeploymentUnit(name);
/* 1415 */     this.log.debug("getDeploymentUnit, url=" + url + ", du=" + du);
/* 1416 */     return du;
/*      */   }
/*      */ 
/*      */   public URL getWatchUrl(URL url)
/*      */   {
/* 1429 */     return url;
/*      */   }
/*      */ 
/*      */   public void checkIncompleteDeployments()
/*      */     throws DeploymentException
/*      */   {
/*      */     try
/*      */     {
/* 1441 */       this.delegate.checkComplete();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1445 */       throw new DeploymentException("Deployments are incomplete", e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void fillParentAndChildrenSDI(DeploymentInfo parent, Map map)
/*      */   {
/* 1455 */     Set subDeployments = parent.subDeployments;
/* 1456 */     Iterator it = subDeployments.iterator();
/* 1457 */     while (it.hasNext())
/*      */     {
/* 1459 */       DeploymentInfo child = (DeploymentInfo)it.next();
/* 1460 */       SerializableDeploymentInfo sdichild = returnSDI(child, map);
/* 1461 */       sdichild.parent = returnSDI(parent, map);
/* 1462 */       sdichild.parent.subDeployments.add(sdichild);
/* 1463 */       fillParentAndChildrenSDI(child, map);
/*      */     }
/*      */   }
/*      */ 
/*      */   private SerializableDeploymentInfo returnSDI(DeploymentInfo di, Map map)
/*      */   {
/* 1469 */     SerializableDeploymentInfo sdi = (SerializableDeploymentInfo)map.get(di.url);
/* 1470 */     if (sdi == null)
/*      */     {
/* 1472 */       sdi = new SerializableDeploymentInfo(di);
/* 1473 */       map.put(di.url, sdi);
/*      */     }
/* 1475 */     return sdi;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.MainDeployer
 * JD-Core Version:    0.6.0
 */