/*    */ package org.jboss.deployment;
/*    */ 
/*    */ import java.util.Set;
/*    */ import javax.security.jacc.PolicyConfiguration;
/*    */ import javax.security.jacc.PolicyConfigurationFactory;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ 
/*    */ public class JaccInitializationDeployer extends AbstractRealDeployer
/*    */ {
/*    */   private Set<String> acceptedAttachments;
/*    */ 
/*    */   public JaccInitializationDeployer()
/*    */   {
/* 47 */     setOutput(PolicyConfiguration.class);
/*    */   }
/*    */ 
/*    */   public Set<String> getAcceptedAttachments()
/*    */   {
/* 54 */     return this.acceptedAttachments;
/*    */   }
/*    */ 
/*    */   public void setAcceptedAttachments(Set<String> acceptedAttachments)
/*    */   {
/* 59 */     this.acceptedAttachments = acceptedAttachments;
/*    */   }
/*    */ 
/*    */   public void internalDeploy(DeploymentUnit unit) throws DeploymentException
/*    */   {
/* 64 */     boolean accepted = false;
/* 65 */     for (String accept : this.acceptedAttachments)
/*    */     {
/* 67 */       if (unit.isAttachmentPresent(accept))
/*    */       {
/* 69 */         accepted = true;
/* 70 */         break;
/*    */       }
/*    */     }
/* 73 */     if (!accepted) {
/* 74 */       return;
/*    */     }
/* 76 */     String contextID = unit.getName();
/* 77 */     PolicyConfiguration pc = null;
/*    */     try
/*    */     {
/* 80 */       PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
/* 81 */       pc = pcFactory.getPolicyConfiguration(contextID, true);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 85 */       throw new RuntimeException("failed to initialize JACC for unit: " + unit.getName(), e);
/*    */     }
/* 87 */     unit.addAttachment(PolicyConfiguration.class, pc);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.JaccInitializationDeployer
 * JD-Core Version:    0.6.0
 */